'use strict'

var semver = require('semver')
var logger = require('../../logger')
var shimmer = require('../shimmer')
var symbols = require('../../symbols')
var appendMsg ='PgSql :' 

module.exports = function (pg, agent, version, enabled) {
  if (!semver.satisfies(version, '>=4.0.0 <8.0.0')) {
    logger.debug(appendMsg ,'pg version %s not supported - aborting...', version)
    return pg
  }

  patchClient(pg.Client, 'pg.Client', agent, enabled)

  var getter = pg.__lookupGetter__('native')
  if (getter) {
    delete pg.native

    pg.__defineGetter__('native', function () {
      var native = getter()
      if (native && native.Client) {
        patchClient(native.Client, 'pg.native.Client', agent, enabled)
      }
      return native
    })
  }

  return pg
}

function patchClient(Client, klass, agent, enabled) {
  logger.debug(appendMsg ,'shimming %s.prototype.query', klass)
  shimmer.wrap(Client.prototype, '_pulseQueryQueue', wrapPulseQueryQueue)
  if (!enabled) return

  shimmer.wrap(Client.prototype, 'query', wrapQuery)

  function wrapQuery (orig, name) {
    return function wrappedFunction (sql) {
      var span = agent.startSpan('SQL', 'postgresql')
      var id = span && span.transaction.id

      if (sql && typeof sql.text === 'string') sql = sql.text

      logger.debug(appendMsg ,'intercepted call to %s.prototype.%s %o', klass, name, {
        id: id,
        sql: sql
      })

      if (span) {
        var args = arguments
        var index = args.length - 1
        var cb = args[index]

        if (Array.isArray(cb)) {
          index = cb.length - 1
          cb = cb[index]
        }

        if (typeof sql === 'string') {
          span.name = (sql)
        } else {
          logger.debug(appendMsg ,'unable to parse sql form pg module', typeof sql)
        }

        var options = {
          host: this.host || '',
          port: this.port || '',
          dbName: this.database || 'unknown',
          resTime: '',
          serverType: 'postgresql',
          error: '',
          nodeOrder: '',
          query: sql || ''
        }

        span.options = options

        if (typeof cb === 'function') {
          args[index] = end
          return orig.apply(this, arguments)
        } else {
          cb = null
          var query = orig.apply(this, arguments)

        if (typeof query.on === 'function') {
            query.on('end', end)
            query.on('error', end)
          } else if (typeof query.then === 'function') {
            query.then(end)
          } else {
            logger.debug(appendMsg ,'ERROR: unknown pg query type: %s %o', typeof query, {
              id: id
            })
          }

          return query
        }
      } else {
        return orig.apply(this, arguments)
      }

      function end() {
        logger.debug(appendMsg ,'intercepted end of %s.prototype.%s %o', klass, name, {
          id: id
        })
        span.end()
        if (cb) return cb.apply(this, arguments)
      }
    }
  }

  function wrapPulseQueryQueue(orig) {
    return function wrappedFunction() {
      if (this.queryQueue) {
        var query = this.queryQueue[this.queryQueue.length - 1]
        if (query && typeof query.callback === 'function' && query.callback.name !== 'egAPMCallbackWrapper') {
          query.callback = agent._instrumentation.bindFunction(query.callback)
        }
      } else {
        logger.debug(appendMsg ,'ERROR: Internal structure of pg Client object have changed!')
      }
      return orig.apply(this, arguments)
    }
  }
}