'use strict'
var log = require('./../logger');

var eventLoopStats;

/**
 *  load eventloop from node_modules folder
 */

try {
    eventLoopStats = require('@risingstack/event-loop-stats')
    log.info('@risingstack/event-loop-stats npm required successfully...')

} catch (e) {
    log.error("@risingstack/event-loop-stats couldn't be required", e)

    eventLoopStats = {
        sense: function () {
            return  {
                max: 0,
                min: 0,
                sum: 0,
                num: 0
              }
        }
    }

    try{
        eventLoopStats = require('event-loop-stats')
        log.info('event-loop-stats npm required successfully...')

    }catch(e){
        log.error("Event-loop-stats couldn't be required", e)
    }


}

module.exports = eventLoopStats;