'use strict'
var log = require('./../logger');

var gcStats = {};
/**
 * Here trying to load two versions of gc stats 
 * if first not loads successful then looking for the another module
 */
try {
    gcStats = (require('@risingstack/gc-stats'))();
    log.info('@risingstack/gc-stats npm required successfully...')
} catch (e) {
    
    gcStats.on = function () {}

    log.error("GC-stats couldn't be required", e)
    try {
        gcStats = (require('gc-stats'))();
        log.info('gc-stats npm required successfully...')
    } catch (e) {
        log.error("GC-stats couldn't be required", e)
    }

}

module.exports = gcStats