'use strict'

var shimmer = require('./shimmer');
var log = require('../../../logger')
var appendMsg = 'core-zlib :'
//Note:- need to wrap zlib.Deflate.prototype._transform module ('write', 'flush', 'end') segments

function wrapZlib(agent) {
    
    var zlib = require('zlib')
    
    methods = [
        'deflate',
        'deflateRaw',
        'gzip',
        'gunzip',
        'inflate',
        'inflateRaw',
        'unzip'
    ]

    shimmer.massWrap(zlib, methods, function (orig, name) {
        return function () {

            var span = agent.buildSpan();

            if (!span) {
                log.debug(appendMsg, "ZLIB: span is null :", name)
                return orig.apply(this, arguments);
            }

            var index = arguments.length - 1;
            var cbName = ''

            if (typeof arguments[index] === 'function') {
                 
                cbName = arguments[index].name || 'anonymous'

                function wrapCallback(cb) {

                    return function wrappedCallback() {
                        span.end()
                        return cb.apply(this, arguments)
                    }
                }

                arguments[index] = wrapCallback(arguments[index])
            }

            var res = orig.apply(this, arguments)

            span.start('Buffer', 'ZLIB:'+name)
            span.cbName = cbName
            return res;

        }
    })

    log.info (appendMsg, 'wrapped ZLIB module')
}



module.exports = wrapZlib;