'use strict'

var semver = require('semver')

var shimmer = require('../shimmer')
var logger = require('../../logger')
var appendMsg = 'Redis :'

module.exports = function (redis, agent, version, enabled) {
  if (!semver.satisfies(version, '^2.0.0')) {
    logger.debug(appendMsg ,'redis version is not supported - aborting...', version)
    return redis
  }else{
    logger.debug(appendMsg ,'redis version is  supported V: ', version)
  }

  var proto = redis.RedisClient && redis.RedisClient.prototype
  if (semver.satisfies(version, '>2.5.3')) {
    logger.debug(appendMsg ,'shimming redis.RedisClient.prototype.internal_send_command')
    shimmer.wrap(proto, 'internal_send_command', wrapInternalSendCommand)
  } else {
    logger.debug(appendMsg ,'shimming redis.RedisClient.prototype.send_command')
    shimmer.wrap(proto, 'send_command', wrapSendCommand)
  }

  return redis

  function makeWrappedCallback (span, cb) {
    return agent._instrumentation.bindFunction(function wrappedCallback () {
      if (span) span.end()
      if (cb) {
        return cb.apply(this, arguments)
      }
    })
  }

  function wrapInternalSendCommand (original) {
    return function wrappedInternalSendCommand (commandObj) {
      var span = enabled && agent.buildSpan()
      var id = span && span.transaction.id
      var command = commandObj && commandObj.command
      var args  =  commandObj && JSON.stringify(commandObj.args)

      logger.debug(appendMsg ,'intercepted call to RedisClient.prototype.internal_send_command', {
        id: id,
        command: command
      })

      if (commandObj) {
        commandObj.callback = makeWrappedCallback(span, commandObj.callback)
        if (span) {
    

    

          span.start(String(command).toUpperCase(), 'redis')
          
          var connection = this.connection_options
          var db_name = this.selected_db || 0

          span.options = {
            host: connection.host,
            port: connection.port,
            resTime: '',
            nodeOrder: '',
            error: '',
            serverType: 'redis',
            command: db_name +'#'+ command 
          }
        }


      }

      return original.apply(this, arguments)
    }
  }

  function wrapSendCommand (original) {
    return function wrappedSendCommand (command) {
      var span = enabled && agent.buildSpan()
      var id = span && span.transaction.id
      var args = Array.prototype.slice.call(arguments)

      logger.debug(appendMsg ,'intercepted call to RedisClient.prototype.internal_send_command', {
        id: id,
        command: command
      })

      //command


      if (args.length > 0) {
        var index = args.length - 1
        var cb = args[index]
        if (typeof cb === 'function') {
          args[index] = makeWrappedCallback(span, cb)
        } else if (Array.isArray(cb) && typeof cb[cb.length - 1] === 'function') {
          cb[cb.length - 1] = makeWrappedCallback(span, cb[cb.length - 1])
        } else {
          var obCb = makeWrappedCallback(span)
          if (typeof args[index] === 'undefined') {
            args[index] = obCb
          } else {
            args.push(obCb)
          }
        }
        if (span) span.start(String(command).toUpperCase(), 'redis')
      }

      return original.apply(this, args)
    }
  }
}
