'use strict'

var semver = require('semver')
var shimmer = require('../shimmer')
var logger = require('../../logger')
var appendMsg = 'Tedious :'

module.exports = function (tedious, agent, version, enabled) {
  if (!enabled) return tedious
  if (!semver.satisfies(version, '>=0.0.5')) {
    logger.debug(appendMsg,'version not supported - aborting...', version)
    return tedious
  } else {
    logger.debug(appendMsg ,'version is supported', version)
  }

  const ins = agent._instrumentation
  logger.debug(appendMsg ,'wrapping tedious.Connection function')
  shimmer.wrap(tedious, 'Connection', wrapConnection)
  shimmer.wrap(tedious, 'Request', wrapRequest)

  return tedious

  function wrapRequest(OriginalRequest) {
    class Request extends OriginalRequest {
      constructor() {
        super(...arguments)
        ins.bindEmitter(this)
      }
    }

    return Request
  }

  function wrapConnection(OriginalConnection) {
    class Connection extends OriginalConnection {
      constructor() {
        super(...arguments)
        ins.bindEmitter(this)
      }

      makeRequest(request) {
        const span = agent.startSpan(null, 'db.mssql.query')
        if (!span) {
          return super.makeRequest(...arguments)
        }

        const preparing = request.sqlTextOrProcedure === 'sp_prepare'
        const params = request.parametersByName
        const sql = (params.statement || params.stmt || {}).value
        span.name = (sql) + (preparing ? ' (prepare)' : '')


        if (this.config) {
          var host = this.config.server || ''
          var dbName = this.config.options.database || ''
          var port = this.config.options.port || ''

          //Collect options
          span.options = {
            host: host,
            port: port,
            dbName: dbName,
            resTime: '',
            serverType: 'mssql',
            error: '',
            nodeOrder: '',
            query: sql
          }

        }

        request.userCallback = wrapCallback(request.userCallback)

        return super.makeRequest(...arguments)

        function wrapCallback(cb) {
          return function () {
            span.end()
            return cb && cb.apply(this, arguments)
          }
        }
      }
    }

    return Connection
  }
}