/*
 * Decompiled with CFR 0.152.
 */
package com.eg.cli;

import com.eg.cli.CLIConfigInfo;
import com.eg.cli.URLConnect;
import com.eg.cli.Validator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class AccountController
extends JPanel
implements ActionListener,
FocusListener {
    private String[] strLabel = new String[]{"Manager IP / Host name", "Port", "SSL Enabled", "eG Login ID", "eG Password", "Allow this account for all users", "Manager ID"};
    private JTextField ipField;
    private JTextField portField;
    private JTextField loginIDField;
    private JPasswordField pwdField;
    private JRadioButton sslFieldYes;
    private JRadioButton sslFieldNo;
    private JRadioButton exUsrFieldYes;
    private JRadioButton exUsrFieldNo;
    private JTextField managerIDField;
    private int row = this.strLabel.length + 1;
    private String action = "add";
    private String operation;
    private String oldMgrID;
    private boolean defaultIDEnabled = false;

    public AccountController() {
        this("add", null);
    }

    public AccountController(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        this.operation = string;
        ArrayList arrayList = null;
        if (string.equalsIgnoreCase("modify")) {
            this.action = string;
            this.oldMgrID = string2;
            arrayList = CLIConfigInfo.getCredentials(string2);
            if (!CLIConfigInfo.isValidCurrentUser(arrayList)) {
                System.out.println("Error: Current user authentication failed for this account");
                System.exit(0);
            }
        }
        int n = -1;
        boolean bl = arrayList == null || arrayList.size() == 0;
        Border border = BorderFactory.createLineBorder(Color.black);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        borderLayout.setHgap(10);
        JLabel jLabel = new JLabel("  ");
        this.add((Component)jLabel, "North");
        jLabel = new JLabel("  ");
        this.add((Component)jLabel, "East");
        jLabel = new JLabel("  ");
        this.add((Component)jLabel, "West");
        JPanel jPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(this.row - 1, 1);
        gridLayout.setHgap(5);
        gridLayout.setVgap(5);
        jPanel.setLayout(gridLayout);
        Font font = new Font("Verdana Unicode", 1, 11);
        JLabel jLabel2 = new JLabel(this.strLabel[0]);
        this.ipField = new JTextField(20);
        jLabel2.setLabelFor(this.ipField);
        this.ipField.setFont(font);
        jLabel2.setFont(font);
        jLabel2.setHorizontalAlignment(2);
        this.ipField.setHorizontalAlignment(10);
        this.ipField.addFocusListener(this);
        if (!bl && (n = arrayList.indexOf("mgrip")) != -1) {
            this.ipField.setText((String)arrayList.get(n + 1));
        }
        jPanel.add(jLabel2);
        jPanel.add(this.ipField);
        JLabel jLabel3 = new JLabel(this.strLabel[1]);
        this.portField = new JTextField(20);
        jLabel3.setLabelFor(this.portField);
        jLabel3.setFont(font);
        this.portField.setFont(font);
        jLabel3.setHorizontalAlignment(2);
        this.portField.setHorizontalAlignment(10);
        if (!bl && (n = arrayList.indexOf("mgrport")) != -1) {
            this.portField.setText((String)arrayList.get(n + 1));
        }
        jPanel.add(jLabel3);
        jPanel.add(this.portField);
        JLabel jLabel4 = new JLabel(this.strLabel[2]);
        jLabel4.setFont(font);
        jLabel4.setHorizontalAlignment(2);
        jLabel4.setVerticalAlignment(3);
        this.sslFieldYes = new JRadioButton("Yes");
        this.sslFieldNo = new JRadioButton("No");
        this.sslFieldNo.setSelected(true);
        if (!bl && (n = arrayList.indexOf("ssl")) != -1 && ((String)(object3 = (String)arrayList.get(n + 1))).equalsIgnoreCase("yes")) {
            this.sslFieldYes.setSelected(true);
        }
        object3 = new ButtonGroup();
        ((ButtonGroup)object3).add(this.sslFieldYes);
        ((ButtonGroup)object3).add(this.sslFieldNo);
        this.sslFieldYes.setFont(font);
        this.sslFieldNo.setFont(font);
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout(3, 5, 5);
        jPanel2.setLayout(flowLayout);
        jPanel2.add(this.sslFieldYes);
        jPanel2.add(this.sslFieldNo);
        jPanel.add(jLabel4);
        jPanel.add(jPanel2);
        JLabel jLabel5 = new JLabel(this.strLabel[3]);
        jLabel5.setFont(font);
        this.loginIDField = new JTextField(20);
        this.loginIDField.setFont(font);
        jLabel5.setLabelFor(this.loginIDField);
        jLabel5.setHorizontalAlignment(2);
        this.loginIDField.setHorizontalAlignment(10);
        if (!bl) {
            n = arrayList.indexOf("eguser");
            int n2 = n = n == -1 ? arrayList.indexOf("user") : n;
            if (n != -1) {
                this.loginIDField.setText((String)arrayList.get(n + 1));
            }
        }
        jPanel.add(jLabel5);
        jPanel.add(this.loginIDField);
        JLabel jLabel6 = new JLabel(this.strLabel[4]);
        jLabel6.setFont(font);
        this.pwdField = new JPasswordField(20);
        this.pwdField.setFont(font);
        this.pwdField.setEchoChar('*');
        jLabel6.setLabelFor(this.pwdField);
        jLabel6.setHorizontalAlignment(2);
        this.pwdField.setHorizontalAlignment(10);
        if (!bl && (n = arrayList.indexOf("pwd")) != -1) {
            object2 = (String)arrayList.get(n + 1);
            this.pwdField.setText((String)object2);
        }
        jPanel.add(jLabel6);
        jPanel.add(this.pwdField);
        object2 = new JLabel(this.strLabel[5]);
        ((JComponent)object2).setFont(font);
        ((JLabel)object2).setHorizontalAlignment(2);
        ((JLabel)object2).setVerticalAlignment(3);
        this.exUsrFieldYes = new JRadioButton("Yes");
        this.exUsrFieldNo = new JRadioButton("No");
        this.exUsrFieldYes.setSelected(true);
        if (!bl && (n = arrayList.indexOf("allowallusers")) != -1 && ((String)(object = (String)arrayList.get(n + 1))).equalsIgnoreCase("no")) {
            this.exUsrFieldNo.setSelected(true);
            this.exUsrFieldYes.setSelected(false);
        }
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.exUsrFieldYes);
        ((ButtonGroup)object).add(this.exUsrFieldNo);
        this.exUsrFieldYes.setFont(font);
        this.exUsrFieldNo.setFont(font);
        JPanel jPanel3 = new JPanel();
        FlowLayout flowLayout2 = new FlowLayout(3, 5, 5);
        jPanel3.setLayout(flowLayout2);
        jPanel3.add(this.exUsrFieldYes);
        jPanel3.add(this.exUsrFieldNo);
        jPanel.add((Component)object2);
        jPanel.add(jPanel3);
        JLabel jLabel7 = new JLabel(this.strLabel[6]);
        this.managerIDField = new JTextField(20);
        jLabel7.setLabelFor(this.managerIDField);
        jLabel7.setFont(font);
        this.managerIDField.setFont(font);
        jLabel7.setHorizontalAlignment(2);
        this.managerIDField.setHorizontalAlignment(10);
        if (!bl) {
            this.managerIDField.setText(string2);
        }
        jPanel.add(jLabel7);
        jPanel.add(this.managerIDField);
        JPanel jPanel4 = new JPanel();
        FlowLayout flowLayout3 = new FlowLayout(1, 5, 5);
        jPanel4.setLayout(flowLayout3);
        JButton jButton = new JButton("VALIDATE");
        jButton.setFont(font);
        jPanel4.add(jButton);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("CLEAR");
        jButton2.setFont(font);
        jPanel4.add(jButton2);
        jButton2.addActionListener(this);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel4, "South");
    }

    public void focusLost(FocusEvent focusEvent) {
        String string = this.managerIDField.getText();
        if (this.action.equalsIgnoreCase("modify") || string != null && string.length() > 0) {
            return;
        }
        String string2 = this.ipField.getText();
        this.managerIDField.setText(string2);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        String string = jButton.getText();
        if (string.equalsIgnoreCase("VALIDATE")) {
            Object object;
            String string2;
            Object object2;
            Validator validator = new Validator();
            String string3 = "Please enter the valid";
            String string4 = this.ipField.getText();
            if (string4 == null || string4.length() == 0) {
                JOptionPane.showMessageDialog(this, string3 + " 'Manager IP \\ Host name'");
                return;
            }
            String string5 = this.portField.getText();
            if (!validator.isValidPort(string5)) {
                JOptionPane.showMessageDialog(this, string3 + " 'Port'");
                return;
            }
            String string6 = this.loginIDField.getText();
            if (!validator.isValidUser(string6)) {
                JOptionPane.showMessageDialog(this, string3 + " 'Login ID'");
                return;
            }
            char[] cArray = this.pwdField.getPassword();
            String string7 = new String(cArray);
            if (!validator.isValidPwd(string7)) {
                JOptionPane.showMessageDialog(this, string3 + " 'Password'");
                return;
            }
            String string8 = this.managerIDField.getText();
            if (string8 == null || string8.equals("") || string8.equalsIgnoreCase("null")) {
                JOptionPane.showMessageDialog(this, string3 + " 'Manager ID'");
                return;
            }
            if (string8.indexOf(" ") > -1) {
                JOptionPane.showMessageDialog(this, " Blank space is not allowed in 'Manager ID'");
                return;
            }
            if (!validator.isValidMgrID(string8)) {
                JOptionPane.showMessageDialog(this, " Special characters are not allowed in 'Manager ID'");
                return;
            }
            if (this.operation.equalsIgnoreCase("add") && ((File)(object2 = new File(string2 = CLIConfigInfo.Accounts_File_Dir + CLIConfigInfo.separator + string8 + ".account"))).exists()) {
                JOptionPane.showMessageDialog(this, "Manager ID already exist, please enter new one");
                return;
            }
            string7 = CLIConfigInfo.AESencrypt(string7);
            string2 = null;
            string2 = this.sslFieldYes.isSelected() ? this.validate(string4, string5, string6, string7, true) : this.validate(string4, string5, string6, string7, false);
            object2 = "";
            String string9 = "";
            String string10 = "";
            if (string2 != null && string2.indexOf(",") > 0) {
                object = new StringTokenizer(string2, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    object2 = ((StringTokenizer)object).nextToken();
                    string9 = ((StringTokenizer)object).nextToken();
                    string10 = ((StringTokenizer)object).nextToken();
                }
            }
            if (string2 != null && string2.equals("LOGIN_SUCCESS")) {
                String string11;
                Object object3;
                object = this.managerIDField.getText();
                if (((String)object).length() == 0) {
                    int n = JOptionPane.showConfirmDialog(this, "By defalut, Manager IP is considered as Manager ID. Do you want to continue?", "Confirm", 0, 3, null);
                    if (n == 1) {
                        this.managerIDField.requestFocus();
                        return;
                    }
                    this.defaultIDEnabled = true;
                }
                String string12 = System.getProperty("user.name");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("mgrip#" + string4);
                arrayList.add("mgrport#" + string5);
                if (this.sslFieldYes.isSelected()) {
                    arrayList.add("ssl#yes");
                }
                if (this.sslFieldNo.isSelected()) {
                    arrayList.add("ssl#no");
                }
                arrayList.add("eguser#" + CLIConfigInfo.AESencrypt(string6));
                arrayList.add("pwd#" + string7);
                arrayList.add("systemuser#" + CLIConfigInfo.AESencrypt(string12));
                if (this.exUsrFieldYes.isSelected()) {
                    arrayList.add("allowallusers#" + CLIConfigInfo.AESencrypt("yes"));
                }
                if (this.exUsrFieldNo.isSelected()) {
                    arrayList.add("allowallusers#" + CLIConfigInfo.AESencrypt("no"));
                }
                if (object2 != null && ((String)object2).length() > 0) {
                    arrayList.add("secmgrip#" + (String)object2);
                    arrayList.add("secmgrport#" + string9);
                    if (string10.equalsIgnoreCase("true")) {
                        arrayList.add("secssl#yes");
                    } else if (string10.equalsIgnoreCase("false")) {
                        arrayList.add("secssl#no");
                    }
                }
                this.writeToFile(arrayList);
                if (this.action.equals("modify") && ((File)(object3 = new File(string11 = CLIConfigInfo.Accounts_File_Dir + CLIConfigInfo.separator + this.oldMgrID + ".account"))).exists() && !((String)object).equals(this.oldMgrID)) {
                    ((File)object3).delete();
                }
                string11 = CLIConfigInfo.CLI_Install_Dir + CLIConfigInfo.separator + "images" + CLIConfigInfo.separator + "icon_okay.gif";
                object3 = Toolkit.getDefaultToolkit().getImage(string11);
                ImageIcon imageIcon = new ImageIcon((Image)object3);
                JOptionPane.showMessageDialog(this, "Registered Successfully.", null, -1, imageIcon);
                System.exit(0);
            } else if (string2 != null && !string2.equals("EXCEPTION")) {
                JOptionPane.showMessageDialog(this, string2, null, 0, null);
            } else {
                JOptionPane.showMessageDialog(this, "Problem in communicating with the manager !", null, 2, null);
            }
        } else if (string.equalsIgnoreCase("clear")) {
            this.ipField.setText("");
            this.portField.setText("");
            this.loginIDField.setText("");
            this.pwdField.setText("");
            this.sslFieldNo.setSelected(true);
            this.managerIDField.setText("");
        }
    }

    public String validate(String string, String string2, String string3, String string4, boolean bl) {
        URLConnect uRLConnect = new URLConnect();
        uRLConnect.setManagerIP(string);
        uRLConnect.setManagerPort(string2);
        uRLConnect.setSSLEnabled(bl);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("login_id", string3);
        hashtable.put("login_pwd", string4);
        uRLConnect.setResource(hashtable);
        uRLConnect.setServerFile("CLIUserAuthServlet");
        uRLConnect.connect();
        String string5 = uRLConnect.getLoginStatus();
        return string5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            System.out.println("Please enter the values.");
        }
        BufferedWriter bufferedWriter = null;
        try {
            this.createDir();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CLIConfigInfo.Accounts_File_Dir);
            stringBuffer.append(CLIConfigInfo.separator);
            if (this.defaultIDEnabled) {
                stringBuffer.append(this.ipField.getText());
            } else {
                stringBuffer.append(this.managerIDField.getText());
            }
            stringBuffer.append(CLIConfigInfo.suffix);
            FileOutputStream fileOutputStream = new FileOutputStream(stringBuffer.toString());
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
            bufferedWriter = new BufferedWriter(printWriter);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = (String)arrayList.get(i);
                bufferedWriter.write(string, 0, string.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error while writing the credential to the file.");
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void createDir() {
        boolean bl = false;
        try {
            File file = new File(CLIConfigInfo.Accounts_File_Dir);
            if (file.exists()) {
                return;
            }
            bl = file.mkdirs();
        }
        catch (Exception exception) {
            System.out.println("Error : Cannot create the Directory.");
        }
        if (!bl) {
            System.out.println("Error : Cannot create the Directory.");
            System.exit(1);
        }
    }

    public void createRegisterWindow() {
        String string = "Add New Account";
        if (this.action.equalsIgnoreCase("modify")) {
            string = "Modify Account";
        }
        JFrame jFrame = new JFrame(string);
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(this);
        jFrame.pack();
        jFrame.setSize(this.row * 50, this.row * 36);
        jFrame.setResizable(false);
        jFrame.setVisible(true);
        String string2 = "";
        Image image = Toolkit.getDefaultToolkit().getImage(string2);
        image = image.getScaledInstance(300, 300, 4);
        jFrame.setIconImage(image);
    }

    public static void main(String[] stringArray) {
        AccountController accountController = new AccountController();
        accountController.createRegisterWindow();
    }
}

