/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.pattern.parser;

import com.eg.ch.qos.logback.core.pattern.parser.Token;
import com.eg.ch.qos.logback.core.pattern.parser.TokenStream;
import com.eg.ch.qos.logback.core.pattern.util.AsIsEscapeUtil;
import com.eg.ch.qos.logback.core.pattern.util.IEscapeUtil;
import com.eg.ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionTokenizer {
    private static final int EXPECTING_STATE = 0;
    private static final int RAW_COLLECTING_STATE = 1;
    private static final int QUOTED_COLLECTING_STATE = 2;
    final IEscapeUtil escapeUtil;
    final TokenStream tokenStream;
    final String pattern;
    final int patternLength;
    char quoteChar;
    int state = 0;

    OptionTokenizer(TokenStream tokenStream) {
        this(tokenStream, new AsIsEscapeUtil());
    }

    OptionTokenizer(TokenStream tokenStream, IEscapeUtil iEscapeUtil) {
        this.tokenStream = tokenStream;
        this.pattern = tokenStream.pattern;
        this.patternLength = tokenStream.patternLength;
        this.escapeUtil = iEscapeUtil;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void tokenize(char c2, List<Token> list) throws ScanException {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        char c3 = c2;
        while (this.tokenStream.pointer < this.patternLength) {
            block0 : switch (this.state) {
                case 0: {
                    switch (c3) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': 
                        case ',': {
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.state = 2;
                            this.quoteChar = c3;
                            break block0;
                        }
                        case '}': {
                            this.emitOptionToken(list, arrayList);
                            return;
                        }
                    }
                    stringBuffer.append(c3);
                    this.state = 1;
                    break;
                }
                case 1: {
                    switch (c3) {
                        case ',': {
                            arrayList.add(stringBuffer.toString().trim());
                            stringBuffer.setLength(0);
                            this.state = 0;
                            break block0;
                        }
                        case '}': {
                            arrayList.add(stringBuffer.toString().trim());
                            this.emitOptionToken(list, arrayList);
                            return;
                        }
                    }
                    stringBuffer.append(c3);
                    break;
                }
                case 2: {
                    if (c3 == this.quoteChar) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        this.state = 0;
                        break;
                    }
                    if (c3 == '\\') {
                        this.escape(String.valueOf(this.quoteChar), stringBuffer);
                        break;
                    }
                    stringBuffer.append(c3);
                }
            }
            c3 = this.pattern.charAt(this.tokenStream.pointer);
            ++this.tokenStream.pointer;
        }
        if (c3 != '}') throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
        if (this.state == 0) {
            this.emitOptionToken(list, arrayList);
            return;
        } else {
            if (this.state != 1) throw new ScanException("Unexpected end of pattern string in OptionTokenizer");
            arrayList.add(stringBuffer.toString().trim());
            this.emitOptionToken(list, arrayList);
        }
    }

    void emitOptionToken(List<Token> list, List<String> list2) {
        list.add(new Token(1006, list2));
        this.tokenStream.state = TokenStream.TokenizerState.LITERAL_STATE;
    }

    void escape(String string, StringBuffer stringBuffer) {
        if (this.tokenStream.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.tokenStream.pointer++);
            this.escapeUtil.escape(string, stringBuffer, c2, this.tokenStream.pointer);
        }
    }
}

