/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class EgSapGenericJco2Test
extends AsAbapTblJco2Base {
    private String XMIAuditLevel = "";
    private int AuditLevel = 0;
    public final SimpleDateFormat MTETimeStampSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Hashtable ht_lastTime = new Hashtable();
    private static Hashtable ht_confLastTime = new Hashtable();
    private static Hashtable ht_minConfTestFreq = new Hashtable();
    protected static Hashtable ht_ht_monValues = new Hashtable();
    protected static Hashtable ht_ht_confValues = new Hashtable();
    protected static Hashtable ht_ht_StatusValues = new Hashtable();
    protected static Hashtable ht_sapVersion = new Hashtable();
    protected static Hashtable ht_testStatus = new Hashtable();
    protected static Hashtable ht_ht_mteTimeStamps = new Hashtable();
    protected static Hashtable errCodeTbl;
    private IRepository rep;
    private boolean isAbapSystemComp = false;
    String SID = null;
    private static Hashtable syncHash;
    private static final String syncString;
    private static final String syncString2;
    private static final String syncString3;
    private static final ArrayList perfAttrList;
    private String sapVersion = "";
    private static final String MON_SET_NAME = "SAP CCMS Monitor Templates";
    private long perfCutoff = 0L;
    protected boolean isSapCCMSConfigTest = false;

    public EgSapGenericJco2Test(String[] stringArray) {
        super(stringArray);
        this.instanceName = this.getInstanceName();
        this.perfCutoff = (long)(0.9 * (double)this.measurePeriod);
        this.SID = this.getSID();
    }

    protected void setIsSapCCMSConfigTest() {
        this.isSapCCMSConfigTest = true;
    }

    protected void setDataForSystem(boolean bl) {
        this.isAbapSystemComp = true;
        this.setData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        String string;
        Object object;
        long l = 0L;
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        JCO.Client client2 = null;
        if (this.isSapCCMSConfigTest) {
            this.printOut("CONF_DEBUG : Config test with measure period " + this.measurePeriod);
            object = (Long)ht_minConfTestFreq.get(this.thisServer);
            if (object == null) {
                string = syncString3;
                synchronized (string) {
                    object = (Long)ht_minConfTestFreq.get(this.thisServer);
                    if (object == null) {
                        this.printOut("CONF_DEBUG : Setting min conf test freq for first time for " + this.thisServer);
                        object = new Long(0L);
                        ht_minConfTestFreq.put(this.thisServer, new Long(this.measurePeriod));
                        this.printOut("CONF_DEBUG : Initialized minConfTestFreq for " + this.thisServer + " to " + ((Long)object).toString());
                    }
                }
            }
            this.printOut("CONF_DEBUG : comparing measurePeriod " + this.measurePeriod + " for " + this.thisServer + " with minConfTestFreq " + ((Long)object).toString());
            if (this.measurePeriod < (Long)object) {
                string = syncString3;
                synchronized (string) {
                    if (this.measurePeriod < (Long)object) {
                        this.printOut("CONF_DEBUG : Updating minConfTestFreq to " + this.measurePeriod + " for " + this.thisServer);
                        object = new Long(this.measurePeriod);
                        ht_minConfTestFreq.put(this.thisServer, object);
                    }
                }
            }
        }
        object = null;
        object = (String)syncHash.get(this.targetHost);
        if (object == null) {
            string = syncString;
            synchronized (string) {
                object = (String)syncHash.get(this.targetHost);
                if (object == null) {
                    syncHash.put(this.targetHost, new String(this.targetHost));
                    object = (String)syncHash.get(this.targetHost);
                }
            }
        }
        string = object;
        synchronized (string) {
            Object object2;
            this.isDynamicInfoTest = false;
            long l3 = System.currentTimeMillis();
            Long l4 = null;
            try {
                l4 = (Long)ht_lastTime.get(this.thisServer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l5 = 0L;
            if (l4 != null) {
                l5 = l4;
            }
            long l6 = l3 - l5;
            if (this.isDebugOn) {
                this.printOut(this.entity + " diff " + l6 + " perfCutoff " + this.perfCutoff);
            }
            if (l6 >= this.perfCutoff) {
                bl = true;
                l5 = l3;
                object2 = syncString2;
                synchronized (object2) {
                    try {
                        ht_lastTime.put(this.thisServer, new Long(l5));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.printOut("ERROR : ht_lasttime put exception " + exception.toString());
                        return;
                    }
                }
            }
            bl = false;
            this.printOut("getDataFromSAP = " + bl);
            if (bl) {
                try {
                    l4 = (Long)ht_confLastTime.get(this.thisServer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                l5 = 0L;
                if (l4 != null) {
                    l5 = l4;
                }
                l6 = l3 - l5;
                if (this.isDebugOn) {
                    this.printOut(this.entity + " diff " + l6 + " perfCutoff " + this.perfCutoff);
                }
                object2 = (Long)ht_minConfTestFreq.get(this.thisServer);
                long l7 = 0L;
                if (object2 != null) {
                    l7 = (Long)object2;
                }
                if ((double)l6 >= 0.9 * (double)l7) {
                    bl2 = true;
                    this.printOut("CONF_DEBUG : get Conf Data From SAP = true");
                }
                long l8 = System.currentTimeMillis();
                hashtable = new Hashtable();
                if (bl2) {
                    this.printOut("CONF_DEBUG: initializing conf HT");
                    hashtable3 = new Hashtable();
                }
                hashtable2 = new Hashtable();
                try {
                    Object object3;
                    Hashtable hashtable4;
                    Object object4;
                    client2 = this.getConnection();
                    if (client2 == null) {
                        String string2 = syncString2;
                        synchronized (string2) {
                            try {
                                ht_ht_monValues.put(this.thisServer, hashtable);
                                if (bl2) {
                                    this.printOut("CONF_DEBUG: Resetting conf HT for instance : " + this.thisServer);
                                    ht_ht_confValues.put(this.thisServer, hashtable3);
                                }
                                ht_ht_StatusValues.put(this.thisServer, hashtable2);
                                ht_sapVersion.put(this.thisServer, new String(this.sapVersion));
                                ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                            }
                            catch (Exception exception) {
                                this.printOut("Exception while setting data values (after connection failure) : " + exception.toString());
                            }
                            this.releaseClient(client2);
                        }
                        this.printOut("server:" + this.thisServer);
                        ht_testStatus.put(this.thisServer, new Boolean(false));
                        return;
                    }
                    l = System.currentTimeMillis();
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - getConnection method took " + (l - l8) + " ms");
                    }
                    if (!this.logonToXMI(client2)) {
                        String string3 = syncString2;
                        synchronized (string3) {
                            try {
                                ht_ht_monValues.put(this.thisServer, hashtable);
                                if (bl2) {
                                    ht_ht_confValues.put(this.thisServer, hashtable3);
                                }
                                ht_ht_StatusValues.put(this.thisServer, hashtable2);
                                ht_sapVersion.put(this.thisServer, new String(this.sapVersion));
                                ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                            }
                            catch (Exception exception) {
                                this.printOut("Exception while setting data values (after logon error) : " + exception.toString());
                                this.logToErrorFile("ERROR", this.entity, "Exception while setting data values (after logon error) : " + exception.toString());
                            }
                        }
                        ht_testStatus.put(this.thisServer, new Boolean(false));
                        this.logoffAndReleaseClient(client2);
                        return;
                    }
                    ht_testStatus.put(this.thisServer, new Boolean(true));
                    if (this.isDebugOn) {
                        this.printOut("Tracing - - logged on to XMI " + (System.currentTimeMillis() - l8));
                    }
                    JCO.Table table = this.getMonitors(client2);
                    this.printOut("Tracing - Got Monitors in " + (System.currentTimeMillis() - l8));
                    if (table != null) {
                        int n = table.getNumRows();
                        for (int i = 0; i < n; ++i) {
                            object4 = table.getString("MONI_NAME");
                            if (object4 == null || ((String)object4).length() <= 0) continue;
                            if (this.isDebugOn) {
                                this.printOut("Trying to get data from monitor  tree root : " + (String)object4);
                            }
                            this.populateMonValuesFromTree((String)object4, client2, bl2);
                            table.nextRow();
                        }
                    }
                    this.logoffAndReleaseClient(client2);
                    Hashtable hashtable5 = (Hashtable)ht_ht_monValues.get(this.thisServer);
                    if (hashtable5 != null) {
                        Enumeration enumeration = hashtable5.keys();
                        while (enumeration.hasMoreElements()) {
                            object4 = (String)enumeration.nextElement();
                            this.printOut("Monitor Values. key ( " + (String)object4 + " ) Value = " + (ArrayList)hashtable5.get(object4));
                        }
                    }
                    if ((hashtable4 = (Hashtable)ht_ht_StatusValues.get(this.thisServer)) != null) {
                        object4 = hashtable4.keys();
                        while (object4.hasMoreElements()) {
                            object3 = (String)object4.nextElement();
                            this.printOut("Status Values. key ( " + (String)object3 + " ) Value =  " + (ArrayList)hashtable4.get(object3));
                        }
                    }
                    if (bl2 && (object4 = (Hashtable)ht_ht_confValues.get(this.thisServer)) != null) {
                        object3 = ((Hashtable)object4).keys();
                        while (object3.hasMoreElements()) {
                            String string4 = (String)object3.nextElement();
                            this.printOut("Config Values. key ( " + string4 + " ) Value = " + (ArrayList)((Hashtable)object4).get(string4));
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    try {
                        this.logoffAndReleaseClient(client2);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
                String string5 = syncString2;
                synchronized (string5) {
                    try {
                        ht_lastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                }
            }
            if ((object2 = (Boolean)ht_testStatus.get(this.thisServer)) != null && ((Boolean)object2).booleanValue()) {
                this.isDynamicInfoTest = true;
            }
        }
        if (this.isDebugOn) {
            this.printOut("setData took " + (System.currentTimeMillis() - l2) + "ms.");
        }
    }

    private JCO.Table getMonitors(JCO.Client client2) {
        long l = System.currentTimeMillis();
        JCO.Function function = null;
        try {
            function = this.createFunction("BAPI_SYSTEM_MON_GETLIST");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MON_GETLIST not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MON_GETLIST not found in SAP " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        JCO.Structure structure = function.getImportParameterList().getStructure("MONI_SET_NAME");
        if (structure == null) {
            return null;
        }
        structure.setValue(MON_SET_NAME, "NAME");
        try {
            this.executeFunction(function, client2, true);
            JCO.Table table = function.getTableParameterList().getTable("MONITOR_NAMES");
            if (table == null) {
                this.printOut("Could not obtain monitor_names table");
                return null;
            }
            table.setRow(0);
            if (this.isDebugOn) {
                this.printOut("getMonitorsForSet [MON_GETLIST] for set 'SAP CCMS Monitor Templates' took " + (System.currentTimeMillis() - l) + "ms.");
            }
            this.printOut("got monitor list table");
            return table;
        }
        catch (Exception exception) {
            this.printOut("Error getting monitors : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error getting monitors : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateMonValuesFromTree(String string, JCO.Client client2, boolean bl) {
        String string2;
        Hashtable<String, ArrayList<String>> hashtable;
        Hashtable<String, ArrayList<String>> hashtable2;
        int n;
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MON_GETTREE");
        if (function == null) {
            return;
        }
        arrayList = new ArrayList<String>();
        if (bl) {
            arrayList2 = new ArrayList<String>();
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        JCO.Table table = null;
        Object var12_10 = null;
        String string3 = new String();
        String string4 = "";
        String string5 = "";
        boolean bl2 = false;
        try {
            function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            JCO.Structure structure = function.getImportParameterList().getStructure("MONITOR_NAME");
            structure.setValue(string, "MONI_NAME");
            structure.setValue(MON_SET_NAME, "MS_NAME");
            this.executeFunction(function, client2, true);
            table = function.getTableParameterList().getTable("TREE_NODES");
            this.printOut("Time taken to get monitor tree [MON_GETTREE] for monitor " + string + " is " + (System.currentTimeMillis() - l) + "ms.");
            bl2 = perfAttrList.contains(string);
            n = table.getNumRows();
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            exception.printStackTrace();
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            String string6;
            string5 = table.getString("MSEGNAME");
            if (string5 == null) {
                table.nextRow();
                continue;
            }
            if ((string5 = string5.trim()) == null || string5.length() < 10) {
                table.nextRow();
                continue;
            }
            string4 = string5.substring(9);
            if (!this.isAbapSystemComp && !string4.equalsIgnoreCase(this.instanceName)) {
                table.nextRow();
                continue;
            }
            hashtable2 = table.getString("OBJECTNAME");
            hashtable = table.getString("MTCLASS");
            string2 = table.getString("MTNAMESHRT");
            String string7 = table.getString("MTMCNAME");
            if (this.isPerformanceAttribute((String)((Object)hashtable))) {
                if (bl2) {
                    string6 = this.getPerfValueForTID(table.getString("MTSYSID"), string7, table.getString("MTNUMRANGE"), table.getString("MTUID"), table.getString("MTCLASS"), table.getString("MTINDEX"), table.getString("EXTINDEX"), string2, string, (String)((Object)hashtable2), client2);
                    arrayList.add(string4 + "#" + hashtable2 + "|" + table.getString("MTNAMESHRT") + "|" + string6);
                }
            } else if (this.isStatusMessageAttribute((String)((Object)hashtable))) {
                string6 = this.getStatusMessageValue(table.getString("MTSYSID"), string7, table.getString("MTNUMRANGE"), table.getString("MTUID"), table.getString("MTCLASS"), table.getString("MTINDEX"), table.getString("EXTINDEX"), string2, string, client2);
                arrayList3.add(string4 + "#" + string6);
            } else if (bl && this.isTextAttribute((String)((Object)hashtable))) {
                string6 = this.getTxtPropMessageValue(table.getString("MTSYSID"), string7, table.getString("MTNUMRANGE"), table.getString("MTUID"), table.getString("MTCLASS"), table.getString("MTINDEX"), table.getString("EXTINDEX"), string2, string, client2);
                arrayList2.add(string4 + "#" + hashtable2 + "|" + table.getString("MTNAMESHRT") + "|" + string6);
            }
            table.nextRow();
        }
        Hashtable<String, ArrayList<String>> hashtable3 = null;
        hashtable2 = null;
        hashtable = null;
        try {
            hashtable3 = (Hashtable<String, ArrayList<String>>)ht_ht_monValues.get(this.thisServer);
            hashtable = (Hashtable)ht_ht_StatusValues.get(this.thisServer);
            hashtable2 = (Hashtable)ht_ht_confValues.get(this.thisServer);
        }
        catch (Exception exception) {
            this.printOut("Exception while setting data values. Resetting to null and initialized shortly : " + exception.toString());
            hashtable3 = null;
            hashtable = null;
            hashtable2 = null;
        }
        if (hashtable3 == null) {
            hashtable3 = new Hashtable<String, ArrayList<String>>();
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, ArrayList<String>>();
        }
        if (hashtable2 == null) {
            this.printOut("CONF_DEBUG : Initialized config values for " + this.thisServer);
            hashtable2 = new Hashtable<String, ArrayList<String>>();
        }
        hashtable3.put(string, arrayList);
        hashtable.put(string, arrayList3);
        if (bl) {
            this.printOut("CONF_DEBUG : Setting confValues for monitor " + string);
            this.printOut("CONF_DEBUG : confValues = " + arrayList2);
            hashtable2.put(string, arrayList2);
        }
        string2 = syncString2;
        synchronized (string2) {
            try {
                ht_ht_monValues.put(this.thisServer, hashtable3);
                ht_ht_StatusValues.put(this.thisServer, hashtable);
                if (bl) {
                    ht_confLastTime.put(this.thisServer, new Long(System.currentTimeMillis()));
                    ht_ht_confValues.put(this.thisServer, hashtable2);
                    this.printOut("CONF_DEBUG : Updated config values for server " + this.thisServer);
                }
                this.printOut("Updated monitor, status values for server " + this.thisServer);
                if (this.sapVersion != null && this.sapVersion.length() > 0) {
                    ht_sapVersion.put(this.thisServer, this.sapVersion);
                }
            }
            catch (Exception exception) {
                this.printOut("Exception while storing measures for " + this.thisServer + " : " + exception.toString());
                this.logToErrorFile("ERROR", "Exception while storing measures for " + this.thisServer, exception.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string4)) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getSystemWideData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    this.printOut("No data for : " + string);
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got systemwide data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getMonData4AllInst(String string, boolean bl) {
        Hashtable hashtable = null;
        Hashtable<String, Double> hashtable2 = null;
        Hashtable<String, Hashtable<String, Double>> hashtable3 = new Hashtable<String, Hashtable<String, Double>>();
        ArrayList arrayList = null;
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList2 = (ArrayList)hashtable.get(string);
                if (arrayList2 == null) {
                    this.printOut("No data for : " + string);
                    return null;
                }
                arrayList = (ArrayList)arrayList2.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getSystemWideDataByInst : " + exception.toString());
            }
        }
        int n = arrayList.size();
        hashtable2 = new Hashtable<String, Double>();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            String string3 = (String)arrayList.get(i);
            int n4 = string3.indexOf("#");
            if (n4 == -1) continue;
            String string4 = string3.substring(0, n4);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1 || (n3 = string3.lastIndexOf("|")) == -1) continue;
            String string5 = string3.substring(n4 + 1, n3);
            if (bl && (n2 = string5.indexOf("|")) != -1) {
                string5 = string5.substring(n2 + 1);
            }
            String string6 = string3.substring(n3 + 1);
            Double d = null;
            try {
                d = new Double(string6);
            }
            catch (NumberFormatException numberFormatException) {
                d = NaDbl;
            }
            hashtable2 = (Hashtable<String, Double>)hashtable3.get(string4);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable<String, Double>();
                hashtable3.put(string4, hashtable2);
            }
            hashtable2.put(string5, d);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " getMonData4AllInst for monitor " + string + " : " + hashtable3);
        }
        return hashtable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getSystemWideStatusMessage(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_StatusValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_StatusValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        this.printOut("Got system specific values : " + arrayList2);
        return arrayList2;
    }

    public Hashtable cloneHashtable(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)arrayList.get(i);
                int n2 = string2.indexOf("#");
                if (n2 < 0) {
                    arrayList2.add(string2);
                    continue;
                }
                String string3 = string2.substring(0, n2);
                if (!this.instanceName.equalsIgnoreCase(string3)) continue;
                String string4 = string2.substring(n2 + 1);
                arrayList2.add(string4);
            }
            hashtable2.put(string, arrayList2);
        }
        return hashtable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getStatus() {
        String string = syncString2;
        synchronized (string) {
            if (ht_ht_StatusValues == null) {
                return null;
            }
            if (ht_ht_StatusValues.size() == 0) {
                return new Hashtable();
            }
            return this.cloneHashtable((Hashtable)ht_ht_StatusValues.get(this.thisServer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getValue(String string) {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_StatusValues == null) {
                    return null;
                }
                Hashtable hashtable = (Hashtable)ht_ht_StatusValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No value");
                    return null;
                }
                object = null;
                try {
                    object = (ArrayList)hashtable.get(string);
                    if (object == null) {
                        return null;
                    }
                    arrayList = (ArrayList)((ArrayList)object).clone();
                }
                catch (Exception exception) {
                    this.printOut("Exception in getValue(): " + exception.toString());
                }
            }
            catch (Exception exception) {
                this.printOut("Exception in getValue() : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            object = (String)arrayList.get(i);
            int n2 = ((String)object).indexOf("#");
            if (n2 < 0) {
                arrayList2.add(object);
                continue;
            }
            String string3 = ((String)object).substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string3)) continue;
            String string4 = ((String)object).substring(n2 + 1);
            arrayList2.add(string4);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getConfigData(String string) {
        Hashtable hashtable = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_confValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_confValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No config data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (!this.instanceName.equalsIgnoreCase(string4)) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSapVersion() {
        String string = syncString2;
        synchronized (string) {
            this.printOut("htsapversion: '" + ht_sapVersion + "'");
            if (ht_sapVersion == null) {
                return null;
            }
            return (String)ht_sapVersion.get(this.thisServer);
        }
    }

    private String formatValue(String string, String string2) {
        String string3 = string;
        if (string == null || string2 == null) {
            return null;
        }
        int n = Integer.parseInt(string2);
        if (n > 0) {
            int n2;
            int n3 = string3.length();
            if (n > n3) {
                for (n2 = 0; n2 < n - n3; ++n2) {
                    string3 = "0" + string3;
                }
            }
            string3 = (n2 = string3.length() - n) == 0 ? "0." + string3 : string3.substring(0, n2) + "." + string3.substring(n2);
        }
        return string3;
    }

    private String getPerfValueForTID(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, JCO.Client client2) {
        String string11 = "";
        long l = System.currentTimeMillis();
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MTE_GETPERFCURVAL");
        if (function == null) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFCURVAL not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFCURVAL not found in SAP");
            return "";
        }
        function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        JCO.Structure structure = function.getImportParameterList().getStructure("TID");
        structure.setValue(string, "MTSYSID");
        structure.setValue(string2, "MTMCNAME");
        structure.setValue(string3, "MTNUMRANGE");
        structure.setValue(string4, "MTUID");
        structure.setValue(string5, "MTCLASS");
        structure.setValue(string6, "MTINDEX");
        structure.setValue(string7, "EXTINDEX");
        try {
            this.executeFunction(function, client2, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing getPerfValueForTID : " + exception.toString());
            return "";
        }
        try {
            String[] stringArray;
            JCO.Structure structure2 = function.getExportParameterList().getStructure("CURRENT_VALUE");
            string11 = structure2.getString("ALRELEVVAL");
            String string12 = structure2.getString("ALRELVALDT").trim();
            String string13 = structure2.getString("ALRELVALTI").trim();
            if (string12.length() != 0 && string13.length() != 0) {
                stringArray = string12 + " " + string13;
                String string14 = string9 + "|" + string10 + "|" + string2 + "|" + string8;
                Date date = null;
                try {
                    date = this.MTETimeStampSDF.parse((String)stringArray);
                }
                catch (Exception exception) {
                    this.printOut("Exception while parsing MTE timestamp " + (String)stringArray + " : " + exception.toString());
                }
                if (date != null) {
                    Date date2;
                    Hashtable<String, Date> hashtable = (Hashtable<String, Date>)ht_ht_mteTimeStamps.get(this.thisServer);
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, Date>();
                        ht_ht_mteTimeStamps.put(this.thisServer, hashtable);
                    }
                    if ((date2 = (Date)hashtable.get(string14)) != null) {
                        long l2;
                        long l3 = date2.getDate();
                        long l4 = date.getDate();
                        long l5 = l4 - l3;
                        if (l5 > 0L && (double)(l2 = l5 / 1000L) > 3.0 * this.timeSinceLastTest) {
                            this.printOut("Stale measure found " + string14 + ". prevDate " + date2.toString() + ", currDate " + date.toString());
                            return "";
                        }
                    }
                    hashtable.put(string14, date);
                }
            } else {
                return "";
            }
            stringArray = this.getPerfPropsForTID(string, string2, string3, string4, string5, string6, string7, string8, client2);
            if (stringArray != null) {
                string11 = this.formatValue(string11, stringArray[9]);
            }
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFCURVAL : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFCURVAL : " + exception.toString());
            exception.printStackTrace();
        }
        if (this.isDebugOn) {
            this.printOut("getPerfValueForTID for monitor name " + string9 + " and mtNameshrt " + string8 + "  returning " + string11 + " and took " + (System.currentTimeMillis() - l) + "ms.");
        }
        return string11;
    }

    private String[] getPerfPropsForTID(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, JCO.Client client2) {
        long l = System.currentTimeMillis();
        String[] stringArray = new String[10];
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MTE_GETPERFPROP");
        if (function == null) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFPROP not found in SAP.");
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFPROP not found in SAP");
            return null;
        }
        function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        JCO.Structure structure = function.getImportParameterList().getStructure("TID");
        structure.setValue(string, "MTSYSID");
        structure.setValue(string2, "MTMCNAME");
        structure.setValue(string3, "MTNUMRANGE");
        structure.setValue(string4, "MTUID");
        structure.setValue(string5, "MTCLASS");
        structure.setValue(string6, "MTINDEX");
        structure.setValue(string7, "EXTINDEX");
        try {
            this.executeFunction(function, client2, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing getPerfPropsForTID " + exception.toString());
            return null;
        }
        try {
            JCO.Structure structure2 = function.getExportParameterList().getStructure("PROPERTIES");
            stringArray[0] = structure2.getString("RELVALTYPE");
            stringArray[1] = structure2.getString("THRESHDIR");
            stringArray[2] = structure2.getString("TRESHG2Y");
            stringArray[3] = structure2.getString("TRESHY2R");
            stringArray[4] = structure2.getString("TRESHY2G");
            stringArray[5] = structure2.getString("TRESHR2Y");
            stringArray[6] = structure2.getString("MSGCLASS");
            stringArray[7] = structure2.getString("MSGID");
            stringArray[8] = structure2.getString("VALUNIT");
            stringArray[9] = structure2.getString("DECIMALS");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETPERFPROP : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETPERFPROP : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        return stringArray;
    }

    private String getStatusMessageValue(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, JCO.Client client2) {
        long l = System.currentTimeMillis();
        String string10 = "";
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MTE_GETSMVALUE");
        if (function == null) {
            return "";
        }
        function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        JCO.Structure structure = function.getImportParameterList().getStructure("TID");
        if (structure == null) {
            return "";
        }
        structure.setValue(string, "MTSYSID");
        structure.setValue(string2, "MTMCNAME");
        structure.setValue(string3, "MTNUMRANGE");
        structure.setValue(string4, "MTUID");
        structure.setValue(string5, "MTCLASS");
        structure.setValue(string6, "MTINDEX");
        structure.setValue(string7, "EXTINDEX");
        try {
            this.executeFunction(function, client2, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing executeFunction : " + exception.toString());
            return "";
        }
        String string11 = "";
        String string12 = "";
        try {
            JCO.Structure structure2 = function.getExportParameterList().getStructure("VALUE");
            if (structure2 == null) {
                return "";
            }
            string12 = structure2.getString("SMSGVALUE");
            string11 = structure2.getString("MSG");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETSMVALUE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETSMVALUE : " + exception.toString());
            exception.printStackTrace();
            return "";
        }
        if (string11.length() != 0 && string11 != null) {
            string10 = string11;
        }
        if (string12 != null && (string12.equals("1") || string12.equals("0"))) {
            string10 = string10 + "Ok";
        }
        if (this.isDebugOn) {
            this.printOut("getStatusMessageValue [MTE_GETSMVALUE] for monitor name " + string9 + " and mtNameShrt " + string8 + " returning " + string10 + " and took " + (System.currentTimeMillis() - l) + "ms.");
        }
        return string10;
    }

    private String getTxtPropMessageValue(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, JCO.Client client2) {
        long l = System.currentTimeMillis();
        String string10 = "";
        this.printOut("Starting getTxtPropMessageValue [BAPITXTPRP] for monitor name " + string9 + " and mtNameShrt " + string8);
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MTE_GETTXTPROP");
        if (function == null) {
            return "";
        }
        function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        JCO.Structure structure = function.getImportParameterList().getStructure("TID");
        if (structure == null) {
            return "";
        }
        structure.setValue(string, "MTSYSID");
        structure.setValue(string2, "MTMCNAME");
        structure.setValue(string3, "MTNUMRANGE");
        structure.setValue(string4, "MTUID");
        structure.setValue(string5, "MTCLASS");
        structure.setValue(string6, "MTINDEX");
        structure.setValue(string7, "EXTINDEX");
        try {
            this.executeFunction(function, client2, true);
        }
        catch (Exception exception) {
            this.printOut("Exception while executing executeFunction : " + exception.toString());
            return "";
        }
        String string11 = "";
        String string12 = "";
        try {
            JCO.Structure structure2 = function.getExportParameterList().getStructure("PROPERTIES");
            if (structure2 == null) {
                return "";
            }
            string12 = structure2.getString("TEXT");
        }
        catch (Exception exception) {
            this.printOut("BAPI_SYSTEM_MTE_GETTXTPROP : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "BAPI_SYSTEM_MTE_GETTXTPROP : " + exception.toString());
            exception.printStackTrace();
            return "";
        }
        if (this.isDebugOn) {
            this.printOut("getTxtPropMessageValue [BAPITXTPRP] for monitor name " + string9 + " and mtNameShrt " + string8 + " returning " + string12 + " and took " + (System.currentTimeMillis() - l) + "ms.");
        }
        return string12;
    }

    private boolean isPerformanceAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("100");
    }

    private boolean isMessageLogAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("101");
    }

    private boolean isStatusMessageAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("102");
    }

    private boolean isTextAttribute(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("110") || string.equals("111");
    }

    public static void main(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase("-password")) continue;
            stringArray[n + 1] = EgCrypt.decrypt((String)stringArray[n + 1]);
            break;
        }
        n = 1;
        EgSapGenericJco2Test egSapGenericJco2Test = new EgSapGenericJco2Test(stringArray);
        while (n != 0) {
            egSapGenericJco2Test.setData();
            egSapGenericJco2Test.printOut("Waiting 3 seconds");
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = 0;
        }
        egSapGenericJco2Test.printOut("Getting config data for System Configuration : ");
        ArrayList arrayList = egSapGenericJco2Test.getConfigData("System Configuration");
        if (arrayList != null) {
            egSapGenericJco2Test.printOut(arrayList.toString());
        } else {
            egSapGenericJco2Test.printOut("Null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getSystemData(String string) {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        ArrayList arrayList = new ArrayList();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = syncString2;
        synchronized (string2) {
            try {
                if (ht_ht_monValues == null) {
                    return null;
                }
                hashtable = (Hashtable)ht_ht_monValues.get(this.thisServer);
                if (hashtable == null || hashtable.size() == 0) {
                    this.printOut("No System data for " + this.entity);
                    return null;
                }
                ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                if (arrayList3 == null) {
                    return null;
                }
                arrayList = (ArrayList)arrayList3.clone();
            }
            catch (Exception exception) {
                this.printOut("Exception in getSystemData : " + exception.toString());
                this.logToErrorFile("ERROR", this.reportingName + ":" + this.entity, "Exception in getData : " + exception.toString());
            }
        }
        int n = arrayList.size();
        hashtable2 = new Hashtable();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)arrayList.get(i);
            int n2 = string3.indexOf("#");
            if (n2 < 0) {
                arrayList2.add(string3);
                continue;
            }
            String string4 = string3.substring(0, n2);
            if (this.SID != null && !this.SID.equals("") && string4.indexOf("_" + this.SID + "_") == -1) continue;
            String string5 = string3.substring(n2 + 1);
            arrayList2.add(string5);
            this.addValue(hashtable2, string4, string5);
        }
        if (this.isDebugOn) {
            this.printOut(this.entity + " Instance is " + this.instanceName + " Got data for monitor " + string + " : " + arrayList2);
        }
        return hashtable2;
    }

    public void addValue(Hashtable hashtable, String string, String string2) {
        ArrayList<String> arrayList = null;
        if (hashtable.containsKey(string)) {
            arrayList = (ArrayList<String>)hashtable.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string2);
        } else {
            arrayList = new ArrayList<String>();
            arrayList.add(string2);
        }
        hashtable.put(string, arrayList);
    }

    static {
        syncHash = new Hashtable();
        syncString = new String("SAP");
        syncString2 = new String("SAP2");
        syncString3 = new String("SAP3");
        perfAttrList = new ArrayList();
        perfAttrList.add("Background Processing");
        perfAttrList.add("Buffers");
        perfAttrList.add("Communications");
        perfAttrList.add("Database");
        perfAttrList.add("Enqueue");
        perfAttrList.add("Entire System");
        perfAttrList.add("Spool System");
        perfAttrList.add("System Configuration");
    }
}

