/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SybEngineTest
extends GenericTest {
    private String user;
    private String passwd;
    private String s_debug = "false";
    private boolean isDebug = false;
    private String driver = "com.sybase.jdbc4.jdbc.SybDriver";
    private static final int i_measureCount = 4;
    private Hashtable prevHash = new Hashtable();
    private String curTimeSecs = "";
    private String prevTimeSecs = "";
    private String query = "";
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";
    private String charSet = "";
    private String encryptPassword = "false";
    private boolean isCharsetProcNeeded = false;

    public SybEngineTest(String[] stringArray) {
        super(stringArray);
        Comparable<Boolean> comparable;
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.s_debug = this.getValueForParam("isdebug");
        this.charSet = this.getValueForParam("charset");
        this.encryptPassword = this.getValueForParam("encrypt_password");
        if (this.charSet == null || this.charSet.trim().length() == 0 || this.charSet.equalsIgnoreCase("NULL") || this.charSet.equalsIgnoreCase("none")) {
            this.isCharsetProcNeeded = true;
            this.charSet = this.defaultCharSet;
        }
        this.encryptPassword = this.encryptPassword != null && (this.encryptPassword.trim().equalsIgnoreCase("y") || this.encryptPassword.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        try {
            comparable = new Boolean(this.s_debug);
            this.isDebug = (Boolean)comparable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isDebug = false;
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append(" select EngineNumber engine_no, CPUTime cpu_time, ");
        ((StringBuffer)comparable).append(" SystemCPUTime sys_cpu_time, UserCPUTime user_cpu_time, ");
        ((StringBuffer)comparable).append(" IdleCPUTime idle_cpu_time, getdate()  as cur_date from monEngine ");
        this.query = ((StringBuffer)comparable).toString();
        System.out.println(this.entity + " query " + this.query);
        System.out.println(this.entity + " Inside Constructor ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        if (this.isCharsetProcNeeded && this.isFirstTime) {
            object = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword, this.driver, false);
            System.out.println(" charSetName :" + (String)object);
            if (object != null && ((String)object).length() > 0) {
                this.charSet = object;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        object = this.getConnection(this.targetHost, this.portNo, this.user, this.passwd, this.charSet, this.encryptPassword);
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        if (object == null) {
            return;
        }
        try {
            sybStatement = (SybStatement)object.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (object != null) {
                this.closeConn((SybConnection)object);
            }
            return;
        }
        Hashtable hashtable2 = new Hashtable();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            resultSet = sybStatement.executeQuery(this.query);
            while (resultSet.next()) {
                string = resultSet.getString(1);
                d = resultSet.getDouble(2);
                d2 = resultSet.getDouble(3);
                d3 = resultSet.getDouble(4);
                d4 = resultSet.getDouble(5);
                this.curTimeSecs = resultSet.getString(6);
                arrayList = new ArrayList();
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                hashtable2.put(string, arrayList);
            }
            if (this.prevHash != null && this.prevHash.size() > 0) {
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    ArrayList arrayList2 = (ArrayList)hashtable2.get(string2);
                    ArrayList arrayList3 = (ArrayList)this.prevHash.get(string2);
                    if (arrayList3 == null) continue;
                    double d5 = (Double)arrayList2.get(0);
                    double d6 = (Double)arrayList3.get(0);
                    double d7 = (Double)arrayList2.get(1);
                    double d8 = (Double)arrayList3.get(1);
                    double d9 = (Double)arrayList2.get(2);
                    double d10 = (Double)arrayList3.get(2);
                    double d11 = (Double)arrayList2.get(3);
                    double d12 = (Double)arrayList3.get(3);
                    double d13 = 0.0;
                    double d14 = 0.0;
                    double d15 = 0.0;
                    d13 = this.getFreqSecs(this.curTimeSecs);
                    if (d13 >= (d14 = this.getFreqSecs(this.prevTimeSecs))) {
                        d15 = d13 - d14;
                    }
                    double d16 = 0.0;
                    double d17 = 0.0;
                    double d18 = 0.0;
                    double d19 = 0.0;
                    double d20 = -5.0;
                    double d21 = -5.0;
                    double d22 = -5.0;
                    double d23 = -5.0;
                    if (d15 > 0.0) {
                        if (d7 >= d8) {
                            d17 = d7 - d8;
                            d21 = d17 / d15 * 100.0;
                        } else {
                            d21 = -5.0;
                        }
                        if (d9 >= d10) {
                            d18 = d9 - d10;
                            d22 = d18 / d15 * 100.0;
                        } else {
                            d22 = -5.0;
                        }
                        if (d11 >= d12) {
                            d19 = d11 - d12;
                            d23 = d19 / d15 * 100.0;
                        } else {
                            d23 = -5.0;
                        }
                        d20 = (d17 + d18) / d15 * 100.0;
                    }
                    ArrayList<Double> arrayList4 = new ArrayList<Double>();
                    arrayList4.add(new Double(d20));
                    arrayList4.add(new Double(d21));
                    arrayList4.add(new Double(d22));
                    arrayList4.add(new Double(d23));
                    String string3 = "Engine" + string2;
                    if (this.isDebug) {
                        System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "]-Final MeasureList : " + string3 + "-->" + arrayList4);
                    }
                    this.addNewMeasure(string3, arrayList4);
                }
            }
            this.prevHash = (Hashtable)hashtable2.clone();
            this.prevTimeSecs = this.curTimeSecs;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", " SybEngineTest execute query ", exception.toString());
            exception.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (object != null) {
                this.closeConn((SybConnection)object);
            }
        }
    }

    private double getFreqSecs(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        long l = date.getTime();
        double d = l / 1000L;
        return d;
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        try {
            Class.forName(this.driver);
            String string7 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", string5);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("REPEAT_READ", "false");
            properties.put("ENCRYPT_PASSWORD", string6);
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string7, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "Exception while Connection ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SybEngineTest sybEngineTest = new SybEngineTest(stringArray);
        sybEngineTest.computeMeasures(new Hashtable());
    }
}

