/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMQueue;
import com.eg.apm.APMUtils;
import com.eg.apm.JVMDataRepository;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaAPMExceptionObject;
import com.eg.apm.JavaAPMStatusCodeObject;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.Status;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternData;
import com.eg.jvmmonitor.JVMMetricData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class APMWorker
implements Runnable {
    private APMQueue<Object> myQueue;
    public static int counter = 1;
    protected static String loggerDispStr = "[APMWorker]";
    private static Hashtable<String, Integer> AutoNameHT = new Hashtable();
    private static Hashtable<String, String> computedNodeOrders = new Hashtable();
    private static Hashtable appTierNameTable = new Hashtable();
    private boolean runThis = true;

    public APMWorker(APMQueue<Object> aPMQueue) {
        this.myQueue = aPMQueue;
    }

    @Override
    public void run() {
        loggerDispStr = "[APMWorker] [" + Thread.currentThread().getName() + "] ";
        do {
            try {
                boolean bl = false;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} runThis : {}", (Object)loggerDispStr, (Object)this.runThis);
                while (!bl && this.runThis) {
                    try {
                        Object object;
                        Object object2 = this.myQueue.dequeue(true);
                        if (object2 instanceof MethodInfo) {
                            object = (MethodInfo)object2;
                            if (object != null) {
                                this.processMethodInfo((MethodInfo)object);
                            }
                        } else if (object2 instanceof JVMMetricData) {
                            try {
                                object = (JVMMetricData)object2;
                                this.processJvmMetricData((JVMMetricData)object);
                            }
                            catch (Exception exception) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to parse JVMMetricData object completely... {}", (Object)loggerDispStr, (Object)exception);
                            }
                        } else if (object2 instanceof HashMap) {
                            object = (HashMap)object2;
                            String string = (String)((HashMap)object).get("JvmGUID");
                            this.processAutoDiscovery((Map)object, string);
                        } else {
                            this.sleep(10L);
                        }
                    }
                    catch (Exception exception) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to parse apm object completely... {}", (Object)loggerDispStr, (Object)exception);
                        bl = true;
                    }
                    this.sleep(1L);
                }
                this.sleep(1000L);
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occured in the worker thread {}", (Object)loggerDispStr, (Object)exception);
                break;
            }
            this.sleep(100L);
        } while (this.runThis);
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Worker exiting - runThis : {}", (Object)loggerDispStr, (Object)this.runThis);
    }

    private void processJvmMetricData(JVMMetricData jVMMetricData) {
        if (jVMMetricData != null) {
            Map map = jVMMetricData.getProperties();
            String string = (String)map.get("JvmGUID");
            Hashtable hashtable = (Hashtable)map.get("JVM");
            if (hashtable != null) {
                JVMDataRepository.setData((String)string, (Hashtable)hashtable);
            }
        }
    }

    private void processAutoDiscovery(Map map, String string) {
        try {
            String string2 = (String)map.get("CONTAINER_NAME");
            if (string2 != null && string2.trim().length() > 0) {
                APMDiscoveryHelper.storeAutoDiscoveryDetails(map, string);
            } else {
                APMDiscoveryLogger.discoveryLogger.debug("{} Discovery data received seems to be invalid, Hence discarding the discoverd details for {}, discovered data - {} ", new Object[]{loggerDispStr, string, map});
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while getting auto discovery details !!.. so set the default value... {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void processMethodInfo(MethodInfo methodInfo) {
        try {
            Object object;
            Map map = methodInfo.getProperties();
            String string = (String)map.get("JvmGUID");
            String string2 = (String)map.get("NodeID");
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} NodeID : {} , JvmGUID : {} & Main Props : {}", new Object[]{loggerDispStr, string2, string, map});
            JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent((String)string);
            if (javaAPMComponent == null) {
                return;
            }
            if (map.containsKey("is404Request") && ((Boolean)map.get("is404Request")).booleanValue()) {
                this.processStatusCodeDetails(map, javaAPMComponent, true);
                return;
            }
            String string3 = (String)map.get("PS");
            if (APMUtils.isDetailsAvailable((Map)map, (String)"TRANSACTION_FLOW_DETAILS")) {
                JavaTransactionFlowUtility.retriveTransactionFlowDetails((Map)map, (String)string);
                String string4 = methodInfo.getGuidString();
                this.updateAutoNamingTables(string2, string4, string3);
                this.checkAppnameTiername(map, string2);
            }
            this.updateCommonJVMDetails(javaAPMComponent, map);
            boolean bl = (Boolean)map.get("firstNode");
            boolean bl2 = (Boolean)map.get("keyTransaction");
            String string5 = (String)map.get("requestType");
            long l = (Long)map.get("cpuTime");
            long l2 = (Long)map.get("blockedTime");
            long l3 = (Long)map.get("waitedTime");
            if (JavaBTMOffloadLogger.btmOffLoadLogger.isDebugEnabled()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL : {} \t Response Time :  {} ", new Object[]{loggerDispStr, methodInfo.getRawURL(), methodInfo.getExecutionTime()});
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} isFirstNode -   {}, keyTransaction -  {}, requestType -   {}", new Object[]{loggerDispStr, bl, bl2, string5});
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} CPU time -   {}, Blocked time -   {}, Waited time -   {}", new Object[]{loggerDispStr, l, l2, l3});
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} methodInfo.isErrorURL() - {}, methodInfo.isSlowURL() - {}, methodInfo.isStalled() - {}", new Object[]{loggerDispStr, methodInfo.isErrorURL(), methodInfo.isSlowURL(), methodInfo.isStalled()});
            }
            UPDManager uPDManager = javaAPMComponent.getUPDManager();
            if (bl2) {
                object = uPDManager.manualPatternTable.get(string3);
                if (object == null) {
                    uPDManager.manualPatternTable.put(string3, string3);
                    uPDManager.updateTables4Manual();
                }
            } else {
                object = uPDManager.autoPatternTable.get(string3);
                if (object == null) {
                    uPDManager.autoPatternTable.put(string3, string3);
                    uPDManager.updateTables4Auto();
                }
            }
            this.processStatusCodeDetails(map, javaAPMComponent, false);
            if (methodInfo.isErrorURL()) {
                this.addToUPD(uPDManager, methodInfo, bl, bl2, string5, l, l2, l3);
                object = (ArrayList)map.remove("JAVA_EXCEPTION_DETAILS");
                if (object != null && ((ArrayList)object).size() > 0) {
                    String string6 = (String)map.get("GUID");
                    JavaAPMExceptionObject javaAPMExceptionObject = new JavaAPMExceptionObject(string6, string5, string3, (ArrayList)object);
                    javaAPMComponent.getApmRepositoryForException().addExceptions(javaAPMExceptionObject);
                }
            } else if (methodInfo.isSlowURL()) {
                this.addToUPD(uPDManager, methodInfo, bl, bl2, string5, l, l2, l3);
            } else if (methodInfo.isStalled()) {
                this.addStalledURLDetails(uPDManager, methodInfo, bl, bl2, string5, l, l2, l3);
            } else {
                this.updateAllUrlDetails(uPDManager, methodInfo, bl, bl2, string5, l, l2, l3);
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to parse Methodinfo object completely... {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void processStatusCodeDetails(Map map, JavaAPMComponent javaAPMComponent, boolean bl) {
        try {
            if (bl) {
                double[] dArray = (double[])map.get("404RequestDetails");
                JavaAPMStatusCodeObject javaAPMStatusCodeObject = new JavaAPMStatusCodeObject("404", dArray[0], dArray[1], true);
                javaAPMComponent.getApmRepositoryForStatusCode().addStatusCodes(javaAPMStatusCodeObject);
            } else {
                Object v = map.get("STATUS");
                if (v != null && v.equals("-")) {
                    return;
                }
                int n = (Integer)map.get("STATUS");
                String string = (String)map.get("STATUS_MESSAGE");
                if (string == null) {
                    string = "-";
                }
                boolean bl2 = (Boolean)map.remove("REDIRECTED_ERROR_PAGE");
                String string2 = (String)map.get("PS");
                String string3 = (String)map.get("GUID");
                JavaAPMStatusCodeObject javaAPMStatusCodeObject = new JavaAPMStatusCodeObject(string3, string2, String.valueOf(n), string, bl2);
                javaAPMComponent.getApmRepositoryForStatusCode().addStatusCodes(javaAPMStatusCodeObject);
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} exception while updating status code repository  {} ", (Object)loggerDispStr, (Object)exception);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace(loggerDispStr + "{} updated status code details in status code repository for  {}", (Object)loggerDispStr, map.get("requestID"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAppnameTiername(Map map, String string) {
        try {
            String string2 = (String)map.get("appName");
            string2 = string2 != null ? string2 : "";
            String string3 = (String)map.get("tierName");
            string3 = string3 != null ? string3 : "";
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  appnameFromJar : {} , tiernameFromJar : {}  ", new Object[]{loggerDispStr, string2, string3});
            String string4 = APMWorker.getValueFromAppTierNameTable(string + "_AppName");
            string4 = string4 != null ? string4 : "";
            String string5 = APMWorker.getValueFromAppTierNameTable(string + "_TierName");
            string5 = string5 != null ? string5 : "";
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} appnameFromManager : {} , tiernameFromManager : {}  ", new Object[]{loggerDispStr, string4, string5});
            String string6 = "none";
            String string7 = "none";
            if (string2.equals(string4) && string3.equals(string5)) {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Both App and Tier name from JAR and MANAGER is same", (Object)loggerDispStr);
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            if (string4.equals("MyApp") && !string2.equals(string4)) {
                string6 = string2;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  appnameFromJar from JAR is not same, so using {} to update eg_apmTemp.ini", (Object)loggerDispStr, (Object)string2);
            } else {
                bl = true;
            }
            if (string5.equals("MyTier") && !string3.equals(string5)) {
                string7 = string3;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  tiernameFromJar [{}] from JAR is not same, so using {} to update eg_apmTemp.ini", new Object[]{loggerDispStr, string3, string5});
            } else {
                bl2 = true;
            }
            if (!string6.equals("none") || !string7.equals("none")) {
                String string8 = APMWorker.getValueFromAppTierNameTable(string);
                string8 = string8 != null ? string8 : "Not_Found";
                JavaTransactionFlowUtility.storeAppTiernameIntoTemp((String)string, (String)string8, (String)(string6 + ":" + string7));
            }
            if (bl) {
                // empty if block
            }
            if (!bl2) return;
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occured due to {} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void updateAutoNamingTables(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string2.substring(string2.lastIndexOf("#~#") + 3);
        stringBuilder.append(string);
        stringBuilder.append(">");
        stringBuilder.append(string3);
        stringBuilder.append(">");
        stringBuilder.append(string4);
        String string5 = stringBuilder.toString();
        Integer n = AutoNameHT.get(string5);
        if (!APMWorker.isAvilableInComputedNodeOrders(string5) && n == null) {
            AutoNameHT.put(string5, 1);
        } else if (n != null && 0 < n && n <= 100) {
            AutoNameHT.put(string5, n + 1);
        } else if (APMWorker.isAvilableInComputedNodeOrders(string5)) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} {} Node order reached maximum count limit,so discarding this node order ", (Object)loggerDispStr, (Object)string5);
            AutoNameHT.remove(string5);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} AutoNameHT : {}", (Object)loggerDispStr, AutoNameHT);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} computedNodeOrders : {}", (Object)loggerDispStr, computedNodeOrders);
    }

    private void updateCommonJVMDetails(JavaAPMComponent javaAPMComponent, Map map) {
        String string;
        String string2;
        Object object;
        javaAPMComponent.setHeartBeatStatus(Status.HEART_BEATING);
        String string3 = (String)map.get("DataBaseHT");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            object = (String)map.remove("TimeZone");
            string2 = (String)map.remove("blockedWaitedTimeNotSupported");
            string = (String)map.remove("cpuTimeNotSupported");
            Hashtable hashtable = (Hashtable)map.remove("CustomPC");
            javaAPMComponent.setTimeZone((String)object);
            javaAPMComponent.setBlockedWaitNotSupported(string2);
            javaAPMComponent.setCpuTimeNotSupported(string);
            javaAPMComponent.setCustomPointCuts(hashtable);
        }
        if ((object = (String[])map.remove("sessionUserMapping")) != null && ((String[])object).length > 0) {
            string2 = object[0];
            string = object[1];
            javaAPMComponent.updateSessionUserMapping(string, string2);
        }
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateAllUrlDetails(UPDManager uPDManager, MethodInfo methodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                String string2 = methodInfo.getUrlPatternsMatched();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL - {}   {}ms & matched patterns {}", new Object[]{loggerDispStr, methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched()});
                URLPatternData uRLPatternData = (URLPatternData)uPDManager.getUPDTblWC(bl2).get(string2);
                if (uRLPatternData != null) {
                    uRLPatternData.updateAllUrlCount(methodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (methodInfo == null) break block3;
                methodInfo.clearURLTree();
            }
        }
    }

    private void addToUPD(UPDManager uPDManager, MethodInfo methodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL - {}   {}ms & matched patterns {}", new Object[]{loggerDispStr, methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched()});
                String string2 = methodInfo.getUrlPatternsMatched();
                URLPatternData uRLPatternData = (URLPatternData)uPDManager.getUPDTblWC(bl2).get(string2);
                if (uRLPatternData != null) {
                    uRLPatternData.addURLInfo(methodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (methodInfo == null) break block3;
                methodInfo.clearURLTree();
            }
        }
    }

    public void addStalledURLDetails(UPDManager uPDManager, MethodInfo methodInfo, boolean bl, boolean bl2, String string, long l, long l2, long l3) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL - {}   {}ms & matched patterns {}", new Object[]{loggerDispStr, methodInfo.getProperties().get("requestID"), methodInfo.getExecutionTime(), methodInfo.getUrlPatternsMatched()});
                String string2 = methodInfo.getUrlPatternsMatched();
                URLPatternData uRLPatternData = (URLPatternData)uPDManager.getUPDTblWC(bl2).get(string2);
                if (uRLPatternData != null) {
                    uRLPatternData.addStalledURLInfo(methodInfo, bl, string, l, l2, l3);
                }
            }
            catch (Exception exception) {
                if (methodInfo == null) break block3;
                methodInfo.clearURLTree();
            }
        }
    }

    static void clearRepository(JavaAPMComponent javaAPMComponent) {
        String string = javaAPMComponent.getID();
        String string2 = javaAPMComponent.getNickWithPort();
        AutoNameHT.remove(string);
        AutoNameHT.remove(string2);
        computedNodeOrders.remove(string);
        computedNodeOrders.remove(string2);
        int n = 0;
        if (!javaAPMComponent.isEntityExists("BusinessTransTest")) {
            javaAPMComponent.removeEntity("BusinessTransTest");
            ++n;
        }
        if (!javaAPMComponent.isEntityExists("KBusinessTransTest")) {
            javaAPMComponent.removeEntity("KBusinessTransTest");
            ++n;
        }
        if (n == 2) {
            javaAPMComponent.reset();
        }
    }

    public static Hashtable<String, Integer> getAutoNameHT() {
        return (Hashtable)AutoNameHT.clone();
    }

    public static void clearAutoNameHT() {
        AutoNameHT.clear();
    }

    public static Hashtable<String, String> getComputedNodeOrders() {
        return computedNodeOrders;
    }

    public static void setComputedNodeOrders(Hashtable<String, String> hashtable) {
        computedNodeOrders = hashtable;
    }

    public static void addEntryIntoComputedNodeOrders(String string) {
        computedNodeOrders.put(string, string);
    }

    public static boolean isAvilableInComputedNodeOrders(String string) {
        return computedNodeOrders.containsKey(string);
    }

    public void setRunThis(boolean bl) {
        this.runThis = bl;
    }

    public static Hashtable getAppTierNameTable() {
        return appTierNameTable;
    }

    public static void setAppTierNameTable(Hashtable hashtable) {
        appTierNameTable = hashtable;
    }

    public static boolean IsThisAvailableInAppTierNameTable(String string) {
        return appTierNameTable.containsKey(string);
    }

    public static String getValueFromAppTierNameTable(String string) {
        return (String)appTierNameTable.get(string);
    }

    public static void removeThisFromAppTierNameTable(String string) {
        appTierNameTable.remove(string);
    }

    public static void addNewEntryToAppTierNameTable(String string, String string2) {
        appTierNameTable.put(string, string2);
    }
}

