/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.event;

import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.joran.event.BodyEvent;
import com.eg.ch.qos.logback.core.joran.event.EndEvent;
import com.eg.ch.qos.logback.core.joran.event.SaxEvent;
import com.eg.ch.qos.logback.core.joran.event.StartEvent;
import com.eg.ch.qos.logback.core.joran.spi.ElementPath;
import com.eg.ch.qos.logback.core.joran.spi.JoranException;
import com.eg.ch.qos.logback.core.spi.ContextAware;
import com.eg.ch.qos.logback.core.spi.ContextAwareImpl;
import com.eg.ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaxEventRecorder
extends DefaultHandler
implements ContextAware {
    final ContextAwareImpl cai;
    public List<SaxEvent> saxEventList = new ArrayList<SaxEvent>();
    Locator locator;
    ElementPath globalElementPath = new ElementPath();

    public SaxEventRecorder(Context context) {
        this.cai = new ContextAwareImpl(context, this);
    }

    public final void recordEvents(InputStream inputStream) throws JoranException {
        this.recordEvents(new InputSource(inputStream));
    }

    public List<SaxEvent> recordEvents(InputSource inputSource) throws JoranException {
        SAXParser sAXParser = this.buildSaxParser();
        try {
            sAXParser.parse(inputSource, (DefaultHandler)this);
            return this.saxEventList;
        }
        catch (IOException iOException) {
            this.handleError("I/O error occurred while parsing xml file", iOException);
        }
        catch (SAXException sAXException) {
            throw new JoranException("Problem parsing XML document. See previously reported errors.", sAXException);
        }
        catch (Exception exception) {
            this.handleError("Unexpected exception while parsing XML document.", exception);
        }
        throw new IllegalStateException("This point can never be reached");
    }

    private void handleError(String string, Throwable throwable) throws JoranException {
        this.addError(string, throwable);
        throw new JoranException(string, throwable);
    }

    private SAXParser buildSaxParser() throws JoranException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setNamespaceAware(true);
            return sAXParserFactory.newSAXParser();
        }
        catch (Exception exception) {
            String string = "Parser configuration error occurred";
            this.addError(string, exception);
            throw new JoranException(string, exception);
        }
    }

    @Override
    public void startDocument() {
    }

    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4 = this.getTagName(string2, string3);
        this.globalElementPath.push(string4);
        ElementPath elementPath = this.globalElementPath.duplicate();
        this.saxEventList.add(new StartEvent(elementPath, string, string2, string3, attributes, this.getLocator()));
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        String string = new String(cArray, n2, n3);
        SaxEvent saxEvent = this.getLastEvent();
        if (saxEvent instanceof BodyEvent) {
            BodyEvent bodyEvent = (BodyEvent)saxEvent;
            bodyEvent.append(string);
        } else if (!this.isSpaceOnly(string)) {
            this.saxEventList.add(new BodyEvent(string, this.getLocator()));
        }
    }

    boolean isSpaceOnly(String string) {
        String string2 = string.trim();
        return string2.length() == 0;
    }

    SaxEvent getLastEvent() {
        if (this.saxEventList.isEmpty()) {
            return null;
        }
        int n2 = this.saxEventList.size();
        return this.saxEventList.get(n2 - 1);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.saxEventList.add(new EndEvent(string, string2, string3, this.getLocator()));
        this.globalElementPath.pop();
    }

    String getTagName(String string, String string2) {
        String string3 = string;
        if (string3 == null || string3.length() < 1) {
            string3 = string2;
        }
        return string3;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addError("XML_PARSING - Parsing error on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber());
        this.addError(sAXParseException.toString());
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError("XML_PARSING - Parsing fatal error on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber());
        this.addError(sAXParseException.toString());
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addWarn("XML_PARSING - Parsing warning on line " + sAXParseException.getLineNumber() + " and column " + sAXParseException.getColumnNumber(), sAXParseException);
    }

    @Override
    public void addError(String string) {
        this.cai.addError(string);
    }

    @Override
    public void addError(String string, Throwable throwable) {
        this.cai.addError(string, throwable);
    }

    @Override
    public void addInfo(String string) {
        this.cai.addInfo(string);
    }

    @Override
    public void addInfo(String string, Throwable throwable) {
        this.cai.addInfo(string, throwable);
    }

    @Override
    public void addStatus(Status status) {
        this.cai.addStatus(status);
    }

    @Override
    public void addWarn(String string) {
        this.cai.addWarn(string);
    }

    @Override
    public void addWarn(String string, Throwable throwable) {
        this.cai.addWarn(string, throwable);
    }

    @Override
    public Context getContext() {
        return this.cai.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.cai.setContext(context);
    }

    public List<SaxEvent> getSaxEventList() {
        return this.saxEventList;
    }
}

