/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybLob;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public abstract class LobInputStream
extends InputStream {
    protected SybLob _lob;
    protected long _nextReadPos = 0L;
    protected long _readLimit = 0L;
    protected byte[] temp = new byte[1];
    protected boolean _streamClosed = false;

    public LobInputStream(SybLob sybLob) {
        this(sybLob, 1L, Long.MAX_VALUE);
    }

    public LobInputStream(SybLob sybLob, long l, long l2) {
        this._lob = sybLob;
        this._nextReadPos = l;
        this._readLimit = l2;
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        this.read(this.temp, 0, 1);
        return this.temp[0];
    }

    @Override
    public void close() throws IOException {
        this._streamClosed = true;
    }

    protected void checkIfClosed() throws IOException {
        if (this._streamClosed) {
            ErrorMessage.raiseIOException("JZ040", "Read", "InputStream");
        }
    }

    @Override
    public int available() throws IOException {
        long l = Integer.MAX_VALUE;
        try {
            l = this._lob.length();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOException("JZ041", "available()", "InputStream", sQLException);
        }
        return (int)(l - this._nextReadPos + 1L);
    }
}

