/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net.ssl;

import com.eg.ch.qos.logback.core.util.LocationUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class KeyStoreFactoryBean {
    private String location;
    private String provider;
    private String type;
    private String password;

    public KeyStore createKeyStore() throws NoSuchProviderException, NoSuchAlgorithmException, KeyStoreException {
        if (this.getLocation() == null) {
            throw new IllegalArgumentException("location is required");
        }
        InputStream inputStream = null;
        try {
            URL uRL = LocationUtil.urlForResource(this.getLocation());
            inputStream = uRL.openStream();
            KeyStore keyStore = this.newKeyStore();
            keyStore.load(inputStream, this.getPassword().toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchProviderException("no such keystore provider: " + this.getProvider());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NoSuchAlgorithmException("no such keystore type: " + this.getType());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyStoreException(this.getLocation() + ": file not found");
        }
        catch (Exception exception) {
            throw new KeyStoreException(this.getLocation() + ": " + exception.getMessage(), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private KeyStore newKeyStore() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        return this.getProvider() != null ? KeyStore.getInstance(this.getType(), this.getProvider()) : KeyStore.getInstance(this.getType());
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getType() {
        if (this.type == null) {
            return "JKS";
        }
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public String getPassword() {
        if (this.password == null) {
            return "changeit";
        }
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }
}

