/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgConfigInfo;
import com.eg.EgInstallInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;

public class SSLCertificateHelper {
    public static void main(String[] stringArray) {
        try {
            Vector vector;
            ArrayList arrayList = SSLCertificateHelper.readInputData();
            String string = "";
            if (arrayList != null && arrayList.size() > 0 && (vector = (Vector)arrayList.get(0)) != null && vector.size() > 0) {
                Hashtable hashtable = (Hashtable)vector.get(0);
                string = (String)vector.get(1);
                String string2 = (String)vector.get(2);
                Hashtable hashtable2 = SSLCertificateHelper.processData(hashtable, string, string2);
                SSLCertificateHelper.writeOutputData(hashtable2);
            }
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][main]:" + exception.toString());
            exception.printStackTrace();
        }
    }

    public static Hashtable processData(Hashtable hashtable, String string, String string2) {
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        KeyStore keyStore = null;
        Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
        while (iterator.hasNext()) {
            int n;
            Object object;
            Object object2;
            Object object3;
            String string3;
            String string4 = (String)iterator.next();
            ArrayList arrayList = (ArrayList)hashtable.get(string4);
            if (arrayList == null) continue;
            if (string4.equals("KeyStoreFile")) {
                String string5 = (String)arrayList.get(0);
                string3 = (String)arrayList.get(1);
                object3 = (String)arrayList.get(2);
                try {
                    keyStore = KeyStore.getInstance((String)object3);
                    object2 = string3.toCharArray();
                    object = new FileInputStream(string5);
                    keyStore.load((InputStream)object, (char[])object2);
                    ((FileInputStream)object).close();
                }
                catch (KeyStoreException keyStoreException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:Exception in loading KeyStore : " + keyStoreException.toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:KeyStore file not found : " + fileNotFoundException.toString());
                }
                catch (IOException iOException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:IO Exception : " + iOException.toString());
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:Exception : " + exception.toString());
                }
                if (keyStore == null) continue;
                try {
                    object2 = keyStore.aliases();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        Hashtable hashtable3 = SSLCertificateHelper.doTheWork("KeyStore", (String)object, string, keyStore, string2);
                        if (hashtable3 == null) continue;
                        hashtable2.put((String)object + " [KeyStore entry]", hashtable3);
                    }
                    continue;
                }
                catch (KeyStoreException keyStoreException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][processData]:KeyStoreException : " + keyStoreException.toString());
                    continue;
                }
            }
            if (string4.equals("certificates")) {
                for (n = 0; n < arrayList.size(); ++n) {
                    string3 = (String)arrayList.get(n);
                    object3 = SSLCertificateHelper.doTheWork("certificate", string3, string, null, string2);
                    if (object3 == null) continue;
                    hashtable2.put(string3, object3);
                }
                continue;
            }
            for (n = 0; n < arrayList.size(); ++n) {
                string3 = (String)arrayList.get(n);
                if (string3 == null || string3.indexOf(":") == -1 || (object = SSLCertificateHelper.doTheWork((String)(object3 = string3.substring(0, string3.lastIndexOf(":"))), (String)(object2 = string3.substring(string3.lastIndexOf(":") + 1)), string, null, string2)) == null) continue;
                if (((String)object2).equals("443")) {
                    hashtable2.put(object3, object);
                    continue;
                }
                hashtable2.put((String)object3 + ":" + (String)object2, object);
            }
        }
        return hashtable2;
    }

    private static Hashtable doTheWork(String string, String string2, String string3, KeyStore keyStore, String string4) {
        String string5 = "-";
        String string6 = "-";
        String string7 = "-";
        String string8 = "-";
        String string9 = "-";
        String string10 = "-";
        String string11 = "-";
        String string12 = "-";
        String string13 = "-";
        String string14 = "-";
        String string15 = "-";
        String string16 = "-";
        String string17 = "-";
        String string18 = "-";
        String string19 = "-";
        String string20 = "-";
        String string21 = "-";
        String string22 = "-";
        String string23 = "-";
        String string24 = "-";
        String string25 = "-";
        String string26 = "-";
        String string27 = "-";
        try {
            Object object;
            Object object2;
            Certificate certificate = null;
            if (string.equalsIgnoreCase("KeyStore")) {
                certificate = keyStore.getCertificate(string2);
            }
            if (string.equalsIgnoreCase("certificate")) {
                Iterator<? extends Certificate> iterator;
                Collection<? extends Certificate> collection = null;
                try {
                    iterator = new FileInputStream(string2);
                    object2 = CertificateFactory.getInstance("X.509");
                    collection = ((CertificateFactory)object2).generateCertificates((InputStream)((Object)iterator));
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Specified certificate file not found !!! " + string2);
                }
                if (collection == null) {
                    return null;
                }
                iterator = collection.iterator();
                if (iterator.hasNext()) {
                    certificate = (Certificate)iterator.next();
                }
            }
            if (!string.equalsIgnoreCase("KeyStore") && !string.equalsIgnoreCase("certificate")) {
                int n = 30000;
                int n2 = 443;
                try {
                    n = Integer.parseInt(string3);
                    n2 = Integer.parseInt(string2);
                    object2 = HttpsURLConnection.getDefaultSSLSocketFactory();
                    object = (SSLSocket)((SocketFactory)object2).createSocket(string, n2);
                    ((Socket)object).setSoTimeout(n);
                    ((SSLSocket)object).startHandshake();
                    Certificate[] certificateArray = ((SSLSocket)object).getSession().getPeerCertificates();
                    if (certificateArray.length > 0) {
                        certificate = certificateArray[0];
                    }
                    ((Socket)object).close();
                }
                catch (NumberFormatException numberFormatException) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : NumberFormatException  for " + string + " " + string2);
                    n = 30000;
                }
                catch (Exception exception) {
                    SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Exception for : " + string + " " + string2 + " " + SSLCertificateHelper.stackTraceToString(exception));
                }
            }
            if (certificate == null) {
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork] : Certificate file is null for " + string + " " + string2);
                return null;
            }
            ArrayList arrayList = new ArrayList();
            PublicKey publicKey = certificate.getPublicKey();
            if (publicKey != null) {
                string5 = publicKey.toString();
                if (string5.indexOf("modulus") > -1) {
                    string5 = string5.substring(0, string5.indexOf("modulus"));
                } else if (string5.indexOf("Parameters:") > -1) {
                    string5 = string5.substring(0, string5.indexOf("Parameters:"));
                }
                string5 = string5.trim();
                string6 = publicKey.getAlgorithm();
                string7 = publicKey.getFormat();
            }
            int n = certificate.hashCode();
            string8 = certificate.getType();
            if (string8 != null && string8.length() > 0 && string8.equalsIgnoreCase("x.509")) {
                Set<String> set;
                Object object3;
                StringBuffer stringBuffer;
                Object object4;
                Serializable serializable;
                ArrayList arrayList2;
                BigInteger bigInteger;
                Date date;
                object = (X509Certificate)certificate;
                int n3 = ((X509Certificate)object).getVersion();
                string9 = String.valueOf(n3);
                Date date2 = ((X509Certificate)object).getNotBefore();
                if (date2 != null) {
                    string10 = date2.toString();
                }
                if ((date = ((X509Certificate)object).getNotAfter()) != null) {
                    if (string4.equals("SSLCertValidityTest")) {
                        long l;
                        long l2 = date.getTime();
                        double d = (l2 - (l = System.currentTimeMillis())) / EgConfigInfo.msecPerDay;
                        if (d < 0.0) {
                            d = 0.0;
                        }
                        string11 = String.valueOf(d);
                    } else {
                        string11 = date.toString();
                    }
                }
                if ((bigInteger = ((X509Certificate)object).getSerialNumber()) != null) {
                    string12 = SSLCertificateHelper.hexify(bigInteger.toByteArray());
                    string12 = string12.trim();
                }
                string13 = ((X509Certificate)object).getSigAlgName();
                string14 = ((X509Certificate)object).getSigAlgOID();
                byte[] byArray = ((X509Certificate)object).getSigAlgParams();
                if (byArray != null && byArray.length > 0) {
                    string15 = byArray.toString();
                }
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                string16 = "" + messageDigest.getAlgorithm();
                string17 = "" + SSLCertificateHelper.getThumbPrint((X509Certificate)object, messageDigest);
                string17 = string17.trim();
                byte[] byArray2 = SSLCertificateHelper.getAuthorityKeyId((X509Certificate)object);
                if (byArray2 != null) {
                    string18 = SSLCertificateHelper.hexify(byArray2);
                }
                if ((arrayList2 = SSLCertificateHelper.getCrlDistributionPoint((X509Certificate)object)) != null) {
                    serializable = new StringBuffer();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        ((StringBuffer)serializable).append(arrayList2.get(i));
                        ((StringBuffer)serializable).append(";");
                    }
                    string19 = ((StringBuffer)serializable).toString();
                }
                if (((X509Certificate)object).getIssuerDN() != null) {
                    string20 = ((Object)((X509Certificate)object).getIssuerDN()).toString();
                }
                if ((serializable = (ArrayList)((X509Certificate)object).getIssuerAlternativeNames()) != null && serializable.size() > 0) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    for (int i = 0; i < serializable.size(); ++i) {
                        object4 = (String)serializable.get(i);
                        stringBuffer2.append((String)object4);
                        stringBuffer2.append(";");
                    }
                    string22 = stringBuffer2.toString();
                }
                if (((X509Certificate)object).getSubjectX500Principal() != null) {
                    String string28;
                    string23 = string28 = ((X509Certificate)object).getSubjectX500Principal().toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string28, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string29;
                        object4 = stringTokenizer.nextToken();
                        if (object4 != null && ((String)object4).length() > 0 && ((String)object4).indexOf("=") > -1 && (string29 = ((String)object4).substring(0, ((String)object4).indexOf("=")).trim()).equals("CN")) continue;
                    }
                }
                if (((X509Certificate)object).getSubjectAlternativeNames() != null) {
                    string24 = ((X509Certificate)object).getSubjectAlternativeNames().toString();
                    String string30 = string24.substring(2, string24.length() - 2);
                    string24 = string24.trim();
                }
                ArrayList<String> arrayList3 = new ArrayList<String>();
                arrayList3.add("digitalSignature");
                arrayList3.add("nonRepudiation");
                arrayList3.add("keyEncipherment");
                arrayList3.add("dataEncipherment");
                arrayList3.add("keyAgreement");
                arrayList3.add("keyCertSign");
                arrayList3.add("cRLSign");
                arrayList3.add("encipherOnly");
                arrayList3.add("decipherOnly");
                boolean[] blArray = ((X509Certificate)object).getKeyUsage();
                if (blArray != null && blArray.length > 0) {
                    object4 = new StringBuffer();
                    for (int i = 0; i < blArray.length; ++i) {
                        if (!blArray[i]) continue;
                        ((StringBuffer)object4).append(arrayList3.get(i));
                        if (i >= blArray.length - 1) continue;
                        ((StringBuffer)object4).append(", ");
                    }
                    string25 = ((StringBuffer)object4).toString();
                    if ((string25 = string25.trim()).indexOf(",") > -1) {
                        string25 = string25.substring(0, string25.lastIndexOf(","));
                    }
                }
                object4 = null;
                try {
                    object4 = ((X509Certificate)object).getExtendedKeyUsage();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object4 != null) {
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    hashtable.put("1.3.6.1.4.1.311.10.3.3", "Microsoft Server Gated Crypto");
                    hashtable.put("1.3.6.1.5.5.7.3.1", "TLS Web server authentication");
                    hashtable.put("1.3.6.1.5.5.7.3.2", "TLS Web client authentication");
                    hashtable.put("1.3.6.1.5.5.7.3.3", "Code signing");
                    hashtable.put("1.3.6.1.5.5.7.3.4", "E-mail protection");
                    hashtable.put("1.3.6.1.5.5.7.3.5", "IP security end system");
                    hashtable.put("1.3.6.1.5.5.7.3.6", "IP security tunnel termination");
                    hashtable.put("1.3.6.1.5.5.7.3.7", "IP security user");
                    hashtable.put("1.3.6.1.5.5.7.3.8", "Timestamping");
                    hashtable.put("1.3.6.1.5.5.7.3.9", "OCSPstamping");
                    hashtable.put("2.16.840.1.113730.4.1", "Netscape Server Gated Crypto");
                    stringBuffer = new StringBuffer();
                    for (int i = 0; i < object4.size(); ++i) {
                        String string31 = (String)object4.get(i);
                        if (string31 == null || string31.length() <= 0) continue;
                        object3 = (String)hashtable.get(string31);
                        if (object3 == null) {
                            object3 = "-";
                        }
                        if (!object3.equals("-")) {
                            stringBuffer.append((String)object3);
                            stringBuffer.append(", ");
                            continue;
                        }
                        stringBuffer.append(string31);
                        stringBuffer.append(", ");
                    }
                    string26 = stringBuffer.toString();
                    if (string26.indexOf(",") > -1) {
                        string26 = string26.substring(0, string26.lastIndexOf(","));
                    }
                }
                if ((set = object.getCriticalExtensionOIDs()) != null && !set.isEmpty()) {
                    stringBuffer = new StringBuffer();
                    for (String string31 : set) {
                        object3 = object.getExtensionValue(string31);
                        if (object3 == null) continue;
                        stringBuffer.append(string31);
                        stringBuffer.append(",");
                    }
                    string27 = stringBuffer.toString();
                    if (string27.indexOf(",") > -1) {
                        string27 = string27.substring(0, string27.lastIndexOf(","));
                    }
                }
            }
            object = new Hashtable();
            ((Hashtable)object).put("CertificateKey", string5);
            ((Hashtable)object).put("KeyAlgorithm", string6);
            ((Hashtable)object).put("KeyFormat", string7);
            ((Hashtable)object).put("CertificateType", string8);
            ((Hashtable)object).put("CertificateVersion", string9);
            ((Hashtable)object).put("ValidFrom", string10);
            ((Hashtable)object).put("ValidTo", string11);
            ((Hashtable)object).put("SerialNumber", string12);
            ((Hashtable)object).put("SignatureAlgorithm", string13);
            ((Hashtable)object).put("SignatureOID", string14);
            ((Hashtable)object).put("SignatureParams", string15);
            ((Hashtable)object).put("ThumbAlgorithm", string16);
            ((Hashtable)object).put("ThumbPrint", string17);
            ((Hashtable)object).put("KeyIdentifier", string18);
            ((Hashtable)object).put("CrlDP", string19);
            ((Hashtable)object).put("Issuer", string20);
            ((Hashtable)object).put("IssuerAlt", string22);
            ((Hashtable)object).put("InstalledOn", string23);
            ((Hashtable)object).put("SAlternative", string24);
            ((Hashtable)object).put("KeyUsage", string25);
            ((Hashtable)object).put("ExtendedKeyUsage", string26);
            ((Hashtable)object).put("CriticalExtensions", string27);
            return object;
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][doTheWork]:Exception is : " + exception.toString());
            exception.printStackTrace();
            return new Hashtable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList readInputData() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = null;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(System.in);
            object = objectInputStream.readObject();
            arrayList.add(object);
            objectInputStream.close();
            objectInputStream = null;
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][readInputData]Error 1 : " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                    objectInputStream = null;
                }
            }
            catch (Exception exception) {
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][readInputData]Error 2 : " + exception.toString());
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeOutputData(Hashtable hashtable) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(System.out);
            objectOutputStream.writeObject(hashtable);
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][writeOutputData]Error 1 : " + exception.toString());
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                    objectOutputStream = null;
                }
            }
            catch (Exception exception) {
                SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][writeOutputData]Error 2 : " + exception.toString());
            }
        }
    }

    public static synchronized void logToTempFile(String string) {
        try {
            PrintWriter printWriter;
            String string2 = EgInstallInfo.getInstallDir() + "/agent/logs/sslcerttest.log";
            File file = new File(string2);
            if (file.exists() && file.length() >= 1000000L) {
                EgInstallInfo.fileRename(string2, string2 + ".1");
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                return;
            }
            String string3 = new String(string);
            printWriter.println(string3);
            printWriter.close();
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][logToTempFile] : Exception is : " + exception.toString());
        }
    }

    protected static byte[] getAuthorityKeyId(X509Certificate x509Certificate) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.35");
        if (byArray == null) {
            return null;
        }
        DEROctetString dEROctetString = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray)).readObject();
        ASN1InputStream aSN1InputStream = new ASN1InputStream(dEROctetString.getOctets());
        AuthorityKeyIdentifier authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance((Object)aSN1InputStream.readObject());
        return authorityKeyIdentifier.getKeyIdentifier();
    }

    protected static ArrayList getCrlDistributionPoint(X509Certificate x509Certificate) throws CertificateParsingException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x509Certificate.getEncoded());
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            X509CertificateStructure x509CertificateStructure = new X509CertificateStructure(aSN1Sequence);
            TBSCertificateStructure tBSCertificateStructure = x509CertificateStructure.getTBSCertificate();
            X509Extensions x509Extensions = tBSCertificateStructure.getExtensions();
            if (x509Extensions != null) {
                Enumeration enumeration = x509Extensions.oids();
                while (enumeration.hasMoreElements()) {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                    X509Extension x509Extension = x509Extensions.getExtension(aSN1ObjectIdentifier);
                    ASN1OctetString aSN1OctetString = x509Extension.getValue();
                    ASN1InputStream aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
                    if (!aSN1ObjectIdentifier.equals((Object)X509Extensions.CRLDistributionPoints)) continue;
                    CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1InputStream2.readObject());
                    DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
                    for (int i = 0; i != distributionPointArray.length; ++i) {
                        DistributionPoint distributionPoint = distributionPointArray[i];
                        DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
                        GeneralNames generalNames = (GeneralNames)distributionPointArray[i].getDistributionPoint().getName();
                        GeneralName[] generalNameArray = generalNames.getNames();
                        for (int j = 0; j < generalNameArray.length; ++j) {
                            if (generalNameArray[j].getTagNo() != 6) continue;
                            ASN1String aSN1String = (ASN1String)generalNameArray[j].getName();
                            arrayList.add(aSN1String.getString());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            SSLCertificateHelper.logToTempFile("[SSLCertificateHelper][getCrlDistributionPoint] : Exception is : " + exception.toString());
        }
        return arrayList;
    }

    protected static ASN1Primitive getExtensionValue(X509Certificate x509Certificate, String string) throws IOException {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
        aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(aSN1OctetString.getOctets()));
        return aSN1InputStream.readObject();
    }

    protected static String getStringFromGeneralNames(ASN1Primitive aSN1Primitive) {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Primitive), (boolean)false);
        if (aSN1Sequence.size() == 0) {
            return null;
        }
        DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(0);
        return new String(ASN1OctetString.getInstance((ASN1TaggedObject)dERTaggedObject, (boolean)false).getOctets());
    }

    protected static String getThumbPrint(X509Certificate x509Certificate, MessageDigest messageDigest) throws NoSuchAlgorithmException, CertificateEncodingException {
        byte[] byArray = x509Certificate.getEncoded();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        if (byArray2 != null) {
            return SSLCertificateHelper.hexify(byArray2);
        }
        return null;
    }

    protected static String hexify(byte[] byArray) {
        StringBuffer stringBuffer = null;
        if (byArray != null) {
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            stringBuffer = new StringBuffer(byArray.length * 2);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(cArray[(byArray[i] & 0xF0) >> 4]);
                stringBuffer.append(cArray[byArray[i] & 0xF]);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stackTraceToString(Throwable throwable) {
        String string = null;
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            string = stringWriter.toString();
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (stringWriter != null) {
                    stringWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }
}

