/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import java.util.Enumeration;
import java.util.Hashtable;

public class Iana {
    protected static final String UNSUPPORTED_CHARSET = "UnsupportedCharset";
    private static final Hashtable<String, String> _IANA_MAP = new Hashtable();

    public static String lookupIana(String string) {
        String string2 = _IANA_MAP.get(string);
        if (string2 == null) {
            return UNSUPPORTED_CHARSET;
        }
        return string2.toString();
    }

    public static String reverseLookupIana(String string) {
        if (_IANA_MAP.contains(string)) {
            Enumeration<String> enumeration = _IANA_MAP.keys();
            String string2 = null;
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement().toString();
                String string3 = _IANA_MAP.get(string2).toString();
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return UNSUPPORTED_CHARSET;
    }

    public static boolean truncationConversionOK(String string) {
        String string2 = Iana.lookupIana(string);
        if (string.equals(string2)) {
            return true;
        }
        if ("cp037".equals(string2)) {
            return false;
        }
        return false;
    }

    public static Hashtable<String, String> getConversionMap() {
        return _IANA_MAP;
    }

    static {
        _IANA_MAP.put("iso_1", "ISO8859_1");
        _IANA_MAP.put("ascii_7", "ASCII");
        _IANA_MAP.put("cp1252", "Cp1252");
        _IANA_MAP.put("cp850", "Cp850");
        _IANA_MAP.put("cp437", "Cp437");
        _IANA_MAP.put("mac", "MacRoman");
        _IANA_MAP.put("roman8", "hp-roman8");
        _IANA_MAP.put("unknown", UNSUPPORTED_CHARSET);
        _IANA_MAP.put("cp037", "Cp037");
        _IANA_MAP.put("big5", "Big5");
        _IANA_MAP.put("big5hk", "Big5_HKSCS");
        _IANA_MAP.put("iso88592", "ISO8859_2");
        _IANA_MAP.put("iso88595", "ISO8859_5");
        _IANA_MAP.put("iso88596", "ISO8859_6");
        _IANA_MAP.put("iso88597", "ISO8859_7");
        _IANA_MAP.put("iso88598", "ISO8859_8");
        _IANA_MAP.put("iso88599", "ISO8859_9");
        _IANA_MAP.put("iso15", "ISO8859_15_FDIS");
        _IANA_MAP.put("cp852", "Cp852");
        _IANA_MAP.put("ibm420", "Cp420");
        _IANA_MAP.put("cp500", "Cp500");
        _IANA_MAP.put("cp855", "Cp855");
        _IANA_MAP.put("cp857", "Cp857");
        _IANA_MAP.put("cp860", "Cp860");
        _IANA_MAP.put("cp863", "Cp863");
        _IANA_MAP.put("cp864", "Cp864");
        _IANA_MAP.put("cp869", "Cp869");
        _IANA_MAP.put("ibm918", "Cp918");
        _IANA_MAP.put("koi8", "KOI8_R");
        _IANA_MAP.put("cp866", "Cp866");
        _IANA_MAP.put("cp1250", "Cp1250");
        _IANA_MAP.put("cp1251", "Cp1251");
        _IANA_MAP.put("cp1253", "Cp1253");
        _IANA_MAP.put("cp1254", "Cp1254");
        _IANA_MAP.put("cp1255", "Cp1255");
        _IANA_MAP.put("cp1256", "Cp1256");
        _IANA_MAP.put("cp1257", "Cp1257");
        _IANA_MAP.put("cp1258", "Cp1258");
        _IANA_MAP.put("cp874", "Cp874");
        _IANA_MAP.put("tis620", "MS874");
        _IANA_MAP.put("mac_cyr", "MacCyrillic");
        _IANA_MAP.put("mac_ee", "MacCentralEurope");
        _IANA_MAP.put("macgreek", "MacGreek");
        _IANA_MAP.put("macturk", "MacTurkish");
        _IANA_MAP.put("sjis", "MS932");
        _IANA_MAP.put("eucjis", "EUC_JP");
        _IANA_MAP.put("deckanji", "EUC_JP");
        _IANA_MAP.put("utf8", "UTF8");
        _IANA_MAP.put("cp932", "MS932");
        _IANA_MAP.put("cp936", "GBK");
        _IANA_MAP.put("eucgb", "EUC_CN");
        _IANA_MAP.put("eucksc", "EUC_KR");
        _IANA_MAP.put("cp950", "Cp950");
        _IANA_MAP.put("cp949", "Cp949");
        _IANA_MAP.put("gb18030", "GB18030");
        _IANA_MAP.put("euccns", "EUC_TW");
        _IANA_MAP.put("ucs2", "Unicode");
    }
}

