/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class SybUTF8CharsetDecoder
extends CharsetDecoder {
    private boolean[] areSet = new boolean[]{false, false, false, false};
    private int[] storedBytes = new int[]{0, 0, 0, 0};

    public SybUTF8CharsetDecoder(Charset charset, float f, float f2) {
        super(charset, f, f2);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = 0;
        for (int i = this.storedBytes.length - 1; i >= 0; --i) {
            if (!this.areSet[i] || byteBuffer.position() <= this.storedBytes.length - i || this.storedBytes[i] == byteBuffer.get(byteBuffer.position() + i - this.storedBytes.length)) continue;
            return CoderResult.malformedForLength(byteBuffer.position());
        }
        while (byteBuffer.hasRemaining() || this.areSet[0]) {
            if (!charBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            if ((this.checkAndGet(0, byteBuffer) & 0x80) == 0) {
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put((char)this.storedBytes[0]);
                this.areSet[0] = false;
                ++n;
                continue;
            }
            if ((this.storedBytes[0] & 0xE0) == 192) {
                if (!byteBuffer.hasRemaining() || (this.checkAndGet(1, byteBuffer) & 0xC0) != 128) {
                    this.clearAreSet();
                    n = n == 0 ? byteBuffer.limit() + 1 : n;
                    return CoderResult.unmappableForLength(n);
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put((char)((this.storedBytes[0] & 0x1F) << 6 | this.storedBytes[1] & 0x3F));
                this.areSet[0] = false;
                this.areSet[1] = false;
                n += 2;
                continue;
            }
            if ((this.storedBytes[0] & 0xF0) == 224) {
                if (byteBuffer.remaining() < 2 || (this.checkAndGet(1, byteBuffer) & 0xC0) != 128 || (this.checkAndGet(2, byteBuffer) & 0xC0) != 128) {
                    this.clearAreSet();
                    n = n == 0 ? byteBuffer.limit() + 1 : n;
                    return CoderResult.unmappableForLength(n);
                }
                if (!charBuffer.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                int n2 = (this.storedBytes[0] & 0xF) << 12 | (this.storedBytes[1] & 0x3F) << 6 | this.storedBytes[2] & 0x3F;
                charBuffer.put((char)n2);
                this.areSet[0] = false;
                this.areSet[1] = false;
                this.areSet[2] = false;
                n += 3;
                continue;
            }
            if ((this.storedBytes[0] & 0xF8) == 240) {
                if (byteBuffer.remaining() < 3 || (this.checkAndGet(1, byteBuffer) & 0xC0) != 128 || (this.checkAndGet(2, byteBuffer) & 0xC0) != 128 || (this.checkAndGet(3, byteBuffer) & 0xC0) != 128) {
                    this.clearAreSet();
                    n = n == 0 ? byteBuffer.limit() + 1 : n;
                    return CoderResult.unmappableForLength(n);
                }
                int n3 = (this.storedBytes[0] & 7) << 18 | (this.storedBytes[1] & 0x3F) << 12 | (this.storedBytes[2] & 0x3F) << 6 | this.storedBytes[3] & 0x3F;
                if (n3 > 0x10FFFF) {
                    this.clearAreSet();
                    n = n == 0 ? byteBuffer.limit() + 1 : n;
                    return CoderResult.unmappableForLength(n);
                }
                if (n3 <= 65535) {
                    if (!charBuffer.hasRemaining()) {
                        return CoderResult.OVERFLOW;
                    }
                    charBuffer.put((char)n3);
                    this.areSet[0] = false;
                    this.areSet[1] = false;
                    this.areSet[2] = false;
                    this.areSet[3] = false;
                    n += 4;
                    continue;
                }
                if (charBuffer.remaining() < 2) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put((char)(0xD800 | n3 - 65536 >> 10 & 0x3FF));
                charBuffer.put((char)(0xDC00 | n3 - 65536 & 0x3FF));
                this.areSet[0] = false;
                this.areSet[1] = false;
                this.areSet[2] = false;
                this.areSet[3] = false;
                n += 4;
                continue;
            }
            this.clearAreSet();
            n = n == 0 ? byteBuffer.limit() + 1 : n;
            return CoderResult.unmappableForLength(n);
        }
        return CoderResult.UNDERFLOW;
    }

    private void clearAreSet() {
        this.areSet[0] = false;
        this.areSet[1] = false;
        this.areSet[2] = false;
        this.areSet[3] = false;
    }

    private int checkAndGet(int n, ByteBuffer byteBuffer) {
        if (this.areSet[n]) {
            return this.storedBytes[n];
        }
        this.storedBytes[n] = byteBuffer.get();
        this.areSet[n] = true;
        return this.storedBytes[n];
    }
}

