/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.spi;

import com.eg.ch.qos.logback.classic.spi.ClassPackagingData;
import com.eg.ch.qos.logback.classic.spi.IThrowableProxy;
import com.eg.ch.qos.logback.classic.spi.STEUtil;
import com.eg.ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.net.URL;
import java.security.CodeSource;
import java.util.HashMap;
import sun.reflect.Reflection;

public class PackagingDataCalculator {
    static final StackTraceElementProxy[] STEP_ARRAY_TEMPLATE = new StackTraceElementProxy[0];
    HashMap<String, ClassPackagingData> cache = new HashMap();
    private static boolean GET_CALLER_CLASS_METHOD_AVAILABLE = false;

    public void calculate(IThrowableProxy iThrowableProxy) {
        while (iThrowableProxy != null) {
            this.populateFrames(iThrowableProxy.getStackTraceElementProxyArray());
            IThrowableProxy[] iThrowableProxyArray = iThrowableProxy.getSuppressed();
            if (iThrowableProxyArray != null) {
                for (IThrowableProxy iThrowableProxy2 : iThrowableProxyArray) {
                    this.populateFrames(iThrowableProxy2.getStackTraceElementProxyArray());
                }
            }
            iThrowableProxy = iThrowableProxy.getCause();
        }
    }

    void populateFrames(StackTraceElementProxy[] stackTraceElementProxyArray) {
        Throwable throwable = new Throwable("local stack reference");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n2 = STEUtil.findNumberOfCommonFrames(stackTraceElementArray, stackTraceElementProxyArray);
        int n3 = stackTraceElementArray.length - n2;
        int n4 = stackTraceElementProxyArray.length - n2;
        ClassLoader classLoader = null;
        ClassLoader classLoader2 = null;
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            ClassPackagingData classPackagingData;
            Class clazz = null;
            if (GET_CALLER_CLASS_METHOD_AVAILABLE) {
                clazz = Reflection.getCallerClass((int)(n3 + i2 - n5 + 1));
            }
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[n4 + i2];
            String string = stackTraceElementProxy.ste.getClassName();
            if (clazz != null && string.equals(clazz.getName())) {
                classLoader = clazz.getClassLoader();
                if (classLoader2 == null) {
                    classLoader2 = classLoader;
                }
                classPackagingData = this.calculateByExactType(clazz);
                stackTraceElementProxy.setClassPackagingData(classPackagingData);
                continue;
            }
            ++n5;
            classPackagingData = this.computeBySTEP(stackTraceElementProxy, classLoader);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
        this.populateUncommonFrames(n2, stackTraceElementProxyArray, classLoader2);
    }

    void populateUncommonFrames(int n2, StackTraceElementProxy[] stackTraceElementProxyArray, ClassLoader classLoader) {
        int n3 = stackTraceElementProxyArray.length - n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i2];
            ClassPackagingData classPackagingData = this.computeBySTEP(stackTraceElementProxy, classLoader);
            stackTraceElementProxy.setClassPackagingData(classPackagingData);
        }
    }

    private ClassPackagingData calculateByExactType(Class clazz) {
        String string = clazz.getName();
        ClassPackagingData classPackagingData = this.cache.get(string);
        if (classPackagingData != null) {
            return classPackagingData;
        }
        String string2 = this.getImplementationVersion(clazz);
        String string3 = this.getCodeLocation(clazz);
        classPackagingData = new ClassPackagingData(string3, string2);
        this.cache.put(string, classPackagingData);
        return classPackagingData;
    }

    private ClassPackagingData computeBySTEP(StackTraceElementProxy stackTraceElementProxy, ClassLoader classLoader) {
        String string = stackTraceElementProxy.ste.getClassName();
        ClassPackagingData classPackagingData = this.cache.get(string);
        if (classPackagingData != null) {
            return classPackagingData;
        }
        Class clazz = this.bestEffortLoadClass(classLoader, string);
        String string2 = this.getImplementationVersion(clazz);
        String string3 = this.getCodeLocation(clazz);
        classPackagingData = new ClassPackagingData(string3, string2, false);
        this.cache.put(string, classPackagingData);
        return classPackagingData;
    }

    String getImplementationVersion(Class clazz) {
        if (clazz == null) {
            return "na";
        }
        Package package_ = clazz.getPackage();
        if (package_ != null) {
            String string = package_.getImplementationVersion();
            if (string == null) {
                return "na";
            }
            return string;
        }
        return "na";
    }

    String getCodeLocation(Class clazz) {
        try {
            URL uRL;
            CodeSource codeSource;
            if (clazz != null && (codeSource = clazz.getProtectionDomain().getCodeSource()) != null && (uRL = codeSource.getLocation()) != null) {
                String string = uRL.toString();
                String string2 = this.getCodeLocation(string, '/');
                if (string2 != null) {
                    return string2;
                }
                return this.getCodeLocation(string, '\\');
            }
        }
        catch (Exception exception) {
        }
        return "na";
    }

    private String getCodeLocation(String string, char c2) {
        int n2 = string.lastIndexOf(c2);
        if (this.isFolder(n2, string)) {
            n2 = string.lastIndexOf(c2, n2 - 1);
            return string.substring(n2 + 1);
        }
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return null;
    }

    private boolean isFolder(int n2, String string) {
        return n2 != -1 && n2 + 1 == string.length();
    }

    private Class loadClass(ClassLoader classLoader, String string) {
        if (classLoader == null) {
            return null;
        }
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Class bestEffortLoadClass(ClassLoader classLoader, String string) {
        Class clazz = this.loadClass(classLoader, string);
        if (clazz != null) {
            return clazz;
        }
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != classLoader) {
            clazz = this.loadClass(classLoader2, string);
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        try {
            Reflection.getCallerClass((int)2);
            GET_CALLER_CLASS_METHOD_AVAILABLE = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Throwable throwable) {
            System.err.println("Unexpected exception");
            throwable.printStackTrace();
        }
    }
}

