/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.builder;

import com.eg.org.apache.commons.lang3.Validate;
import com.eg.org.apache.commons.lang3.builder.Diff;
import com.eg.org.apache.commons.lang3.builder.ToStringBuilder;
import com.eg.org.apache.commons.lang3.builder.ToStringStyle;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResult
implements Iterable<Diff<?>> {
    public static final String OBJECTS_SAME_STRING = "";
    private static final String DIFFERS_STRING = "differs from";
    private final List<Diff<?>> diffs;
    private final Object lhs;
    private final Object rhs;
    private final ToStringStyle style;

    DiffResult(Object object, Object object2, List<Diff<?>> list, ToStringStyle toStringStyle) {
        Validate.isTrue(object != null, "Left hand object cannot be null", new Object[0]);
        Validate.isTrue(object2 != null, "Right hand object cannot be null", new Object[0]);
        Validate.isTrue(list != null, "List of differences cannot be null", new Object[0]);
        this.diffs = list;
        this.lhs = object;
        this.rhs = object2;
        this.style = toStringStyle == null ? ToStringStyle.DEFAULT_STYLE : toStringStyle;
    }

    public List<Diff<?>> getDiffs() {
        return Collections.unmodifiableList(this.diffs);
    }

    public int getNumberOfDiffs() {
        return this.diffs.size();
    }

    public ToStringStyle getToStringStyle() {
        return this.style;
    }

    public String toString() {
        return this.toString(this.style);
    }

    public String toString(ToStringStyle toStringStyle) {
        if (this.diffs.isEmpty()) {
            return OBJECTS_SAME_STRING;
        }
        ToStringBuilder toStringBuilder = new ToStringBuilder(this.lhs, toStringStyle);
        ToStringBuilder toStringBuilder2 = new ToStringBuilder(this.rhs, toStringStyle);
        for (Diff<?> diff : this.diffs) {
            toStringBuilder.append(diff.getFieldName(), diff.getLeft());
            toStringBuilder2.append(diff.getFieldName(), diff.getRight());
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = toStringBuilder.build();
        objectArray[1] = DIFFERS_STRING;
        objectArray[2] = toStringBuilder2.build();
        return String.format("%s %s %s", objectArray);
    }

    @Override
    public Iterator<Diff<?>> iterator() {
        return this.diffs.iterator();
    }
}

