/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net;

import com.eg.ch.qos.logback.core.AppenderBase;
import com.eg.ch.qos.logback.core.net.AutoFlushingObjectWriter;
import com.eg.ch.qos.logback.core.net.DefaultSocketConnector;
import com.eg.ch.qos.logback.core.net.ObjectWriter;
import com.eg.ch.qos.logback.core.net.ObjectWriterFactory;
import com.eg.ch.qos.logback.core.net.QueueFactory;
import com.eg.ch.qos.logback.core.net.SocketConnector;
import com.eg.ch.qos.logback.core.spi.PreSerializationTransformer;
import com.eg.ch.qos.logback.core.util.CloseUtil;
import com.eg.ch.qos.logback.core.util.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSocketAppender<E>
extends AppenderBase<E>
implements SocketConnector.ExceptionHandler {
    public static final int DEFAULT_PORT = 4560;
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 128;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private static final int DEFAULT_EVENT_DELAY_TIMEOUT = 100;
    private final ObjectWriterFactory objectWriterFactory;
    private final QueueFactory queueFactory;
    private String remoteHost;
    private int port = 4560;
    private InetAddress address;
    private Duration reconnectionDelay = new Duration(30000L);
    private int queueSize = 128;
    private int acceptConnectionTimeout = 5000;
    private Duration eventDelayLimit = new Duration(100L);
    private BlockingDeque<E> deque;
    private String peerId;
    private SocketConnector connector;
    private Future<?> task;
    private volatile Socket socket;

    protected AbstractSocketAppender() {
        this(new QueueFactory(), new ObjectWriterFactory());
    }

    AbstractSocketAppender(QueueFactory queueFactory, ObjectWriterFactory objectWriterFactory) {
        this.objectWriterFactory = objectWriterFactory;
        this.queueFactory = queueFactory;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        int n2 = 0;
        if (this.port <= 0) {
            ++n2;
            this.addError("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.remoteHost == null) {
            ++n2;
            this.addError("No remote host was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (this.queueSize == 0) {
            this.addWarn("Queue size of zero is deprecated, use a size of one to indicate synchronous processing");
        }
        if (this.queueSize < 0) {
            ++n2;
            this.addError("Queue size must be greater than zero");
        }
        if (n2 == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException unknownHostException) {
                this.addError("unknown host: " + this.remoteHost);
                ++n2;
            }
        }
        if (n2 == 0) {
            this.deque = this.queueFactory.newLinkedBlockingDeque(this.queueSize);
            this.peerId = "remote peer " + this.remoteHost + ":" + this.port + ": ";
            this.connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay.getMilliseconds());
            this.task = this.getContext().getExecutorService().submit(new Runnable(){

                public void run() {
                    AbstractSocketAppender.this.connectSocketAndDispatchEvents();
                }
            });
            super.start();
        }
    }

    @Override
    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly(this.socket);
        this.task.cancel(true);
        super.stop();
    }

    @Override
    protected void append(E e2) {
        if (e2 == null || !this.isStarted()) {
            return;
        }
        try {
            boolean bl2 = this.deque.offer(e2, this.eventDelayLimit.getMilliseconds(), TimeUnit.MILLISECONDS);
            if (!bl2) {
                this.addInfo("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded");
            }
        }
        catch (InterruptedException interruptedException) {
            this.addError("Interrupted while appending event to SocketAppender", interruptedException);
        }
    }

    private void connectSocketAndDispatchEvents() {
        try {
            while (this.socketConnectionCouldBeEstablished()) {
                try {
                    ObjectWriter objectWriter = this.createObjectWriterForSocket();
                    this.addInfo(this.peerId + "connection established");
                    this.dispatchEvents(objectWriter);
                }
                catch (IOException iOException) {
                    this.addInfo(this.peerId + "connection failed: " + iOException);
                }
                finally {
                    CloseUtil.closeQuietly(this.socket);
                    this.socket = null;
                    this.addInfo(this.peerId + "connection closed");
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        this.addInfo("shutting down");
    }

    private boolean socketConnectionCouldBeEstablished() throws InterruptedException {
        this.socket = this.connector.call();
        return this.socket != null;
    }

    private ObjectWriter createObjectWriterForSocket() throws IOException {
        this.socket.setSoTimeout(this.acceptConnectionTimeout);
        AutoFlushingObjectWriter autoFlushingObjectWriter = this.objectWriterFactory.newAutoFlushingObjectWriter(this.socket.getOutputStream());
        this.socket.setSoTimeout(0);
        return autoFlushingObjectWriter;
    }

    private SocketConnector createConnector(InetAddress inetAddress, int n2, int n3, long l2) {
        SocketConnector socketConnector = this.newConnector(inetAddress, n2, n3, l2);
        socketConnector.setExceptionHandler(this);
        socketConnector.setSocketFactory(this.getSocketFactory());
        return socketConnector;
    }

    private void dispatchEvents(ObjectWriter objectWriter) throws InterruptedException, IOException {
        while (true) {
            E e2 = this.deque.takeFirst();
            this.postProcessEvent(e2);
            Serializable serializable = this.getPST().transform(e2);
            try {
                objectWriter.write(serializable);
            }
            catch (IOException iOException) {
                this.tryReAddingEventToFrontOfQueue(e2);
                throw iOException;
            }
        }
    }

    private void tryReAddingEventToFrontOfQueue(E e2) {
        boolean bl2 = this.deque.offerFirst(e2);
        if (!bl2) {
            this.addInfo("Dropping event due to socket connection error and maxed out deque capacity");
        }
    }

    @Override
    public void connectionFailed(SocketConnector socketConnector, Exception exception) {
        if (exception instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (exception instanceof ConnectException) {
            this.addInfo(this.peerId + "connection refused");
        } else {
            this.addInfo(this.peerId + exception);
        }
    }

    protected SocketConnector newConnector(InetAddress inetAddress, int n2, long l2, long l3) {
        return new DefaultSocketConnector(inetAddress, n2, l2, l3);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    protected abstract void postProcessEvent(E var1);

    protected abstract PreSerializationTransformer<E> getPST();

    public void setRemoteHost(String string) {
        this.remoteHost = string;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(Duration duration) {
        this.reconnectionDelay = duration;
    }

    public Duration getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setQueueSize(int n2) {
        this.queueSize = n2;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setEventDelayLimit(Duration duration) {
        this.eventDelayLimit = duration;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int n2) {
        this.acceptConnectionTimeout = n2;
    }
}

