/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import com.egurkha.util.EgUtilities;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class CtxXcXADBConnTest
extends GenericTest {
    private boolean firstTime = true;
    private EgUtilities util = null;
    private static String upEventID = "1200";
    private static String upEventID1 = "3004";
    private static String downEventID = "1201";
    private static String downEventID1 = "3003";
    private String eventID = "";
    private String previousEventId = "";
    private String fileName = EgInstallInfo.getInstallDir() + "/agent/logs/xddb_" + this.reportingName + ".log";
    private double currSystemTime = 0.0;
    private long lastEventRecordId = 0L;
    private double diffTime = 0.0;
    private double dbAvailibilty = -5.0;
    private double dbAvailibityDuration = -5.0;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;

    public CtxXcXADBConnTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            long l;
            if (this.meAgentless) {
                System.out.println("[CtxXcXADBConnTest] Agentless not support. So return!");
                return;
            }
            String string = "wevtutil.exe qe application /c:1 /rd:true /f:xml";
            String string2 = "";
            if (this.lastEventRecordId > 0L) {
                string = "wevtutil.exe qe application \"/q:*[System[EventRecordID > " + this.lastEventRecordId + "]]\" /c:1 /rd:true /f:xml";
                string2 = "wevtutil.exe qe application \"/q:*[System[(Provider[@Name='Citrix Broker Service' or @Name='Citrix High Availability Service']) and (EventRecordID > " + this.lastEventRecordId + ") and (EventID=1201 or EventID=1200 or EventID=3004 or EventID=3003) ]]\" /c:1 /rd:true /f:text";
            }
            if (this.util == null) {
                this.util = EgUtilities.createInstance();
            }
            if ((l = this.getLastEventRecordId(string)) > this.lastEventRecordId) {
                this.lastEventRecordId = l;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            if (this.firstTime) {
                String string3 = "wevtutil.exe qe application \"/q:*[System[(Provider[@Name='Citrix Broker Service' or @Name='Citrix High Availability Service']) and (EventID=1200 or EventID=3004) ]]\" /c:1 /rd:true /f:xml";
                String string4 = "wevtutil.exe qe application \"/q:*[System[(Provider[@Name='Citrix Broker Service' or @Name='Citrix High Availability Service']) and (EventID=1201 or EventID=3003) ]]\" /c:1 /rd:true /f:xml";
                long l2 = this.getLastEventRecordId(string3);
                String string5 = this.eventID;
                long l3 = this.getLastEventRecordId(string4);
                String string6 = this.eventID;
                if (l2 > l3) {
                    this.dbAvailibilty = 100.0;
                    this.previousEventId = string5;
                } else if (l2 < l3) {
                    this.dbAvailibilty = 0.0;
                    this.currSystemTime = System.currentTimeMillis();
                    this.writeDoubleToFile(this.currSystemTime);
                    this.previousEventId = string6;
                } else {
                    this.dbAvailibilty = -5.0;
                }
                this.dbAvailibityDuration = -5.0;
                this.firstTime = false;
                arrayList.add(new Double(this.dbAvailibilty));
                arrayList.add(new Double(this.dbAvailibityDuration));
                this.addNewMeasure(arrayList);
                return;
            }
            ArrayList arrayList2 = this.util.getExecOutputLines(string2);
            if (arrayList2 == null || arrayList2.size() < 2) {
                System.out.println("[CtxXcXADBConnTest] outList1 is NULL or size is Zero. So return!");
                return;
            }
            ArrayList arrayList3 = (ArrayList)arrayList2.get(0);
            if (arrayList3 == null || arrayList3.size() == 0) {
                System.out.println("[CtxXcXADBConnTest] cmdInfo1 for eventid is NULL or size is Zero. So return!");
                this.setPreviousMeasure();
                return;
            }
            String string7 = EgLangInfo.getAgentCommandSearch((String)"EventLog", (String)"Citrix Broker Service");
            int n = arrayList3.size();
            for (int i = 0; i < n; ++i) {
                String string8;
                String string9 = (String)arrayList3.get(i);
                if (string9 == null || string9.trim().length() == 0) continue;
                if ((string9 = string9.trim()).indexOf("Source") != -1 && string9.indexOf(string7) == -1) {
                    this.setPreviousMeasure();
                    return;
                }
                if (string9.indexOf("Event ID:") == -1 || (string8 = string9.substring(string9.indexOf(":") + 1, string9.length())) == null || string8.trim().length() == 0) continue;
                this.previousEventId = string8 = string8.trim();
                if (string8.equalsIgnoreCase(upEventID) || string8.equalsIgnoreCase(upEventID1)) {
                    this.dbAvailibilty = 100.0;
                    this.dbAvailibityDuration = -5.0;
                    this.diffTime = 0.0;
                    if (this.f == null || !this.f.exists()) break;
                    this.f.delete();
                    break;
                }
                this.setDiffTime();
                this.dbAvailibilty = 0.0;
                this.dbAvailibityDuration = this.diffTime;
                break;
            }
            arrayList.add(new Double(this.dbAvailibilty));
            arrayList.add(new Double(this.dbAvailibityDuration));
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "CtxXcXADBConnTest", string);
        }
    }

    public long getLastEventRecordId(String string) {
        long l = 0L;
        try {
            int n;
            ArrayList arrayList = this.util.getExecOutputLines(string);
            if (arrayList == null || arrayList.size() < 2) {
                System.out.println("[CtxXcXADBConnTest] outList is NULL or size is Zero. So return!");
                return l;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                System.out.println("[CtxXcXADBConnTest] cmdInfo is NULL or length is Zero. So return!");
                return l;
            }
            String string2 = (String)arrayList2.get(0);
            if (string2 == null || string2.trim().length() == 0) {
                System.out.println("[CtxXcXADBConnTest] xmlData is NULL or length is Zero. So return!");
                return l;
            }
            int n2 = string2.indexOf("<EventRecordID>");
            if (n2 < 0) {
                return l;
            }
            int n3 = n2 + "<EventRecordID>".length();
            String string3 = string2.substring(n3, n = string2.indexOf("</EventRecordID>"));
            if (string3 == null || string3.trim().length() == 0) {
                System.out.println("[CtxXcXADBConnTest] currentEventRecordId is NULL or length is Zero. So return!");
                return l;
            }
            this.eventID = string3 = string3.trim();
            l = Long.parseLong(string3);
        }
        catch (Exception exception) {
            l = 0L;
            String string4 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "CtxXcXADBConnTest", string4);
        }
        return l;
    }

    private void setPreviousMeasure() {
        try {
            if (this.previousEventId.equalsIgnoreCase(downEventID) || this.previousEventId.equalsIgnoreCase(downEventID1)) {
                this.setDiffTime();
                this.dbAvailibityDuration = this.diffTime;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(this.dbAvailibilty));
            arrayList.add(new Double(this.dbAvailibityDuration));
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "CtxXcXADBConnTest", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoubleToFile(double d) {
        try {
            if (this.f == null) {
                this.f = new File(this.fileName);
            }
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            this.dos.writeDouble(d);
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
            }
            catch (Exception exception) {}
            this.dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readDoubleFromFile() {
        double d = 0.0;
        try {
            if (this.f == null || !this.f.exists()) {
                double d2 = -5.0;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            d = this.dis.readDouble();
        }
        catch (Exception exception) {
            System.out.println("[CtxXcXADBConnTest] read file having some problem. so return zero!!!");
            exception.printStackTrace();
        }
        finally {
            try {
                this.dis.close();
            }
            catch (Exception exception) {}
            this.dis = null;
        }
        return d;
    }

    private void setDiffTime() {
        try {
            this.currSystemTime = System.currentTimeMillis();
            double d = this.readDoubleFromFile();
            double d2 = 0.0;
            d2 = d < 0.0 ? (double)this.measurePeriod : this.currSystemTime - d;
            d2 = d2 >= 0.0 ? (d2 /= 60000.0) : 0.0;
            this.diffTime += d2;
            this.writeDoubleToFile(this.currSystemTime);
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "CtxXcXADBConnTest", string);
        }
    }
}

