/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class VmgRdpClientTest
extends VmgTestBase {
    public static final short CLIENT_TYPE_ICA = 1;
    public static final short CLIENT_TYPE_RDP = 2;
    public static final short INDEX_CLIENT_TYPE = 0;
    public static final short INDEX_DOMAIN_NAME = 1;
    public static final short INDEX_USER_NAME = 2;
    public static final short INDEX_IP_ADDRESS = 3;
    int size = 1000;
    int numPac = 10;
    int packetInterval = 50;
    int timeOut = 1000;
    boolean displayDomain = true;
    private boolean isReportUnavailability = true;
    public Hashtable rdpCilentIpAddressHt_DD = new Hashtable();

    public VmgRdpClientTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        String string = this.getValueForParam("packetSize");
        if (string != null && string.length() != 0) {
            this.size = Integer.parseInt(string);
        }
        if ((string = this.getValueForParam("packetCount")) != null && string.length() != 0) {
            this.numPac = Integer.parseInt(string);
        }
        if ((string = this.getValueForParam("timeout")) != null && string.length() != 0) {
            this.timeOut = Integer.parseInt(string);
        }
        if ((string = this.getValueForParam("packetInterval")) != null && string.length() != 0) {
            this.packetInterval = Integer.parseInt(string);
        }
        if ((string = this.getValueForParam("reportUnavailability")) != null && string.length() != 0) {
            this.isReportUnavailability = !string.equalsIgnoreCase("false") && !string.equalsIgnoreCase("no");
        }
        this.isDynamicInfoTest = true;
    }

    public boolean parse(ArrayList arrayList, Hashtable hashtable) {
        return true;
    }

    public void freeTest() {
        this.rdpCilentIpAddressHt_DD = new Hashtable();
    }

    public void computeMeasuresFor(VmGuest vmGuest) {
        if (vmGuest == null) {
            if (VmConstants.isDebugEnabled()) {
                System.out.println("[VmgRdpClientTest][computeMeasuresFor]vmg object is null......");
            }
            return;
        }
        if (vmGuest.isOperatingSystem(0)) {
            Object object;
            Object object2;
            if (!vmGuest.isLoggedOn()) {
                System.out.println("[VmgRdpClientTest][computeMeasuresFor][" + vmGuest.getVmName() + "=" + vmGuest + "]No one is logged on.......");
                return;
            }
            ArrayList arrayList = vmGuest.getLoggedOnUsers();
            if (arrayList.size() > 1) {
                System.out.println("[VmgRdpClientTest][computeMeasuresFor][" + vmGuest.getVmName() + "=" + vmGuest + "]More than one user logged on.......");
                return;
            }
            if (EgMainAgent.isReportVmWithoutUserName) {
                object2 = vmGuest.getOsInfo();
                object = null;
                boolean bl = false;
                if (object2 == null) {
                    object = "";
                } else {
                    object = object2.getOsName();
                    bl = object2.getDesktopExperienceEnabled();
                }
                boolean bl2 = this.isDesktopOperatingSystem((String)object);
                if (!bl2 && !bl) {
                    if (VmConstants.isDebugEnabled()) {
                        System.out.println("[VmgRdpClientTest][computeMeasuresFor][" + vmGuest.getVmName() + "=" + vmGuest + "] vm os is " + (String)object + " .so we dont report metrics for this vm.......");
                    }
                    return;
                }
            }
            if ((object2 = this.findClients((short)2, vmGuest)) == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            object = this.findMeasures((Hashtable)object2, vmGuest);
            if (object == null || ((Hashtable)object).size() == 0) {
                if (VmConstants.isDebugEnabled()) {
                    System.out.println("[VmgRdpClientTest][computeMeasuresFor]htMeasures=" + object);
                }
                return;
            }
            this.findAndSendMeasuresByUsers((Hashtable)object2, (Hashtable)object, vmGuest);
        }
    }

    public Hashtable findClients(short s, VmGuest vmGuest) {
        EsxHelper esxHelper;
        Hashtable<String, ArrayList<String[]>> hashtable = new Hashtable<String, ArrayList<String[]>>();
        String string = "";
        if (s == 1) {
            string = "ica";
        } else if (s == 2) {
            string = "rdp";
        } else {
            if (VmConstants.isDebugEnabled()) {
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "]Given client type " + s + " is invalid.");
            }
            return hashtable;
        }
        String string2 = "Unknown";
        if (vmGuest.getOsInfo() != null) {
            string2 = vmGuest.getOsInfo().getBrokeredBy();
        }
        if (string2 == null) {
            string2 = "Unknown";
        }
        CommandInfo commandInfo = null;
        String string3 = vmGuest.getIpAddress();
        ArrayList arrayList = null;
        if (this.isMyOsWindows && this.eGAgentIpAddressList != null && string3 != null && this.eGAgentIpAddressList.contains(string3) && vmGuest.isOperatingSystem(0)) {
            commandInfo = string2.equalsIgnoreCase("vmware") ? VmCommands.getVmgHrznViewClientTestCmdForLocalhost(vmGuest, string) : VmCommands.getVmgRdpClientTestCmdForLocalhost(vmGuest, string);
            if (this.esx != null) {
                esxHelper = VmHelper.getVmHelper();
                arrayList = esxHelper.getCommandOutput(commandInfo.getCommand());
            } else {
                esxHelper = EsxHelper.getEsxHelper();
                arrayList = esxHelper.getCommandOutput(commandInfo.getCommand());
            }
        } else {
            commandInfo = string2.equalsIgnoreCase("vmware") ? VmCommands.getHrznViewClientCommand(vmGuest, string) : VmCommands.get_ts_users_Command(vmGuest, string);
            if ((vmGuest.getInsideView().equalsIgnoreCase("wmi") || vmGuest.getInsideView().equalsIgnoreCase("tcp")) && vmGuest.isOperatingSystem(0)) {
                arrayList = this.getVmgTestResult(vmGuest, commandInfo);
            } else if (this.esxi != null) {
                esxHelper = EsxHelper.getEsxHelper();
                arrayList = esxHelper.getCommandOutput(this.esxi, vmGuest, commandInfo);
            } else {
                esxHelper = VmHelper.getVmHelper();
                arrayList = esxHelper.getCommandOutput(this.esx, vmGuest, commandInfo);
            }
        }
        if (VmConstants.isDebugEnabled()) {
            System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findClients]output=" + arrayList);
        }
        if (arrayList == null) {
            return hashtable;
        }
        int n = arrayList.size();
        if (n <= 0) {
            return hashtable;
        }
        String string4 = "";
        int n2 = -1;
        hashtable = new Hashtable();
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList2;
            String string5 = (String)arrayList.get(i);
            if (string5 == null || string5.length() == 0) continue;
            if (VmConstants.isDebugEnabled()) {
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "]strLine=" + string5);
            }
            if ((arrayList2 = this.myTokenizer(string5, "#*#")) == null || arrayList2.size() < 4) {
                if (!VmConstants.isDebugEnabled()) continue;
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "]Invalid number of tokens in " + arrayList2);
                continue;
            }
            String string6 = "";
            String[] stringArray = new String[3];
            string4 = (String)arrayList2.get(0);
            n2 = string4.indexOf("=");
            if (n2 > 0) {
                stringArray[0] = string4.substring(n2 + 1).trim();
            }
            if ((n2 = (string4 = (String)arrayList2.get(1)).indexOf("=")) > 0) {
                stringArray[1] = string4.substring(n2 + 1).trim();
            }
            if ((n2 = (string4 = (String)arrayList2.get(2)).indexOf("=")) > 0) {
                stringArray[2] = string4.substring(n2 + 1).trim();
            }
            if ((n2 = (string4 = (String)arrayList2.get(3)).indexOf("=")) > 0) {
                string6 = string4.substring(n2 + 1).trim();
            }
            if (string6.length() == 0 || string6.equalsIgnoreCase("0.0.0.0")) continue;
            ArrayList<String[]> arrayList3 = null;
            arrayList3 = (ArrayList<String[]>)hashtable.get(string6);
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<String[]>();
                arrayList3.add(stringArray);
                hashtable.put(string6, arrayList3);
            } else {
                arrayList3.add(stringArray);
            }
            if (!VmConstants.isDebugEnabled()) continue;
            System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "]alLoginInfo=" + arrayList2);
        }
        return hashtable;
    }

    public Hashtable findMeasures(Hashtable hashtable, VmGuest vmGuest) {
        if (VmConstants.isDebugEnabled()) {
            System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findMeasures]htClients=" + hashtable);
        }
        Hashtable<String, Double[]> hashtable2 = new Hashtable<String, Double[]>();
        if (hashtable == null) {
            return hashtable2;
        }
        int n = hashtable.size();
        if (n <= 0) {
            return hashtable2;
        }
        if (n > 1) {
            System.out.println("[VmgRdpClientTest][computeMeasuresFor][" + vmGuest.getVmName() + "=" + vmGuest + "]More than one user logged on.......");
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        hashtable2 = new Hashtable();
        while (enumeration.hasMoreElements()) {
            Double[] doubleArray;
            String string = (String)enumeration.nextElement();
            if (string != null && string.equals("0.0.0.0") || (doubleArray = this.getMeasuresFor(string, vmGuest)) == null) continue;
            hashtable2.put(string, doubleArray);
        }
        return hashtable2;
    }

    public Double[] getMeasuresFor(String string, VmGuest vmGuest) {
        EsxHelper esxHelper;
        CommandInfo commandInfo = VmCommands.get_nfping_Command(vmGuest, string, this.packetInterval, this.size, this.numPac, this.timeOut);
        ArrayList arrayList = null;
        if ((vmGuest.getInsideView().equalsIgnoreCase("wmi") || vmGuest.getInsideView().equalsIgnoreCase("tcp")) && vmGuest.isOperatingSystem(0)) {
            arrayList = this.getVmgTestResult(vmGuest, commandInfo);
        } else if (this.esxi != null) {
            esxHelper = EsxHelper.getEsxHelper();
            arrayList = esxHelper.getCommandOutput(this.esxi, vmGuest, commandInfo);
        } else {
            esxHelper = VmHelper.getVmHelper();
            arrayList = esxHelper.getCommandOutput(this.esx, vmGuest, commandInfo);
        }
        if (VmConstants.isDebugEnabled()) {
            System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][getMeasuresFor]out=" + arrayList);
        }
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        if (n == 0) {
            return null;
        }
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2;
            String string3;
            StringTokenizer stringTokenizer;
            String string4 = (String)arrayList.get(i);
            if (string4 == null) continue;
            if (string4.indexOf("% loss") >= 0) {
                String string5;
                String string6;
                stringTokenizer = new StringTokenizer(string4, ",");
                if (stringTokenizer.countTokens() < 3) continue;
                string3 = stringTokenizer.nextToken().trim();
                string2 = stringTokenizer.nextToken().trim();
                String string7 = stringTokenizer.nextToken().trim();
                int n2 = -5;
                int n3 = -5;
                stringTokenizer = new StringTokenizer(string3, "=");
                if (stringTokenizer.countTokens() >= 2) {
                    string6 = stringTokenizer.nextToken().trim();
                    string5 = stringTokenizer.nextToken().trim();
                    try {
                        n2 = Integer.parseInt(string5);
                    }
                    catch (Exception exception) {
                        n2 = -5;
                    }
                }
                if ((stringTokenizer = new StringTokenizer(string2, "=")).countTokens() >= 2) {
                    string6 = stringTokenizer.nextToken().trim();
                    string5 = stringTokenizer.nextToken().trim();
                    try {
                        n3 = Integer.parseInt(string5);
                    }
                    catch (Exception exception) {
                        n3 = -5;
                    }
                }
                if (n2 <= 0 || n3 < 0) continue;
                if (n3 >= n2) {
                    d = 0.0;
                    continue;
                }
                d = (double)(n2 - n3) * 100.0 / (double)n2;
                continue;
            }
            if (string4.indexOf("Minimum =") < 0 || string4.indexOf("Maximum =") < 0 || (stringTokenizer = new StringTokenizer(string4, "=")).countTokens() < 4) continue;
            stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken().trim();
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken().trim();
            d2 = this.getVal(string3);
            d3 = this.getVal(string2);
        }
        if (!this.isReportUnavailability && d == 100.0) {
            return null;
        }
        Double[] doubleArray = new Double[]{new Double(d2), new Double(d3), new Double(d)};
        return doubleArray;
    }

    public boolean findAndSendMeasuresByUsers(Hashtable hashtable, Hashtable hashtable2, VmGuest vmGuest) {
        Object object;
        double d;
        double d2;
        Object object2;
        Object object3;
        if (hashtable == null) {
            return false;
        }
        Hashtable<String, Double[]> hashtable3 = new Hashtable<String, Double[]>();
        Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object3 = (ArrayList)hashtable.get(string);
            if (object3 == null || (object2 = (Double[])hashtable2.get(string)) == null) continue;
            double d3 = object2[0];
            d2 = object2[1];
            d = object2[2];
            if (VmConstants.isDebugEnabled()) {
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findAndSendMeasuresByUsers]minDelay=" + d3 + ";avgDelay=" + d2 + ";lossPct=" + d);
            }
            if (d3 < 0.0 || d2 < 0.0 || d < 0.0) continue;
            int n = ((ArrayList)object3).size();
            for (int i = 0; i < n; ++i) {
                String[] stringArray = (String[])((ArrayList)object3).get(i);
                if (stringArray == null) {
                    if (!VmConstants.isDebugEnabled()) continue;
                    System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findAndSendMeasuresByUsers]loginInfo is null");
                    continue;
                }
                String string2 = "";
                if (stringArray[2].length() == 0) {
                    if (!VmConstants.isDebugEnabled()) continue;
                    System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findAndSendMeasuresByUsers]loginInfo[INDEX_USER_NAME].length()==0");
                    continue;
                }
                string2 = this.displayDomain ? (stringArray[1].length() == 0 ? stringArray[2] : stringArray[1] + "\\" + stringArray[2]) : stringArray[2];
                object = (Double[])hashtable3.get(string2);
                if (object == null) {
                    if (VmConstants.isDebugEnabled()) {
                        System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findAndSendMeasuresByUsers]First time for " + string2);
                    }
                    object = new Double[]{new Double(1.0), object2[0], object2[1], object2[2]};
                    hashtable3.put(string2, (Double[])object);
                    hashtable4.put(string2, string);
                    continue;
                }
                if (VmConstants.isDebugEnabled()) {
                    System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findAndSendMeasuresByUsers]Not first time for " + string2);
                }
                double d4 = object[0];
                double d5 = object[1];
                double d6 = object[2];
                double d7 = object[3];
                object[0] = new Double(d4 + 1.0);
                if (d3 < d5) {
                    object[1] = new Double(d3);
                }
                object[2] = new Double(d6 + d2);
                object[3] = new Double(d7 + d);
            }
        }
        if (hashtable3 == null) {
            return false;
        }
        int n = hashtable3.size();
        if (n <= 0) {
            return false;
        }
        object3 = hashtable3.keys();
        while (object3.hasMoreElements()) {
            String string;
            object2 = (String)object3.nextElement();
            Double[] doubleArray = (Double[])hashtable3.get(object2);
            if (doubleArray == null) {
                if (!VmConstants.isDebugEnabled()) continue;
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][findAndSendMeasuresByUsers]measures is null for " + (String)object2);
                continue;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            d2 = doubleArray[0];
            d = doubleArray[1];
            double d8 = doubleArray[2] / d2;
            double d9 = doubleArray[3] / d2;
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d));
            arrayList.add(new Double(d9));
            object = (String)object2 + "_on_" + vmGuest.getVmName();
            if (EgMainAgent.isShowUsernameInLowercase) {
                object = ((String)object2).toLowerCase() + "_on_" + vmGuest.getVmName();
            }
            if (VmConstants.isDebugEnabled()) {
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][measureList]" + (String)object + "=" + arrayList);
                System.out.println("[" + ((Object)((Object)this)).getClass().getName() + "][" + vmGuest + "][htClientIPAdd]" + hashtable4);
            }
            if (hashtable4 != null && (string = (String)hashtable4.get(object2)) != null && string.trim().length() > 0) {
                this.rdpCilentIpAddressHt_DD.put(object, string);
            }
            this.addNewMeasure((String)object, arrayList);
        }
        return true;
    }

    private double getVal(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 1) {
            return -5.0;
        }
        String string2 = stringTokenizer.nextToken();
        try {
            double d = EgLangInfo.getDoubleValue((String)string2);
            return d / 1000.0;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    public ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + n3;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        VmgRdpClientTest vmgRdpClientTest = new VmgRdpClientTest(stringArray);
        vmgRdpClientTest.computeMeasures(new Hashtable());
    }
}

