﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
#<#
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rptTopNDD=[int]$testargs[4]
$otherdetails=$testargs[5]
$details=$otherdetails.split("#")
$toHideAdminTrfic=$details[0]
$reportingname='EXO/'+$details[1]
$proxyserverip=($details[2]).ToString().trim()
$ExcludeMails=$details[3]
$rptNamFrMT=$details[1]
#>

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
$proxyserver='http://'+$proxyserverip

$filepath=$egurkhaPath+'/agent/'+$reportingname+'/'
try{
    $filereaded=Get-ChildItem -Path $filepath |Where-Object {$_.Name -like 'msgs*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -First 2 
    if($filereaded.Length -eq 2){
        if($filereaded[0].Length -lt 100 -and $filereaded[1].Length -ge 100){
            $fileName=([String]$filereaded[0].Name).Trim()
            Remove-Item $filepath$fileName
        }
    }  
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "msgs" -keyFileName "kmsgs" -EgPath $egurkhaPath
    $datafile1=$readfiles1[1] -replace (".csv",".dat") 
    $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]
    $MessageTracetemp= import-csv $csvfile1    
    Remove-Item $csvfile1
    Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'msgs' -InputFile $readfiles1[3]
    Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kmsgs' -InputFile $readfiles1[4]
    Write-Host 'ReadFile:'$readfiles1[3]   
}
catch [System.Management.Automation.RuntimeException] {
    Write-Error -Message "File not found. The $reportingname location does not contain msgs files."
}
catch{
    $errmsg=$_.Exception.Message
    $errstack=$_.Exception.StackTrace
    Write-Error -Message $errmsg
}

if ( Test-Path $filepath -PathType Container ) {
    
    if($rptNamFrMT -match '_exd'){
        $alldomainnames=@()
	    $dhash=Eg-O635Domains -username $userName -password $Password -rptNam $rptNamFrMT -proxyserverip $proxyserverip -proxyUsr $proxyUsr -proxyPass $proxyPass
    	foreach($h in $dhash.Keys){
	        if($dhash[$h] -match $rptNamFrMT){
		        $alldomainnames+=$h        
	        }
	    }
    }else{
        $alldomainnames=Eg-GetDomain -userName $username -Password $Password -proxyUsr $proxyUsr -proxyPass $proxyPass -proxyserver $proxyserver       
    }
	$remvedmails=New-Object System.Collections.ArrayList
    if($toHideAdminTrfic -eq $true){           
        [void]$remvedmails.Add($username)   
    }
    try{
        if($ExcludeMails.Contains(',')){        
            $ExcludeMails=$ExcludeMails.Split(',')      
        }
    }catch{  $ExcludeMails=" "}

    foreach( $ExcludeMail in  $ExcludeMails){        
       [void] $remvedmails.Add($ExcludeMail)
    }

    #each domain process
    foreach($domainname in $alldomainnames){  
        $tmpdomainname = "@"+$domainname 
        if($MessageTracetemp.SenderAddress -match $tmpdomainname -or $MessageTracetemp.RecipientAddress -match $tmpdomainname){
            $domainname=$domainname.ToString().ToLower() 
            Write-host 'gettingmeasuresofSpecificDomains#' $domainname
            $unqSendersHT = New-Object System.Collections.Hashtable
            $unqRecepientsHT = New-Object System.Collections.Hashtable
            $FmIPHT = New-Object System.Collections.Hashtable       
            $Pending=0
            $None=0
            $Failed=0
            $Delivered=0
            $Expanded=0
            $Resolved=0
            $GettingStatus=0
            $Quarantined=0
            $Unknown=0
            $FilteredAsSpam=0
            $interMailSent=0
            $sizeinterMailSent=0
            $exterMailSent=0
            $sizeexterMailSent=0
            $interMailRevd=0
            $sizeinterMailRevd=0
            $exterMailRevd=0
            $sizeexterMailRevd=0
            $MailInboundTraffic = @{} 
            $MailOutboundTraffic = @{} 
            $MailOutTraffic=@{}
            $mailOutTrfcExsent=@{}
            $MailInTrafficSent=@{}
            $MailInTrafficRevd=@{}
            $MailInboundDomain=@{}
            $MailOutboundDomain=@{}
            $delstatuscnt=0
  
            #for each domain the data will be processed in this loop
            foreach($Message in $MessageTracetemp){ 
                if($Message.SenderAddress -match $remvedmails -and $Message.RecipientAddress -match $remvedmails -and $remvedmails -match " " -and $remvedmails -match $null){}
                else{        
                    $sendersDomain = "" 
                    $RecipientDomain=""
                    try{$sendersDomain=(($Message.SenderAddress).split('@')[1]).ToString().ToLower()}catch{$sendersDomain=""}
                    try{$RecipientDomain=(($Message.RecipientAddress).split('@')[1]).ToString().ToLower()}catch{$RecipientDomain=""}                
                    if(($sendersDomain-ne "" -and $domainname -eq $sendersDomain) -or ($RecipientDomain -ne "" -and $domainname -eq $RecipientDomain)) {
                        try{$unqSendersHT.Add($Message.SenderAddress,$Message.SenderAddress)}catch{} 
                        try{$unqRecepientsHT.Add($Message.RecipientAddress,$Message.RecipientAddress)}catch{}
                        try{$FmIPHT.Add($Message.FromIP,$Message.FromIP)}catch{}
                               
                        ## message delivery status
                        $Status = $Message.Status
                        if($Status -eq 'Delivered' -and $Status -ne $null){$Delivered++} 
                        elseif($Status -eq 'Expanded' -and $Status -ne $null){$Expanded++}
                        elseif($Status -eq 'Resolved' -and $Status -ne $null){$Resolved++}
                        elseif($Status -eq 'Pending' -and $Status -ne $null){$Pending++}   
                        elseif($Status -eq 'Failed' -and $Status -ne $null){$Failed++}
                        elseif($Status -eq 'GettingStatus' -and $Status -ne $null){$GettingStatus++}
                        elseif($Status -eq 'Quarantined' -and $Status -ne $null){$Quarantined++}
                        elseif($Status -eq 'Unknown' -and $Status -ne $null){$Unknown++}
                        elseif($Status -eq 'None' -and $Status -ne $null){$None++} 
                        elseif($Status -eq 'FilteredAsSpam' -and $Status -ne $null){$FilteredAsSpam++}

                        #Read each message tracking entry and add it to a hash table
                        $MessageSenderAddress=$Message.SenderAddress+'#'+$Message.FromIP
	                    if ($Message.SenderAddress -ne $null -and $domainname.Contains($sendersDomain)) {
		                    if ($MailOutboundTraffic.ContainsKey($MessageSenderAddress)) { 
		                        $MailOutboundTraffic[$MessageSenderAddress]['Outbound']++ 
		                        $MailOutboundTraffic[$MessageSenderAddress]['OutboundSize'] += [int]$Message.Size
    	                    }
                            else{
                                $MailOutboundTraffic[$MessageSenderAddress] = @{}
	                            $MailOutboundTraffic[$MessageSenderAddress]['Outbound']= 1
	                            $MailOutboundTraffic[$MessageSenderAddress]['Inbound']=0
	                            $MailOutboundTraffic[$MessageSenderAddress]['InboundSize']= 0
	                            $MailOutboundTraffic[$MessageSenderAddress]['OutboundSize']= [int]$Message.Size
                            }
	                    }
	                    if ($Message.RecipientAddress -ne $null -and $domainname.Contains($RecipientDomain)) { 
		                    if ($MailInboundTraffic.ContainsKey($MessageSenderAddress)){ 
			                    $MailInboundTraffic[$MessageSenderAddress]['Outbound']++ 
			                    $MailInboundTraffic[$MessageSenderAddress]['OutboundSize'] += [int]$Message.Size
		                    }
                            else{
                                $MailInboundTraffic[$MessageSenderAddress] = @{}
	                            $MailInboundTraffic[$MessageSenderAddress]['Outbound']= 1
	                            $MailInboundTraffic[$MessageSenderAddress]['Inbound']=0
	                            $MailInboundTraffic[$MessageSenderAddress]['InboundSize']= 0
	                            $MailInboundTraffic[$MessageSenderAddress]['OutboundSize']= [int]$Message.Size
                            }     
	                    }
       
		                if( $domainname.Contains($sendersDomain) -and $domainname.Contains($RecipientDomain)){
			                $interMailSent++
			                $sizeinterMailSent=$sizeinterMailSent+$Message.Size

		                    ##internal mail sent to our domain from our domain // sending means outbound
            	    
		                    if($MailInTrafficSent.ContainsKey($MessageSenderAddress)){
			                    $MailInTrafficSent[$MessageSenderAddress]['Outbound']++
			                    $MailInTrafficSent[$MessageSenderAddress]['OutboundSize'] +=[int]$Message.Size
		                    }
		                    else{
			                    $MailInTrafficSent[$MessageSenderAddress]=@{}
			                    $MailInTrafficSent[$MessageSenderAddress]['Inbound']=0
			                    $MailInTrafficSent[$MessageSenderAddress]['InboundSize']=0
			                    $MailInTrafficSent[$MessageSenderAddress]['Outbound']=1
			                    $MailInTrafficSent[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
		                    }   
		    
		                    ## internal mail reciving an mail from our domain //reciving inbound
		                    if($Message.Status -eq 'Delivered'){         
			                    $interMailRevd++
			                    $sizeinterMailRevd=$sizeinterMailRevd+$Message.Size
		                        if($MailInTrafficRevd.ContainsKey($Message.RecipientAddress)){
			                        $MailInTrafficRevd[$Message.RecipientAddress]['Inbound']++
			                        $MailInTrafficRevd[$Message.RecipientAddress]['InboundSize'] +=[int]$Message.Size
		                        }
		                        else{
			                        $MailInTrafficRevd[$Message.RecipientAddress]=@{}
			                        $MailInTrafficRevd[$Message.RecipientAddress]['Inbound']=1
			                        $MailInTrafficRevd[$Message.RecipientAddress]['InboundSize']=[int]$Message.Size
			                        $MailInTrafficRevd[$Message.RecipientAddress]['Outbound']=0
			                        $MailInTrafficRevd[$Message.RecipientAddress]['OutboundSize']=0
		                        }
		                    }           
		                }
		                elseif( $domainname.Contains($sendersDomain) -and !($domainname.Contains($RecipientDomain))){
			                $exterMailRevd++                   #external mail recived an mail from our domain  ## measure ui name is Externalemails sent
			                $sizeexterMailRevd=$sizeexterMailRevd+$Message.Size

		                    if($mailOutTrfcExsent.ContainsKey($MessageSenderAddress)){
			                    $mailOutTrfcExsent[$MessageSenderAddress]['Outbound']++
			                    $mailOutTrfcExsent[$MessageSenderAddress]['OutboundSize'] +=[int]$Message.Size
		                    }
		                    else{
			                    $mailOutTrfcExsent[$MessageSenderAddress]=@{}
			                    $mailOutTrfcExsent[$MessageSenderAddress]['Inbound']=0
			                    $mailOutTrfcExsent[$MessageSenderAddress]['InboundSize']=0
			                    $mailOutTrfcExsent[$MessageSenderAddress]['Outbound']=1
			                    $mailOutTrfcExsent[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
		                    }
		                }
	                    elseif(!($domainname.Contains($sendersDomain)) -and $domainname.Contains($RecipientDomain)){
                            $exterMailSent++           #External mail sent an mail to our domain  outbound
                            $sizeexterMailSent=$sizeexterMailSent+$Message.Size
                            if($MailOutTraffic.ContainsKey($MessageSenderAddress)){
                                $MailOutTraffic[$MessageSenderAddress]['Outbound']++
                                $MailOutTraffic[$MessageSenderAddress]['OutboundSize'] +=[int]$Message.Size
                            }
                            else{
                                $MailOutTraffic[$MessageSenderAddress]=@{}
                                $MailOutTraffic[$MessageSenderAddress]['Inbound']=0
                                $MailOutTraffic[$MessageSenderAddress]['InboundSize']=0
                                $MailOutTraffic[$MessageSenderAddress]['Outbound']=1
                                $MailOutTraffic[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
                            }
                        }
       
		                ###Message Status DD
         
                        if($delstatuscnt -lt $rptTopNDD -and ($Message.Status -eq 'None' -or $Message.Status -eq 'Failed' -or $Message.Status -eq 'Pending' -or $Message.Status -eq 'Unknown' -or $Message.Status -eq 'Quarantined') ){
		                    $size=(($Message.Size)/1024).tostring("#.##").replace(',','.')
	                        Write-Host '#delstatusdd'$Message.Status $Message.Received '~!~'$Message.SenderAddress '~!~' $Message.RecipientAddress '~!~' $Message.Subject '~!~' $size '~!~' $Message.FromIP                    		    
                            $delstatuscnt++;
                        }elseif($FilteredAsSpam -lt $rptTopNDD -and $Message.Status -eq 'FilteredAsSpam'){                    
		                    $size=(($Message.Size)/1024).tostring("#.##").replace(',','.')  
                            Write-Host "#delstatusdd Spam" $Message.Received'~!~'$Message.SenderAddress'~!~'$Message.RecipientAddress'~!~'$Message.Subject'~!~'$size '~!~'$Message.FromIP           
                        }
         
                       if($sendersDomain -ne "" -and $sendersDomain -ne $null -and !($domainname.Contains($sendersDomain))){
                            if($MailInboundDomain.ContainsKey($sendersDomain)){
			                    $MailInboundDomain[$sendersDomain]['Outbound']++
			                    $MailInboundDomain[$sendersDomain]['OutboundSize']+=[int]$Message.Size                   
                            }
                            else{
				                $MailInboundDomain[$sendersDomain]=@{}
			                    $MailInboundDomain[$sendersDomain]['Inbound']=0
			                    $MailInboundDomain[$sendersDomain]['InboundSize']=0
			                    $MailInboundDomain[$sendersDomain]['Outbound']=1
			                    $MailInboundDomain[$sendersDomain]['OutboundSize']=[int]$Message.Size
                            }
                       }
                       if($RecipientDomain -ne "" -and $RecipientDomain -ne $null -and !($domainname.Contains($RecipientDomain))){
                            if($MailOutboundDomain.ContainsKey($RecipientDomain)){
			                    $MailOutboundDomain[$RecipientDomain]['Inbound']++
			                    $MailOutboundDomain[$RecipientDomain]['InboundSize']+=[int]$Message.Size                   
                            }
                            else{
				                $MailOutboundDomain[$RecipientDomain]=@{}
			                    $MailOutboundDomain[$RecipientDomain]['Inbound']=1
			                    $MailOutboundDomain[$RecipientDomain]['InboundSize']=[int]$Message.Size
			                    $MailOutboundDomain[$RecipientDomain]['Outbound']=0
			                    $MailOutboundDomain[$RecipientDomain]['OutboundSize']=0
                            }
                        }                              
                    }            
                }        
            }

            write-host 'SenderAddress' $unqSendersHT.Keys.Count"#@!"
            write-host 'RecipientAddress' $unqRecepientsHT.Keys.Count"#@!"
            write-host 'FromIP' $FmIPHT.Keys.Count"#@!"

            ## message delivery status measures
	        Write-Host '#statusMeasure' $None' ~' $Failed' ~' $Pending' ~'  $Delivered '~' $Expanded '~' $Resolved  '~' $FilteredAsSpam '~' $GettingStatus '~' $Quarantined '~' $Unknown 	          

	        #Build a table to format the results 
	        $table = New-Object system.Data.DataTable "DetailedMessageStats" 
	        $col2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $table.columns.add($col2) 
	        $col3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $table.columns.add($col3) 
	        $col4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $table.columns.add($col4)
	        $col5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $table.columns.add($col5) 
	        $col6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $table.columns.add($col6) 

	        $intable=New-Object system.Data.DataTable "DetailedMessageStats" #table for out emails
	        $incol2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $intable.columns.add($incol2) 
	        $incol3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $intable.columns.add($incol3) 
	        $incol4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $intable.columns.add($incol4) 
	        $incol5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $intable.columns.add($incol5) 
	        $incol6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $intable.columns.add($incol6) 

	        $outtable=New-Object system.Data.DataTable "DetailedMessageStats" #table for out emails
	        $tcol2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $outtable.columns.add($tcol2) 
	        $tcol3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $outtable.columns.add($tcol3) 
	        $tcol4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $outtable.columns.add($tcol4) 
	        $tcol5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $outtable.columns.add($tcol5) 
	        $tcol6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $outtable.columns.add($tcol6) 

	        $Inbunddomainstab=New-Object system.Data.DataTable "Detailed Sender Domains Stats" #table for out emails
	        $tcol1 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $Inbunddomainstab.columns.add($tcol1) 
	        $tcol2 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $Inbunddomainstab.columns.add($tcol2)  
	        $tcol3 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $Inbunddomainstab.columns.add($tcol3) 

	        $Outbunddomainstab=New-Object system.Data.DataTable "Detailed Recipents Domains Stats" #table for out emails
	        $tcol1 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $Outbunddomainstab.columns.add($tcol1) 
	        $tcol2 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $Outbunddomainstab.columns.add($tcol2) 
	        $tcol3 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $Outbunddomainstab.columns.add($tcol3) 
 
	        #Transpose hashtable to datatable 
	        $TotalInboundSize=0 
	        $TotalOutboundSize=0
	        $TotalInboundItems=0
	        $TotalOutboundItems=0
    
  	        ForEach ($Recipient in $MailInboundTraffic.keys){ 
	            $RecipientName = $Recipient 
	            $row = $table.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInboundTraffic[$RecipientName].Inbound 
		        $row.Outbound = $MailInboundTraffic[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInboundTraffic[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailInboundTraffic[$RecipientName].OutboundSize)/1024
		        $table.Rows.Add($row)     
		        $TotalInboundSize = $TotalInboundSize + $MailInboundTraffic[$RecipientName].OutboundSize
		        $TotalInboundItems = $TotalInboundItems + $MailInboundTraffic[$RecipientName].Outbound

	        } 
	        #Export data to CSV and Screen 
              
	        #"*******Top 10 Recipients by Inbound size*******" 
	        $InSize=$table  | sort OutboundSize -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
	
   	        foreach($s in $InSize){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'InboundSize ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
            #"*******Top 10 Recipients by Inbound items*******" 
	        $InItems=$table | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
   	        foreach($s in $InItems){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
                Write-Host  'InboundItems ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
   	        $table.Rows.Clear()  # clearing all rows of the outable 
    
   	        ForEach ($Recipient in $MailOutboundTraffic.keys){ 
	            $RecipientName = $Recipient 
	            $row = $table.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailOutboundTraffic[$RecipientName].Inbound 
		        $row.Outbound = $MailOutboundTraffic[$RecipientName].Outbound 
		        $row.InboundSize = ($MailOutboundTraffic[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailOutboundTraffic[$RecipientName].OutboundSize)/1024
		        $table.Rows.Add($row)   
		        $TotalOutboundSize = $TotalOutboundSize + $MailOutboundTraffic[$RecipientName].OutboundSize
		        $TotalOutboundItems = $TotalOutboundItems + $MailOutboundTraffic[$RecipientName].Outbound
	        }
   	        #"*******Top 10 Senders by Outbound size*******" 
	        $outSize=$table | sort OutboundSize -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
  	        foreach($s in $outSize){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'OutboundSize ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        } 
   	            #"*******Top 10 Senders by Outbound items*******" 
	            $outitems = $table | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
	        foreach($s in $outitems){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'OutboundItems ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
   
	        #"*******Totals*******"
	        $TotalItems=$TotalInboundItems+$TotalOutboundItems
	        $TotalSize=$TotalInboundSize+$TotalOutboundSize 
            $TotalInboundSize=if([math]::round($TotalInboundSize /1Gb, 2) -gt 0){ ([math]::round($TotalInboundSize /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }
            $TotalOutboundSize=if([math]::round($TotalOutboundSize /1Gb, 2) -gt 0){ ([math]::round($TotalOutboundSize /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }
            $TotalSize=if([math]::round($TotalSize /1Gb, 2) -gt 0){ ([math]::round($TotalSize /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }
	        write-host "Totals "$TotalInboundSize ~ $TotalOutboundSize ~ $TotalInboundItems ~ $TotalOutboundItems ~ $TotalItems ~ $TotalSize"#@!" 

	        #$table | sort Date,Recipient,Inbound,Outbound, InboundSize, OutboundSize -desc | Out-GridView -Title "Messages Sent By User"
	        $sizeinterMailSent=if([math]::round($sizeinterMailSent /1Gb, 2) -gt 0){ ([math]::round($sizeinterMailSent /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }
	        $sizeinterMailRevd=if([math]::round($sizeinterMailRevd /1Gb, 2) -gt 0){ ([math]::round($sizeinterMailRevd /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }
	        $sizeexterMailSent=if([math]::round($sizeexterMailSent /1Gb, 2) -gt 0){ ([math]::round($sizeexterMailSent /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }
	        $sizeexterMailRevd=if([math]::round($sizeexterMailRevd /1Gb, 2) -gt 0){ ([math]::round($sizeexterMailRevd /1Gb, 2)).tostring("#.##").replace(',','.') } else { 0 }    
	        Write-Host  'emailsCountAndSize##' $interMailSent ~ $sizeinterMailSent  ~ $interMailRevd ~ $sizeinterMailRevd ~ $exterMailSent ~ $sizeexterMailSent ~ $exterMailRevd ~ $sizeexterMailRevd
   
            ForEach ($Recipient in $MailOutTraffic.keys) { 
	            $RecipientName = $Recipient 	     
		        $row = $outtable.NewRow() 
		        #$row.Date = $Date 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailOutTraffic[$RecipientName].Inbound 
		        $row.Outbound = $MailOutTraffic[$RecipientName].Outbound 
		        $row.InboundSize = ($MailOutTraffic[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailOutTraffic[$RecipientName].OutboundSize)/1024
		        $outtable.Rows.Add($row)     
	        }
   	        # $exterMailRevd++           #external mail recived an mail from our domain inbound
	        # $exterMailSent++           #External mail sent an mail to our domain  outbound
	        #"*******Top 10 External Recipients by Outbound items*******" 
	        $Externalemailsent = $outtable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
   	        foreach($s in $Externalemailsent){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	           Write-Host  'Externalemailsent ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }

            $outtable.Rows.Clear()  # clearing all rows of the outable 

   	        ForEach ($Recipient in $mailOutTrfcExsent.keys) { 
	            $RecipientName = $Recipient 	     
		        $row = $outtable.NewRow() 
		        #$row.Date = $Date 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $mailOutTrfcExsent[$RecipientName].Inbound 
		        $row.Outbound = $mailOutTrfcExsent[$RecipientName].Outbound
		        $row.InboundSize = ($mailOutTrfcExsent[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($mailOutTrfcExsent[$RecipientName].OutboundSize)/1024
		        $outtable.Rows.Add($row)     
	        }
   	        #"*******Top 10 External Recipients by Inbound items*******" 
	        $Externalemailrecived = $outtable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
  	        foreach($s in $Externalemailrecived){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')      
	          Write-Host  'Externalemailrecived' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
         
 	        ForEach ($Recipient in $MailInTrafficSent.keys){ 
	            $RecipientName = $Recipient 	     
		        $row = $intable.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInTrafficSent[$RecipientName].Inbound 
		        $row.Outbound = $MailInTrafficSent[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInTrafficSent[$RecipientName].InboundSize)/1024 
		        $row.OutboundSize = ($MailInTrafficSent[$RecipientName].OutboundSize)/1024
		        $intable.Rows.Add($row)     
	        }
  
	        #"*******Top 10 Internal Recipients by Outbound items*******" 
	        $Internalemailsent = $intable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
 	        foreach($s in $Internalemailsent){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	          Write-Host  'Internalemailsent ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }

            $intable.Rows.Clear()  # clearing all rows of the intable 

 	        ForEach ($Recipient in $MailInTrafficRevd.keys){ 
	            $RecipientName = $Recipient 	     
		        $row = $intable.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInTrafficRevd[$RecipientName].Inbound 
		        $row.Outbound = $MailInTrafficRevd[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInTrafficRevd[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailInTrafficRevd[$RecipientName].OutboundSize)/1024
		        $intable.Rows.Add($row)     
	        }
	        #"*******Top 10 Internal Recipients by Inbound items*******" 
	        $Internalemailreceving = $intable | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
 	        foreach($s in $Internalemailreceving){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	          Write-Host  'Internalemailreceving ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
              ## ADDING ROWS TO TABLE
            $sendercount=0
    
            ForEach ($Recipient in $MailInboundDomain.keys){ 
	            $RecipientName = $Recipient 
	            $sendercount++
		        $row = $Inbunddomainstab.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Outbound = $MailInboundDomain[$RecipientName].Outbound 
		        $row.OutboundSize = ($MailInboundDomain[$RecipientName].OutboundSize)/1024
		        $Inbunddomainstab.Rows.Add($row)     
	        }
 	        #"*******Top 10 Sender Domains by Outbound items*******" 
	        $unquesendrdoms = $Inbunddomainstab | sort Outbound -Descending #| select -first 10 | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
            $uniqueRecipentDomainsCnt = 0
            foreach($s in $unquesendrdoms){
               $inbundsize=if($s.Item(2) -gt 0){ ($s.Item(2)).tostring("#.##").replace(',','.') } else { 0 }
               if($uniqueRecipentDomainsCnt -lt $rptTopNDD){
	                Write-Host  'uniqueRecipentDomains ' $s.Item(0)','$s.Item(1)','$inbundsize #for Inbound domains measure here sender is others and reciver ours domain
                    $uniqueRecipentDomainsCnt++
                }
	        }
  
            ## ADDING ROWS TO TABLE
            $recipncount=0
            ForEach ($Recipient in $MailOutboundDomain.keys){ 
	            $RecipientName = $Recipient 
                $recipncount++
		        $row = $Outbunddomainstab.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailOutboundDomain[$RecipientName].Inbound 
		        $row.InboundSize = ($MailOutboundDomain[$RecipientName].InboundSize)/1024
		        $Outbunddomainstab.Rows.Add($row)     
	        }
   
	        #"*******Top 10 Recipents Domains by Outbound items*******" 
	        $unqueOutdoms = $Outbunddomainstab | sort Inbound -Descending # | select -first 10  | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
            $uniqueSenderDomainsCnt = 0
            foreach($s in $unqueOutdoms){
                $outboundsize=if($s.Item(2) -gt 0){ ($s.Item(2)).tostring("#.##").replace(',','.') } else { 0 }
	            if($uniqueSenderDomainsCnt -lt $rptTopNDD){
                    Write-Host  'uniqueSenderDomains' $s.Item(0)','$s.Item(1)',' $outboundsize   ## for outbound domains measure dd and here we are getting domains where sender is ours and recevers in other
                    $uniqueSenderDomainsCnt++
                }
	        }
            Write-Host 'uniquesdominascount'  $MailOutboundDomain.Count '~'  $MailInboundDomain.count   
            Write-Host 'donewithMeasuresofdomain#'$domainname    
        }            
    }            
}

# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUqMkfqRnXJVKMO6+6l0mCnKmj
# kOCggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUXmIWnFrSDE9rlTXBo/jLASit
# F1UwDQYJKoZIhvcNAQEBBQAEggEAKHr0aIWVXfV268eYbllRUBes0h13j2IqGT+N
# abTA2Ufqku7rNWRhxswVTZlHoQYuH/IXNY4fBENouxzUtAFFTpv07I/Zljk+Gaji
# IK2zn2Fwa3ZnyK0w+areNUfmGzB5tbagmzuyVFozmYt5Aw2xV6j32pbYeN7zggy9
# jeF7vHwhmPoMGARu+iR7j99npj5BaF9tK6uAxyat1/guVhIRo4S9ICdc9jQt4b4m
# pVXzCzsX83/Gbj18u453/7hqNszMrnuimyvjzzHdOzzzwYZNNiccLuP26bECkD80
# d4EhngdxgRg2AgrPQalQpCH7MInaECYbwYg4LnJSDuYryEmiFqGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwMzU3WjAjBgkqhkiG9w0BCQQxFgQUio7E31k3dZ103P6tvrWT
# W3FA7bEwDQYJKoZIhvcNAQEBBQAEggEAmdQD52P42Pg5f8gzvbYrUlS3QG6zuhaN
# iVcYRgjGteYnstAbxnXN9E5hu1+WsZUExp6TUlU1xApXy7hzNVe5gku6lgdoOuEp
# nstmNbj3KN5pP7sbKe17Wx538PSR8+X9wN5dPu23DO8nk5f9WFbWmzU4gHTXPNkV
# uTFCuWOhjrNaBwUjfbHGg1PL85TMpGznluX9nHRpMXmKSDDpWrQEHGivWClWoTQi
# uTDCTtLr8zA6+56bKuX6txecsM6MzAxfvQEdZHOiJn05fmKTitWUqmm3HTU5WI6l
# 8ptqIDizKZ6QEn/u6YRe04m/rJno/r/ssW3inYCzAtsWCelou8Q6/w==
# SIG # End signature block
