﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rName=$testargs[4]
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

$RprtNameAndmTime=$rName.split("#")
$reportingname=$RprtNameAndmTime[0]
$mTime=$RprtNameAndmTime[1]

#-----------------------------
$domainSpecific=$false
if($reportingname -match '_exd'){
    $domainSpecific=$true
    $alldomainnames=@()
    $dhash=Eg-O635Domains -username $userName -password $Password -rptNam $reportingname -proxyserverip 'none' -proxyUsr $proxyUsr -proxyPass $proxyPass
    $reportingname=$dhash['SupersetName']
    foreach($h in $dhash.Keys){
        if($h -ne 'SupersetName'){
            $alldomainnames+=$h
        }
    }
    $DS_mxbx_Key='';$DS_mxbx_fpth='';$DS_mxbx_nam='';
    $DS_csmx_Key='';$DS_csmx_fpth='';$DS_csmx_nam='';
    $DS_rcpm_Key='';$DS_rcpm_fpth='';$DS_rcpm_nam='';
    $DS_rptmx_Key='';$DS_rptmx_fpth='';$DS_rptmx_nam='';
    $DS_stsmx_Key='';$DS_stsmx_fpth='';$DS_stsmx_nam='';
}
$rptPath='EXO/'+$reportingname
$chkwritPath=$egurkhaPath+'/agent/'+$rptPath
if($domainSpecific){ 
    $isWrite=Check-WriteFile -rptPath $chkwritPath -srchWrd 'EXOMailnDevices' -mTimInMin $mTime
}
$isProceed=$false
if($isWrite){
    $isProceed=$true
}elseif($domainSpecific -eq $false){
    $isProceed=$true
}else{
    $isProceed=$false
}
#--------------------------------
$servicSpecific=$false
if($reportingname -match '_exs'){
    $servicSpecific=$true
}
#--------------------------------

if($isProceed){
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')

    $ManualThrottle=0
    [double]$ActiveThrottle=.25
    $ResetSeconds=900

    $WriteLog=$true
    $LogFile = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mail.log"
    $LogFile1 = $egurkhaPath+'/agent/EXO/'+$reportingname+"\mail1.log"
    $isFrstTimLog=$true

    # Writes output to a log file with a time date stamp
    Function Write-Log {
	    Param ([string]$string)
	    [string]$date = Get-Date -Format G
        if ($WriteLog) {
           ( "[" + $date + "] - [" + $reportingname+"] mTime -  " + $mTime + " - " + $string ) | Out-File -FilePath $LogFile -Append } 
        if($isFrstTimLog){     
            if ($WriteLog -eq $true){ #if flag is true 
                if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
                    if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                        Remove-Item $LogFile1 
                    } 
                    Rename-Item $LogFile $LogFile1 
                }
            }
            $isFrstTimLog=$false
        }
    }

    Function Start-SleepWithProgress {
	    Param([int]$sleeptime)
	    For ($i=0;$i -le $sleeptime;$i++){
		    $timeleft = ($sleeptime - $i);
		    Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		    start-sleep 1
	    }
	    Write-Progress -Completed -Activity "Sleeping"
    }

    Function New-CleanO365Session {
        $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $Password -asplaintext -force)
        $i = 0
	    while (($Credential -eq $Null) -and ($i -lt 5)){
		    $script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		    $i++
	    }
	    if ($Credential -eq $null){
		    Write-log ("[ "+$(Get-CurrentLineNumber) +" ] "+"[Error] - Failed to get credentials")
		    Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	    }
	    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+"Removing all PS Sessions")
	    Get-PSSession | Remove-PSSession -Confirm:$false
	    [System.GC]::Collect()
	    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Sleeping 15 seconds for Session Tear Down")
	    Start-SleepWithProgress -SleepTime 15
	    $Error.Clear()
	
	    # Create the session
	    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Creating new PS Session")
	    $sessionOption = New-PSSessionOption -SkipRevocationCheck
	    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
	        $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication basic -ProxyCredential $proxyCred
	    }
	    $global:session = New-PSSession -ConfigurationName Microsoft.Exchange -ConnectionUri $azureEnvArr[1] -Credential $Credential -Authentication Basic -AllowRedirection -SessionOption $sessionOption -WarningAction SilentlyContinue

	    # Check for an error while creating the session
	    if ($Error.Count -gt 0){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Error while setting up session")
		    $ErrorCount++
		    if ($ErrorCount -gt 3){
			    $deleky=0
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Failed to setup session after multiple tries")
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Aborting Script")
                try{
                    if(Test-Path -path $global:writeTmpCsv){
                        Write-Log "Converting tmpmailboxstats to dat file due to unavailability of session"
                        $null=Protect-File  $global:writeTmpCsv -Algorithm AES -KeyAsPlainText $global:WriteTmpKey -RemoveSource
                    }
                }catch{
                    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "File stats cannot be converted to dat while aborting the script")
                }
			    exit
		    }
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Sleeping 60s so that issue can potentially be resolved")
		    Start-SleepWithProgress -sleeptime 60
		    New-CleanO365Session
	    }
	    else {
		    $ErrorCount = 0
	    }	
	    # Import the PS session
	    $null = Import-PSSession $session -AllowClobber -WarningAction SilentlyContinue -DisableNameChecking
	
	    # Set the Start time for the current session
	    Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
    }

    Function Test-O365Session {
	    $ObjectTime = Get-Date
	    $SessionInfo = $null
	    $SessionInfo = Get-PSSession
	    if ($SessionInfo -eq $null) { 
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - No Session Found")
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Recreating Session")
		    New-CleanO365Session
	    }	
	    elseif ($SessionInfo.State -ne "Opened"){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "[ERROR] - Session not in Open State")
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ $SessionInfo | fl | Out-String )
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Recreating Session")
		    New-CleanO365Session
	    }
	    elseif (($ObjectTime - $SessionStartTime).totalseconds -gt $ResetSeconds){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Session Has been active for greater than " + $ResetSeconds + " seconds" )
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+  "Rebuilding Connection")
		    [int]$DelayinSeconds = ((($ResetSeconds * $ActiveThrottle) / 2) - 15)
		    if ($DelayinSeconds -gt 0){
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Sleeping " + $DelayinSeconds + " addtional seconds to allow throttle recovery")
			    Start-SleepWithProgress -SleepTime $DelayinSeconds
		    }
		    else{
			    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Active Delay calculated to be " + ($DelayinSeconds + 15) + " seconds no addtional delay needed")
		    }
		    New-CleanO365Session
	    }
	    else{
		    #Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "the session "+ $SessionInfo +" state is "+$SessionInfo.State)
	    }
	    if ($ManualThrottle -gt 0){
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "Sleeping " + $ManualThrottle + " milliseconds")
		    Start-Sleep -Milliseconds $ManualThrottle
	    }
    }

    Function Get-EstimatedTimeToCompletion {
	    param([int]$ProcessedCount)
	    $ProcessedCount++
	    if (($ProcessedCount % 100) -eq 0){
		    $CurrentDate = Get-Date
		    $AveragePerObject = (((($CurrentDate) - $ScriptStartTime).totalseconds) / $ProcessedCount)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Total Number of Objects:     " + $ObjectCount)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Number of Objects processed: " + $ProcessedCount)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Average seconds per object:  " + $AveragePerObject)
		    Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[STATS] - Estimated completion time:   " + $CurrentDate.addseconds((($ObjectCount - $ProcessedCount) * $AveragePerObject)))
	    }
	    return $ProcessedCount
    }

    function Get-CurrentLineNumber {
        $MyInvocation.ScriptLineNumber
    }


    $rptPath='EXO/'+$reportingname
    $MyDir=$egurkhaPath+'/agent/EXO/'+$reportingname
    if(!(Test-Path -Path $MyDir )){
        New-Item -ItemType directory -Path $MyDir
    }
    $isErrorOccur= $false
    Set-StrictMode -Version 2
    $ErrorCount = 0
    $TotMailbxcnt=""

    if(!$servicSpecific){
        $Error.Clear()
        try{
            New-CleanO365Session
            $Mailboxes = Eg-WriteFile -ComntRptPath $rptPath -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
            $results=invoke-command -scriptblock {Get-mailbox -resultsize unlimited |
                select-object -property Displayname, PrimarySMTPAddress, Identity, WasInactiveMailbox, SKUAssigned,
                RecipientTypeDetails, LitigationHoldEnabled, DeliverToMailboxAndForward, InPlaceHolds, UserPrincipalName,ArchiveStatus,Name,ArchiveName,ArchiveState,ArchiveQuota,ArchiveWarningQuota,
                ForwardingSmtpAddress, ServerName, Database, Location, Datacenter, AuditAdmin,GrantSendOnBehalfTo,IssueWarningQuota,ProhibitSendQuota,ProhibitSendReceiveQuota,IsInactiveMailbox, WhenChanged, WhenCreated, WhenSoftDeleted
            } -session (get-pssession) # | export-csv $Mailboxes[1]
            $results | ?{$_.SKUAssigned -eq $true} | export-csv $Mailboxes[1]
        }
        Catch{
            $ErrorMessage = $_.Exception.Message 
            $isErrorOccur=$true      
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ " ErrorMessage while running Mailbox : "+$ErrorMessage)  
            Write-Log $Error
            $TotMailbxcnt=""
        } 
        if($isErrorOccur -eq $true -or  (Get-Item $Mailboxes[1]).length -le 2kb){ 
            Remove-Item $Mailboxes[1] 
        }
        else{
            $DS_mxbx_Key=$Mailboxes[0];$DS_mxbx_fpth=$Mailboxes[1];$DS_mxbx_nam=$Mailboxes[2];  
            $TotMailbxcnt = import-csv  $Mailboxes[1]
            $null=Protect-File  $Mailboxes[1] -Algorithm AES -KeyAsPlainText $Mailboxes[0] -RemoveSource
        }

        $Error.Clear()
        try{
            Test-O365Session
            $casMailboxes = Eg-WriteFile -ComntRptPath $rptPath -FileName "casmailboxes" -keyFileName "Kcasmailboxes" -EgPath $egurkhaPath
            invoke-command -scriptblock { Get-CASMailbox -resultsize unlimited  | select-object ActiveSyncEnabled,Name ,Displayname, Guid, PrimarySMTPAddress
            } -session (get-pssession) | export-csv $casMailboxes[1]
        }Catch{
            $ErrorMessage = $_.Exception.Message
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running CASMailbox : "+$ErrorMessage)  
            $isErrorOccur=$true
        } 

        if($isErrorOccur -eq $true -or (Get-Item $casMailboxes[1]).length -le 2kb){
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Deleted File Error in excuting the CASMailbox ")
            Remove-Item $casMailboxes[1]
        }
        else{
            $DS_csmx_Key=$casMailboxes[0];$DS_csmx_fpth=$casMailboxes[1];$DS_csmx_nam=$casMailboxes[2];
            $null=Protect-File  $casMailboxes[1] -Algorithm AES -KeyAsPlainText $casMailboxes[0] -RemoveSource
        }
    }

    if(!$servicSpecific){
        $Error.Clear()
        try{
            Test-O365Session
            $RecipntPerm = Eg-WriteFile -ComntRptPath $rptPath -FileName "RecipntPerm" -keyFileName "kRecipntPerm" -EgPath $egurkhaPath
	        if($TotMailbxcnt -ne $null -and $TotMailbxcnt -ne ''){
		        $UserMailbox=$TotMailbxcnt|?{$_.RecipientTypeDetails -eq 'UserMailbox'}
		        $UserMailbox | Get-RecipientPermission  -ResultSize Unlimited  | ? {$_.Trustee -ne "NT AUTHORITY\SELF" -and $_.Trustee -ne "NULL SID"} | Export-Csv $RecipntPerm[1]
	        }
        }
        Catch{
            $ErrorMessage = $_.Exception.Message
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running RecipientPermission : "+$ErrorMessage)  
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true) { # -and (Get-Item $RecipntPerm[1]).length -le 2kb){
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error in excuting the RecipientPermission cmdlet")
	        Write-Log $Error
            Remove-Item $RecipntPerm[1]
        }else{
            $DS_rcpm_Key=$RecipntPerm[0];$DS_rcpm_fpth=$RecipntPerm[1];$DS_rcpm_nam=$RecipntPerm[2];
            $null=Protect-File  $RecipntPerm[1] -Algorithm AES -KeyAsPlainText $RecipntPerm[0] -RemoveSource   
        }
    }

    if(!$servicSpecific){
        $Error.Clear()
        try{
            Test-O365Session
            $Recpnt = Eg-WriteFile -ComntRptPath $rptPath -FileName "recipients" -keyFileName "krecipients" -EgPath $egurkhaPath
            $results=  invoke-command -scriptblock { Get-Recipient -ResultSize Unlimited |
                                                Select-Object -property PrimarySMTPAddress,SKUAssigned,RecipientTypeDetails,Name ,Displayname, Guid
                                        } -session (get-pssession)  | export-csv $Recpnt[1]
            #$results | ?{$_.SKUAssigned -eq $true} | export-csv $Recpnt[1]
        }Catch{
            $ErrorMessage = $_.Exception.Message
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running Recipient : "+$ErrorMessage)  
            $isErrorOccur=$true
        } 
        if($isErrorOccur -eq $true -or (Get-Item $Recpnt[1]).length -le 2kb){
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error in excuting the Recipient ")
            Remove-Item $Recpnt[1]
        }else{
            $DS_rptmx_Key=$Recpnt[0];$DS_rptmx_fpth=$Recpnt[1];$DS_rptmx_nam=$Recpnt[2];
            $null=Protect-File  $Recpnt[1] -Algorithm AES -KeyAsPlainText $Recpnt[0] -RemoveSource       
        }
    }

    if(!$domainSpecific){
        $Error.Clear()
        $isErrorOccur=$false
        try{
        $DeviceStats = Eg-WriteFile -ComntRptPath $rptPath -FileName "devicestats" -keyFileName "kdevicestats" -EgPath $egurkhaPath
	    Test-O365Session
        Invoke-Command  -ScriptBlock { 
                    Get-MobileDevice -ResultSize Unlimited | 
                    select-Object WhenChangedUTC,DeviceType, DeviceUserAgent, DeviceOS, DeviceOSLanguage, Identity, ClientType }| Export-CSV -LiteralPath $DeviceStats[1]
        }catch{
            $isErrorOccur =$true
	    }
        if($isErrorOccur -eq $true -or (Get-Item $DeviceStats[1]).length -le 2kb){
            Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error while fetching mobiledevices. Deleting the incomplete dat file")
            Remove-Item $DeviceStats[1]
        }else{
            $null=Protect-File  $DeviceStats[1] -Algorithm AES -KeyAsPlainText $DeviceStats[0] -RemoveSource 
        }
    }
    if(!$servicSpecific){
        try{
            $Error.Clear()
            $o365Domain=Eg-GetDomain -userName $userName -Password $Password -proxyUsr $proxyUsr -proxyPass $proxyPass -IsIntial $true -proxyserver 'none'
            $GraphDir=$egurkhaPath+'\agent\O365\MsGraph'
            $unProtPath=$GraphDir+'\GraphDetails.dat'
            $keyFileNam='\GraphDetailsKey.dat'
            $kvalue=Get-Content -Path $GraphDir$keyFileNam
            $null=Unprotect-File $unProtPath -Algorithm AES -KeyAsPlainText $kvalue -DstSuffix '.ini'
            $spoGraphDtls=$GraphDir+"\GraphDetails.ini"
            $getInputs=Get-Content -Path $spoGraphDtls
            Remove-Item $spoGraphDtls
            $flag=$false
            foreach($input in $getInputs){
                if($input.StartsWith('[') -and $input.ToLower().Contains($o365Domain.ToLower())){
                    $flag=$true
                }
                if($flag){
                    if($input.Contains("client_id")){
                        $appId=$input.ToString().Substring($input.IndexOf('~')+1)
                    }
                    if($input.Contains("client_secret")){
                        $appSecret=$input.ToString().Substring($input.IndexOf('~')+1)
                    }
                    if($input.Contains("TenantName")){
                        $tenantID=$input.ToString().Substring($input.IndexOf('~')+1)
                    }
                    if($input.Contains("Authority")){
                        $authString=$input.ToString().Substring($input.IndexOf('~')+1)
                        $authString=$authString+$o365Domain
                    }
                    if($input.Contains("Resource")){
                        $resource=$input.ToString().Substring($input.IndexOf('~')+1)
                        $flag=$false
                    }
                }         
            }
            $path=(([XML]((Get-Package -Name AzureAD  | select SwidTagText)).SwidTagText).SoftwareIdentity.Meta.InstalledLocation)+'\Microsoft.IdentityModel.Clients.ActiveDirectory.dll'
            Add-Type -Path $path
            try{
                $mailboxStats = Eg-WriteFile -ComntRptPath $rptPath -FileName "statsmailbox" -keyFileName "kstatsmailbox" -EgPath $egurkhaPath
                $creds = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.ClientCredential" -ArgumentList $appId, $appSecret
                $authContext = New-Object "Microsoft.IdentityModel.Clients.ActiveDirectory.AuthenticationContext"-ArgumentList $authString
                $context = $authContext.AcquireTokenAsync($resource, $creds).Result
                $authCode=$context.CreateAuthorizationHeader()
                $header = @{
                    'Authorization'=$authCode
                }
                $queryRes = Invoke-RestMethod -Method 'Get' -Headers $header -Uri "https://graph.microsoft.com/v1.0/reports/getMailboxUsageDetail(period='D7')"
                $queryRes=$queryRes.Replace('ï»¿','')
                $queryRes=$queryRes.Replace('(Byte)','')
                $queryRes=$queryRes.Replace(' ','')
                $resultarray = ConvertFrom-Csv -InputObject $queryRes
                foreach($rs in $resultarray){
                    $rs | Export-Csv $mailboxStats[1] -Append -Force
                }
                #$resultarray | ForEach-Object{$_ | Export-Csv $mailboxStats[1] -Append}
            }
            catch{
                Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error occured in graphapi - mailboxStats ")
                $isErrorOccur =$true
            }
            if($isErrorOccur -eq $true -or (Get-Item $mailboxStats[1]).length -le 2kb){
                Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "[ERROR] - Error while fetching mailboxStats. Deleting the incomplete dat file")
                Remove-Item $mailboxStats[1]
            }else{   
                $DS_stsmx_Key=$mailboxStats[0];$DS_stsmx_fpth=$mailboxStats[1];$DS_stsmx_nam=$mailboxStats[2];
                $null=Protect-File $mailboxStats[1] -Algorithm AES -KeyAsPlainText $mailboxStats[0] -RemoveSource
            }
        }Catch{ 
                $ErrorMessage = $_.Exception.Message
                Write-Log ("[ "+$(Get-CurrentLineNumber) +" ] "+ "ErrorMessage while running mailbox/device statistics : "+$ErrorMessage)       
        }
    }

    Write-Log "Script Complete Destroying PS Sessions"
    Get-PSSession | Remove-PSSession -Confirm:$false
}

if($domainSpecific -and $servicSpecific -eq $false){  
    #------------- 1.For Domain Specific - mailbox ---------------------- 
    if($DS_mxbx_fpth -ne ''){
        $mxbxFilePth=$DS_mxbx_fpth -replace (".csv",".dat")   
        if((Get-Item -Path $mxbxFilePth).Length -gt 2KB){
            $null=Unprotect-File $mxbxFilePth -Algorithm AES -KeyAsPlainText $DS_mxbx_Key
            $mailbxs= import-csv $DS_mxbx_fpth
            $nam=$DS_mxbx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$nam
                foreach($tmpRes in $mailbxs){
                    if($tmpRes.PrimarySmtpAddress -match $domain -and $tmpRes.SKUAssigned -eq $true){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$nam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_mxbx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_mxbx_Key -RemoveSource
                }
            }
        }
    }

    #------------- 2.Domain Specific - casmailboxes ----------------------
    if($DS_csmx_fpth -ne ''){   
        $csmxFilePth=$DS_csmx_fpth -replace (".csv",".dat")
        if((Get-Item -Path $csmxFilePth).Length -gt 2KB){
            $null=Unprotect-File $csmxFilePth -Algorithm AES -KeyAsPlainText $DS_csmx_Key
            $csmailbxs= import-csv $DS_csmx_fpth
            $csnam=$DS_csmx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$csnam
                foreach($tmpRes in $csmailbxs){
                    if($tmpRes.PrimarySMTPAddress -match $domain){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$csnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_csmx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_csmx_Key -RemoveSource
                }
            }
        }
    }


    #$DS_rcpm_Key=$RecipntPerm[0];$DS_rcpm_fpth=$RecipntPerm[1];$DS_rcpm_nam=$RecipntPerm[2];
     #------------- 3.Domain Specific - recipient Permissions ----------------------
    if($DS_rcpm_fpth -ne ''){  
        $rpcmTFilePth=$DS_rcpm_fpth -replace (".csv",".dat")
        if((Get-Item -Path $rpcmTFilePth).Length -gt 2KB){
            $null=Unprotect-File $rpcmTFilePth -Algorithm AES -KeyAsPlainText $DS_rcpm_Key
            $rcpts= import-csv $DS_rcpm_fpth
            $rpnam=$DS_rcpm_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$rpnam
                foreach($tmpRes in $rcpts){
                    if($tmpRes.PrimarySMTPAddress -match $domain){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$rpnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_rcpm_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_rcpm_Key -RemoveSource
                }
            }
        }
    }
        
    #------------- 4.Domain Specific - recipients ----------------------
    if($DS_rptmx_fpth -ne ''){  
        $rptmxFilePth=$DS_rptmx_fpth -replace (".csv",".dat")
        if((Get-Item -Path $rptmxFilePth).Length -gt 2KB){
            $null=Unprotect-File $rptmxFilePth -Algorithm AES -KeyAsPlainText $DS_rptmx_Key
            $rcpts= import-csv $DS_rptmx_fpth
            $rpnam=$DS_rptmx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$rpnam
                foreach($tmpRes in $rcpts){
                    if($tmpRes.PrimarySMTPAddress -match $domain){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$rpnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_rptmx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_rptmx_Key -RemoveSource
                }
            }
        }
    }

    #------------- 5.For Domain Specific - statsmailbox ----------------------
    if($DS_stsmx_fpth -ne ''){
        $stsmxFilePth=$DS_stsmx_fpth -replace (".csv",".dat")
        if((Get-Item -Path $stsmxFilePth).Length -gt 2KB){
            $null=Unprotect-File $stsmxFilePth -Algorithm AES -KeyAsPlainText $DS_stsmx_Key
            $dstat= import-csv $DS_stsmx_fpth
            $dsnam=$DS_stsmx_nam.ToString()
            foreach($domain in $alldomainnames){
                $isAddContent=$false
                $domainDir=$egurkhaPath+'/agent/EXO/'+$dhash[$domain]
                if(!(Test-Path -Path $domainDir )){
                    New-Item -ItemType directory -Path $domainDir
                }        
                $rptDpth=$domainDir+'/'+$dsnam
                foreach($tmpRes in $dstat){
                    if($tmpRes.UserPrincipalName -match $domain){
                        $isAddContent=$true
                        $tmpRes| export-csv $rptDpth -Append
                    }
                }
                if($isAddContent){
                    $knam=$dsnam.Replace("csv","dat")
                    $kDpth=$domainDir+'/k'+$knam
                    $DS_stsmx_Key|Add-Content $kDpth
                    $null=Protect-File $rptDpth -Algorithm AES -KeyAsPlainText $DS_stsmx_Key -RemoveSource
                }
            }
        }
    }
}

$csvDir=$egurkhaPath+'/agent/EXO/'+$reportingname+'/'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'mailbox'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'casmailboxes'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'RecipntPerm'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'recipients'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'statsmailbox'
Eg-DeleteCsvFiles -FilePath $csvDir -Pattern 'devicestats'
# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUkGawuv8p/xk8PeSYTaWPz8Xu
# LjuggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUYAKrdiQKEfLTGvWHj7+zfT18
# 9/4wDQYJKoZIhvcNAQEBBQAEggEAOfp/8PpE4qGVxK6KjbsoYej5Pd/XnQs+Bzmh
# S/AWI8KClOUiwpbr39AHkiUsRf1avIldcS/VvozfwyKqITB7MXu8SnqgLCWjxfNZ
# YqEs3lmdccqBT/zhaJCrjIkH4q84u/d6BThSTXo2P80w16+yr+hlzuPN3BteD0dg
# rJfjQC4fZq/bCDvddovo3yjf/sckLEZ4tLxR/vbVqznep2Qy9suuI65KRqZmid6e
# EExCZPdtf3n8IYw3LoSkAG16js7pOBGdjl3+u1avWi3pvXe8KCp78pwx8Xa8Aazt
# A4G+bXRVvGFLHRsHh8omF7LwrKUDwV4M6l5GEAxxRkRBsAX48aGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwMzU2WjAjBgkqhkiG9w0BCQQxFgQUfqHhjLmeBBHteaO6QZVs
# ma6O+DQwDQYJKoZIhvcNAQEBBQAEggEAN5XjQ0bqF57ssb9qNBrLPuXBdLhct9N6
# de0+cWM8LW5z26VVo50QN3EyLRB4JLsePBTSd9OH6mx9sJtm2iarP/58hH5wa0m1
# gYS1vISD8va2ZZdRvG1F4dGtR2T9divMAvxERx8JeevXc0a805Ic1eQdOGCY4daR
# FD48QqbzCUrBWQPQRRGpTZ3T2lsZkgZSPw/Tt7IDzUhwbmbHE4AIXrCaBqxJW0sY
# /0ScSJ+jXjpWvcPWs7Ov/HD864p0fxj8sd8b7SqdmiCsMQrnVpKRWCCSXyiYejgW
# dcjv9lvmr5ZeBmqfswKgB8BypBkY6D1wneR1uF/pq1ukwDCpzLT/UQ==
# SIG # End signature block
