﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
$excldMailbox= ($testargs[0]).trim()
$toHideAdminAct=$testargs[1]
$reportingname='EXO\'+$testargs[2]
try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "owneractvts" -keyFileName "kowneractvts" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat")
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
    $totaactivites= import-csv $csvfile
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'owneractvts' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kowneractvts' -InputFile $readfiles[4]
    Write-Host 'ReadFile:'$readfiles[3]
    }
    catch [System.Management.Automation.RuntimeException] {
        Write-Error -Message "File not found. The $reportingname location does not contain owneractvts files."
    }
    catch{
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

if($totaactivites -ne $null){ 
	$activitys=@{}
    $Operationddlist=New-Object System.Collections.ArrayList

	foreach($entry in $totaactivites)
	{
       $clientipadd=$entry.ClientIPAddress
       if($clientipadd -and $clientipadd.contains('[') -and $clientipadd.Contains(']') )
       {
        $entry.ClientIPAddress=$clientipadd.ToString().Substring($clientipadd.IndexOf("[")+1,$clientipadd.IndexOf("]")-1)
       }
            $usermailbox=$entry.MailboxOwnerUPN
            if($toHideAdminAct -eq $true)
            {
                if($usermailbox -eq $excldMailbox)
                {
                    continue
                }
            }

	    $oper=$entry.Operation
        if(($entry.FolderId).Length -gt 255){ $entry.FolderId= $entry.FolderId.Substring(0,254) }
        if(($entry.SourceFolders).Length -gt 255){ $entry.SourceFolders= $entry.SourceFolders.Substring(0,254) }
        if(($entry.SourceItems).Length -gt 255){ $entry.SourceItems= $entry.SourceItems.Substring(0,254) }
        if(($entry.SourceItemIdsList).Length -gt 255){ $entry.SourceItemIdsList= $entry.SourceItemIdsList.Substring(0,254) }
        if(($entry.SourceItemSubjectsList).Length -gt 255){ $entry.SourceItemSubjectsList= $entry.SourceItemSubjectsList.Substring(0,254) }
        if(($entry.SourceItemAttachmentsList).Length -gt 255){ $entry.SourceItemAttachmentsList= $entry.SourceItemAttachmentsList.Substring(0,254) }
        if(($entry.SourceItemFolderPathNamesList).Length -gt 255){ $entry.SourceItemFolderPathNamesList= $entry.SourceItemFolderPathNamesList.Substring(0,254) }
        if(($entry.SourceFolderPathNamesList).Length -gt 255){ $entry.SourceFolderPathNamesList= $entry.SourceFolderPathNamesList.Substring(0,254) }

        $ddoperation=$oper +'total' +$entry.LastAccessed  +'~!~'+  $entry.OperationResult +'~!~'+  $entry.LogonUserDisplayName   +'~!~'+  $entry.MailboxOwnerUPN  +'~!~'+  $entry.ExternalAccess  +'~!~'+  $entry.DestFolderId  +'~!~'+  $entry.DestFolderPathName  +'~!~'+  $entry.FolderId  +'~!~'+  $entry.FolderPathName  +'~!~'+  $entry.ClientIPAddress  +'~!~'+  $entry.ClientMachineName  +'~!~'+  $entry.ClientProcessName  +'~!~'+  $entry.ClientInfoString  +'~!~'+  $entry.ClientVersion  +'~!~'+  $entry.DestMailboxOwnerUPN  +'~!~'+  $entry.CrossMailboxOperation    +'~!~'+  $entry.SourceItems  +'~!~'+  $entry.SourceFolders  +'~!~'+  $entry.SourceItemIdsList  +'~!~'+  $entry.SourceItemSubjectsList  +'~!~'+  $entry.SourceItemAttachmentsList  +'~!~'+  $entry.SourceItemFolderPathNamesList  +'~!~'+  $entry.SourceFolderPathNamesList  +'~!~'+  $entry.ItemSubject  +'~!~'+  $entry.ItemAttachments  +'~!~'+  $entry.DirtyProperties  +'~!~'+  $entry.OriginatingServer 

        if($Operationddlist.Contains($ddoperation))
        {
            Continue
        }else{
            $Operationddlist.Add($ddoperation)
        }
	     Write-Host $ddoperation

	    $uniqueuser=$entry.LogonUserDisplayName+'('+$entry.MailboxOwnerUPN+')'
	    if($activitys.Contains($oper))
	    {
		    $activitys[$oper]['count']++
		    if($activitys[$oper]['uniqueips'].Contains($entry.ClientIPAddress))
		    {
		    }
		    else
		    {
		        $null=$activitys[$oper]['uniqueips'].Add($entry.ClientIPAddress)
		    }
		    
		    

		    if($activitys[$oper]['uniqueusers'].Contains($uniqueuser))
		    {
		    }
		    else
		    {
		        $null=$activitys[$oper]['uniqueusers'].Add($uniqueuser)
		    }               
	    }
	    else
	    {
		$activitys[$oper]=@{}
		$activitys[$oper]['count']=1
		$activitys[$oper]['uniqueips'] = New-Object System.Collections.ArrayList
		$null=$activitys[$oper]['uniqueips'].Add($entry.ClientIPAddress)
		$activitys[$oper]['uniqueusers'] = New-Object System.Collections.ArrayList
		$null=$activitys[$oper]['uniqueusers'].Add($uniqueuser)
	    }       

	    }
	    
	    foreach($act in $activitys.Keys)
	    {
	    if($act -ne 'none'){
		Write-Host 'opertype##' $act 'count' $activitys[$act]['count']  

		$totalusers=""
		foreach($user in $activitys[$act]['uniqueusers'])
		{
		    $totalusers=$totalusers+', '+$user
		}
		Write-Host $act 'uniqueusercount'  $activitys[$act]['uniqueusers'].Count 'dd#' $totalusers 

		$totalips=""
		foreach($ip in $activitys[$act]['uniqueips'])
		{
		    $totalips=$totalips+', '+$ip
		}
		Write-Host  $act 'unquieipscount'  $activitys[$act]['uniqueips'].Count 'dd#' $totalips

		}
	    }
}
