/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class DOTNETMonitorTest
extends GenericTest {
    private String sConfig = "";
    private String sSiteName = "";
    private String excludedWebsites = "none";
    private String customName = "none";
    private String slow_url_threshold = "";
    private String stalled_url_threshold = "";
    private boolean isSiteAvailable = false;
    public boolean isFirstTimePerTest = true;
    public static boolean firstTimePerAgent = true;
    private static String syncString = new String("gandhi");
    public Settings settingsObj;
    private ArrayList totalSummaryList = new ArrayList();
    private static int testinstances = 0;
    private Measures measureObj = null;
    private Hashtable prevThresholdHash = new Hashtable();
    private boolean isAgentless = false;
    private String profilerType = "";
    private String tenantId = "";
    private String clientId = "";
    private String clientPwd = "";

    public DOTNETMonitorTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        this.setMeasureCount(this.measureCount);
        this.isAgentless = this.meAgentless;
        ++testinstances;
        String string = this.getValueForParam("tenant_id");
        this.tenantId = string == null || string.trim().length() == 0 || string.trim().equalsIgnoreCase("none") || string.trim().equalsIgnoreCase("null") ? "" : string.trim();
        string = this.getValueForParam("client_id");
        this.clientId = string == null || string.trim().length() == 0 || string.trim().equalsIgnoreCase("none") || string.trim().equalsIgnoreCase("null") ? "" : string.trim();
        string = this.getValueForParam("client_password");
        this.clientPwd = string == null || string.trim().length() == 0 || string.trim().equalsIgnoreCase("none") || string.trim().equalsIgnoreCase("null") ? ((string = this.getValueForParam("client_pwd")) == null || string.trim().length() == 0 || string.trim().equalsIgnoreCase("none") || string.trim().equalsIgnoreCase("null") ? "" : EgCrypt.decrypt((String)string.trim())) : string.trim();
        if (this.tenantId != null && this.tenantId.trim().length() > 0 && this.clientId != null && this.clientId.trim().length() > 0 && this.clientPwd != null && this.clientPwd.trim().length() > 0) {
            this.profilerType = "AZURE_BTM";
            this.needAgentlessDD = true;
        } else {
            this.profilerType = "BTM";
            this.needAgentlessDD = false;
        }
        this.settingsObj = new Settings();
        String string2 = this.getValueForParam("Healthy_URL_Trace");
        String string3 = this.getValueForParam("URL_Segments");
        String string4 = this.getValueForParam("Max_Healthy_URLs_Per_Test_Period");
        String string5 = this.getValueForParam("Max_Slow_URLs_Per_Test_Period");
        String string6 = this.getValueForParam("Max_Stalled_URLs_Per_Test_Period");
        String string7 = this.getValueForParam("Max_Error_URLs_Per_Test_Period");
        this.slow_url_threshold = this.getValueForParam("Slow_URL_Threshold");
        this.stalled_url_threshold = this.getValueForParam("Stalled_URL_Threshold");
        String string8 = this.getValueForParam("Filtered_URL_Patterns");
        String string9 = this.getValueForParam("Method_Exec_CutOff");
        String string10 = this.getValueForParam("SQL_Exec_CutOff");
        String string11 = this.getValueForParam("Max_Grouped_Urls_Per_Measure_Period");
        String string12 = this.getValueForParam("Max_Sql_Queries_Per_Transaction");
        String string13 = this.getValueForParam("Show_cookies");
        String string14 = this.getValueForParam("Show_headers");
        String string15 = this.getValueForParam("website_name");
        if (string15 != null && !string15.trim().equalsIgnoreCase("none") && !string15.trim().equalsIgnoreCase("null") && string15.trim().length() > 0) {
            this.sSiteName = string15;
        }
        this.excludedWebsites = "none";
        String string16 = this.getValueForParam("exclude_websites");
        if (string16 != null && !string16.trim().equalsIgnoreCase("none") && !string16.trim().equalsIgnoreCase("null") && string16.trim().length() > 0) {
            this.excludedWebsites = string16.trim();
        }
        this.customName = "none";
        String string17 = this.getValueForParam("custom_name_for_application");
        if (string17 != null && string17.trim().length() > 0 && !string17.trim().equalsIgnoreCase("none") && !string17.trim().equalsIgnoreCase("null")) {
            this.customName = DOTNETMonitorTest.getValidName(string17.trim());
        }
        this.settingsObj.setCustomName(this.customName);
        String string18 = this.getValueForParam("Mask_SQL");
        boolean bl = false;
        if (string18 != null && (string18 = string18.trim()).length() > 0 && (string18.equalsIgnoreCase("yes") || string18.equalsIgnoreCase("true") || string18.equalsIgnoreCase("y"))) {
            bl = true;
        }
        this.settingsObj.setSqlMask(bl);
        String string19 = this.getValueForParam("Mask_Public_IP");
        boolean bl2 = false;
        if (string19 != null && (string19 = string19.trim()).length() > 0 && (string19.equalsIgnoreCase("yes") || string19.equalsIgnoreCase("true") || string19.equalsIgnoreCase("y"))) {
            bl2 = true;
        }
        this.settingsObj.setPublicIpMask(bl2);
        String string20 = this.getValueForParam("Mask_Private_IP");
        boolean bl3 = false;
        if (string20 != null && (string20 = string20.trim()).length() > 0 && (string20.equalsIgnoreCase("yes") || string20.equalsIgnoreCase("true") || string20.equalsIgnoreCase("y"))) {
            bl3 = true;
        }
        this.settingsObj.setPrivateIpMask(bl3);
        String string21 = this.getValueForParam("Mask_URL_Params");
        boolean bl4 = false;
        if (string21 != null && (string21 = string21.trim()).length() > 0 && (string21.equalsIgnoreCase("yes") || string21.equalsIgnoreCase("true") || string21.equalsIgnoreCase("y"))) {
            bl4 = true;
        }
        this.settingsObj.setUrlMask(bl4);
        try {
            if (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true")) {
                this.settingsObj.setHealthyUrlTrace(1);
            } else {
                this.settingsObj.setHealthyUrlTrace(0);
            }
            int n = DTMHelperBase.getIntegerValue((String)string3);
            if (n < 0) {
                n = 3;
            }
            this.settingsObj.setUrlSegments(n);
            n = DTMHelperBase.getIntegerValue((String)string4);
            if (n < 0) {
                n = 10;
            }
            this.settingsObj.setMaxHealthyUrlPerTestPeriod(n);
            n = DTMHelperBase.getIntegerValue((String)string5);
            if (n < 0) {
                n = 10;
            }
            this.settingsObj.setMaxSlowUrlPerTestPeriod(n);
            n = DTMHelperBase.getIntegerValue((String)string7);
            if (n < 0) {
                n = 10;
            }
            this.settingsObj.setMaxErrorUrlPerTestPeriod(n);
            n = DTMHelperBase.getIntegerValue((String)string6);
            if (n < 0) {
                n = 10;
            }
            this.settingsObj.setMaxSatalledUrlPerTestPeriod(n);
            n = DTMHelperBase.getIntegerValue((String)this.slow_url_threshold);
            if (n < 0) {
                n = 4000;
            }
            this.settingsObj.setSlowUrlThreshold(n);
            n = DTMHelperBase.getIntegerValue((String)this.stalled_url_threshold);
            if (n < 0) {
                n = 60000;
            }
            this.settingsObj.setStalledUrlThreshold(n);
            if (string8 == null) {
                string8 = "";
            }
            this.settingsObj.setFilteredUrlPatterns(string8);
            n = DTMHelperBase.getIntegerValue((String)string9);
            if (n < 0) {
                n = 250;
            }
            this.settingsObj.setMethodExecCutOff(n);
            n = DTMHelperBase.getIntegerValue((String)string10);
            if (n < 0) {
                n = 10;
            }
            this.settingsObj.setSqlExecCutOff(n);
            n = DTMHelperBase.getIntegerValue((String)string11);
            if (n < 0) {
                n = 50;
            }
            this.settingsObj.setMaxGroupedUrlPerMeasure(n);
            n = DTMHelperBase.getIntegerValue((String)string12);
            if (n < 0) {
                n = 100;
            }
            this.settingsObj.setMaxSqlQueryPerTransaction(n);
            string13 = string13 != null && string13.trim().length() > 0 && (string13.trim().equalsIgnoreCase("yes") || string13.trim().equalsIgnoreCase("true")) ? "true" : "false";
            this.settingsObj.setShowCookies(string13);
            string14 = string14 != null && string14.trim().length() > 0 && (string14.trim().equalsIgnoreCase("yes") || string14.trim().equalsIgnoreCase("true")) ? "true" : "false";
            this.settingsObj.setShowHeader(string14);
            this.sConfig = this.settingsObj.getUrlSegments() + "@" + this.settingsObj.getMaxHealthyUrlsPerTestPeriod() + "@" + this.settingsObj.getMaxSlowUrlsPerTestPeriod() + "@" + this.settingsObj.getMaxErrorUrlsPerTestPeriod() + "@" + this.settingsObj.getSlowUrlThreshold() + "@" + this.settingsObj.getStalledUrlThreshold() + "@" + this.settingsObj.getFilteredUrlPatterns() + "@" + this.settingsObj.getHealthyUrlTrace() + "@" + this.settingsObj.getMaxSatalledUrlPerTestPeriod() + "@" + this.settingsObj.getMethodExecCutOff() + "@" + this.settingsObj.getSqlExecCutOff() + "@" + this.settingsObj.getMaxSqlQueryPerTransaction() + "@" + this.settingsObj.getShowCookies() + "@" + this.settingsObj.getShowHeader() + "@" + this.customName;
        }
        catch (NumberFormatException numberFormatException) {
            String string22 = EgInstallInfo.getStackTraceAsString((Exception)numberFormatException);
            this.logToErrorFile("Error", this.entity, string22);
            this.logToErrorFile("INFO", this.entity, "Setting default value for it !");
        }
        catch (Exception exception) {
            String string23 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity + " : constructor()", string23);
        }
    }

    public void freeTest() {
        try {
            if (DTMProfilerHelper.debugFlag >= 2) {
                System.out.println("DOTNETMonitorTest: freeTest method getting called for siteName: " + this.sSiteName);
            }
            if (!this.isFirstTimePerTest) {
                if (this.measureObj != null) {
                    System.out.println("DOTNETMonitorTest: clearAll() is called from test class for " + this.sSiteName);
                    this.measureObj.clearAll();
                }
                this.measureObj = null;
            }
            this.totalSummaryList = new ArrayList();
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity + " : freeTest()", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTest() {
        block11: {
            try {
                Object object;
                if (this.profilerType.equalsIgnoreCase("AZURE_BTM")) {
                    object = this.tenantId + "#@#" + this.clientId;
                    DTMAzureHelper.getInstance().removeData(this.reportingName, this.entity, (String)object);
                }
                this.prevThresholdHash = new Hashtable();
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("DOTNETMonitorTest: stopTest called siteName: " + this.sSiteName);
                }
                if ((object = DOTNETMonitorTest.myTokenizer(this.sSiteName, ",")) != null && ((ArrayList)object).size() > 0) {
                    int n = ((ArrayList)object).size();
                    for (int i = 0; i < n; ++i) {
                        String string = (String)((ArrayList)object).get(i);
                        if (string == null || string.trim().length() == 0) continue;
                        string = string.trim();
                        ServerSocketCreator.getInstance().removeSettings(string, this.profilerType);
                        Repository.getInstance().initializeEntry(string, this.profilerType);
                    }
                }
                this.measureObj = null;
                --testinstances;
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("DOTNETMonitorTest: stop test called no of test instances remaining: " + testinstances);
                }
                if (testinstances != 0) break block11;
                DTMProfilerHelper.getInstance();
                if (DTMProfilerHelper.isClrConfigEnabled()) break block11;
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("DOTNETMonitorTest: server socket closing: " + testinstances);
                }
                String string = syncString;
                synchronized (string) {
                    ServerSocketCreator.getInstance().closeServerSocket(false);
                    ServerSocketCreator.removeInstance();
                    DTMProfilerHelper.removeInstance();
                    DTMAzureHelper.removeInstance();
                    firstTimePerAgent = true;
                    DTMProfilerHelper.profilerFirstTimePerAgent = true;
                    DTMProfilerHelper.isDotNetBTMEnabled = false;
                }
            }
            catch (Exception exception) {
                String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
                this.logToErrorFile("Error", this.entity, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            String string;
            if (DTMProfilerHelper.profilerFirstTimePerAgent) {
                string = syncString;
                synchronized (string) {
                    if (DTMProfilerHelper.profilerFirstTimePerAgent) {
                        System.out.println("[" + this.entity + "] starting server socket");
                        boolean bl = ServerSocketCreator.getInstance().createServerSocket();
                        System.out.println("[" + this.entity + "]isSuccess =" + bl);
                        if (bl) {
                            DTMProfilerHelper.profilerFirstTimePerAgent = false;
                        }
                    }
                }
            }
            if (DTMProfilerHelper.debugFlag == 1) {
                System.out.println("DOTNETMonitorTest: isFirstTimePerTest = " + this.isFirstTimePerTest);
            }
            if (this.isFirstTimePerTest) {
                System.out.println("[" + this.entity + "] profilerType -" + this.profilerType);
                string = syncString;
                synchronized (string) {
                    DTMProfilerHelper.isDotNetBTMEnabled = true;
                }
                if (this.profilerType.equalsIgnoreCase("AZURE_BTM")) {
                    String string2;
                    string = this.tenantId + "#@#" + this.clientId;
                    DTMAzureHelper.getInstance().addToSetting(this.reportingName, this.entity, string);
                    this.isSiteAvailable = DOTNETMonitorTest.getAzureSiteAvailability(this.tenantId, this.clientId, this.clientPwd, this.sSiteName);
                    if (this.isSiteAvailable && (string2 = DTMAzureHelper.getInstance().getActualWebAppName(this.tenantId, this.clientId, this.sSiteName)) != null && string2.trim().length() > 0) {
                        this.sSiteName = string2.trim();
                    }
                } else {
                    this.isSiteAvailable = this.getSiteAvailabilityUsingAppCmd(this.sSiteName, this.excludedWebsites);
                }
                if (!this.isSiteAvailable) {
                    System.out.println("[" + this.entity + "] Could not find the " + this.targetHost + ":" + this.portNo + " in the IIS server for SiteName - " + this.sSiteName);
                    return;
                }
                if (this.settingsObj != null) {
                    ServerSocketCreator.getInstance().setSettingsInformation(this.sSiteName, this.settingsObj, this.profilerType);
                }
                string = "-&eGAdd&-" + this.sSiteName + "@" + this.sConfig + "@END_BLOCK@";
                System.out.println("Broadcasting from test class: " + string);
                ServerSocketCreator.getInstance().broadcast(string, this.profilerType);
                this.isFirstTimePerTest = false;
                return;
            }
            if (DTMProfilerHelper.debugFlag >= 2) {
                System.out.println("DOTNETMonitorTest: Timed at: " + this.getTime() + ".... compute measurement called for testinstance monitoring site name: " + this.sSiteName);
            }
            this.checkThreshold();
            int n = this.settingsObj.getMaxGroupedUrlPerMeasure();
            if (DTMProfilerHelper.debugFlag >= 2) {
                System.out.println("DOTNETMonitorTest: maxGroupedUrl = " + n);
            }
            ArrayList arrayList = DOTNETMonitorTest.myTokenizer(this.sSiteName, ",");
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Hashtable hashtable2;
                String string3 = (String)arrayList.get(i);
                if (string3 == null || string3.trim().length() == 0) continue;
                Measures measures = Repository.getInstance().getValue(string3, 0, this.profilerType);
                if (measures == null) {
                    if (DTMProfilerHelper.debugFlag < 2) continue;
                    System.out.println("DOTNETMonitorTest: No data found....");
                    continue;
                }
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("DOTNETMonitorTest: ready to collect data.........");
                }
                if ((hashtable2 = measures.getMeasurements()) == null || hashtable2.size() == 0) {
                    System.out.println("DOTNETMonitorTest: No data found ");
                    continue;
                }
                if (hashtable2.size() > n) {
                    hashtable2 = this.sortGroupedUrl(hashtable2, n);
                }
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("DOTNETMonitorTest:The size of urlDetails: " + hashtable2.size());
                }
                for (String string4 : hashtable2.keySet()) {
                    RequestsMeasures requestsMeasures;
                    if (DTMProfilerHelper.debugFlag >= 2) {
                        System.out.println("DOTNETMonitorTest: urls :" + string4);
                        System.out.println("'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''");
                    }
                    if (string4 == null || (requestsMeasures = (RequestsMeasures)hashtable2.get(string4)) == null) continue;
                    this.calculateMeasures(string3 + ":" + string4, requestsMeasures);
                }
            }
            if (this.totalSummaryList == null || this.totalSummaryList.size() == 0) {
                this.sentEmptySummary();
            } else {
                this.calculateTotalSummary();
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity, string);
        }
    }

    private void calculateTotalSummary() {
        try {
            double d;
            int n;
            ArrayList arrayList = new ArrayList();
            int n2 = this.totalSummaryList.size();
            for (n = 0; n < n2; ++n) {
                ArrayList arrayList2 = (ArrayList)this.totalSummaryList.get(n);
                if (arrayList2 == null || arrayList2.size() == 0) continue;
                if (arrayList.size() == 0) {
                    arrayList = (ArrayList)arrayList2.clone();
                    continue;
                }
                for (int i = 0; i < this.measureCount; ++i) {
                    d = DTMHelperBase.getDoubleValue((Double)((Double)arrayList.get(i)));
                    double d2 = DTMHelperBase.getDoubleValue((Double)((Double)arrayList2.get(i)));
                    double d3 = 0.0;
                    if (d < 0.0) {
                        d3 = d2;
                    }
                    if (d2 < 0.0) continue;
                    d3 = d + d2;
                    arrayList.set(i, new Double(d3));
                }
            }
            for (n = 19; n < 22; ++n) {
                double d4 = DTMHelperBase.getDoubleValue((Double)((Double)arrayList.get(n)));
                d = -5.0;
                if (n2 > 0 && d4 > 0.0) {
                    d = d4 / (double)n2;
                }
                arrayList.set(n, new Double(d));
            }
            double d5 = DTMHelperBase.getDoubleValue((Double)((Double)arrayList.get(0)));
            double d6 = DTMHelperBase.getDoubleValue((Double)((Double)arrayList.get(4)));
            double d7 = DTMHelperBase.getDoubleValue((Double)((Double)arrayList.get(10)));
            double d8 = DTMHelperBase.getDoubleValue((Double)((Double)arrayList.get(14)));
            double d9 = -5.0;
            double d10 = -5.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = this.timeSinceLastTest / 60.0;
            if (d5 > 0.0 && d13 > 0.0) {
                String string = this.round(d5 / d13, 0);
                String string2 = this.round(d6 / d13, 0);
                String string3 = this.round(d7 / d13, 0);
                String string4 = this.round(d8 / d13, 0);
                d9 = DTMProfilerHelper.getDoubleValueOfString((String)string);
                d10 = DTMProfilerHelper.getDoubleValueOfString((String)string2);
                d11 = DTMProfilerHelper.getDoubleValueOfString((String)string3);
                d12 = DTMProfilerHelper.getDoubleValueOfString((String)string4);
            }
            arrayList.set(26, new Double(d9));
            arrayList.set(28, new Double(d10));
            arrayList.set(29, new Double(d11));
            arrayList.set(30, new Double(d12));
            this.addNewMeasure("Summary", arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void calculateMeasures(String string, RequestsMeasures requestsMeasures) {
        try {
            Object object;
            double d = requestsMeasures.getTotalRequestCount();
            double d2 = requestsMeasures.getTotalRequestTime();
            double d3 = this.getAvgValue(d, d2);
            double d4 = requestsMeasures.getSlowRequestCount();
            double d5 = requestsMeasures.getSlowRequestTime();
            double d6 = this.getAvgValue(d4, d5);
            double d7 = requestsMeasures.getErrorRequestCount();
            double d8 = requestsMeasures.getErrorRequestTime();
            double d9 = this.getAvgValue(d7, d8);
            double d10 = requestsMeasures.getStalledRequestCount();
            double d11 = requestsMeasures.getStalledRequestTime();
            double d12 = this.getAvgValue(d10, d11);
            double d13 = requestsMeasures.getTotalSQLcount();
            double d14 = requestsMeasures.getsqlStatementTime();
            double d15 = this.getAvgValue(d13, d14);
            double d16 = requestsMeasures.getEntryPointTotalRequestCount();
            double d17 = requestsMeasures.getEntryPointTotalRequestTime();
            double d18 = this.getAvgValue(d16, d17);
            double d19 = requestsMeasures.getEntryPointHealthyRequestCount();
            double d20 = requestsMeasures.getEntryPointSlowRequestCount();
            double d21 = requestsMeasures.getEntryPointSlowRequestTime();
            double d22 = this.getAvgValue(d20, d21);
            double d23 = requestsMeasures.getEntryPointErrorRequestCount();
            double d24 = requestsMeasures.getEntryPointErrorRequestTime();
            double d25 = this.getAvgValue(d23, d24);
            double d26 = requestsMeasures.getEntryPointStalledRequestCount();
            double d27 = requestsMeasures.getEntryPointStalledRequestTime();
            double d28 = this.getAvgValue(d26, d27);
            double d29 = requestsMeasures.getHealthyRequestCount();
            double d30 = d29 / d * 100.0;
            double d31 = d4 / d * 100.0;
            double d32 = d7 / d * 100.0;
            double d33 = d10 / d * 100.0;
            double d34 = -5.0;
            double d35 = -5.0;
            double d36 = 0.0;
            double d37 = 0.0;
            double d38 = this.timeSinceLastTest / 60.0;
            if (d > 0.0 && d38 > 0.0) {
                object = this.round(d / d38, 0);
                String string2 = this.round(d7 / d38, 0);
                String string3 = this.round(d16 / d38, 0);
                String string4 = this.round(d23 / d38, 0);
                d34 = DTMProfilerHelper.getDoubleValueOfString((String)object);
                d35 = DTMProfilerHelper.getDoubleValueOfString((String)string2);
                d36 = DTMProfilerHelper.getDoubleValueOfString((String)string3);
                d37 = DTMProfilerHelper.getDoubleValueOfString((String)string4);
            }
            object = new ArrayList<Double>();
            ((ArrayList)object).add(new Double(d));
            ((ArrayList)object).add(new Double(d3));
            ((ArrayList)object).add(new Double(d4));
            ((ArrayList)object).add(new Double(d6));
            ((ArrayList)object).add(new Double(d7));
            ((ArrayList)object).add(new Double(d9));
            ((ArrayList)object).add(new Double(d10));
            ((ArrayList)object).add(new Double(d12));
            ((ArrayList)object).add(new Double(d13));
            ((ArrayList)object).add(new Double(d15));
            ((ArrayList)object).add(new Double(d16));
            ((ArrayList)object).add(new Double(d18));
            ((ArrayList)object).add(new Double(d20));
            ((ArrayList)object).add(new Double(d22));
            ((ArrayList)object).add(new Double(d23));
            ((ArrayList)object).add(new Double(d25));
            ((ArrayList)object).add(new Double(d26));
            ((ArrayList)object).add(new Double(d28));
            ((ArrayList)object).add(new Double(d29));
            ((ArrayList)object).add(new Double(d30));
            ((ArrayList)object).add(new Double(d31));
            ((ArrayList)object).add(new Double(d32));
            ((ArrayList)object).add(new Double(d33));
            if (this.measureCount > 23) {
                ((ArrayList)object).add(new Double(-5.0));
                ((ArrayList)object).add(new Double(-5.0));
                ((ArrayList)object).add(new Double(-5.0));
                ((ArrayList)object).add(new Double(d34));
                ((ArrayList)object).add(new Double(d35));
                if (this.measureCount > 28) {
                    ((ArrayList)object).add(new Double(d19));
                    ((ArrayList)object).add(new Double(d36));
                    ((ArrayList)object).add(new Double(d37));
                }
            }
            if (string.endsWith(":Summary")) {
                this.totalSummaryList.add(object);
            }
            if (DTMProfilerHelper.debugFlag >= 1) {
                System.out.println("DOTNETMonitorTest: descriptor - " + string + " ; measureList - " + object);
            }
            this.addNewMeasure(string, (ArrayList)object);
        }
        catch (Exception exception) {
            String string5 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity, string5);
        }
    }

    private void sentEmptySummary() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.measureCount; ++i) {
            if (i >= 23 && i <= 25) {
                arrayList.add(new Double(-5.0));
                continue;
            }
            arrayList.add(new Double(0.0));
        }
        if (DTMProfilerHelper.debugFlag >= 1) {
            System.out.println("DOTNETMonitorTest: Summary ; summaryMeasureList - " + arrayList);
        }
        this.addNewMeasure("Summary", arrayList);
    }

    public Hashtable sortGroupedUrl(Hashtable hashtable, int n) {
        int n2;
        double d;
        Hashtable<String, RequestsMeasures> hashtable2 = new Hashtable<String, RequestsMeasures>();
        Hashtable hashtable3 = (Hashtable)hashtable.clone();
        if (hashtable3 == null) {
            hashtable3 = new Hashtable();
        }
        int n3 = hashtable3.size();
        String[] stringArray = new String[n3];
        double[] dArray = new double[n3];
        Enumeration enumeration = hashtable3.keys();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RequestsMeasures requestsMeasures = (RequestsMeasures)hashtable3.get(string);
            if (requestsMeasures == null) continue;
            d = requestsMeasures.getTotalRequestCount();
            double d2 = requestsMeasures.getTotalRequestTime();
            double d3 = this.getAvgValue(d, d2);
            stringArray[n4] = string;
            dArray[n4] = d3;
            ++n4;
        }
        int n5 = stringArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            d = dArray[n2];
            for (int i = 0; i < n2; ++i) {
                double d4 = dArray[i];
                if (!(d4 < d)) continue;
                double d5 = dArray[n2];
                dArray[n2] = dArray[i];
                dArray[i] = d5;
                String string = stringArray[n2];
                stringArray[n2] = stringArray[i];
                stringArray[i] = string;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            RequestsMeasures requestsMeasures = (RequestsMeasures)hashtable3.get(stringArray[n2]);
            hashtable2.put(stringArray[n2], requestsMeasures);
        }
        return hashtable2;
    }

    private void checkThreshold() {
        Hashtable hashtable = new Hashtable();
        String string = this.slow_url_threshold + "*&*" + this.stalled_url_threshold;
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            String string2;
            int n = Integer.parseInt(this.slow_url_threshold);
            int n2 = Integer.parseInt(this.stalled_url_threshold);
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            Enumeration enumeration = this.results.keys();
            String string3 = "";
            while (enumeration.hasMoreElements()) {
                Object object6;
                int n3;
                int n4;
                boolean bl = true;
                string2 = (String)enumeration.nextElement();
                object5 = (EgResultSet)this.results.get(string2);
                object4 = ((EgResultSet)object5).thresholds;
                if (object4 == null || ((Threshold[])object4).length <= 0) continue;
                object3 = object4[1];
                object2 = object3.getUpperBound();
                int n5 = n2;
                int n6 = n;
                if (object2 == null) continue;
                if (((double[])object2).length == 1 && object2[0] < 0.0) {
                    System.out.println("[DOTNETMonitorTest] key = " + string2 + ",Bound = " + object2[0]);
                    n5 = -1;
                    n6 = -1;
                } else if (((double[])object2).length >= 2) {
                    object = new boolean[((double[])object2).length];
                    int n7 = 0;
                    for (n4 = 0; n4 < ((double[])object2).length; ++n4) {
                        if (!(object2[n4] >= 0.0)) continue;
                        object[n4] = true;
                        ++n7;
                    }
                    if (n7 == 1) {
                        for (n4 = 0; n4 < ((boolean[])object).length; ++n4) {
                            if (!object[n4]) continue;
                            n6 = new Double((double)object2[n4]).intValue();
                            n5 = -1;
                            break;
                        }
                    } else if (n7 == 2) {
                        n4 = 0;
                        for (n3 = 0; n3 < ((boolean[])object).length; ++n3) {
                            if (!object[n3]) continue;
                            if (n4 == 0) {
                                n5 = new Double((double)object2[n3]).intValue();
                                n4 = 1;
                                continue;
                            }
                            n6 = new Double((double)object2[n3]).intValue();
                            break;
                        }
                    } else if (n7 == 3) {
                        n5 = new Double(object2[0]).intValue();
                        n6 = new Double((double)object2[2]).intValue();
                    }
                    System.out.println("[DotNetMonitorTest] stalledThreshold-->" + n5);
                    System.out.println("[DotNetMonitorTest] slowThreshold-->" + n6);
                } else {
                    System.out.println("[DOTNETMonitorTest] key = " + string2 + " Threshold value is zero");
                }
                if (n6 != n || n5 != n2) {
                    bl = false;
                }
                object = n6 + "*&*" + n5;
                System.out.println("[DOTNETMonitorTest] upperBoundString = " + (String)object + " for key = " + string2);
                String string4 = string2;
                n4 = string2.indexOf(siteAndInfoSeparator);
                if (n4 > 0) {
                    string4 = string2.substring(n4 + 1);
                }
                if (string4.startsWith("++") || string4.startsWith("+*")) continue;
                if (string4.startsWith("+")) {
                    string4 = string4.substring(1);
                }
                if (string4.equalsIgnoreCase("Summary") || (n3 = string4.indexOf(":")) < 0) continue;
                String string5 = string4.substring(0, n3);
                String string6 = string4.substring(n3 + 1);
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("[DOTNETMonitorTest] websiteStr = " + string5);
                    System.out.println("[DOTNETMonitorTest] infoKey = " + string4);
                    System.out.println("[DOTNETMonitorTest] isDefaultThreshold = " + bl);
                    System.out.println("[DOTNETMonitorTest] prevThresholdHash.containsKey(infoKey) = " + this.prevThresholdHash.containsKey(string4));
                }
                if (bl && this.prevThresholdHash.containsKey(string4)) {
                    object6 = (String)hashtable2.get(string5);
                    if (object6 == null) {
                        object6 = "";
                    }
                    object6 = (String)object6 + string4 + "-#-";
                    hashtable2.put(string5, object6);
                    this.prevThresholdHash.remove(string4);
                    continue;
                }
                if (bl) continue;
                object6 = (Hashtable)hashtable3.get(string5);
                if (object6 == null) {
                    object6 = new Hashtable<String, boolean[]>();
                }
                ((Hashtable)object6).put(string6, object);
                hashtable3.put(string5, object6);
            }
            if (hashtable2 != null || hashtable2.size() > 0) {
                Enumeration enumeration2 = hashtable2.keys();
                while (enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    if (string2 == null || (object5 = (String)hashtable2.get(string2)) == null) continue;
                    object4 = "-&eGDelThres&-" + string2 + "-#-" + (String)object5;
                    ServerSocketCreator.getInstance().removeDescriptorThreshold(string2, (String)object5, this.profilerType);
                    ServerSocketCreator.getInstance().broadcast((String)object4, this.profilerType);
                }
            }
            if (hashtable3 == null || hashtable3.size() == 0) {
                if (DTMProfilerHelper.debugFlag >= 2) {
                    System.out.println("[DOTNETMonitorTest] currentThresholdDesc is NULL or Size is Zero. So return!.");
                }
                return;
            }
            if (DTMProfilerHelper.debugFlag >= 2) {
                System.out.println("[DOTNETMonitorTest] currentThresholdDesc - " + hashtable3);
            }
            if (this.prevThresholdHash == null || this.prevThresholdHash.size() == 0) {
                hashtable = (Hashtable)hashtable3.clone();
            } else {
                Enumeration enumeration3 = hashtable3.keys();
                while (enumeration3.hasMoreElements()) {
                    string2 = (String)enumeration3.nextElement();
                    if (string2 == null || (object5 = (Hashtable)hashtable3.get(string2)) == null || ((Hashtable)object5).size() == 0) continue;
                    object4 = (Hashtable)this.prevThresholdHash.get(string2);
                    if (object4 == null || ((Hashtable)object4).size() == 0) {
                        hashtable.put(string2, object5);
                        continue;
                    }
                    object3 = ((Hashtable)object5).keys();
                    while (object3.hasMoreElements()) {
                        String string7;
                        String string8;
                        object2 = (String)object3.nextElement();
                        if (object2 == null || ((String)object2).length() == 0 || (string8 = (String)((Hashtable)object5).get(object2)) == null || (string7 = (String)((Hashtable)object4).get(object2)) != null && string7.trim().length() != 0 && string8.equalsIgnoreCase(string7)) continue;
                        object = (Hashtable)hashtable.get(string2);
                        if (object == null) {
                            object = new Hashtable();
                        }
                        object.put(object2, string8);
                        hashtable.put(string2, object);
                    }
                }
            }
            this.prevThresholdHash = (Hashtable)hashtable3.clone();
            if (DTMProfilerHelper.debugFlag >= 2) {
                System.out.println("[DOTNETMonitorTest] after : prevThresholdHash - " + this.prevThresholdHash);
                System.out.println("[DOTNETMonitorTest] after : modifiedThreshold - " + hashtable);
            }
            if (hashtable == null || hashtable.size() == 0) {
                return;
            }
            Enumeration enumeration4 = hashtable.keys();
            while (enumeration4.hasMoreElements()) {
                string2 = (String)enumeration4.nextElement();
                if (string2 == null || (object5 = (Hashtable)hashtable.get(string2)) == null || ((Hashtable)object5).size() == 0) continue;
                object4 = "";
                object3 = ((Hashtable)object5).keys();
                while (object3.hasMoreElements()) {
                    int n8;
                    String string9;
                    object2 = (String)object3.nextElement();
                    if (object2 == null || (string9 = (String)((Hashtable)object5).get(object2)) == null || string9.trim().length() == 0 || (n8 = string9.indexOf("*&*")) <= -1) continue;
                    object4 = (String)object4 + (String)object2 + "*&*" + string9 + "-&-";
                }
                object2 = "-&eGAddThres&--#-" + string2 + "-#-" + (String)object4 + "-#--&eGEND&-";
                ServerSocketCreator.getInstance().setDescriptorThreshold(string2, (Hashtable)object5, this.profilerType);
                ServerSocketCreator.getInstance().broadcast((String)object2, this.profilerType);
                System.out.println("modifiedSettings = " + (String)object2);
            }
        }
        catch (Exception exception) {
            String string10 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity, "Exception occured in checkThreshold() " + string10);
        }
    }

    public String getThreshold(String string, String string2) {
        String string3 = "";
        if (string2.equalsIgnoreCase("SlowThreshold")) {
            if (this.prevThresholdHash == null || !this.prevThresholdHash.containsKey(string)) {
                string3 = this.slow_url_threshold;
            } else {
                String string4 = (String)this.prevThresholdHash.get(string);
                string3 = string4.substring(0, string4.indexOf("*&*"));
            }
        } else if (string2.equalsIgnoreCase("StalledThreshold")) {
            if (this.prevThresholdHash == null || !this.prevThresholdHash.containsKey(string)) {
                string3 = this.stalled_url_threshold;
            } else {
                String string5 = (String)this.prevThresholdHash.get(string);
                string3 = string5.substring(string5.indexOf("*&*") + 3);
            }
        }
        return string3;
    }

    public static synchronized boolean getAzureSiteAvailability(String string, String string2, String string3, String string4) {
        boolean bl = false;
        try {
            bl = DTMAzureHelper.getInstance().isSiteAvailable(string, string2, string3, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private boolean getSiteAvailabilityUsingAppCmd(String string, String string2) {
        boolean bl = false;
        try {
            IISHelper iISHelper;
            ArrayList arrayList;
            ArrayList arrayList2 = DOTNETMonitorTest.myTokenizer(string.toLowerCase(), ",");
            ArrayList arrayList3 = new ArrayList();
            if (!string2.equalsIgnoreCase("none")) {
                arrayList3 = DOTNETMonitorTest.myTokenizer(string2.toLowerCase(), ",");
            }
            ArrayList<String> arrayList4 = new ArrayList<String>();
            boolean bl2 = false;
            if (string.equalsIgnoreCase("all")) {
                bl2 = true;
            }
            if ((arrayList = (iISHelper = new IISHelper(this.reportingName)).executeAppCmd("list sites")) == null || arrayList.size() < 2) {
                System.out.println("[" + this.entity + "] Couldn't able to run the AppCmd for " + this.reportingName);
                return bl;
            }
            ArrayList arrayList5 = (ArrayList)arrayList.get(0);
            ArrayList arrayList6 = (ArrayList)arrayList.get(1);
            if (arrayList6 != null && arrayList6.size() > 0) {
                this.logToErrorFile("Error", this.entity, "Error occured  while running the AppCmd.exe " + arrayList6);
            }
            String string3 = "";
            int n = arrayList5.size();
            for (int i = 0; i < n; ++i) {
                String string4;
                int n2;
                String string5 = (String)arrayList5.get(i);
                if (string5 == null || (string5 = string5.trim()).length() == 0 || !string5.toLowerCase().startsWith("site") || (n2 = string5.indexOf("\"")) == -1 || (n2 = (string4 = string5.substring(n2 + 1)).indexOf("\"")) == -1 || (string4 = string4.substring(0, n2)) == null || string4.trim().length() == 0 || arrayList3.indexOf((string4 = string4.trim()).toLowerCase()) > -1 || !bl2 && arrayList2.indexOf(string4.toLowerCase()) == -1) continue;
                string3 = string3 + string4 + ",";
                bl = true;
                arrayList4.add(string4);
            }
            if (string3.endsWith(",")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (!bl) {
                System.out.println("[" + this.entity + "] Couldn't able find the website list for " + this.reportingName + ", using the appcmd.exe");
            } else {
                this.sSiteName = string3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public String getSiteId() {
        return this.sSiteName;
    }

    public Measures getMeasures() {
        return this.measureObj;
    }

    public String getProfilerType() {
        return this.profilerType;
    }

    private String getTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = Integer.toString(gregorianCalendar.get(13));
        String string2 = Integer.toString(gregorianCalendar.get(12));
        String string3 = Integer.toString(gregorianCalendar.get(10));
        return string3 + ":" + string2 + ":" + string;
    }

    private double getAvgValue(double d, double d2) {
        double d3 = 0.0;
        try {
            d3 = d > 0.0 ? d2 / d : 0.0;
        }
        catch (Exception exception) {
            d3 = 0.0;
        }
        return d3;
    }

    public static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2).trim();
            arrayList.add(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n).trim();
        arrayList.add(string3);
        return arrayList;
    }

    public boolean isAgentlessComponent() {
        return this.isAgentless;
    }

    public Settings getSettingsObject() {
        return this.settingsObj;
    }

    public static String getValidName(String string) {
        String string2 = "-";
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        try {
            string = DOTNETMonitorTest.findAndReplaceInfoString((String)string, (String)"|", (String)",");
            ArrayList arrayList = DOTNETMonitorTest.myTokenizer(string, ",");
            if (arrayList == null || arrayList.size() == 0) {
                return string2;
            }
            string2 = "";
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ArrayList arrayList2;
                String string3 = (String)arrayList.get(i);
                if (string3 == null || string3.trim().length() == 0 || (arrayList2 = DOTNETMonitorTest.myTokenizer(string3, "~#~")) == null || arrayList2.size() < 4) continue;
                String string4 = (String)arrayList2.get(0);
                String string5 = (String)arrayList2.get(1);
                String string6 = (String)arrayList2.get(2);
                String string7 = (String)arrayList2.get(3);
                String string8 = string5 + "+" + string6 + "+" + string7;
                string2 = string2 + string8 + ",";
            }
            if (string2.length() == 0) {
                string2 = "-";
            } else if (!string2.endsWith(",")) {
                string2 = string2 + ",";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }
}

