/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgConfigInfo;
import com.eg.EgLangInfo;
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DiskActivityTest
extends GenericTest {
    private boolean isCap100 = false;
    private static Hashtable lastResults = new Hashtable();
    private static long lastCheckTime = 0L;
    EgJNIUtil egPerfUtilPd = null;
    EgJNIUtil egPerfUtilLd = null;
    XCmdGeneric xcmdG = null;
    private static final String objPhysical = "PhysicalDisk";
    private static final String objLogical = "LogicalDisk";
    private static final String[] counters = new String[]{"% Idle Time", "% Disk Read Time", "% Disk Write Time", "Avg. Disk sec/Read", "Avg. Disk sec/Write", "Avg. Disk Queue Length", "Current Disk Queue Length", "Disk Reads/sec", "Disk Read Bytes/sec", "Disk Writes/sec", "Disk Write Bytes/sec", "Avg. Disk Bytes/Read", "Avg. Disk Bytes/Write", "Split IO/Sec"};
    private static final int numMeasures = 11;
    private String[] strPhysicalDiskInstances = null;
    private String[] strLogicalDiskInstances = null;
    private static final int PHYSICAL_DISK = 0;
    private static final int LOGICAL_DISK = 1;
    private static final int ALL = 2;
    private int nDisk = 0;
    private EgUtilities egutil = null;
    private String installDir = EgInstallInfo.getInstallDir();
    private boolean bUseExe = false;
    private String UseExeCmd = "";
    private static Hashtable lastCheckHash = new Hashtable();
    private static Hashtable lastResults_dd = new Hashtable();
    public Hashtable dd_results = new Hashtable();
    public Hashtable dd_trace = new Hashtable();
    private boolean dd_flag = false;
    public boolean isDDDone = false;
    public boolean isSudoUsed = false;
    public boolean isHyperV = false;
    private static int maxCheckCt = 24;
    private int vmHealthCheckCt = 0;
    private int vmVirtalDiskCheckCt = 0;
    private EgJNIUtil egJNIUtil = null;
    public Hashtable hypervVhdHash = new Hashtable();
    public static Hashtable diskHash = new Hashtable();
    public static Hashtable diskLastRunHash = new Hashtable();
    private static final String vmObject = "Hyper-V Virtual Storage Device";
    private static final String[] vmCounters = new String[]{"Read Bytes/sec", "Write Bytes/sec", "Read Operations/sec", "Write Operations/sec"};
    public double readSizeInKb = 10.0;
    public double writeSizeInKb = 10.0;
    public double diskResponseTimeSecs = 1.0;
    public double eventCaptureTimeSecs = 10.0;
    public boolean isWindows2008 = false;
    public boolean activityTrace = false;
    public boolean isDiskBusyHigh = false;
    private double configuredDiskBusyPct = 20.0;
    private boolean highSecure = false;

    public void freeTest() {
        this.dd_results = new Hashtable();
        this.hypervVhdHash = new Hashtable();
        this.dd_trace = new Hashtable();
        this.isDDDone = false;
    }

    public static void main(String[] stringArray) {
        DiskActivityTest diskActivityTest = new DiskActivityTest(stringArray);
        diskActivityTest.computeMeasures(new Hashtable());
    }

    private double convertStringTodouble(String string) {
        double d = -5.0;
        try {
            d = EgLangInfo.getDoubleValue((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public DiskActivityTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        this.setMeasureCount(this.measureCount);
        String string10 = this.getValueForParam("use_sudo");
        if (string10 != null && (string10.equalsIgnoreCase("true") || string10.equalsIgnoreCase("yes"))) {
            this.isSudoUsed = true;
        }
        if ((string9 = this.getValueForParam("cap100")) != null && (string9.equalsIgnoreCase("true") || string9.equalsIgnoreCase("yes"))) {
            this.isCap100 = true;
        }
        if ((string8 = this.getValueForParam("Hyperv")) != null && (string8.equalsIgnoreCase("yes") || string8.equalsIgnoreCase("true"))) {
            this.needAgentlessDD = true;
            this.isHyperV = true;
        }
        if ((string7 = this.getValueForParam("isQVD")) != null && (string7.equalsIgnoreCase("yes") || string7.equalsIgnoreCase("true"))) {
            this.needAgentlessDD = true;
        }
        this.bUseExe = (string6 = this.getValueForParam("UseExe")) != null && string6.length() != 0 && !"false".equalsIgnoreCase(string6) && !"no".equalsIgnoreCase(string6);
        if (this.bUseExe) {
            this.egutil = EgUtilities.createInstance();
            this.installDir = this.installDir + "/bin/";
            this.UseExeCmd = this.installDir + "VmgDiskActivityTest.exe";
        }
        this.isDynamicInfoTest = true;
        String string11 = this.getValueForParam("Disks");
        if (string11 == null || string11.length() == 0 || string11.equalsIgnoreCase("Physical")) {
            this.nDisk = 0;
        } else if (string11.equalsIgnoreCase("Logical")) {
            this.nDisk = 1;
        } else if (string11.equalsIgnoreCase("All")) {
            this.nDisk = 2;
        }
        String string12 = this.getValueForParam("Read_size_in_kb");
        if (string12 != null && string12.trim().length() > 0) {
            string12 = string12.trim();
            try {
                this.readSizeInKb = Double.parseDouble(string12);
            }
            catch (Exception exception) {
                this.readSizeInKb = 10.0;
            }
        }
        if ((string5 = this.getValueForParam("Write_size_in_kb")) != null && string5.trim().length() > 0) {
            string5 = string5.trim();
            try {
                this.writeSizeInKb = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                this.writeSizeInKb = 10.0;
            }
        }
        if ((string4 = this.getValueForParam("Disk_response_time_secs")) != null && string4.trim().length() > 0) {
            string4 = string4.trim();
            try {
                this.diskResponseTimeSecs = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                this.diskResponseTimeSecs = 1.0;
            }
        }
        if ((string3 = this.getValueForParam("Event_capture_interval_in_secs")) != null && string3.trim().length() > 0) {
            string3 = string3.trim();
            try {
                this.eventCaptureTimeSecs = Double.parseDouble(string3);
            }
            catch (Exception exception) {
                this.eventCaptureTimeSecs = 10.0;
            }
        }
        this.activityTrace = (string2 = this.getValueForParam("Trace")) != null && (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true"));
        String string13 = this.getValueForParam("Disk_busy_percent");
        if (string13 != null && string13.trim().length() > 0) {
            string13 = string13.trim();
            try {
                this.configuredDiskBusyPct = Double.parseDouble(string13);
            }
            catch (Exception exception) {
                this.configuredDiskBusyPct = 20.0;
            }
        }
        this.highSecure = (string = this.getValueForParam("high_security")) != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true"));
    }

    private boolean isDiff(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray == null && stringArray2 == null) {
            return false;
        }
        if (stringArray == null && stringArray2 != null) {
            return true;
        }
        if (stringArray != null && stringArray2 == null) {
            return true;
        }
        if (stringArray.length != stringArray2.length) {
            return true;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            if (arrayList.contains(stringArray2[n])) continue;
            return true;
        }
        return false;
    }

    private void sendDiskPerf(EgJNIUtil egJNIUtil, EgJNIUtil egJNIUtil2) {
        double[][] dArray = null;
        double[][] dArray2 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        long l = this.measurePeriod / 3L;
        if (l > EgConfigInfo.msecPerMin * 2L) {
            l = EgConfigInfo.msecPerMin * 2L;
        }
        if (!this.meAgentless && lastResults != null && lastResults.size() > 0 && System.currentTimeMillis() - lastCheckTime < l) {
            Enumeration enumeration = lastResults.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ArrayList arrayList = (ArrayList)lastResults.get(string);
                if (arrayList == null || arrayList.size() == 0) continue;
                this.addNewMeasure(string, arrayList);
            }
            if (!this.dd_flag) {
                this.getDDValues();
                this.dd_flag = true;
            }
            return;
        }
        if (!this.meAgentless) {
            lastResults = new Hashtable();
        }
        stringArray = EgJNIUtil.discoverInstances((String)objPhysical);
        stringArray2 = EgJNIUtil.discoverInstances((String)objLogical);
        if (stringArray != null && stringArray.length > 0) {
            if (egJNIUtil == null) {
                egJNIUtil = new EgJNIUtil();
            }
            dArray = egJNIUtil.getCounterValue(objPhysical, stringArray, counters);
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            if (egJNIUtil2 == null) {
                egJNIUtil2 = new EgJNIUtil();
            }
            dArray2 = egJNIUtil2.getCounterValue(objLogical, stringArray2, counters);
        }
        if (dArray == null && dArray2 == null) {
            this.stopTest();
            return;
        }
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray != null && stringArray.length > 0) {
            if (egJNIUtil == null) {
                egJNIUtil = new EgJNIUtil();
            }
            dArray = egJNIUtil.getCounterValue(objPhysical, stringArray, counters);
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            if (egJNIUtil2 == null) {
                egJNIUtil2 = new EgJNIUtil();
            }
            dArray2 = egJNIUtil2.getCounterValue(objLogical, stringArray2, counters);
        }
        if (dArray != null) {
            this.setMeasures(stringArray, dArray, "Disk", true);
        }
        if (dArray2 != null) {
            this.setMeasures(stringArray2, dArray2, "LogicalDisk ", true);
        }
        if (!this.meAgentless) {
            lastCheckTime = System.currentTimeMillis();
        }
        this.stopTest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendDiskPerf(int n, EgJNIUtil egJNIUtil) {
        ArrayList arrayList;
        block122: {
            String[] stringArray;
            double[][] dArray;
            block118: {
                block119: {
                    block115: {
                        DiskActivityGeneric diskActivityGeneric;
                        block121: {
                            block120: {
                                ArrayList arrayList2;
                                String string;
                                ArrayList<Double> arrayList3;
                                block116: {
                                    block117: {
                                        arrayList3 = new ArrayList<Double>();
                                        if (n != 0 && n != 1) {
                                            this.stopTest();
                                            return;
                                        }
                                        string = "";
                                        String[] stringArray2 = null;
                                        if (n == 0) {
                                            string = objPhysical;
                                            stringArray2 = this.strPhysicalDiskInstances;
                                        } else {
                                            string = objLogical;
                                            stringArray2 = this.strLogicalDiskInstances;
                                        }
                                        dArray = null;
                                        stringArray = null;
                                        arrayList2 = null;
                                        if (this.meAgentless) break block116;
                                        if (this.bUseExe) break block117;
                                        stringArray = EgJNIUtil.discoverInstances((String)string);
                                        if (stringArray == null || stringArray.length == 0) {
                                            this.stopTest();
                                            return;
                                        }
                                        if (n == 0) {
                                            if (this.egPerfUtilPd == null) {
                                                egJNIUtil = this.egPerfUtilPd = new EgJNIUtil();
                                            }
                                        } else if (this.egPerfUtilLd == null) {
                                            egJNIUtil = this.egPerfUtilLd = new EgJNIUtil();
                                        }
                                        if (n == 0) {
                                            this.strPhysicalDiskInstances = stringArray;
                                        } else {
                                            this.strLogicalDiskInstances = stringArray;
                                        }
                                        dArray = egJNIUtil.getCounterValue(string, stringArray, counters);
                                        try {
                                            Thread.currentThread();
                                            Thread.sleep(2000L);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        dArray = egJNIUtil.getCounterValue(string, stringArray, counters);
                                        if (dArray != null) break block118;
                                        break block119;
                                    }
                                    if (egJNIUtil != null) {
                                        egJNIUtil.stop();
                                    }
                                    egJNIUtil = null;
                                    this.UseExeCmd = string.equalsIgnoreCase(objPhysical) ? EgInstallInfo.getInstallDir() + "/bin/VmgDiskActivityTest.exe" : EgInstallInfo.getInstallDir() + "/bin/VmgDiskActivityTest.exe false";
                                    if (this.egutil == null) {
                                        this.egutil = EgUtilities.createInstance();
                                    }
                                    if ((arrayList2 = this.egutil.getExecOutputLines(this.UseExeCmd)) == null || arrayList2.size() < 2) {
                                        System.out.println("Failed to run" + this.UseExeCmd);
                                        this.setErrorMessage("Failed to run " + this.UseExeCmd);
                                        this.egutil = null;
                                        this.stopTest();
                                        return;
                                    }
                                    try {
                                        ArrayList arrayList4 = (ArrayList)arrayList2.get(0);
                                        ArrayList arrayList5 = (ArrayList)arrayList2.get(1);
                                        StringTokenizer stringTokenizer = null;
                                        String string2 = "";
                                        double d = 0.0;
                                        double d2 = 0.0;
                                        double d3 = 0.0;
                                        double d4 = 0.0;
                                        if (arrayList4 != null && arrayList4.size() > 0) {
                                            int n2 = arrayList4.size();
                                            for (int i = 0; i < n2; ++i) {
                                                int n3;
                                                String string3 = "";
                                                string2 = ((String)arrayList4.get(i)).trim();
                                                if (string2.startsWith("_Total") || (n3 = string2.indexOf("=")) <= 0) continue;
                                                string3 = string2.substring(0, n3);
                                                stringTokenizer = new StringTokenizer(string2 = string2.substring(n3 + 1, string2.length()), "#");
                                                int n4 = stringTokenizer.countTokens();
                                                if (n4 < 11) continue;
                                                ArrayList<Double> arrayList6 = new ArrayList<Double>();
                                                double d5 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                double d6 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                double d7 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                boolean bl = true;
                                                if (d5 < 0.0) {
                                                    d5 = -5.0;
                                                    bl = false;
                                                }
                                                if (d6 < 0.0) {
                                                    d6 = -5.0;
                                                    bl = false;
                                                }
                                                if (d7 < 0.0) {
                                                    bl = false;
                                                    d7 = -5.0;
                                                }
                                                if (this.isCap100) {
                                                    d5 = d5 > 100.0 ? 100.0 : d5;
                                                    d7 = d7 > 100.0 ? 100.0 : d7;
                                                    d6 = d6 > 100.0 ? 100.0 : d6;
                                                }
                                                double d8 = d5 + d6 + d7;
                                                double d9 = 0.0;
                                                d9 = bl && d8 > 0.0 ? (d6 + d7) * 100.0 / d8 : -5.0;
                                                double d10 = 0.0;
                                                d10 = bl && d8 > 0.0 ? d6 * 100.0 / d8 : -5.0;
                                                double d11 = 0.0;
                                                d11 = bl && d8 > 0.0 ? d7 * 100.0 / d8 : -5.0;
                                                if (d9 > 100.0) {
                                                    d9 = 100.0;
                                                }
                                                if (d10 > 100.0) {
                                                    d10 = 100.0;
                                                }
                                                if (d11 > 100.0) {
                                                    d11 = 100.0;
                                                }
                                                arrayList6.add(new Double(d9));
                                                arrayList6.add(new Double(d10));
                                                arrayList6.add(new Double(d11));
                                                double d12 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                double d13 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList6.add(new Double(d12));
                                                arrayList6.add(new Double(d13));
                                                arrayList6.add(new Double(this.convertStringTodouble(stringTokenizer.nextToken())));
                                                double d14 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList6.add(new Double(d14));
                                                double d15 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList6.add(new Double(d15));
                                                double d16 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                if (d16 > 0.0) {
                                                    d16 /= 1024.0;
                                                }
                                                arrayList6.add(new Double(d16));
                                                double d17 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList6.add(new Double(d17));
                                                double d18 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                if (d18 > 0.0) {
                                                    d18 /= 1024.0;
                                                }
                                                arrayList6.add(new Double(d18));
                                                if (this.measureCount > 11) {
                                                    double d19 = 0.0;
                                                    if (d15 + d17 > 0.0) {
                                                        d19 = d9 / 100.0 / (d15 + d17);
                                                    }
                                                    double d20 = 0.0;
                                                    double d21 = 0.0;
                                                    if (d12 > 0.0) {
                                                        d20 += d12;
                                                    }
                                                    if (d13 > 0.0) {
                                                        d20 += d13;
                                                    }
                                                    if (d20 > 0.0) {
                                                        d20 /= 2.0;
                                                    }
                                                    if (d20 >= d19) {
                                                        d21 = d20 - d19;
                                                    } else if (d14 > 0.0) {
                                                        d21 = d19 * d14;
                                                    }
                                                    double d22 = d21 + d19;
                                                    d22 = d22 < 0.0 ? -5.0 : d22;
                                                    d19 = d19 < 0.0 ? -5.0 : d19;
                                                    d21 = d21 < 0.0 ? -5.0 : d21;
                                                    arrayList6.add(new Double(d19));
                                                    arrayList6.add(new Double(d21));
                                                    arrayList6.add(new Double(d22));
                                                    if (this.measureCount > 14 && n4 >= 14) {
                                                        double d23;
                                                        double d24 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                        if (d24 > 0.0) {
                                                            d24 /= 1024.0;
                                                        }
                                                        if ((d23 = this.convertStringTodouble(stringTokenizer.nextToken())) > 0.0) {
                                                            d23 /= 1024.0;
                                                        }
                                                        double d25 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                        arrayList6.add(new Double(d24));
                                                        arrayList6.add(new Double(d23));
                                                        arrayList6.add(new Double(d25));
                                                    }
                                                }
                                                if (d9 >= d) {
                                                    d = d9;
                                                    d3 = d16;
                                                    d4 = d18;
                                                }
                                                if (string.equalsIgnoreCase(objPhysical)) {
                                                    System.out.println("DiskActivityTest if addnewmeasure: " + string3 + " : " + arrayList6);
                                                    this.addNewMeasure("Disk" + string3, arrayList6);
                                                    continue;
                                                }
                                                System.out.println("DiskActivityTest senddiskperf else addnewmeasure: " + string3 + " : " + arrayList6);
                                                this.addNewMeasure("LogicalDisk " + string3, arrayList6);
                                            }
                                        }
                                        double d26 = -5.0;
                                        if (d > 0.0) {
                                            d26 = d;
                                        } else if (d == 0.0) {
                                            d26 = d;
                                        }
                                        if (string.equalsIgnoreCase(objPhysical)) {
                                            if (d3 > 0.0) {
                                                d2 += d3;
                                            }
                                            if (d4 > 0.0) {
                                                d2 += d4;
                                            }
                                            arrayList3.add(new Double(d26));
                                            arrayList3.add(new Double(d2));
                                            diskHash.put(this.reportingName, arrayList3);
                                            diskLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                                        }
                                        if (!this.dd_flag) {
                                            this.getDDValues();
                                            this.dd_flag = true;
                                        }
                                        return;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        this.egutil = null;
                                        this.stopTest();
                                        return;
                                    }
                                }
                                if (this.isPerfmon) {
                                    boolean bl;
                                    if (egJNIUtil != null) {
                                        egJNIUtil.stop();
                                    }
                                    egJNIUtil = null;
                                    this.checkNbt();
                                    if (this.nbtName == null) {
                                        this.errorMsg = "DiskActivityTest: Failed to get the NETBios name for  " + this.targetHost;
                                        this.setErrorMessage(this.errorMsg);
                                        this.stopTest();
                                        this.xcmdG = null;
                                        return;
                                    }
                                    if (this.xcmdG == null) {
                                        this.xcmdG = new XCmdGeneric(this.nbtName);
                                    }
                                    if (!(bl = this.xcmdG.checkForExeOnRemote("VmgDiskActivityTest.exe"))) {
                                        this.xcmdG.copyExeToRemote(EgInstallInfo.getInstallDir() + "/bin/VmgDiskActivityTest.exe", true);
                                    }
                                    if ((arrayList2 = string.equalsIgnoreCase(objPhysical) ? this.xcmdG.executeRemoteCommand("VmgDiskActivityTest.exe") : this.xcmdG.executeRemoteCommand("VmgDiskActivityTest.exe false")) == null || arrayList2.size() < 2) {
                                        System.out.println("Failed to run" + this.UseExeCmd + " for " + this.nbtName);
                                        this.setErrorMessage("Failed to run " + this.UseExeCmd + " for " + this.nbtName);
                                        this.stopTest();
                                        this.xcmdG = null;
                                        return;
                                    }
                                    try {
                                        ArrayList arrayList7 = (ArrayList)arrayList2.get(0);
                                        ArrayList arrayList8 = (ArrayList)arrayList2.get(1);
                                        StringTokenizer stringTokenizer = null;
                                        String string4 = "";
                                        double d = 0.0;
                                        double d27 = 0.0;
                                        double d28 = 0.0;
                                        double d29 = 0.0;
                                        if (arrayList7 != null && arrayList7.size() > 0) {
                                            int n5 = arrayList7.size();
                                            for (int i = 0; i < n5; ++i) {
                                                double d30;
                                                double d31;
                                                double d32;
                                                int n6;
                                                String string5 = "";
                                                string4 = ((String)arrayList7.get(i)).trim();
                                                if (string4.startsWith("_Total") || (n6 = string4.indexOf("=")) <= 0) continue;
                                                string5 = string4.substring(0, n6);
                                                stringTokenizer = new StringTokenizer(string4 = string4.substring(n6 + 1, string4.length()), "#");
                                                int n7 = stringTokenizer.countTokens();
                                                if (n7 < 11) continue;
                                                ArrayList<Double> arrayList9 = new ArrayList<Double>();
                                                double d33 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                double d34 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                double d35 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                boolean bl2 = true;
                                                if (d33 < 0.0) {
                                                    d33 = -5.0;
                                                    bl2 = false;
                                                }
                                                if (d34 < 0.0) {
                                                    d34 = -5.0;
                                                    bl2 = false;
                                                }
                                                if (d35 < 0.0) {
                                                    bl2 = false;
                                                    d35 = -5.0;
                                                }
                                                if (this.isCap100) {
                                                    d33 = d33 > 100.0 ? 100.0 : d33;
                                                    d35 = d35 > 100.0 ? 100.0 : d35;
                                                    d34 = d34 > 100.0 ? 100.0 : d34;
                                                }
                                                double d36 = d33 + d34 + d35;
                                                double d37 = 0.0;
                                                d37 = bl2 && d36 > 0.0 ? (d34 + d35) * 100.0 / d36 : -5.0;
                                                double d38 = 0.0;
                                                d38 = bl2 && d36 > 0.0 ? d34 * 100.0 / d36 : -5.0;
                                                double d39 = 0.0;
                                                d39 = bl2 && d36 > 0.0 ? d35 * 100.0 / d36 : -5.0;
                                                if (d37 > 100.0) {
                                                    d37 = 100.0;
                                                }
                                                if (d38 > 100.0) {
                                                    d38 = 100.0;
                                                }
                                                if (d39 > 100.0) {
                                                    d39 = 100.0;
                                                }
                                                arrayList9.add(new Double(d37));
                                                arrayList9.add(new Double(d38));
                                                arrayList9.add(new Double(d39));
                                                double d40 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                double d41 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList9.add(new Double(d40));
                                                arrayList9.add(new Double(d41));
                                                arrayList9.add(new Double(this.convertStringTodouble(stringTokenizer.nextToken())));
                                                double d42 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList9.add(new Double(d42));
                                                double d43 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList9.add(new Double(d43));
                                                double d44 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                if (d44 > 0.0) {
                                                    d44 /= 1024.0;
                                                }
                                                arrayList9.add(new Double(d44));
                                                double d45 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                arrayList9.add(new Double(d45));
                                                double d46 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                if (d46 > 0.0) {
                                                    d46 /= 1024.0;
                                                }
                                                arrayList9.add(new Double(d46));
                                                if (this.measureCount > 11) {
                                                    d32 = 0.0;
                                                    if (d43 + d45 > 0.0) {
                                                        d32 = d37 / 100.0 / (d43 + d45);
                                                    }
                                                    d31 = 0.0;
                                                    d30 = 0.0;
                                                    if (d40 > 0.0) {
                                                        d31 += d40;
                                                    }
                                                    if (d41 > 0.0) {
                                                        d31 += d41;
                                                    }
                                                    if (d31 > 0.0) {
                                                        d31 /= 2.0;
                                                    }
                                                    if (d31 >= d32) {
                                                        d30 = d31 - d32;
                                                    } else if (d42 > 0.0) {
                                                        d30 = d32 * d42;
                                                    }
                                                    double d47 = d30 + d32;
                                                    d47 = d47 < 0.0 ? -5.0 : d47;
                                                    d32 = d32 < 0.0 ? -5.0 : d32;
                                                    d30 = d30 < 0.0 ? -5.0 : d30;
                                                    arrayList9.add(new Double(d32));
                                                    arrayList9.add(new Double(d30));
                                                    arrayList9.add(new Double(d47));
                                                }
                                                if (n7 >= 14 && this.measureCount > 14) {
                                                    d32 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                    if (d32 > 0.0) {
                                                        d32 /= 1024.0;
                                                    }
                                                    if ((d31 = this.convertStringTodouble(stringTokenizer.nextToken())) > 0.0) {
                                                        d31 /= 1024.0;
                                                    }
                                                    d30 = this.convertStringTodouble(stringTokenizer.nextToken());
                                                    arrayList9.add(new Double(d32));
                                                    arrayList9.add(new Double(d31));
                                                    arrayList9.add(new Double(d30));
                                                }
                                                if (d37 >= d) {
                                                    d = d37;
                                                    d28 = d44;
                                                    d29 = d46;
                                                }
                                                if (string.equalsIgnoreCase(objPhysical)) {
                                                    this.addNewMeasure("Disk" + string5, arrayList9);
                                                    continue;
                                                }
                                                this.addNewMeasure("LogicalDisk " + string5, arrayList9);
                                            }
                                        }
                                        double d48 = -5.0;
                                        if (d > 0.0) {
                                            d48 = d;
                                        } else if (d == 0.0) {
                                            d48 = d;
                                        }
                                        if (string.equalsIgnoreCase(objPhysical)) {
                                            if (d28 > 0.0) {
                                                d27 += d28;
                                            }
                                            if (d29 > 0.0) {
                                                d27 += d29;
                                            }
                                            arrayList3.add(new Double(d48));
                                            arrayList3.add(new Double(d27));
                                            diskHash.put(this.reportingName, arrayList3);
                                            diskLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
                                        }
                                        if (!this.dd_flag) {
                                            this.getDDValues();
                                            this.dd_flag = true;
                                        }
                                        return;
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        this.xcmdG = null;
                                        this.stopTest();
                                        return;
                                    }
                                }
                                if (!this.isSSH && !this.isRexec) {
                                    this.stopTest();
                                    return;
                                }
                                if (egJNIUtil != null) {
                                    egJNIUtil.stop();
                                }
                                egJNIUtil = null;
                                if (this.aluser.equalsIgnoreCase("NONE") || this.alpassword.equalsIgnoreCase("none")) {
                                    this.stopTest();
                                    return;
                                }
                                String string6 = "";
                                if (this.isSSH) {
                                    string6 = "ssh";
                                } else if (this.isRexec) {
                                    string6 = "rexec";
                                }
                                System.out.println(this.entity + "  highSecure value :" + this.highSecure);
                                diskActivityGeneric = null;
                                diskActivityGeneric = this.highSecure ? new DiskActivityGeneric(string6, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.alencrypt, this.alkeyfile, this.highSecure) : new DiskActivityGeneric(string6, this.targetHost, this.sshPort, this.aluser, this.alpassword, this.alencrypt, this.alkeyfile);
                                arrayList = null;
                                if (!this.alos.equalsIgnoreCase("solaris")) break block120;
                                arrayList = diskActivityGeneric.getActualResultsOnSolaris();
                                System.out.println("DiskActivityTest solaris: " + arrayList);
                                break block115;
                            }
                            if (!this.alos.equalsIgnoreCase("linux")) break block121;
                            System.out.println(this.entity + "enter into the linux");
                            arrayList = diskActivityGeneric.getActualResultsOnLinux();
                            System.out.println("DiskActivityTest linux: " + arrayList);
                            if (EgMainAgent.isRemoteDetailed) {
                                try {
                                    ArrayList arrayList10;
                                    String string = "/usr/bin/iotop --batch -n 2";
                                    if (this.isSudoUsed) {
                                        string = "sudo " + string;
                                    }
                                    if ((arrayList10 = diskActivityGeneric.execCommand(string)) != null && arrayList10.size() > 0) {
                                        this.dd_results = new Hashtable();
                                        this.dd_results = this.getValuesFromIOTOPCommand(arrayList10);
                                        break block115;
                                    } else {
                                        string = "/usr/sbin/iotop --batch -n 2";
                                        if (this.isSudoUsed) {
                                            string = "sudo " + string;
                                        }
                                        if ((arrayList10 = diskActivityGeneric.execCommand(string)) != null && arrayList10.size() > 0) {
                                            this.dd_results = new Hashtable();
                                            this.dd_results = this.getValuesFromIOTOPCommand(arrayList10);
                                        }
                                    }
                                    break block115;
                                }
                                catch (Exception exception) {
                                    System.out.println(exception);
                                }
                            }
                            break block115;
                        }
                        if (this.alos.equalsIgnoreCase("aix")) {
                            arrayList = diskActivityGeneric.getActualResultsOnAix();
                            System.out.println("DiskActivityTest aix: " + arrayList);
                        } else if (this.alos.equalsIgnoreCase("hpux")) {
                            arrayList = diskActivityGeneric.getActualResultsOnHPUnix();
                        }
                    }
                    System.out.println("DiskActivityTest hpux: " + arrayList);
                    if (arrayList == null) {
                        this.stopTest();
                        return;
                    }
                    break block122;
                }
                this.stopTest();
                return;
            }
            if (n == 0) {
                this.setMeasures(stringArray, dArray, "Disk", false);
            } else {
                this.setMeasures(stringArray, dArray, "LogicalDisk ", false);
            }
            this.stopTest();
            return;
        }
        int n8 = arrayList.size();
        int n9 = 0;
        while (n9 < n8) {
            StringTokenizer stringTokenizer;
            String string = (String)arrayList.get(n9);
            if (string != null && (stringTokenizer = new StringTokenizer(string, "#")).countTokens() >= 15) {
                int n10;
                String string7 = stringTokenizer.nextToken();
                int n11 = stringTokenizer.countTokens();
                ArrayList<Double> arrayList11 = new ArrayList<Double>();
                for (n10 = 0; n10 < n11; ++n10) {
                    double d = -1.0;
                    try {
                        d = Double.parseDouble(stringTokenizer.nextToken().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n10 >= this.measureCount) continue;
                    arrayList11.add(new Double(d));
                }
                if (n11 < this.measureCount) {
                    for (n10 = n11; n10 < this.measureCount; ++n10) {
                        arrayList11.add(new Double(-5.0));
                    }
                }
                System.out.println("x: " + arrayList11);
                this.addNewMeasure(string7, arrayList11);
            }
            ++n9;
        }
        return;
    }

    private void setMeasures(String[] stringArray, double[][] dArray, String string, boolean bl) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (stringArray == null) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < stringArray.length; ++i) {
            double d5;
            double d6;
            if (stringArray[i].equals("_Total")) continue;
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            double d7 = dArray[i][0];
            double d8 = dArray[i][1];
            double d9 = dArray[i][2];
            boolean bl2 = true;
            if (d7 < 0.0) {
                d7 = -5.0;
                bl2 = false;
            }
            if (d8 < 0.0) {
                d8 = -5.0;
                bl2 = false;
            }
            if (d9 < 0.0) {
                bl2 = false;
                d9 = -5.0;
            }
            if (this.isCap100) {
                d7 = d7 > 100.0 ? 100.0 : d7;
                d9 = d9 > 100.0 ? 100.0 : d9;
                d8 = d8 > 100.0 ? 100.0 : d8;
            }
            double d10 = d7 + d8 + d9;
            double d11 = 0.0;
            d11 = bl2 && d10 > 0.0 ? (d8 + d9) * 100.0 / d10 : -5.0;
            double d12 = 0.0;
            d12 = bl2 && d10 > 0.0 ? d8 * 100.0 / d10 : -5.0;
            double d13 = 0.0;
            d13 = bl2 && d10 > 0.0 ? d9 * 100.0 / d10 : -5.0;
            if (d11 > 100.0) {
                d11 = 100.0;
            }
            if (d12 > 100.0) {
                d12 = 100.0;
            }
            if (d13 > 100.0) {
                d13 = 100.0;
            }
            arrayList2.add(new Double(d11));
            arrayList2.add(new Double(d12));
            arrayList2.add(new Double(d13));
            for (int j = 3; j < counters.length; ++j) {
                if (j > 10) continue;
                if (j == 8 || j == 10) {
                    if (dArray[i][j] > 0.0) {
                        dArray[i][j] = dArray[i][j] / 1024.0;
                    }
                    if (d11 >= d) {
                        d = d11;
                        if (j == 8 && dArray[i][j] >= 0.0) {
                            d3 = dArray[i][j];
                        } else if (j == 10 && dArray[i][j] >= 0.0) {
                            d4 = dArray[i][j];
                        }
                    }
                }
                arrayList2.add(new Double(dArray[i][j]));
                if (!(d11 >= this.configuredDiskBusyPct)) continue;
                this.isDiskBusyHigh = true;
            }
            if (this.measureCount > 11) {
                double d14 = (Double)arrayList2.get(0);
                d6 = (Double)arrayList2.get(3);
                d5 = (Double)arrayList2.get(4);
                double d15 = (Double)arrayList2.get(6);
                double d16 = (Double)arrayList2.get(7);
                double d17 = (Double)arrayList2.get(9);
                double d18 = 0.0;
                if (d16 + d17 > 0.0) {
                    d18 = d11 / 100.0 / (d16 + d17);
                }
                double d19 = 0.0;
                double d20 = 0.0;
                if (d6 > 0.0) {
                    d19 += d6;
                }
                if (d5 > 0.0) {
                    d19 += d5;
                }
                if (d19 > 0.0) {
                    d19 /= 2.0;
                }
                if (d19 >= d18) {
                    d20 = d19 - d18;
                } else if (d15 > 0.0) {
                    d20 = d18 * d15;
                }
                double d21 = d20 + d18;
                d21 = d21 < 0.0 ? -5.0 : d21;
                d18 = d18 < 0.0 ? -5.0 : d18;
                d20 = d20 < 0.0 ? -5.0 : d20;
                arrayList2.add(new Double(d18));
                arrayList2.add(new Double(d20));
                arrayList2.add(new Double(d21));
            }
            if (this.measureCount > 14) {
                double d22 = dArray[i][11] / 1024.0;
                d6 = dArray[i][12] / 1024.0;
                d5 = dArray[i][13];
                arrayList2.add(new Double(d22));
                arrayList2.add(new Double(d6));
                arrayList2.add(new Double(d5));
            }
            this.addNewMeasure(string + stringArray[i], arrayList2);
            if (!this.dd_flag) {
                this.getDDValues();
                this.dd_flag = true;
            }
            if (!bl || this.meAgentless) continue;
            lastResults.put(string + stringArray[i], arrayList2);
        }
        double d23 = -5.0;
        if (d > 0.0) {
            d23 = d;
        } else if (d == 0.0) {
            d23 = d;
        }
        if (string.equalsIgnoreCase("Disk")) {
            if (d3 > 0.0) {
                d2 += d3;
            }
            if (d4 > 0.0) {
                d2 += d4;
            }
            arrayList.add(new Double(d23));
            arrayList.add(new Double(d2));
            diskHash.put(this.reportingName, arrayList);
            diskLastRunHash.put(this.reportingName, new Long(System.currentTimeMillis()));
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.isDiskBusyHigh = false;
        this.getOSName();
        if (this.isHyperV) {
            this.getHypervVmDiskInfo();
        }
        try {
            if (this.nDisk != 0 && this.nDisk != 1 && this.nDisk != 2) {
                return;
            }
            this.dd_flag = false;
            if (this.nDisk == 2) {
                if (this.egPerfUtilPd == null) {
                    this.egPerfUtilPd = new EgJNIUtil();
                }
                if (this.egPerfUtilLd == null) {
                    this.egPerfUtilLd = new EgJNIUtil();
                }
                if (!this.meAgentless && !this.bUseExe) {
                    this.sendDiskPerf(this.egPerfUtilPd, this.egPerfUtilLd);
                } else {
                    this.sendDiskPerf(0, this.egPerfUtilPd);
                    this.sendDiskPerf(1, this.egPerfUtilLd);
                }
            } else if (this.nDisk == 0) {
                if ((this.meAgentless || this.isPerfmon) && this.egPerfUtilPd == null) {
                    this.egPerfUtilPd = new EgJNIUtil();
                }
                this.sendDiskPerf(0, this.egPerfUtilPd);
            } else {
                if (this.egPerfUtilLd == null) {
                    this.egPerfUtilLd = new EgJNIUtil();
                }
                this.sendDiskPerf(1, this.egPerfUtilLd);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stopTest() {
        if (this.egPerfUtilLd != null) {
            this.egPerfUtilLd.stop();
        }
        if (this.egPerfUtilPd != null) {
            this.egPerfUtilPd.stop();
        }
        this.egPerfUtilPd = null;
        this.egPerfUtilLd = null;
        this.strPhysicalDiskInstances = null;
        this.strLogicalDiskInstances = null;
    }

    private Hashtable getDetailsFromAppPid(String string) {
        CpuUtil cpuUtil = null;
        ArrayList arrayList = null;
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Cloneable> hashtable2 = new Hashtable<String, Cloneable>();
        if (string.equalsIgnoreCase("localhost")) {
            String string2 = System.getProperty("os.name");
            cpuUtil = new CpuUtil(true);
            cpuUtil.setOS(string2);
            arrayList = cpuUtil.execute(false);
            hashtable = CpuUtil.getPidMap((String)"localhost");
        } else {
            cpuUtil = new CpuUtil(string, true);
            cpuUtil.setOS(this.alos);
            arrayList = cpuUtil.execute(true);
            hashtable = CpuUtil.getPidMap((String)string);
        }
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        hashtable2.put("PidMap", hashtable);
        hashtable2.put("Result", arrayList);
        return hashtable2;
    }

    public void getDDValues() {
        Hashtable hashtable = new Hashtable();
        if (!this.meAgentless) {
            hashtable = this.getDetailsFromAppPid("localhost");
        } else if (this.isPerfmon) {
            hashtable = this.getDetailsFromAppPid(this.nbtName);
        }
        Hashtable hashtable2 = new Hashtable();
        ArrayList arrayList = new ArrayList();
        hashtable2 = (Hashtable)hashtable.get("PidMap");
        arrayList = (ArrayList)hashtable.get("Result");
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        if (n == 0) {
            return;
        }
        String string = null;
        String[] stringArray = new String[4];
        for (int i = 0; i < n; ++i) {
            int n2;
            String string2 = (String)arrayList.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            int n3 = stringTokenizer.countTokens();
            if (n3 < 18) continue;
            String string3 = stringTokenizer.nextToken();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            if (string3.equals("_Total")) continue;
            for (n2 = 1; n2 < n3; ++n2) {
                String string4 = stringTokenizer.nextToken();
                if (n2 == 3) {
                    string = string4;
                    String string5 = (String)hashtable2.get(string);
                    if (string5 != null && string5.length() > 0) {
                        string3 = string5;
                    }
                    arrayList2.add(string3);
                }
                if (n2 == 7) {
                    stringArray[0] = string4.trim();
                }
                if (n2 == 8) {
                    stringArray[2] = string4.trim();
                }
                if (n2 == 18) {
                    stringArray[1] = string4.trim();
                }
                if (n2 != 17) continue;
                stringArray[3] = string4.trim();
            }
            for (n2 = 0; n2 < 4; ++n2) {
                double d = -5.0;
                try {
                    d = Double.parseDouble(stringArray[n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    d = -5.0;
                }
                arrayList2.add(new Double(d));
            }
            if (this.dd_results == null) {
                this.dd_results = new Hashtable();
            }
            this.dd_results.put(string, arrayList2);
        }
        if (this.dd_results == null) {
            this.dd_results = new Hashtable();
        }
    }

    public Hashtable getValuesFromIOTOPCommand(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            StringTokenizer stringTokenizer;
            int n2;
            String string2;
            String string3 = ((String)arrayList.get(i)).trim();
            if (string3 == null || string3.length() == 0 || (string2 = string3.trim()) != null && string2.startsWith("Total") || string2.startsWith("TID") || (n2 = (stringTokenizer = new StringTokenizer(string2, "%")).countTokens()) < 3) continue;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String string4 = stringTokenizer.nextToken().trim();
            if (string4 == null || string4.length() == 0) continue;
            String string5 = stringTokenizer.nextToken().trim();
            String string6 = stringTokenizer.nextToken().trim();
            if (string6 == null || string6.length() == 0) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, " ");
            int n3 = stringTokenizer2.countTokens();
            double d = -5.0;
            double d2 = -5.0;
            int n4 = -5;
            if (n3 < 8 || (string = stringTokenizer2.nextToken().trim()) == null || string.length() == 0) continue;
            String string7 = stringTokenizer2.nextToken().trim();
            String string8 = stringTokenizer2.nextToken().trim();
            String string9 = stringTokenizer2.nextToken().trim();
            if (string9 == null || string9.length() == 0) continue;
            String string10 = stringTokenizer2.nextToken().trim();
            String string11 = stringTokenizer2.nextToken().trim();
            if (string11 == null || string11.length() == 0) continue;
            String string12 = stringTokenizer2.nextToken().trim();
            String string13 = stringTokenizer2.nextToken().trim();
            try {
                n4 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n4 = -5;
            }
            try {
                d = Double.valueOf(string9.trim()) / 1024.0;
            }
            catch (NumberFormatException numberFormatException) {
                d = -5.0;
            }
            try {
                d2 = Double.valueOf(string11.trim()) / 1024.0;
            }
            catch (NumberFormatException numberFormatException) {
                d2 = -5.0;
            }
            arrayList2.add(new String(string6));
            arrayList2.add(new Double(d));
            arrayList2.add(new Double(-5.0));
            arrayList2.add(new Double(d2));
            arrayList2.add(new Double(-5.0));
            hashtable.put(string, arrayList2);
        }
        return hashtable;
    }

    private void getHypervVmDiskInfo() {
        this.hypervVhdHash = new Hashtable();
        Hashtable hashtable = this.getVmPids();
        Hashtable hashtable2 = this.getVmVirtualDisks();
        Hashtable hashtable3 = this.getVmVirtualDisksPerf();
        if (hashtable == null || hashtable.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            ArrayList arrayList;
            String string = (String)enumeration.nextElement();
            long l = (Long)hashtable.get(string);
            String string2 = string;
            if (string2.indexOf("(") > -1) {
                string2 = string2.replace('(', '[');
            }
            if (string2.indexOf(")") > -1) {
                string2 = string2.replace(')', ']');
            }
            if ((arrayList = (ArrayList)hashtable2.get(string2)) == null || arrayList.size() == 0) continue;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ArrayList arrayList2;
                String string3 = (String)arrayList.get(i);
                if (string3 == null || string3.trim().length() == 0 || (arrayList2 = (ArrayList)hashtable3.get(string3)) == null || arrayList2.size() < 6) continue;
                double d7 = (Double)arrayList2.get(0);
                double d8 = (Double)arrayList2.get(1);
                double d9 = (Double)arrayList2.get(2);
                double d10 = (Double)arrayList2.get(3);
                double d11 = (Double)arrayList2.get(4);
                double d12 = (Double)arrayList2.get(5);
                if (d7 > 0.0) {
                    d += d7;
                }
                if (d8 > 0.0) {
                    d2 += d8;
                }
                if (d9 > 0.0) {
                    d3 += d9;
                }
                if (d10 > 0.0) {
                    d4 += d10;
                }
                if (d11 > 0.0) {
                    d5 += d11;
                }
                if (!(d12 > 0.0)) continue;
                d6 += d12;
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            arrayList3.add(new String(string));
            arrayList3.add(new Double(d));
            arrayList3.add(new Double(d2));
            arrayList3.add(new Double(d3));
            arrayList3.add(new Double(d4));
            arrayList3.add(new Double(d5));
            arrayList3.add(new Double(d6));
            this.hypervVhdHash.put(l + "", arrayList3);
        }
    }

    private Hashtable getVmPids() {
        Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
        try {
            Object object;
            Object object2;
            Object object3;
            ArrayList arrayList = null;
            if (!this.meAgentless) {
                object3 = "cmd /c cscript.exe " + EgMainAgent.strCScriptOptionalParamters + " " + EgInstallInfo.getInstallDir() + "/lib/HvVmHealth.vbs //Nologo";
                object2 = EgUtilities.createInstance();
                arrayList = object2.getExecOutputLines((String)object3);
                if (arrayList == null || arrayList.size() < 2) {
                    return hashtable;
                }
                arrayList = (ArrayList)arrayList.get(0);
            } else if (this.isPerfmon) {
                this.checkNbt();
                if (this.nbtName == null || this.nbtName.length() == 0) {
                    return hashtable;
                }
                object3 = null;
                object3 = new XCmdGeneric(this.nbtName);
                object2 = EgInstallInfo.getInstallDir() + "/lib/HvVmHealth.vbs";
                try {
                    boolean bl;
                    if (this.vmHealthCheckCt == 0 && !(bl = object3.checkForExeOnRemote("HvVmHealth.vbs"))) {
                        object3.copyExeToRemote((String)object2, true);
                    }
                    ++this.vmHealthCheckCt;
                    if (this.vmHealthCheckCt >= maxCheckCt) {
                        this.vmHealthCheckCt = 0;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                arrayList = object3.executeRemoteCommand("cscript.exe " + EgMainAgent.strCScriptOptionalParamters + " " + EgInstallInfo.getXCmdRemoteDirectory() + "HvVmHealth.vbs //Nologo");
                if (arrayList != null && arrayList.size() == 2) {
                    ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                    object = (ArrayList)arrayList.get(1);
                    arrayList = object != null && ((ArrayList)object).size() > 0 ? null : arrayList2;
                } else {
                    this.vmHealthCheckCt = 0;
                }
            }
            if (arrayList == null || arrayList.size() == 0) {
                return hashtable;
            }
            object3 = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                object = ((String)arrayList.get(i)).trim();
                if (object == null || ((String)object).length() == 0 || !((String)object).startsWith("VmName:") || (n2 = ((StringTokenizer)(object3 = new StringTokenizer((String)object, "#"))).countTokens()) < 5) continue;
                String string = ((StringTokenizer)object3).nextToken().trim();
                String string2 = ((StringTokenizer)object3).nextToken().trim();
                String string3 = ((StringTokenizer)object3).nextToken().trim();
                String string4 = ((StringTokenizer)object3).nextToken().trim();
                String string5 = ((StringTokenizer)object3).nextToken().trim();
                if (string == null || string.indexOf(":") < 0) continue;
                string = string.substring(string.indexOf(":") + 1);
                if (string4 == null || string4.indexOf(":") < 0) continue;
                string4 = string4.substring(string4.indexOf(":") + 1);
                long l = -1L;
                try {
                    l = Long.parseLong(string4);
                }
                catch (Exception exception) {
                    l = -1L;
                }
                if (l < 0L) continue;
                hashtable.put(string, new Long(l));
            }
        }
        catch (Exception exception) {
            System.out.println("[DiskActivityTest] Exception occured while calling the Health details method " + exception);
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "DiskActivityTest", string);
            exception.printStackTrace();
        }
        return hashtable;
    }

    public Hashtable getVmVirtualDisks() {
        Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
        try {
            Object object;
            String string;
            ArrayList arrayList = null;
            if (!this.meAgentless) {
                string = "cmd /c cscript.exe " + EgMainAgent.strCScriptOptionalParamters + " " + EgInstallInfo.getInstallDir() + "/lib/HvVmVirtualDisk.vbs //Nologo";
                object = EgUtilities.createInstance();
                arrayList = object.getExecOutputLines(string);
                if (arrayList == null || arrayList.size() < 2) {
                    return hashtable;
                }
                arrayList = (ArrayList)arrayList.get(0);
            } else if (this.isPerfmon) {
                this.checkNbt();
                if (this.nbtName == null || this.nbtName.length() == 0) {
                    return hashtable;
                }
                string = null;
                string = new XCmdGeneric(this.nbtName);
                object = EgInstallInfo.getInstallDir() + "/lib/HvVmVirtualDisk.vbs";
                try {
                    boolean bl;
                    if (this.vmVirtalDiskCheckCt == 0 && !(bl = string.checkForExeOnRemote("HvVmVirtualDisk.vbs"))) {
                        string.copyExeToRemote((String)object, true);
                    }
                    ++this.vmVirtalDiskCheckCt;
                    if (this.vmVirtalDiskCheckCt >= maxCheckCt) {
                        this.vmVirtalDiskCheckCt = 0;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                arrayList = string.executeRemoteCommand("cscript.exe " + EgMainAgent.strCScriptOptionalParamters + " " + EgInstallInfo.getXCmdRemoteDirectory() + "HvVmVirtualDisk.vbs //Nologo");
                if (arrayList != null && arrayList.size() == 2) {
                    ArrayList arrayList2 = (ArrayList)arrayList.get(0);
                    ArrayList arrayList3 = (ArrayList)arrayList.get(1);
                    arrayList = arrayList3 != null && arrayList3.size() > 0 ? null : arrayList2;
                } else {
                    this.vmVirtalDiskCheckCt = 0;
                }
            }
            if (arrayList == null || arrayList.size() == 0) {
                return hashtable;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                String string2 = ((String)arrayList.get(i)).trim();
                if (string2 == null || string2.trim().length() == 0 || (n2 = (string2 = string2.trim()).indexOf("=")) < 0) continue;
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                ArrayList<String> arrayList4 = (ArrayList<String>)hashtable.get(string3);
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<String>();
                }
                arrayList4.add(string4);
                hashtable.put(string3, arrayList4);
            }
        }
        catch (Exception exception) {
            System.out.println("[DiskActivityTest] Exception occured while calling the Network details method " + exception);
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "DiskActivityTest", string);
            exception.printStackTrace();
        }
        return hashtable;
    }

    private Hashtable getVmVirtualDisksPerf() {
        Hashtable hashtable = new Hashtable();
        String[] stringArray = null;
        double[][] dArray = null;
        if (!this.meAgentless) {
            if (this.egJNIUtil == null) {
                this.egJNIUtil = new EgJNIUtil();
            }
            if ((stringArray = EgJNIUtil.discoverInstances((String)vmObject)) == null) {
                System.out.println("[DiskActivityTest] instance values are null for Hyper-V Virtual Storage Device");
                this.stopTest1();
                return hashtable;
            }
            dArray = this.egJNIUtil.getCounterValue(vmObject, stringArray, vmCounters);
        } else if (this.isPerfmon) {
            this.checkNbt();
            if (this.nbtName == null) {
                System.out.println("[DiskActivityTest] Failed to get the NETBios name for  " + this.targetHost);
                this.stopTest1();
                return hashtable;
            }
            if (this.egJNIUtil == null) {
                EgJNIUtil.isHostAvailable((String)this.nbtName);
                this.egJNIUtil = new EgJNIUtil();
            }
            if ((stringArray = EgJNIUtil.discoverPdhInstancesWithTotal((String)vmObject, (String)this.nbtName)) == null || stringArray.length == 0) {
                System.out.println("[DiskActivityTest] instance values are null for Hyper-V Virtual Storage Device");
                this.stopTest1();
                return hashtable;
            }
            dArray = this.egJNIUtil.getCounterValue(vmObject, stringArray, vmCounters, this.nbtName, "perfmon");
        }
        if (dArray == null || dArray.length == 0) {
            System.out.println("[DiskActivityTest] counterValues values are null for Hyper-V Virtual Storage Device");
            this.stopTest1();
            return hashtable;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            double d;
            String string = stringArray[i];
            double d2 = dArray[i][0];
            double d3 = dArray[i][1];
            double d4 = dArray[i][2];
            double d5 = dArray[i][3];
            double d6 = 0.0;
            if (d2 > 0.0) {
                d6 += d2;
            }
            if (d3 > 0.0) {
                d6 += d3;
            }
            if ((d = 0.0) > 0.0) {
                d += d4;
            }
            if (d5 > 0.0) {
                d += d5;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d4));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d));
            hashtable.put(string, arrayList);
        }
        return hashtable;
    }

    public void stopTest1() {
        if (this.egJNIUtil != null) {
            this.egJNIUtil.stop();
        }
        this.egJNIUtil = null;
    }

    private void getOSName() {
        this.isWindows2008 = false;
        String string = "";
        if (!this.meAgentless) {
            string = System.getProperties().getProperty("os.name");
            String string2 = null;
            WindowsOsHelper windowsOsHelper = new WindowsOsHelper(this.reportingName, this.meAgentless);
            string2 = windowsOsHelper.setOs();
            if (string2 != null && string2.trim().length() > 0) {
                string = string2;
            }
        } else {
            this.checkNbt();
            if (this.nbtName != null && this.nbtName.length() > 0) {
                WindowsOsHelper windowsOsHelper = new WindowsOsHelper(this.nbtName, this.reportingName, this.meAgentless);
                string = windowsOsHelper.setOs();
            }
        }
        if (string.indexOf("2008") > -1 || string.toLowerCase().indexOf("vista") >= 0 || string.toLowerCase().indexOf("windows 7") >= 0) {
            this.isWindows2008 = true;
        }
    }
}

