/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SPOSiteConnectivityTest
extends GenericTest {
    O365Util o365util = O365Util.getInstance();
    String O365_user = "";
    String password = "";
    String O365_domain = "";
    String domainUser = "";
    String domainPwd = "";
    String domainName = "";
    String[] spoUrl = null;
    String[] valString = null;
    String proxyUsr = "";
    String proxyPass = "";
    String proxyHst = "";
    String proxyPrt = "";
    HashMap infoMap = null;

    public SPOSiteConnectivityTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        this.O365_domain = "";
        this.O365_user = this.getValueForParam("O365_User_Name");
        this.password = this.getValueForParam("O365_Password");
        this.domainUser = this.getValueForParam("Domain_User_Name");
        this.domainPwd = this.getValueForParam("Domain_Password");
        this.domainName = this.getValueForParam("Domain_Name");
        String string2 = this.getValueForParam("SITE_URLs");
        if (string2 != null && string2 != "") {
            this.spoUrl = string2.split(",");
        }
        if ((string = this.getValueForParam("validity_string")) != "" && string != null) {
            this.valString = string.split(",");
        }
        this.proxyHst = this.getValueForParam("Proxy_Host");
        this.proxyPrt = this.getValueForParam("Proxy_Port");
        this.proxyUsr = this.getValueForParam("Proxy_User_Name");
        this.proxyPass = this.getValueForParam("Proxy_Password");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string;
            String string2;
            Header[] headerArray;
            BasicHttpParams basicHttpParams;
            O365SSLSocketFactory o365SSLSocketFactory;
            Object object;
            if (this.O365_domain == null || this.O365_domain.equals("")) {
                this.O365_domain = this.o365util.getInitialDomain(this.O365_user, this.password, this.domainUser, this.domainPwd, this.domainName, this.proxyUsr, this.proxyPass, this.proxyHst, this.proxyPrt);
                if (this.O365_domain.length() == 0) {
                    this.logToErrorFile("ERROR", this.entity, "SPOSiteConnectivityTest - Please check the o365 credentials");
                    return;
                }
            }
            String string3 = "";
            String string4 = "";
            String string5 = "";
            int n = 0;
            try {
                string3 = this.requestToken();
                n = string3 != null && string3 != "" ? 200 : 700;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", "", "Error Occured in SPOSiteConnectivityTest - Token generation2 " + exception);
            }
            DefaultHttpClient defaultHttpClient = null;
            try {
                object = KeyStore.getInstance(KeyStore.getDefaultType());
                ((KeyStore)object).load(null, null);
                o365SSLSocketFactory = new O365SSLSocketFactory((KeyStore)object);
                o365SSLSocketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                basicHttpParams = new BasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)basicHttpParams, (String)"UTF-8");
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                schemeRegistry.register(new Scheme("https", (SocketFactory)o365SSLSocketFactory, 443));
                headerArray = new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
                defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)headerArray, (HttpParams)basicHttpParams);
            }
            catch (Exception exception) {
                defaultHttpClient = new DefaultHttpClient();
            }
            if (!this.proxyHst.toLowerCase().equals("none") && !this.proxyPrt.toLowerCase().equals("none")) {
                try {
                    if (!this.proxyUsr.toLowerCase().equals("none") && !this.proxyPass.toLowerCase().equals("none")) {
                        defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(this.proxyUsr, this.proxyPass));
                        object = new HttpHost(this.proxyHst, Integer.parseInt(this.proxyPrt));
                        defaultHttpClient.getParams().setParameter("http.route.default-proxy", object);
                    } else {
                        object = new HttpHost(this.proxyHst, Integer.parseInt(this.proxyPrt));
                        defaultHttpClient.getParams().setParameter("http.route.default-proxy", object);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.logToErrorFile("ERROR", this.entity, "Error Occured in o365LoginTest -[proxy credentials]" + exception);
                }
            }
            object = "https://" + this.O365_domain + ".sharepoint.com/_forms/default.aspx?wa=wsignin1.0";
            o365SSLSocketFactory = new HttpPost((String)object);
            o365SSLSocketFactory.setHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Win64; x64; Trident/5.0)");
            o365SSLSocketFactory.setHeader("Host", this.O365_domain + ".sharepoint.com");
            o365SSLSocketFactory.setHeader("Content-Type", "application/x-www-form-urlencoded");
            o365SSLSocketFactory.setEntity((HttpEntity)new StringEntity(string3));
            basicHttpParams = defaultHttpClient.execute((HttpUriRequest)o365SSLSocketFactory);
            EntityUtils.toString((HttpEntity)basicHttpParams.getEntity());
            int n2 = basicHttpParams.getStatusLine().getStatusCode();
            headerArray = basicHttpParams.getAllHeaders();
            for (int i = 0; i < headerArray.length; ++i) {
                string2 = headerArray[i].getName();
                string = headerArray[i].getValue();
                if (string2.indexOf("Set-Cookie") <= -1) continue;
                if (string.indexOf("rtFa=") > -1) {
                    string4 = string;
                }
                if (string.indexOf("FedAuth=") <= -1) continue;
                string5 = string;
            }
            String string6 = "https://" + this.O365_domain + ".sharepoint.com/_api/contextinfo";
            string2 = new HttpPost(string6);
            string2.setHeader("Cookie", string4);
            string2.setHeader("Cookie", string5);
            string = defaultHttpClient.execute((HttpUriRequest)string2);
            int n3 = string.getStatusLine().getStatusCode();
            String string7 = EntityUtils.toString((HttpEntity)string.getEntity());
            if (string7.indexOf("<d:FormDigestValue>") > -1) {
                string7.substring(string7.indexOf("<d:FormDigestValue>") + 19, string7.indexOf("</d:FormDigestValue>"));
            }
            if (n == 200 && n2 == 302 && n3 == 200 && this.spoUrl.length > 0) {
                this.infoMap = this.getSiteInfoDtls(this.spoUrl, this.valString, defaultHttpClient);
                for (Map.Entry entry : this.infoMap.entrySet()) {
                    String string8 = entry.getKey().toString();
                    ArrayList arrayList = (ArrayList)entry.getValue();
                    this.addNewMeasure(string8, arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("ERROR", this.entity, "Error Occured in ExoLoginTest" + exception);
        }
    }

    private HashMap getSiteInfoDtls(String[] stringArray, String[] stringArray2, DefaultHttpClient defaultHttpClient) {
        HashMap hashMap = new HashMap();
        try {
            for (int i = 0; i < this.spoUrl.length; ++i) {
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = 0.0;
                double d6 = -5.0;
                double d7 = -5.0;
                double d8 = -5.0;
                String string = this.spoUrl[i];
                String[] stringArray3 = string.split(":");
                if (stringArray3.length > 2) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string2 = string.substring(0, string.indexOf(":"));
                    String string3 = string.substring(string.indexOf(":") + 1, string.length());
                    String string4 = "";
                    if (this.spoUrl.length == this.valString.length) {
                        string4 = this.valString[i];
                    } else if (this.valString.length == 1) {
                        string4 = this.valString[0];
                    } else {
                        this.logToErrorFile("ERROR", this.entity, "validation String length mismatch with url length" + Arrays.toString(this.valString));
                    }
                    try {
                        Object[] objectArray;
                        CloseableHttpResponse closeableHttpResponse = null;
                        HttpPost httpPost = new HttpPost(string3);
                        httpPost.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.115 Safari/537.36");
                        try {
                            long l = System.currentTimeMillis();
                            closeableHttpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                            d = System.currentTimeMillis() - l;
                            objectArray = closeableHttpResponse.getAllHeaders();
                            for (int j = 0; j < objectArray.length; ++j) {
                                String string5 = objectArray[j].getName();
                                String string6 = objectArray[j].getValue();
                                if (string5.equals("X-SharePointHealthScore")) {
                                    d6 = Double.parseDouble(string6.trim());
                                }
                                if (string5.equals("SPRequestDuration")) {
                                    d7 = Double.parseDouble(string6.trim());
                                }
                                if (!string5.equals("SPIisLatency")) continue;
                                d8 = Double.parseDouble(string6.trim());
                            }
                        }
                        catch (HttpHostConnectException httpHostConnectException) {
                            arrayList.add(new Double(d5));
                            arrayList.add(new Double(d2));
                            arrayList.add(new Double(d));
                            arrayList.add(new Double(d3));
                            arrayList.add(new Double(d4));
                            if (this.measureCount > 5) {
                                arrayList.add(d6);
                                arrayList.add(d7);
                                arrayList.add(d8);
                            }
                            httpHostConnectException.printStackTrace();
                            hashMap.put(string2, arrayList);
                            return hashMap;
                        }
                        catch (UnknownHostException unknownHostException) {
                            unknownHostException.printStackTrace();
                            arrayList.add(new Double(d5));
                            arrayList.add(new Double(d2));
                            arrayList.add(new Double(d));
                            arrayList.add(new Double(d3));
                            arrayList.add(new Double(d4));
                            if (this.measureCount > 5) {
                                arrayList.add(d6);
                                arrayList.add(d7);
                                arrayList.add(d8);
                            }
                            hashMap.put(string2, arrayList);
                            return hashMap;
                        }
                        HttpEntity httpEntity = null;
                        if (closeableHttpResponse != null) {
                            httpEntity = closeableHttpResponse.getEntity();
                            d2 = closeableHttpResponse.getStatusLine().getStatusCode();
                        }
                        if (d2 == 200.0 || d2 == 0.0 || d2 > 300.0 && d2 < 400.0) {
                            d5 = 100.0;
                            if (httpEntity != null) {
                                String string7 = EntityUtils.toString((HttpEntity)httpEntity);
                                if (string4 != "") {
                                    d3 = string7.indexOf(string4) > -1 ? 100.0 : 0.0;
                                }
                                objectArray = string7.getBytes("UTF-8");
                                d4 = new Double(objectArray.length) / 1000.0;
                            }
                        }
                        arrayList.add(new Double(d5));
                        arrayList.add(new Double(d2));
                        arrayList.add(new Double(SPOSiteConnectivityTest.getDecimalPoint(d / 1000.0)));
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(d4));
                        if (this.measureCount > 5) {
                            arrayList.add(d6);
                            if (d7 != -5.0) {
                                arrayList.add(SPOSiteConnectivityTest.getDecimalPoint(d7 / 1000.0));
                            }
                            if (d7 != -5.0) {
                                arrayList.add(SPOSiteConnectivityTest.getDecimalPoint(d8 / 1000.0));
                            }
                        }
                        EntityUtils.consume((HttpEntity)httpEntity);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        arrayList.add(new Double(d5));
                        arrayList.add(new Double(d2));
                        arrayList.add(new Double(d));
                        arrayList.add(new Double(d3));
                        arrayList.add(new Double(d4));
                        if (this.measureCount > 5) {
                            arrayList.add(d6);
                            arrayList.add(d7);
                            arrayList.add(d8);
                        }
                        hashMap.put(string2, arrayList);
                        return hashMap;
                    }
                    hashMap.put(string2, arrayList);
                    continue;
                }
                this.logToErrorFile("ERROR", this.entity, "URL format of input is Inccorect " + stringArray3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("ERROR", this.entity, "Exception Occured in SPOSiteConnectivityTest and the Exception is " + exception);
        }
        return hashMap;
    }

    private String extractToken(String string) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        String string2 = xPath.evaluate("//BinarySecurityToken/text()", document.getDocumentElement());
        return string2;
    }

    private String requestToken() throws XPathExpressionException, SAXException, ParserConfigurationException, IOException {
        String string = "";
        URLConnection uRLConnection = null;
        String string2 = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:a=\"http://www.w3.org/2005/08/addressing\" xmlns:u=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><s:Header><a:Action s:mustUnderstand=\"1\">http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Issue</a:Action><a:ReplyTo><a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address></a:ReplyTo><a:To s:mustUnderstand=\"1\">https://login.microsoftonline.com/extSTS.srf</a:To><o:Security s:mustUnderstand=\"1\" xmlns:o=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"><o:UsernameToken><o:Username>" + this.O365_user + "</o:Username><o:Password>" + this.password + "</o:Password></o:UsernameToken></o:Security></s:Header><s:Body><t:RequestSecurityToken xmlns:t=\"http://schemas.xmlsoap.org/ws/2005/02/trust\"><wsp:AppliesTo xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\"><a:EndpointReference><a:Address>https://" + this.O365_domain + "-admin.sharepoint.com</a:Address></a:EndpointReference></wsp:AppliesTo><t:KeyType>http://schemas.xmlsoap.org/ws/2005/05/identity/NoProofKey</t:KeyType><t:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Issue</t:RequestType><t:TokenType>urn:oasis:names:tc:SAML:1.0:assertion</t:TokenType></t:RequestSecurityToken></s:Body></s:Envelope>";
        URL uRL = new URL("https://login.microsoftonline.com/extSTS.srf");
        try {
            int n;
            Object object;
            if (!this.proxyHst.toLowerCase().equals("none") && !this.proxyPrt.toLowerCase().equals("none")) {
                if (!this.proxyUsr.toLowerCase().equals("none") && !this.proxyPass.toLowerCase().equals("none")) {
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                    Authenticator.setDefault(this.o365util.getAuthenticator(this.proxyHst, this.proxyPrt, this.proxyUsr, this.proxyPass));
                    int n2 = Integer.parseInt(this.proxyPrt);
                    object = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHst, n2));
                    uRLConnection = uRL.openConnection((Proxy)object);
                } else {
                    Properties properties = System.getProperties();
                    properties.setProperty("https.proxySet", "true");
                    properties.setProperty("https.proxyHost", this.proxyHst);
                    properties.setProperty("https.proxyPort", this.proxyPrt);
                    uRLConnection = uRL.openConnection();
                }
            } else {
                uRLConnection = uRL.openConnection();
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.addRequestProperty("Content-Type", "text/xml; charset=utf-8");
            object = httpURLConnection.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object);
            outputStreamWriter.write(string2);
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
            InputStream inputStream = httpURLConnection.getInputStream();
            StringBuilder stringBuilder = new StringBuilder("");
            while ((n = inputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            inputStream.close();
            String string3 = stringBuilder.toString();
            string = this.extractToken(string3);
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR", "", "Error Occured in SPOSiteConnectivityTest - Token generation1 " + exception);
        }
        return string;
    }

    public static double getDecimalPoint(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
        numberFormat.setMaximumFractionDigits(2);
        return Double.parseDouble(numberFormat.format(d));
    }

    public void freeTest() {
        this.infoMap = null;
    }
}

