﻿
clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy


$testargs=$args
$Rptcrds=$testargs[4].split("#")
$reportingname='MTM/'+$Rptcrds[0]
$testFrequency=$Rptcrds[1]

try{


    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "MTMdAuditOper" -keyFileName "kMTMdAuditOper" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
    $usractivites= import-csv $csvfile
    Remove-Item $csvfile       
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'MTMdAuditOper' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kMTMdAuditOper' -InputFile $readfiles[4]
    Write-Host "ReadFile:"$readfiles[3]

    }
    catch [System.Management.Automation.RuntimeException] {
        Write-Error -Message "File not found. The $reportingname location does not contain MTM usr Activities files."
    }
    catch{
        $errmsg=$_.Exception.Message
        $errstack=$_.Exception.StackTrace
        Write-Error -Message $errmsg
    }

$botsAdditnCnt=0
$botsRemvedCnt=0
$chanlsAddtionCnt=0
$chanlsDeltionsCnt=0
$teamCreatedCnt=0
$CnnctorAddsToChnlCnt=0
$TabAddedtoChnlCnt=0
$ConnctorRmvdToChnlCnt=0
$TabRmvedtoChnlCnt=0
$ConnctorModifdInChnlCnt=0
$TabModifdInChnlCnt=0

    foreach($input in $usractivites)
    {
        $operation=$input.Operations
        $auditdata=$input.AuditData | ConvertFrom-Json
        $auditdata.CreationTime=($auditdata.CreationTime).Replace("T"," ")
        $usertype=[int]$auditdata.UserType
        if($usertype -eq 0) { $auditdata.UserType ="Regular user" }
        if($usertype -eq 2) { $auditdata.UserType ="Administrator" }
        if($usertype -eq 3) { $auditdata.UserType ="Microsoft datacenter administrator" }
        if($usertype -eq 4) { $auditdata.UserType ="System Account" }
        if($usertype -eq 5) { $auditdata.UserType ="An Application" }
        if($usertype -eq 6) { $auditdata.UserType ="Service principal" }
        if($usertype -eq 7) { $auditdata.UserType ="Custom policy" }
        if($usertype -eq 8) { $auditdata.UserType ="System policy" }

        if($operation -eq 'BotAddedToTeam')
        { 
            Write-Host 'BotAddedToTeamdd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~' $empty '~!~'$auditdata.AddOnName'~!~' $auditdata.UserId'~!~'$auditdata.UserType '~!~'$auditdata.TeamGuid'~!~' $empty '~!~'$auditdata.AddOnGuid
            $botsAdditnCnt++
        }        

        if($operation -eq 'ChannelAdded')
        {
            Write-Host 'ChannelAddeddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName'~!~' $empty '~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid
            $chanlsAddtionCnt++           
        }
        
        if($operation -eq 'ChannelDeleted')
        {
            Write-Host 'ChannelDeleteddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName'~!~' $empty '~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid
            $chanlsDeltionsCnt++
        }
        
        if($operation -eq 'BotRemovedFromTeam')
        {
            Write-Host 'BotRemovedFromTeamdd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~' $empty '~!~'$auditdata.AddOnName'~!~' $auditdata.UserId'~!~'$auditdata.UserType '~!~'$auditdata.TeamGuid'~!~' $empty '~!~'$auditdata.AddOnGuid
            $botsRemvedCnt++
        }
        
        if($operation -eq 'TeamCreated')
        {
            Write-Host 'TeamCreateddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~' $empty '~!~' $empty '~!~'$auditdata.UserId  '~!~'$auditdata.UserType '~!~'$auditdata.TeamGuid
            $teamCreatedCnt++
        }
       
        if($operation -eq 'ConnectorAdded')
        {
            Write-Host 'ConnectorAddeddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName '~!~'$auditdata.AddOnName'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid'~!~'$auditdata.AddOnGuid
            $CnnctorAddsToChnlCnt++
        }

        if($operation -eq 'TabAdded')
        {
            Write-Host 'TabAddeddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName'~!~'$auditdata.TabType'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid'~!~'$auditdata.AddOnGuid
            $TabAddedtoChnlCnt++
        }

        if($operation -eq 'ConnectorRemoved')
        {
          Write-Host 'ConnectorRemoved#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName '~!~'$auditdata.AddOnName'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid'~!~'$auditdata.AddOnGuid
            $ConnctorRmvdToChnlCnt++
        }

        if($operation -eq 'TabRemoved')
        {
            Write-Host 'TabRemoveddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName'~!~'$auditdata.TabType'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid'~!~'$auditdata.AddOnGuid
            $TabRmvedtoChnlCnt++
        }
        
        if($operation -eq 'TabUpdated')
        {
        #"ExtraProperties":[{"Key":"OldAddOnGuid","Value":"f02fddc9-159a-4d58-9800-d94c4f64bfe8"},{"Key":"OldAddOnType","Value":"Tab"},{"Key":"OldTabType","Value":"extension"},{"Key":"OriginEnvironment","Value":"ProdASSE-02"}],
            foreach($keyvalue in $auditdata.ExtraProperties)
            {
                if($keyvalue.key -eq "OldAddOnGuid"){$OldAddOnGuid = $keyvalue.Value}
                if($keyvalue.key -eq "OldTabType"){$OldTabType = $keyvalue.Value}
            }
            Write-Host 'TabUpdateddd#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName'~!~'$auditdata.TabType'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid'~!~'$auditdata.AddOnGuid'~!~' $OldAddOnGuid '~!~' $OldTabType
            $TabModifdInChnlCnt++
        }
       
        if($operation -eq 'ConnectorUpdated')
        {
            Write-Host 'ConnectorUpdated#'$auditdata.CreationTime'~!~'$auditdata.TeamName'~!~'$auditdata.ChannelName '~!~'$auditdata.AddOnName'~!~'$auditdata.UserId'~!~'$auditdata.UserType'~!~'$auditdata.TeamGuid'~!~'$auditdata.ChannelGuid'~!~'$auditdata.AddOnGuid
            $ConnctorModifdInChnlCnt++
        }

    }
 Write-host 'measures'$botsAdditnCnt ~ $botsRemvedCnt ~ $chanlsAddtionCnt ~ $chanlsDeltionsCnt ~ $teamCreatedCnt ~ $CnnctorAddsToChnlCnt ~ $TabAddedtoChnlCnt ~ $ConnctorRmvdToChnlCnt ~ $TabRmvedtoChnlCnt ~ $ConnctorModifdInChnlCnt ~ $TabModifdInChnlCnt
