/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;

public class GeoLocationInfoMgrThread
extends Thread {
    private ArrayList ipAddressList = null;
    private HttpURLConnection urlCon = null;
    private URL url = null;
    private ObjectOutputStream outputToServlet = null;
    public Hashtable geoDetailsHash = new Hashtable();

    public GeoLocationInfoMgrThread(ArrayList arrayList) {
        this.ipAddressList = arrayList;
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
            this.url = new URL(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.geoLocationInformation");
            this.urlCon = this.getConnection(this.url);
            if (this.urlCon != null) {
                this.outputToServlet = new ObjectOutputStream(this.urlCon.getOutputStream());
                if (this.outputToServlet != null) {
                    this.outputToServlet.writeObject("agent");
                    this.outputToServlet.writeObject(this.ipAddressList);
                    this.outputToServlet.flush();
                    this.outputToServlet.close();
                    ConnectionThread connectionThread = new ConnectionThread(this.urlCon, true);
                    int n = 0;
                    boolean bl = GeoLocationInfoMgrThread.checkForTimeout(connectionThread);
                    if (bl) {
                        n = connectionThread.code;
                        ArrayList arrayList = connectionThread.data;
                        if (arrayList != null && arrayList.size() > 0) {
                            this.geoDetailsHash = (Hashtable)arrayList.get(0);
                        }
                    }
                    connectionThread = null;
                    this.urlCon.disconnect();
                    this.urlCon = null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("[GeoLocationInfoMgrThread] Manager could not be contacted...");
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.outputToServlet != null) {
                    this.outputToServlet.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection getConnection(URL uRL) {
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            httpURLConnection.setRequestProperty("Content-length", "0");
            if (EgMainAgent.isProxySet) {
                if (EgMainAgent.isAuthenticationRequired) {
                    httpURLConnection.setRequestProperty("Proxy-Authorization", this.encode(EgMainAgent.proxyUsername, EgMainAgent.proxyPassword));
                }
            }
        }
        catch (Exception exception) {
            httpURLConnection = null;
            String string = EgMainAgent.controlSync;
            synchronized (string) {
                EgMainAgent.controlMode = false;
            }
            System.out.println("[GeoLocationInfoMgrThread] Unable to connect to the host ... ");
            exception.printStackTrace();
        }
        finally {
            return httpURLConnection;
        }
    }

    public String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString((String)string3);
        return "Basic " + string4;
    }

    private static boolean checkForTimeout(ConnectionThread connectionThread) {
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l = EgConfigInfo.getResponseCodeTimeout / 2L;
        long l2 = 0L;
        long l3 = 250L;
        while (true) {
            GeoLocationInfoMgrThread.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            long l4 = l3;
            if (l - l2 < l4) {
                l4 = l - l2;
            }
            l3 = l4;
        }
    }

    private static void suspendForPeriod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Hashtable getGeoDetails() {
        if (this.geoDetailsHash != null) {
            return (Hashtable)this.geoDetailsHash.clone();
        }
        return new Hashtable();
    }
}

