/*
 * Decompiled with CFR 0.152.
 */
import com.eg.BlockedThreadFinder;
import com.eg.IniFile;
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;

public class MainAgentHelper
extends Thread {
    ArrayList perfObjs = new ArrayList();
    boolean doPerfmonCheck = false;
    ArrayList perfCounters = new ArrayList();
    boolean recoveryStarted = false;
    public long stampPeriod = 5L * EgConfigInfo.msecPerMin;
    private long prev_stamp = 0L;
    private boolean toRestart = false;
    private long lastIpCheckTime = System.currentTimeMillis();
    private long ipCheckTimeout = 2L * EgConfigInfo.msecPerHour;
    private static EgJNIUtil egPerfUtil = null;
    private boolean isInit = false;
    private static boolean currentDebug = false;
    private static String debugIni = null;
    private static boolean isFirstTime = true;
    private static boolean is64BitAgent = false;
    public static boolean isJsMaxMem = false;
    private static int xmxValue = 128;
    public static String debugSync = new String("debugSync");
    private double JsHandle = 0.0;
    private static boolean XmxChangedForRemoteAgent = false;

    public MainAgentHelper() {
    }

    public MainAgentHelper(boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        this.doPerfmonCheck = bl;
        this.perfObjs = arrayList;
        this.perfCounters = arrayList2;
        this.isInit = true;
    }

    private boolean hasIpChanged() {
        String[] stringArray = EgMainAgent.getIpAddressesOfHost();
        if (stringArray == null && EgMainAgent.ipAddresses != null) {
            return false;
        }
        if (EgMainAgent.ipAddresses == null && stringArray != null) {
            return false;
        }
        if (stringArray.length != EgMainAgent.ipAddresses.length) {
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses has been changed!. IP Addresses of Host length is " + stringArray.length + " EgMainAgent IP Addresses length is " + EgMainAgent.ipAddresses.length);
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses of Host is " + new ArrayList<String>(Arrays.asList(stringArray)).toString());
            this.logToErrorFile("WARN", "MainAgentHelper", "EgMainAgent IP Addresses is " + new ArrayList<String>(Arrays.asList(EgMainAgent.ipAddresses)).toString());
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < EgMainAgent.ipAddresses.length; ++j) {
                if (!EgMainAgent.ipAddresses[j].equals(stringArray[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses could not find!. IP Addresses of Host length is " + stringArray.length + " EgMainAgent IP Addresses length is " + EgMainAgent.ipAddresses.length);
            this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses of Host is " + new ArrayList<String>(Arrays.asList(stringArray)).toString());
            this.logToErrorFile("WARN", "MainAgentHelper", "EgMainAgent IP Addresses is " + new ArrayList<String>(Arrays.asList(EgMainAgent.ipAddresses)).toString());
            return true;
        }
        return false;
    }

    private boolean checkPerfmon() {
        boolean bl = true;
        if (this.perfObjs == null || this.perfObjs.size() == 0 || this.perfObjs.size() != this.perfCounters.size()) {
            return true;
        }
        for (int i = 0; i < this.perfObjs.size(); ++i) {
            bl = false;
            String string = (String)this.perfObjs.get(i);
            String string2 = (String)this.perfCounters.get(i);
            String[] stringArray = EgJNIUtil.discoverInstances((String)string);
            if (stringArray == null || stringArray.length == 0) {
                this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed to get instances for object " + string + " counter " + string2);
                return false;
            }
            if (string.equalsIgnoreCase("Process")) continue;
            egPerfUtil = new EgJNIUtil();
            String[] stringArray2 = new String[]{string2};
            double[][] dArray = egPerfUtil.getCounterValue(string, stringArray, stringArray2);
            if (egPerfUtil != null) {
                egPerfUtil.stop();
            }
            egPerfUtil = null;
            if (dArray == null) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed for the object " + string + " instances " + arrayList.toString());
                this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed for the object " + string + " counter " + string2);
                return false;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (!(dArray[j][0] >= 0.0)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.logToErrorFile("WARN", "MainAgentHelper", "Perfmon check failed to get valid values for object " + string + " counter " + string2);
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCurrentLocalTime(long l) {
        long l2 = System.currentTimeMillis();
        Object object = EgMainAgent.syncMgrUpload;
        synchronized (object) {
            if (EgMainAgent.mgrUpload != null) {
                long l3 = l2 - EgMainAgent.mgrUpload.lastUpdated;
                System.out.println("MgrUpload check currentTime " + new Date(l2) + " last updated " + new Date(EgMainAgent.mgrUpload.lastUpdated) + l3);
                if (l3 >= EgConfigInfo.msecPerMin * 20L) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            EgMainAgent.mgrUpload.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(2000L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        EgMainAgent.mgrUpload.stop();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println("To restart MgrUpload at ... " + new Date());
                    EgMainAgent.mgrUpload = new EgMgrUpload(EgMainAgent.me);
                    System.out.println("After restart MgrUpload at ... " + new Date());
                }
            } else {
                System.out.println("To start MgrUpload at ... " + new Date());
                EgMainAgent.mgrUpload = new EgMgrUpload(EgMainAgent.me);
                System.out.println("After start MgrUpload at ... " + new Date());
            }
        }
        try {
            object = new Properties();
            File file = new File(EgInstallInfo.getInstallDir() + "/agent/config/eg_recover.ini");
            if (!file.exists()) {
                file.createNewFile();
            }
            ((Properties)object).setProperty("CurrentTime", "" + l);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((Properties)object).store(fileOutputStream, null);
            fileOutputStream.close();
            file = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void startRecovery() {
        System.out.println("Starting the recovery Process");
        try {
            String string = "net start eGAgentmon";
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(string);
        }
        catch (Exception exception) {
            System.out.println("Failed to start eGurkha Agent self monitor!");
        }
    }

    public void run() {
        while (true) {
            this.doWork();
            this.sleepFor(this.stampPeriod);
        }
    }

    public void doWork() {
        long l;
        if (!this.isInit) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (EgMainAgent.hasChgMgrIPorDNSRestartRequired) {
            l = EgMgrUpload.lastSuccessfulUploadTime;
            long l3 = EgMgrUpload.lastUploadAttemptTime;
            long l4 = EgMainAgent.hasChgMgrIPorDNSRestartRequiredTime;
            if (l4 > 0L && l2 - l > l4 && l2 - l3 < l4) {
                this.toRestart = true;
                this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                this.logToErrorFile("WARN", "MainAgentHelper", "Agent does not detect the IP Addresses or DNS name during migration. So restart the eGAgent");
            }
        }
        if (l2 - this.lastIpCheckTime >= this.ipCheckTimeout) {
            if (!this.toRestart && EgMainAgent.hasIPChangedToRestartAgent && this.hasIpChanged()) {
                this.toRestart = true;
                this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                this.logToErrorFile("WARN", "MainAgentHelper", "IP Addresses has been changed!. So restart the eGAgent");
            }
            this.lastIpCheckTime = System.currentTimeMillis();
        }
        if (!this.toRestart && EgMainAgent.isRunningWinpcap && EgMainAgent.winpCapRestart > 0L && l2 - EgMainAgent.agentStartTime > EgMainAgent.winpCapRestart) {
            this.toRestart = true;
            this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
            this.logToErrorFile("WARN", "MainAgentHelper", "WinPcap restart!. So restart the eGAgent");
        }
        if (!this.toRestart && EgMainAgent.vSphereFailureRestartRequired) {
            try {
                if (Vm25Connection.needToRestartAgent) {
                    Vm25Connection.needToRestartAgent = false;
                    this.toRestart = true;
                    this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                    this.logToErrorFile("WARN", "MainAgentHelper", "vSphere connection LockMap issue. So restart the eGAgent");
                }
                if (!this.toRestart) {
                    Hashtable hashtable = VmEsx3iBaseReal.ht_vSphereURLSuccessTime;
                    Hashtable hashtable2 = VmEsx3iBaseReal.ht_vSphereURLActiveTime;
                    this.toRestart = this.isAnyVsphereMonitoringFailed(hashtable, hashtable2);
                    if (this.toRestart) {
                        this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                        this.logToErrorFile("WARN", "MainAgentHelper", "vSphere monitoring - performance metrics are not collected. So restart the eGAgent");
                    } else {
                        hashtable = EsxDiskUsageRealTest.ht_vSphereURLSuccessTime;
                        hashtable2 = EsxDiskUsageRealTest.ht_vSphereURLActiveTime;
                        this.toRestart = this.isAnyVsphereMonitoringFailed(hashtable, hashtable2);
                        if (this.toRestart) {
                            this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                            this.logToErrorFile("WARN", "MainAgentHelper", "vSphere monitoring - datastore metrics are not collected. So restart the eGAgent");
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.toRestart && EgMainAgent.maxJvmThreadBlockedCount > 0 && EgMainAgent.jvmBlockedThreadRestartRequired && this.isMaxThreadBlockedReached(EgMainAgent.maxJvmThreadBlockedCount)) {
            this.toRestart = true;
            this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
            this.logToErrorFile("WARN", "MainAgentHelper", "eGAgent has reached the maximum java thread blocked count!. So restart the eGAgent");
        }
        if ((l = System.currentTimeMillis()) - this.prev_stamp >= this.stampPeriod) {
            try {
                if (!(this.doPerfmonCheck && !this.checkPerfmon() || this.toRestart)) {
                    this.writeCurrentLocalTime(l);
                }
                this.prev_stamp = l;
                if (!this.recoveryStarted) {
                    this.startRecovery();
                    this.recoveryStarted = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (EgMainAgent.isRemoteAgent && EgMainAgent.remoteAgentXmxChangeRequired) {
            boolean bl = false;
            String string = System.getProperty("os.name").toLowerCase();
            if (string.startsWith("win") || string.startsWith("microsoft") || string.indexOf("win") > 0) {
                bl = true;
            }
            if (!XmxChangedForRemoteAgent && bl) {
                int n = 128;
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                List<String> list = runtimeMXBean.getInputArguments();
                if (list == null || list.size() == 0) {
                    n = 128;
                } else {
                    String string2 = "";
                    for (int i = 0; i < list.size(); ++i) {
                        string2 = list.get(i);
                        if ((string2 = string2.toLowerCase()).indexOf("-xmx") >= 0) {
                            string2 = string2.substring(4);
                            string2 = string2.trim();
                            string2 = string2.substring(0, string2.length() - 1);
                            break;
                        }
                        System.err.println(new Date() + " : {mainAgentHelper} ss continue =" + string2);
                    }
                    try {
                        string2 = string2.trim();
                        n = Integer.parseInt(string2);
                    }
                    catch (Exception exception) {
                        n = 128;
                    }
                }
                int n2 = 0;
                if (n <= 1024) {
                    n2 = this.getNewXmxValue();
                }
                EgUtilities egUtilities = EgUtilities.createInstance();
                if (n2 > n) {
                    this.setNewXmxForRemoteAgent(n, n2);
                    XmxChangedForRemoteAgent = true;
                    this.toRestart = true;
                    this.writeCurrentLocalTime(l2 - EgConfigInfo.msecPerMin * 15L);
                    this.logToErrorFile("WARN", "MainAgentHelper", "Xmx setting changed for this remote agent. So restart the eGAgent");
                }
                XmxChangedForRemoteAgent = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForDebugOnOff() {
        boolean bl;
        String string = "";
        String string2 = debugSync;
        synchronized (string2) {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_output.ini");
            string = iniFile.getValue("OUTPUT", "Output");
        }
        boolean bl2 = bl = string != null && (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("y") || string.equalsIgnoreCase("t"));
        if (currentDebug) {
            if (!bl) {
                MainAgentHelper.setDebugOff();
            }
        } else if (bl) {
            MainAgentHelper.setDebugOn();
        } else {
            MainAgentHelper.setDebugOff();
        }
    }

    public static synchronized boolean setDebugOff() {
        currentDebug = false;
        return EgAgentLogController.setDebugOff();
    }

    public static synchronized boolean setDebugOn() {
        currentDebug = true;
        return EgAgentLogController.setDebugOn();
    }

    private void sleepFor(long l) {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (l3 > 0L) {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            } else if (l3 > EgAgentCommon.maxSleep) {
                l3 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            l3 = l2 - l4;
        }
    }

    private void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        try {
            printWriter = new PrintWriter(new FileWriter(EgConfigInfo.egAgentErrorFile, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    private boolean getAgentOsArch() {
        boolean bl = false;
        String string = System.getProperty("os.arch");
        bl = string != null && string.length() > 0 ? !(string = string.trim()).equalsIgnoreCase("x86") : false;
        return bl;
    }

    private double getJsMemory() {
        double d = 0.0;
        String string = "Process";
        String[] stringArray = new String[]{"Working Set", "Handle Count"};
        String[] stringArray2 = new String[]{"jsn"};
        EgJNIUtil egJNIUtil = new EgJNIUtil();
        double[][] dArray = egJNIUtil.getCounterValue(string, stringArray2, stringArray);
        if (egJNIUtil != null) {
            egJNIUtil.stop();
        }
        if (dArray == null || dArray.length == 0) {
            return d;
        }
        d = dArray[0][0];
        this.JsHandle = dArray[0][1];
        if (d > 0.0) {
            d /= 1048576.0;
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setJsMaxMemory() {
        if (isFirstTime) {
            isFirstTime = false;
            is64BitAgent = true;
            if (!is64BitAgent) return;
            String string = EgInstallInfo.getInstallDir() + "\\lib\\RunAgent.bat";
            File file = new File(new String(string));
            if (!file.exists()) return;
            xmxValue = this.getXmxValue();
        }
        if (is64BitAgent && EgMainAgent.isRestartAgent) {
            double d;
            double d2 = this.getJsMemory();
            if (d2 > (d = (double)xmxValue + (double)(xmxValue * EgMainAgent.agentRestartMemoryPct) / 100.0)) {
                isJsMaxMem = true;
                this.logToErrorFile("WARN", "MainAgentHelper", "Configured Memory of jsn is " + d2 + " Current Memory of jsn is " + d);
                return;
            } else {
                isJsMaxMem = false;
            }
            return;
        } else {
            isJsMaxMem = false;
        }
    }

    private int getXmxValue() {
        String string;
        int n;
        block9: {
            n = 0;
            String string2 = null;
            string2 = EgInstallInfo.getInstallDir() + "/lib/RunAgent.bat";
            string = "128";
            if (string2 != null) {
                try {
                    File file = new File(string2);
                    if (file.exists() && file.isFile() && file.canRead()) {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        String string3 = "";
                        while ((string3 = bufferedReader.readLine()) != null) {
                            if ((string3 = string3.toLowerCase()).indexOf("-xmx") < 0) continue;
                            int n2 = string3.indexOf("-xmx");
                            if ((string3 = string3.substring(n2)).indexOf(" ") > -1) {
                                int n3 = string3.indexOf(" ");
                                string3 = string3.substring(0, n3);
                                string3 = string3.substring(4);
                                string3 = string3.trim();
                                string = string3.substring(0, string3.length() - 1);
                                break;
                            }
                            string = "128";
                            break;
                        }
                        bufferedReader.close();
                        break block9;
                    }
                    string = "128";
                }
                catch (Exception exception) {
                    string = "128";
                }
            } else {
                string = "128";
            }
        }
        try {
            string = string.trim();
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = 128;
        }
        return n;
    }

    private boolean isAnyVsphereMonitoringFailed(Hashtable hashtable, Hashtable hashtable2) {
        boolean bl = false;
        if (hashtable != null && hashtable.size() > 0) {
            long l = System.currentTimeMillis();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                long l2;
                Long l3;
                String string = (String)enumeration.nextElement();
                if (string == null) continue;
                Long l4 = (Long)hashtable.get(string);
                long l5 = 0L;
                if (l4 != null) {
                    l5 = l4;
                }
                if ((l3 = (Long)hashtable2.get(string)) != null && l - (l2 = l3.longValue()) >= EgMainAgent.vSphereFailureRestartTime / 2L) {
                    this.logToErrorFile("INFO", "MainAgentHelper", " Sphere url " + string + " currently not in use");
                    hashtable.remove(string);
                    hashtable2.remove(string);
                    continue;
                }
                if (l - l5 <= EgMainAgent.vSphereFailureRestartTime) continue;
                this.logToErrorFile("WARN", "MainAgentHelper", " vSphere metric collection was failed for  url " + string);
                bl = true;
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewXmxForRemoteAgent(int n, int n2) {
        String string = EgInstallInfo.getInstallDir() + "/lib/RunAgent.bat";
        String string2 = EgInstallInfo.getInstallDir() + "/lib/RunAgent_temp.bat";
        boolean bl = false;
        String string3 = String.valueOf(n2 / 4);
        String string4 = "-XX:NewSize=" + string3 + "m -XX:MaxNewSize=" + string3 + "m -XX:MetaspaceSize=" + string3 + "m -XX:MaxMetaspaceSize=" + string3 + "m -XX:+UseG1GC -XX:+UnlockDiagnosticVMOptions -XX:+UseTLAB -XX:+UseCMSInitiatingOccupancyOnly -XX:InitiatingHeapOccupancyPercent=30 -XX:ConcGCThreads=5 -XX:ParallelGCThreads=20 -XX:+UseAdaptiveGCBoundary ";
        if (string != null) {
            Object object;
            File file;
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                file = new File(string);
                if (file.exists() && file.isFile() && file.canWrite()) {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    bufferedWriter = new BufferedWriter(new FileWriter(string2));
                    object = "";
                    while ((object = bufferedReader.readLine()) != null) {
                        String string5 = ((String)object).toLowerCase();
                        if (string5.indexOf("-xmx" + n + "m") > 0) {
                            object = ((String)object).replace("-Xmx" + n + "M", "-Xmx" + n2 + "M");
                        }
                        if (string5.indexOf("-xx:newsize") > 0) {
                            object = this.getNewLine((String)object, "-XX:NewSize", string3);
                            bl = true;
                        }
                        if (string5.indexOf("-xx:maxnewsize") > 0) {
                            object = this.getNewLine((String)object, "-XX:MaxNewSize", string3);
                            bl = true;
                        }
                        if (string5.indexOf("-xx:permsize") > 0) {
                            object = this.getNewLine((String)object, "-XX:PermSize", string3);
                            bl = true;
                        }
                        if (string5.indexOf("-xx:maxpermsize") > 0) {
                            object = this.getNewLine((String)object, "-XX:MaxPermSize", string3);
                            bl = true;
                        }
                        if (!bl && ((String)object).indexOf("-Xmx" + n2 + "M") > 0) {
                            object = ((String)object).replace("-Xmx" + n2 + "M", "-Xmx" + n2 + "M" + " " + string4);
                        }
                        bufferedWriter.write((String)object + "\n");
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("IOException occurred while changing Xmx settings in " + string);
                }
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("IOException occurred while changing Xmx settings in " + string2);
                }
            }
            file = new File(string);
            file.delete();
            object = new File(string2);
            ((File)object).renameTo(file);
        }
    }

    private String getNewLine(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        String string4 = string.substring(n);
        if (string4.indexOf(" ") > -1) {
            int n2 = string4.indexOf(" ");
            string4 = string4.substring(0, n2);
            int n3 = string2.length();
            string4 = string4.substring(n3);
            string4 = string4.trim();
            String string5 = string4.substring(0, string4.length() - 1);
            string = string.replace(string2 + string5 + "m", string2 + "=" + string3 + "m");
        }
        return string;
    }

    private int getNewXmxValue() {
        long[] lArray = this.getMemoryDetails();
        int n = EgMainAgent.xmxAllocationPercentageFromFreememory;
        int n2 = 0;
        double d = lArray[0];
        double d2 = lArray[1];
        lArray = this.getMemoryDetails();
        if (lArray != null && lArray.length == 2) {
            double d3 = 0.0;
            if (d2 > 0.0) {
                d3 = d / d2 * 100.0;
            }
            if (d3 < 50.0) {
                d3 = 51.0;
            }
            if (d3 > 50.0) {
                n2 = (int)(d / 100.0) * n;
            } else {
                this.logToErrorFile("WARN", "MainAgentHelper", "System freeSpacePercentage is less than 50% of total memory, so don't update Xmx settings");
            }
        }
        return n2;
    }

    private long[] getMemoryDetails() {
        long[] lArray = new long[2];
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
            method.setAccessible(true);
            String string = method.getName();
            String string2 = "getTotalPhysicalMemorySize";
            String string3 = "getFreePhysicalMemorySize";
            if (!string.equalsIgnoreCase(string2) && (!string.equalsIgnoreCase(string3) || !Modifier.isPublic(method.getModifiers()))) continue;
            try {
                if (string.equalsIgnoreCase(string3)) {
                    lArray[0] = (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]) / 0x100000L;
                    continue;
                }
                if (!string.equalsIgnoreCase(string2)) continue;
                lArray[1] = (Long)method.invoke((Object)operatingSystemMXBean, new Object[0]) / 0x100000L;
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        return lArray;
    }

    public boolean isMaxThreadBlockedReached(int n) {
        boolean bl;
        block3: {
            bl = true;
            try {
                BlockedThreadFinder blockedThreadFinder = BlockedThreadFinder.getInstance();
                Integer[] integerArray = blockedThreadFinder.getBlockedCount();
                if (integerArray == null || integerArray.length <= 0) break block3;
                System.out.println("Blocked Thread ____ " + Arrays.asList(integerArray));
                for (Integer n2 : integerArray) {
                    if (n2 != null && n2 >= n) continue;
                    bl = false;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        return bl;
    }
}

