/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import com.egurkha.util.EgJNIUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class VTPcoipSessTest
extends GenericTest {
    private static double bToMb = 1048576.0;
    public int numberOfProcessors = EgMainAgent.numProcessors;
    public Vector users = new Vector();
    public Vector pids = new Vector();
    public Vector sessions = new Vector();
    public Hashtable pinfo = new Hashtable();
    public Hashtable userDD = new Hashtable();
    public Hashtable apppidMap = new Hashtable();
    XCmdGeneric xcmdG = null;
    private Hashtable sessionNameHash = new Hashtable();
    private int tsClientCheckCt = 0;
    private static int maxTsClientCheckCt = 12;
    public Hashtable userSessIDMap = new Hashtable();
    private static String s_termSrvSessObject = "Terminal Services Session";
    private static String[] s_a_termSrvSessCtrs = new String[]{"Input Bytes", "Input Errors", "Output Bytes", "Output Errors"};
    private EgJNIUtil egPerfUtil1 = null;
    private EgJNIUtil egPerfUtil2 = null;
    private EgJNIUtil egPerfUtil3 = null;
    private EgJNIUtil egPerfUtil4 = null;
    private EgJNIUtil egPerfUtil5 = null;
    private static final String object1 = "PCoIP Session General Statistics";
    private static final String[] counters1 = new String[]{"Bytes Received", "Bytes Sent", "Packets Received", "Packets Sent", "Session Duration Seconds", "RX Packets Lost", "TX Packets Lost"};
    private static final String object2 = "PCoIP Session Imaging Statistics";
    private static final String[] counters2 = new String[]{"Imaging Bytes Received", "Imaging Bytes Sent", "Imaging Decoder Capability kbit/sec", "Imaging Encoded Frames/sec", "Imaging RX BW kbit/sec", "Imaging TX BW kbit/sec"};
    private static final String object3 = "PCoIP Session Audio Statistics";
    private static final String[] counters3 = new String[]{"Audio Bytes Received", "Audio Bytes Sent", "Audio RX BW kbit/sec", "Audio TX BW kbit/sec", "Audio TX BW Limit kbit/sec"};
    private static final String object4 = "PCoIP Session Network Statistics";
    private static final String[] counters4 = new String[]{"Round Trip Latency ms", "RX BW kbit/sec", "RX Packet Loss %", "TX BW Active Limit kbit/sec", "TX BW kbit/sec", "TX BW Limit kbit/sec", "TX Packet Loss %"};
    private static final String object5 = "PCoIP Session USB Statistics";
    private static final String[] counters5 = new String[]{"USB Bytes Received", "USB Bytes Sent", "USB RX BW kbit/sec", "USB TX BW kbit/sec"};
    private Hashtable prevGeneralStatsTable = new Hashtable();
    private Hashtable prevImageStatsTable = new Hashtable();
    private Hashtable prevAudioStatTable = new Hashtable();
    private Hashtable prevNetworkStatTable = new Hashtable();
    private Hashtable prevUSBStatTable = new Hashtable();
    private Hashtable sessionCountTable = new Hashtable();
    private Hashtable pcoipSessIds = new Hashtable();
    private boolean firstTime = true;
    private EgJNIUtil egTermPerf = null;
    private boolean debugOn = true;
    private Hashtable idMap = null;

    public void freeTest() {
        this.users = new Vector();
        this.pids = new Vector();
        this.sessions = new Vector();
        this.pinfo = new Hashtable();
        this.userDD = new Hashtable();
        this.sessionNameHash = new Hashtable();
        this.apppidMap = new Hashtable();
    }

    public VTPcoipSessTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
    }

    private Hashtable SessionIDMappingHash() {
        Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
        try {
            if (this.debugOn) {
                System.out.println("[" + this.entity + "] pcoip SessIds --->" + this.pcoipSessIds);
                System.out.println("[" + this.entity + "] userSessIDMap ->" + this.userSessIDMap);
            }
            if (this.pcoipSessIds != null && this.pcoipSessIds.size() > 0) {
                Enumeration enumeration = this.pcoipSessIds.keys();
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2;
                    String string3 = (String)enumeration.nextElement();
                    if (string3 == null || string3.length() == 0 || (string2 = (String)this.pcoipSessIds.get(string3 = string3.trim())) == null || string2.length() == 0) continue;
                    string2 = string2.trim();
                    if (this.userSessIDMap == null || !this.userSessIDMap.containsKey(string3) || (string = (String)this.userSessIDMap.get(string3)) == null || string.length() == 0) continue;
                    string = string.trim();
                    int n = string.indexOf("#");
                    String string4 = "";
                    if (n > 0) {
                        string = string.substring(0, n) + " " + string.substring(n + 1);
                    }
                    string = string.toLowerCase();
                    ArrayList<String> arrayList = null;
                    if (hashtable != null && hashtable.containsKey(string2)) {
                        arrayList = (ArrayList<String>)hashtable.get(string2);
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(string);
                        hashtable.put(string2, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    hashtable.put(string2, arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debugOn) {
            System.out.println("[" + this.entity + "] session total  ---->" + hashtable);
        }
        return hashtable;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.users = new Vector();
        this.pids = new Vector();
        this.pinfo = new Hashtable();
        this.sessions = new Vector();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        this.userDD = new Hashtable();
        this.userSessIDMap = new Hashtable();
        this.idMap = new Hashtable();
        this.apppidMap = new Hashtable();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        try {
            Object object;
            Hashtable hashtable2 = this.getPCoIPSessionOutput();
            if (this.debugOn) {
                System.out.println("[" + this.entity + "] pcoip session outputs ->" + hashtable2);
                System.out.println("[" + this.entity + "] pcoip session ids ->" + this.pcoipSessIds);
            }
            if (hashtable2 == null || hashtable2.size() == 0 || this.pcoipSessIds == null || this.pcoipSessIds.size() == 0) {
                return;
            }
            Hashtable hashtable3 = this.getTerminalServiceSession();
            if (this.debugOn) {
                System.out.println("[" + this.entity + "] terminal service session output -->" + hashtable3);
            }
            this.idMap = this.SessionIDMappingHash();
            if (this.debugOn) {
                System.out.println("[" + this.entity + "] total id mapping idMap ->" + this.idMap);
            }
            if (!this.meAgentless) {
                object = new EgTermProcs();
                object.setSessID(this.userSessIDMap);
                object.execute();
                this.users = object.getUsers();
                this.pids = object.getPids();
                this.sessions = object.getSessions();
                if (this.users == null || this.pids == null || this.users.size() != this.pids.size()) {
                    return;
                }
                this.pinfo = this.getProcessInfo(false);
                if (this.debugOn) {
                    System.out.println("[" + this.entity + "] users ------>" + this.users);
                    System.out.println("[" + this.entity + "] pids ------>" + this.pids);
                    System.out.println("[" + this.entity + "] sessions ------>" + this.sessions);
                    System.out.println("[" + this.entity + "] pinfo ------>" + this.pinfo);
                }
            } else if (this.isPerfmon) {
                this.getTermProcs();
                if (this.users == null || this.pids == null || this.users.size() != this.pids.size()) {
                    return;
                }
                this.pinfo = this.getProcessInfo(true);
            }
            object = hashtable2.keys();
            while (object.hasMoreElements()) {
                int n;
                int n2;
                arrayList = new ArrayList();
                String string = (String)object.nextElement();
                if (this.debugOn) {
                    System.out.println("[" + this.entity + "] pcoip session user-->" + string);
                }
                if (string == null || string.length() == 0) continue;
                string = string.trim();
                ArrayList arrayList2 = (ArrayList)hashtable2.get(string);
                if (this.debugOn) {
                    System.out.println("[" + this.entity + "] pcoip session output-->" + arrayList2);
                }
                if (arrayList2 == null || arrayList2.size() == 0) continue;
                ArrayList arrayList3 = (ArrayList)this.idMap.get(string);
                if (this.debugOn) {
                    System.out.println("[" + this.entity + "] total terminal sessions for this user -->" + arrayList3);
                }
                int n3 = 0;
                d = -5.0;
                d2 = -5.0;
                d3 = -5.0;
                d4 = -5.0;
                if (arrayList3 != null && arrayList3.size() > 0) {
                    n3 = arrayList3.size();
                    if (hashtable3 != null && hashtable3.size() > 0) {
                        d = 0.0;
                        d2 = 0.0;
                        d3 = 0.0;
                        d4 = 0.0;
                        for (n2 = 0; n2 < n3; ++n2) {
                            ArrayList arrayList4;
                            String string2 = (String)arrayList3.get(n2);
                            if (string2 == null || string2.length() == 0) continue;
                            string2 = string2.trim();
                            if (hashtable3 == null || !hashtable3.containsKey(string2) || (arrayList4 = (ArrayList)hashtable3.get(string2)) == null || arrayList4.size() == 0) continue;
                            double d5 = (Double)arrayList4.get(0);
                            d += d5 / 1024.0;
                            double d6 = (Double)arrayList4.get(1);
                            d2 += d6;
                            double d7 = (Double)arrayList4.get(2);
                            d3 += d7 / 1024.0;
                            double d8 = (Double)arrayList4.get(3);
                            d4 += d8;
                        }
                    }
                }
                if (this.debugOn) {
                    System.out.println("[" + this.entity + "] this user ->" + string + " number of essions ->" + n3);
                }
                if (n3 == 0) {
                    arrayList.add(new Double(0.0));
                    for (n2 = 1; n2 < this.measureCount; ++n2) {
                        arrayList.add(new Double(-5.0));
                    }
                    this.addNewMeasure(string, arrayList);
                    continue;
                }
                arrayList.add(new Double(n3));
                double[] dArray = this.getMemCpuForUser(string);
                if (dArray != null && dArray.length >= 7) {
                    for (int i = 0; i < dArray.length; ++i) {
                        arrayList.add(new Double(dArray[i]));
                    }
                    double d9 = 0.0;
                    if (dArray[0] > 0.0) {
                        d9 = dArray[0] * (double)this.numberOfProcessors;
                    }
                    if (d9 > 100.0) {
                        d9 = 100.0;
                    }
                    arrayList.add(new Double(d9));
                } else {
                    for (int i = 0; i < 8; ++i) {
                        arrayList.add(new Double(-5.0));
                    }
                }
                if (d > 0.0) {
                    d /= this.timeSinceLastTest;
                }
                if (d2 > 0.0) {
                    d2 /= this.timeSinceLastTest;
                }
                if (d3 > 0.0) {
                    d3 /= this.timeSinceLastTest;
                }
                if (d4 > 0.0) {
                    d4 /= this.timeSinceLastTest;
                }
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                if (arrayList2 != null && arrayList2.size() >= 19) {
                    for (n = 0; n < 19; ++n) {
                        arrayList.add((Double)arrayList2.get(n));
                    }
                } else {
                    for (n = 0; n < 19; ++n) {
                        arrayList.add(new Double(-5.0));
                    }
                }
                System.out.println("[" + this.entity + "] the meausrelist value->" + arrayList + " size ->" + arrayList.size());
                this.addNewMeasure(string, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getTerminalServiceSession() {
        String[] stringArray = null;
        double[][] dArray = null;
        ArrayList<Double> arrayList = null;
        Hashtable hashtable = new Hashtable();
        try {
            if (!this.meAgentless) {
                EgTermSession egTermSession = new EgTermSession();
                egTermSession.execute();
                hashtable = egTermSession.getHashValue();
            } else if (this.isPerfmon) {
                this.checkNbt();
                if (this.nbtName == null) {
                    System.out.println("Failed to get NbtName for " + this.targetHost);
                    this.stopTermSessTest();
                    return null;
                }
                if (this.egTermPerf == null) {
                    EgJNIUtil.isHostAvailable((String)this.nbtName);
                    this.egTermPerf = new EgJNIUtil();
                }
                if ((dArray = this.egTermPerf.getCounterValue(s_termSrvSessObject, stringArray, s_a_termSrvSessCtrs, this.targetHost, "perfmon")) == null) {
                    this.stopTermSessTest();
                }
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = dArray[i].length;
                    arrayList = new ArrayList<Double>();
                    for (int j = 0; j < n2; ++j) {
                        arrayList.add(new Double(dArray[i][j]));
                    }
                    hashtable.put(stringArray[i], arrayList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debugOn) {
            System.out.println("[" + this.entity + "] termMeasureHash->" + hashtable);
        }
        return hashtable;
    }

    public void stopTermSessTest() {
        if (this.egTermPerf != null) {
            this.egTermPerf.stop();
            this.egTermPerf = null;
        }
    }

    private Hashtable getPCoIPSessionOutput() {
        double[][] dArray = null;
        double[][] dArray2 = null;
        double[][] dArray3 = null;
        double[][] dArray4 = null;
        double[][] dArray5 = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        String[] stringArray5 = null;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        Hashtable hashtable6 = new Hashtable();
        this.sessionCountTable = new Hashtable();
        try {
            if (!this.meAgentless) {
                stringArray = EgJNIUtil.discoverInstances((String)object1);
                stringArray2 = EgJNIUtil.discoverInstances((String)object2);
                stringArray3 = EgJNIUtil.discoverInstances((String)object3);
                stringArray4 = EgJNIUtil.discoverInstances((String)object4);
                stringArray5 = EgJNIUtil.discoverInstances((String)object5);
                if (stringArray == null || stringArray2 == null || stringArray3 == null || stringArray4 == null || stringArray5 == null) {
                    return new Hashtable();
                }
                if (this.egPerfUtil1 == null) {
                    this.egPerfUtil1 = new EgJNIUtil();
                }
                if (this.egPerfUtil2 == null) {
                    this.egPerfUtil2 = new EgJNIUtil();
                }
                if (this.egPerfUtil3 == null) {
                    this.egPerfUtil3 = new EgJNIUtil();
                }
                if (this.egPerfUtil4 == null) {
                    this.egPerfUtil4 = new EgJNIUtil();
                }
                if (this.egPerfUtil5 == null) {
                    this.egPerfUtil5 = new EgJNIUtil();
                }
                dArray = this.egPerfUtil1.getCounterValue(object1, stringArray, counters1);
                dArray2 = this.egPerfUtil1.getCounterValue(object2, stringArray2, counters2);
                dArray3 = this.egPerfUtil1.getCounterValue(object3, stringArray3, counters3);
                dArray4 = this.egPerfUtil1.getCounterValue(object4, stringArray4, counters4);
                dArray5 = this.egPerfUtil1.getCounterValue(object5, stringArray5, counters5);
            } else if (this.isPerfmon) {
                this.checkNbt();
                if (this.nbtName == null) {
                    System.out.println("Failed to get NbtName for " + this.targetHost);
                    this.stopTest();
                    return new Hashtable();
                }
                stringArray = EgJNIUtil.discoverPdhInstances((String)object1, (String)this.targetHost);
                stringArray2 = EgJNIUtil.discoverPdhInstances((String)object2, (String)this.targetHost);
                stringArray3 = EgJNIUtil.discoverPdhInstances((String)object3, (String)this.targetHost);
                stringArray4 = EgJNIUtil.discoverPdhInstances((String)object4, (String)this.targetHost);
                stringArray5 = EgJNIUtil.discoverPdhInstances((String)object5, (String)this.targetHost);
                if (stringArray == null || stringArray2 == null || stringArray3 == null || stringArray4 == null || stringArray5 == null) {
                    return new Hashtable();
                }
                if (this.egPerfUtil1 == null) {
                    EgJNIUtil.isHostAvailable((String)this.nbtName);
                    this.egPerfUtil1 = new EgJNIUtil();
                }
                if (this.egPerfUtil2 == null) {
                    EgJNIUtil.isHostAvailable((String)this.nbtName);
                    this.egPerfUtil2 = new EgJNIUtil();
                }
                if (this.egPerfUtil3 == null) {
                    EgJNIUtil.isHostAvailable((String)this.nbtName);
                    this.egPerfUtil3 = new EgJNIUtil();
                }
                if (this.egPerfUtil4 == null) {
                    EgJNIUtil.isHostAvailable((String)this.nbtName);
                    this.egPerfUtil4 = new EgJNIUtil();
                }
                if (this.egPerfUtil5 == null) {
                    EgJNIUtil.isHostAvailable((String)this.nbtName);
                    this.egPerfUtil5 = new EgJNIUtil();
                }
                dArray = this.egPerfUtil1.getCounterValue(object1, stringArray, counters1, this.targetHost, "perfmon");
                dArray2 = this.egPerfUtil1.getCounterValue(object2, stringArray2, counters2, this.targetHost, "perfmon");
                dArray3 = this.egPerfUtil1.getCounterValue(object3, stringArray3, counters3, this.targetHost, "perfmon");
                dArray4 = this.egPerfUtil1.getCounterValue(object4, stringArray4, counters4, this.targetHost, "perfmon");
                dArray5 = this.egPerfUtil1.getCounterValue(object5, stringArray5, counters5, this.targetHost, "perfmon");
            }
            this.setClientNameWithUserName();
            if (dArray == null) {
                this.stopTest1();
            } else {
                hashtable = this.getCounterValues(stringArray, dArray);
            }
            if (dArray2 == null) {
                this.stopTest2();
            } else {
                hashtable2 = this.getCounterValues(stringArray2, dArray2);
            }
            if (dArray3 == null) {
                this.stopTest3();
            } else {
                hashtable3 = this.getCounterValues(stringArray3, dArray3);
            }
            if (dArray4 == null) {
                this.stopTest4();
            } else {
                hashtable4 = this.getCounterValues(stringArray4, dArray4);
            }
            if (dArray5 == null) {
                this.stopTest5();
            } else {
                hashtable5 = this.getCounterValues(stringArray5, dArray5);
            }
            long l = System.currentTimeMillis();
            if (this.firstTime) {
                this.prevGeneralStatsTable = hashtable;
                this.prevImageStatsTable = hashtable2;
                this.prevAudioStatTable = hashtable3;
                this.prevNetworkStatTable = hashtable4;
                this.prevUSBStatTable = hashtable5;
                this.firstTime = false;
                return new Hashtable();
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                double d;
                double d2;
                double d3;
                double d4;
                String string = (String)enumeration.nextElement();
                if (string == null || string.length() == 0) continue;
                string = string.trim();
                ArrayList arrayList = null;
                ArrayList arrayList2 = null;
                ArrayList arrayList3 = null;
                ArrayList arrayList4 = null;
                ArrayList arrayList5 = null;
                ArrayList arrayList6 = null;
                ArrayList arrayList7 = null;
                ArrayList arrayList8 = null;
                ArrayList arrayList9 = null;
                ArrayList arrayList10 = null;
                arrayList = (ArrayList)hashtable.get(string);
                if (hashtable2 != null && hashtable2.containsKey(string)) {
                    arrayList2 = (ArrayList)hashtable2.get(string);
                }
                if (hashtable3 != null && hashtable3.containsKey(string)) {
                    arrayList3 = (ArrayList)hashtable3.get(string);
                }
                if (hashtable4 != null && hashtable4.containsKey(string)) {
                    arrayList4 = (ArrayList)hashtable4.get(string);
                }
                if (hashtable5 != null && hashtable5.containsKey(string)) {
                    arrayList5 = (ArrayList)hashtable5.get(string);
                }
                if (this.prevGeneralStatsTable != null && this.prevGeneralStatsTable.containsKey(string)) {
                    arrayList6 = (ArrayList)this.prevGeneralStatsTable.get(string);
                }
                if (this.prevImageStatsTable != null && this.prevImageStatsTable.containsKey(string)) {
                    arrayList7 = (ArrayList)this.prevImageStatsTable.get(string);
                }
                if (this.prevAudioStatTable != null && this.prevAudioStatTable.containsKey(string)) {
                    arrayList8 = (ArrayList)this.prevAudioStatTable.get(string);
                }
                if (this.prevNetworkStatTable != null && this.prevNetworkStatTable.containsKey(string)) {
                    arrayList9 = (ArrayList)this.prevNetworkStatTable.get(string);
                }
                if (this.prevUSBStatTable != null && this.prevUSBStatTable.containsKey(string)) {
                    arrayList10 = (ArrayList)this.prevUSBStatTable.get(string);
                }
                int n = 1;
                if (this.sessionCountTable != null && this.sessionCountTable.containsKey(string)) {
                    n = (Integer)this.sessionCountTable.get(string);
                }
                if (this.debugOn) {
                    System.out.println("[" + this.entity + "]  session count ->[" + n + "]  for this user ->" + string);
                    System.out.println("[" + this.entity + "]  general statistics ->[" + arrayList + "] [prevGeneralStatList ->]" + arrayList6);
                    System.out.println("[" + this.entity + "]  image statistics list ->[" + arrayList2 + "] [prevImageStatList ->]" + arrayList7);
                    System.out.println("[" + this.entity + "]  audio list ->[" + arrayList3 + "] [prevAudioStatList ->]" + arrayList8);
                    System.out.println("[" + this.entity + "]  network list ->[" + arrayList4 + "] [prevNetworkStatList ->]" + arrayList9);
                    System.out.println("[" + this.entity + "]  USB list ->[" + arrayList5 + "] [prevUSBStatList ->]" + arrayList10);
                }
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = 0.0;
                double d11 = 0.0;
                double d12 = 0.0;
                double d13 = 0.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                double d19 = 0.0;
                double d20 = 0.0;
                double d21 = 0.0;
                double d22 = 0.0;
                if (arrayList != null && arrayList.size() >= 7 && arrayList6 != null && arrayList6.size() >= 7) {
                    d5 = (Double)arrayList.get(0);
                    d6 = (Double)arrayList.get(1);
                    d7 = (Double)arrayList.get(2);
                    d8 = (Double)arrayList.get(3);
                    d11 = (Double)arrayList.get(4);
                    d9 = (Double)arrayList.get(5);
                    d10 = (Double)arrayList.get(6);
                    d12 = (Double)arrayList6.get(0);
                    d13 = (Double)arrayList6.get(1);
                    d14 = (Double)arrayList6.get(2);
                    d15 = (Double)arrayList6.get(3);
                    d18 = (Double)arrayList6.get(4);
                    d16 = (Double)arrayList6.get(5);
                    d16 = (Double)arrayList6.get(6);
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                    d19 = this.getDiffValue(d5, d12, n);
                    d20 = this.getDiffValue(d6, d13, n);
                    if (d7 >= 0.0 && d14 >= 0.0 && d7 > d14) {
                        d4 = (d7 - d14) / (double)n;
                    }
                    if (d8 >= 0.0 && d15 >= 0.0 && d8 > d15) {
                        d3 = (d8 - d15) / (double)n;
                    }
                    if (d9 >= 0.0 && d16 >= 0.0 && d9 > d16) {
                        d2 = (d9 - d16) / (double)n;
                    }
                    if (d10 >= 0.0 && d17 >= 0.0 && d10 > d17) {
                        d = (d10 - d17) / (double)n;
                    }
                    if (d11 > 0.0) {
                        d11 /= (double)n;
                    }
                    d21 = 100.0 / (1.0 + d4 / d2);
                    d22 = d / d3 * 100.0;
                    System.out.println("genRXPcktLostPercentage ->" + d21 + " genTXPcktLostPercentage ->" + d22);
                    this.prevGeneralStatsTable = hashtable;
                } else {
                    this.prevGeneralStatsTable = hashtable;
                }
                d4 = 0.0;
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
                double d23 = 0.0;
                double d24 = 0.0;
                double d25 = 0.0;
                double d26 = 0.0;
                double d27 = 0.0;
                double d28 = 0.0;
                double d29 = 0.0;
                double d30 = 0.0;
                double d31 = 0.0;
                double d32 = 0.0;
                if (arrayList2 != null && arrayList2.size() >= 6 && arrayList7 != null && arrayList7.size() >= 6) {
                    d4 = (Double)arrayList2.get(0);
                    d3 = (Double)arrayList2.get(1);
                    d2 = (Double)arrayList2.get(2);
                    d = (Double)arrayList2.get(3);
                    d23 = (Double)arrayList2.get(4);
                    d24 = (Double)arrayList2.get(5);
                    d25 = (Double)arrayList7.get(0);
                    d26 = (Double)arrayList7.get(1);
                    d27 = (Double)arrayList7.get(2);
                    d28 = (Double)arrayList7.get(3);
                    d29 = (Double)arrayList7.get(4);
                    d30 = (Double)arrayList7.get(5);
                    d31 = this.getDiffValue(d4, d25, n);
                    d32 = this.getDiffValue(d3, d26, n);
                    d2 /= (double)n;
                    d /= (double)n;
                    d23 = (d23 - d29) / (double)n;
                    d24 = (d24 - d30) / (double)n;
                    this.prevImageStatsTable = hashtable2;
                } else {
                    this.prevImageStatsTable = hashtable2;
                }
                double d33 = 0.0;
                double d34 = 0.0;
                double d35 = 0.0;
                double d36 = 0.0;
                double d37 = 0.0;
                double d38 = 0.0;
                double d39 = 0.0;
                double d40 = 0.0;
                double d41 = 0.0;
                double d42 = 0.0;
                double d43 = 0.0;
                double d44 = 0.0;
                if (arrayList3 != null && arrayList3.size() >= 5 && arrayList8 != null && arrayList8.size() >= 5) {
                    d33 = (Double)arrayList3.get(0);
                    d34 = (Double)arrayList3.get(1);
                    d35 = (Double)arrayList3.get(2);
                    d36 = (Double)arrayList3.get(3);
                    d37 = (Double)arrayList3.get(4);
                    d38 = (Double)arrayList8.get(0);
                    d39 = (Double)arrayList8.get(1);
                    d40 = (Double)arrayList8.get(2);
                    d41 = (Double)arrayList8.get(3);
                    d42 = (Double)arrayList8.get(4);
                    d43 = this.getDiffValue(d33, d38, n);
                    d44 = this.getDiffValue(d34, d39, n);
                    d35 = (d35 - d40) / (double)n;
                    d36 = (d36 - d41) / (double)n;
                    d37 /= (double)n;
                    this.prevAudioStatTable = hashtable3;
                } else {
                    this.prevAudioStatTable = hashtable3;
                }
                double d45 = 0.0;
                double d46 = 0.0;
                double d47 = 0.0;
                double d48 = 0.0;
                double d49 = 0.0;
                double d50 = 0.0;
                double d51 = 0.0;
                double d52 = 0.0;
                double d53 = 0.0;
                double d54 = 0.0;
                double d55 = 0.0;
                if (arrayList4 != null && arrayList4.size() >= 7 && arrayList9 != null && arrayList9.size() >= 7) {
                    d45 = (Double)arrayList4.get(0);
                    d46 = (Double)arrayList4.get(1);
                    d47 = (Double)arrayList4.get(2);
                    d48 = (Double)arrayList4.get(3);
                    d49 = (Double)arrayList4.get(4);
                    d50 = (Double)arrayList4.get(5);
                    d51 = (Double)arrayList4.get(6);
                    d45 /= 1000.0 * (double)n;
                    d46 /= (double)n;
                    d48 /= (double)n;
                    d49 /= (double)n;
                    d50 /= (double)n;
                    d54 = (d47 /= (double)n) / (d47 + d7) * 100.0;
                    d55 = (d51 /= (double)n) / (d51 + d8) * 100.0;
                    this.prevNetworkStatTable = hashtable4;
                } else {
                    this.prevNetworkStatTable = hashtable4;
                }
                double d56 = 0.0;
                double d57 = 0.0;
                double d58 = 0.0;
                double d59 = 0.0;
                double d60 = 0.0;
                double d61 = 0.0;
                double d62 = 0.0;
                double d63 = 0.0;
                double d64 = 0.0;
                double d65 = 0.0;
                if (arrayList5 != null && arrayList5.size() >= 4 && arrayList10 != null && arrayList10.size() >= 4) {
                    d56 = (Double)arrayList5.get(0);
                    d57 = (Double)arrayList5.get(1);
                    d58 = (Double)arrayList5.get(2);
                    d59 = (Double)arrayList5.get(3);
                    d60 = (Double)arrayList10.get(0);
                    d61 = (Double)arrayList10.get(1);
                    d62 = (Double)arrayList10.get(2);
                    d63 = (Double)arrayList10.get(3);
                    d64 = this.getDiffValue(d56, d60, n);
                    d65 = this.getDiffValue(d57, d61, n);
                    d58 = (d58 - d62) / (double)n;
                    d59 = (d59 - d63) / (double)n;
                    this.prevUSBStatTable = hashtable5;
                } else {
                    this.prevUSBStatTable = hashtable5;
                }
                ArrayList<Double> arrayList11 = new ArrayList<Double>();
                arrayList11.add(new Double(d19));
                arrayList11.add(new Double(d20));
                arrayList11.add(new Double(d9));
                arrayList11.add(new Double(d10));
                arrayList11.add(new Double(d11));
                arrayList11.add(new Double(d31));
                arrayList11.add(new Double(d32));
                arrayList11.add(new Double(d2));
                arrayList11.add(new Double(d));
                arrayList11.add(new Double(d43));
                arrayList11.add(new Double(d44));
                arrayList11.add(new Double(d37));
                arrayList11.add(new Double(d45));
                arrayList11.add(new Double(d46));
                arrayList11.add(new Double(d47));
                arrayList11.add(new Double(d49));
                arrayList11.add(new Double(d51));
                arrayList11.add(new Double(d64));
                arrayList11.add(new Double(d65));
                hashtable6.put(string, arrayList11);
                if (!this.debugOn) continue;
                System.out.println("[VTPcoipSessTest] info -->" + string + "  measureList --> " + arrayList11);
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
        return hashtable6;
    }

    private double getDiffValue(double d, double d2, int n) {
        double d3 = 0.0;
        try {
            double d4 = 0.0;
            if (d2 < 0.0 || this.timeSinceLastTest < 0.0) {
                return -5.0;
            }
            if (d >= d2) {
                d4 = d - d2;
            }
            if (d4 > 0.0) {
                d3 = d4 * 8.0 / (1024.0 * (double)n * this.timeSinceLastTest);
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", this.entity, string);
        }
        return d3;
    }

    public Hashtable getCounterValues(String[] stringArray, double[][] dArray) {
        Hashtable hashtable = new Hashtable();
        double d = 0.0;
        this.pcoipSessIds = new Hashtable();
        try {
            if (stringArray != null && dArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    String string2 = stringArray[i];
                    if (string2 == null || string2.length() == 0) continue;
                    string2 = string2.trim();
                    int n2 = dArray[i].length;
                    if (n2 == 0) continue;
                    for (int j = 0; j < n2; ++j) {
                        double d2 = dArray[i][j] < 0.0 ? 0.0 : dArray[i][j];
                        arrayList.add(new Double(d2));
                    }
                    ArrayList arrayList2 = this.myTokenizer(string2, " ");
                    if (arrayList2 == null || arrayList2.size() == 0 || (string2 = (String)arrayList2.get(2)) == null || string2.length() == 0) continue;
                    string2 = string2.trim();
                    if (this.debugOn) {
                        System.out.println("[" + this.entity + "] the info values is ->" + string2);
                        System.out.println("[" + this.entity + "] aList values ->" + arrayList + " and size ->" + arrayList.size());
                    }
                    if ((string = (String)this.sessionNameHash.get(string2)) == null || string.trim().length() == 0) continue;
                    string = string.trim();
                    if (hashtable != null && hashtable.containsKey(string)) {
                        int n3;
                        ArrayList arrayList3 = (ArrayList)hashtable.get(string);
                        if (this.debugOn) {
                            System.out.println("[" + this.entity + "] tempList values ->" + arrayList3 + " and size ->" + arrayList.size());
                        }
                        if (arrayList3 != null && arrayList3.size() > 0 && arrayList != null && arrayList.size() > 0 && arrayList3.size() == arrayList.size()) {
                            n3 = arrayList3.size();
                            ArrayList<Double> arrayList4 = new ArrayList<Double>();
                            for (int j = 0; j < n3; ++j) {
                                double d3 = (Double)arrayList3.get(j);
                                double d4 = (Double)arrayList.get(j);
                                d = d4 + d3;
                                arrayList4.add(new Double(d));
                            }
                            hashtable.put(string, arrayList4);
                            this.pcoipSessIds.put(string2, string);
                        }
                        n3 = 0;
                        n3 = (Integer)this.sessionCountTable.get(string);
                        if (this.debugOn) {
                            System.out.println("[" + this.entity + "] sessionCount ->" + n3);
                        }
                        this.sessionCountTable.put(string, new Integer(++n3));
                        continue;
                    }
                    hashtable.put(string, arrayList);
                    this.sessionCountTable.put(string, new Integer(1));
                    this.pcoipSessIds.put(string2, string);
                }
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", this.entity, string);
        }
        return hashtable;
    }

    private void setClientNameWithUserName() {
        this.sessionNameHash = new Hashtable();
        ArrayList arrayList = new ArrayList();
        this.userSessIDMap = new Hashtable();
        try {
            Object object;
            if (!this.meAgentless) {
                object = EgInstallInfo.getInstallDir() + "/lib/TSClientUserNames.exe localhost";
                EgCtxClient egCtxClient = new EgCtxClient((String)object);
                egCtxClient.execute();
                arrayList = egCtxClient.getLines();
            } else {
                boolean bl;
                if (this.xcmdG == null) {
                    this.xcmdG = new XCmdGeneric(this.nbtName);
                }
                if (this.tsClientCheckCt == 0 && !(bl = this.xcmdG.checkForExeOnRemote("TSClientUserNames.exe"))) {
                    this.xcmdG.copyExeToRemote(EgInstallInfo.getInstallDir() + "/lib/TSClientUserNames.exe", true);
                }
                ++this.tsClientCheckCt;
                if ((long)this.tsClientCheckCt >= this.getRandom(maxTsClientCheckCt)) {
                    this.tsClientCheckCt = 0;
                }
                if ((object = this.xcmdG.executeRemoteCommand(EgInstallInfo.getXCmdRemoteDirectory() + "TSClientUserNames.exe localhost")) == null || ((ArrayList)object).size() < 2) {
                    return;
                }
                arrayList = (ArrayList)((ArrayList)object).get(0);
            }
            if (arrayList == null || arrayList.size() == 0) {
                return;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                StringTokenizer stringTokenizer;
                int n2;
                String string2 = (String)arrayList.get(i);
                if (string2 == null || string2.trim().length() == 0 || (n2 = (stringTokenizer = new StringTokenizer(string2 = string2.trim(), ";")).countTokens()) < 3) continue;
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken().toLowerCase();
                if (string4 == null || string4.length() == 0 || string5 == null || string5.length() == 0 || string4.equals("-") || string5.equals("-") || !(string = string4.toLowerCase()).startsWith("vmware-rds") || string.indexOf("vmware-rds") < 0) continue;
                this.sessionNameHash.put(string3, string5);
                this.userSessIDMap.put(string3, string4);
            }
            if (this.debugOn) {
                System.out.println("[" + this.entity + "] sessionNameHash ->" + this.sessionNameHash);
                System.out.println("[" + this.entity + "] userSessIDMap ->" + this.userSessIDMap);
            }
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile(this.entity, "Error", string);
        }
    }

    public long getRandom(int n) {
        double d = (double)n * 1.5;
        double d2 = (double)n * 0.5;
        return (long)(d2 + EgMainAgent.getRandom() * (d - d2));
    }

    private double getValue(String string) {
        try {
            double d = Double.parseDouble(string);
            return d;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    private double getValue(String string, double d) {
        try {
            double d2 = Double.parseDouble(string);
            if (d2 < 0.0) {
                return d2;
            }
            return d2 / d;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    public void stopTest() {
        this.stopTest1();
        this.stopTest2();
        this.stopTest3();
        this.stopTest4();
        this.stopTest5();
    }

    public void stopTest1() {
        if (this.egPerfUtil1 != null) {
            this.egPerfUtil1.stop();
            this.egPerfUtil1 = null;
        }
    }

    public void stopTest2() {
        if (this.egPerfUtil2 != null) {
            this.egPerfUtil2.stop();
            this.egPerfUtil2 = null;
        }
    }

    public void stopTest3() {
        if (this.egPerfUtil3 != null) {
            this.egPerfUtil3.stop();
            this.egPerfUtil3 = null;
        }
    }

    public void stopTest4() {
        if (this.egPerfUtil4 != null) {
            this.egPerfUtil4.stop();
            this.egPerfUtil4 = null;
        }
    }

    public void stopTest5() {
        if (this.egPerfUtil5 != null) {
            this.egPerfUtil5.stop();
            this.egPerfUtil5 = null;
        }
    }

    public static void main(String[] stringArray) {
        VTPcoipSessTest vTPcoipSessTest = new VTPcoipSessTest(stringArray);
        vTPcoipSessTest.computeMeasures(new Hashtable());
    }

    private Hashtable getProcessInfo(boolean bl) {
        Hashtable<String, Object[]> hashtable = new Hashtable<String, Object[]>();
        ArrayList arrayList = null;
        CpuUtil cpuUtil = null;
        try {
            Object object;
            if (!bl) {
                object = System.getProperty("os.name");
                cpuUtil = new CpuUtil(true);
                cpuUtil.setOS((String)object);
                arrayList = cpuUtil.execute(bl);
                this.apppidMap = cpuUtil.getPidMap();
            } else {
                cpuUtil = new CpuUtil(this.nbtName, true);
                cpuUtil.setOS(this.alos);
                arrayList = cpuUtil.execute(bl);
                this.apppidMap = CpuUtil.getPidMap((String)this.nbtName);
            }
            if (arrayList == null || arrayList.size() == 0) {
                return null;
            }
            object = null;
            boolean bl2 = false;
            if (arrayList != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    String string;
                    int n2;
                    String string2 = (String)arrayList.get(i);
                    if (arrayList == null || string2.length() <= 0 || (n2 = ((StringTokenizer)(object = new StringTokenizer(string2, "|"))).countTokens()) < 4 || (string = ((StringTokenizer)object).nextToken()) == null) continue;
                    Object[] objectArray = new Object[11];
                    string = string.toLowerCase();
                    objectArray[0] = string;
                    String string3 = ((StringTokenizer)object).nextToken();
                    if (string3 == null) continue;
                    Double d = new Double(string3);
                    double d2 = d;
                    if (d2 > 100.0) {
                        d2 = 100.0;
                    }
                    objectArray[1] = new Double(d2);
                    string3 = ((StringTokenizer)object).nextToken();
                    if (string3 == null) continue;
                    d = new Double(string3);
                    double d3 = d;
                    objectArray[2] = new Double(d3);
                    String string4 = ((StringTokenizer)object).nextToken();
                    String string5 = ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    objectArray[3] = ((StringTokenizer)object).nextToken();
                    objectArray[4] = ((StringTokenizer)object).nextToken();
                    objectArray[5] = ((StringTokenizer)object).nextToken();
                    objectArray[7] = string5;
                    ((StringTokenizer)object).nextToken();
                    objectArray[6] = ((StringTokenizer)object).nextToken();
                    objectArray[10] = ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    ((StringTokenizer)object).nextToken();
                    objectArray[9] = ((StringTokenizer)object).nextToken();
                    objectArray[8] = ((StringTokenizer)object).nextToken();
                    hashtable.put(string4, objectArray);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private void getTermProcs() {
        String string = "query process *";
        this.users = new Vector();
        this.pids = new Vector();
        this.sessions = new Vector();
        Vector<String> vector = new Vector<String>();
        ArrayList arrayList = this.xcmdG.executeRemoteCommand(string);
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("Failed to run" + string);
            return;
        }
        String string2 = null;
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        String string3 = EgLangInfo.getAgentCommandSearch((String)"query process *", (String)"USER");
        if (arrayList2 != null && arrayList2.size() > 0) {
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                StringTokenizer stringTokenizer;
                int n2;
                string2 = ((String)arrayList2.get(i)).trim();
                if (string2.startsWith(string3)) continue;
                if (string2.startsWith(">")) {
                    string2 = string2.substring(1);
                }
                if ((n2 = (stringTokenizer = new StringTokenizer(string2)).countTokens()) < 4) continue;
                String string4 = stringTokenizer.nextToken();
                String string5 = "";
                if (n2 > 4) {
                    string5 = stringTokenizer.nextToken();
                    while (string5.indexOf("#") < 0 && stringTokenizer.hasMoreTokens()) {
                        string4 = string4 + " " + string5;
                        string5 = stringTokenizer.nextToken();
                    }
                    if (string5.equalsIgnoreCase("console") || !string5.toLowerCase().startsWith("vmware-rds")) continue;
                }
                if (stringTokenizer.countTokens() < 3) continue;
                String string6 = stringTokenizer.nextToken();
                if (this.pcoipSessIds != null && !this.pcoipSessIds.containsKey(string6)) continue;
                if (string5 != null && string5.length() > 0 && string5.indexOf("vmware-rd...") > -1) {
                    string5 = (String)this.pcoipSessIds.get(string6);
                }
                String string7 = stringTokenizer.nextToken().trim();
                try {
                    long l = Long.parseLong(string7);
                }
                catch (Exception exception) {
                    if (stringTokenizer.countTokens() < 2) continue;
                    string7 = stringTokenizer.nextToken().trim();
                    try {
                        long l = Long.parseLong(string7);
                    }
                    catch (Exception exception2) {
                        continue;
                    }
                }
                String string8 = stringTokenizer.nextToken().trim();
                while (stringTokenizer.hasMoreTokens()) {
                    string8 = string8 + " " + stringTokenizer.nextToken();
                }
                if (string8.indexOf(".") < 0) continue;
                this.pids.add(string7);
                vector.add(string8);
                this.users.add(string4);
                this.sessions.add(string5);
            }
        }
        System.out.println("Term User Test - SESSIONS ARE " + this.sessions);
    }

    private double[] getMemCpuForUser(String string) {
        int n;
        double[] dArray = new double[7];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = -5.0;
        }
        if (this.pinfo == null) {
            return dArray;
        }
        ArrayList arrayList = new ArrayList();
        int n2 = this.users.size();
        int n3 = this.pids.size();
        ArrayList arrayList2 = null;
        if (this.idMap != null) {
            arrayList2 = (ArrayList)this.idMap.get(string);
        }
        boolean bl = false;
        if (arrayList2 != null && arrayList2.size() > 0) {
            bl = true;
        }
        for (int i = 0; i < n2; ++i) {
            String string2;
            String string3 = (String)this.users.get(i);
            if (string3.equalsIgnoreCase(string)) {
                if (i >= n3) continue;
                arrayList.add(this.pids.get(i));
                continue;
            }
            if (!bl || (string2 = (String)this.sessions.get(i)) == null || string2.trim().length() <= 0) continue;
            int n4 = (string2 = string2.toLowerCase()).indexOf("#");
            if (n4 >= 0) {
                string2 = string2.substring(0, n4) + " " + string2.substring(n4 + 1);
            }
            if (!arrayList2.contains(string2) || i >= n3) continue;
            arrayList.add(this.pids.get(i));
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = arrayList.size();
        String[] stringArray = new String[n5];
        double[] dArray2 = new double[n5];
        int n6 = 0;
        for (n = 0; n < n5; ++n) {
            String string4 = (String)arrayList.get(n);
            Object[] objectArray = (Object[])this.pinfo.get(string4);
            if (objectArray == null || objectArray.length < 11) continue;
            String string5 = (String)objectArray[0];
            double d8 = (Double)objectArray[1];
            double d9 = (Double)objectArray[2];
            double d10 = this.getValue((String)objectArray[3], 1024.0);
            double d11 = this.getValue((String)objectArray[4], 1024.0);
            double d12 = this.getValue((String)objectArray[5]);
            double d13 = this.getValue((String)objectArray[10], bToMb);
            double d14 = this.getValue((String)objectArray[7]);
            ++n6;
            if (d8 > 0.0) {
                d2 += d8;
            }
            if (d9 > 0.0) {
                d += d9;
            }
            if (d14 > 0.0) {
                d3 += d14;
            }
            if (d10 > 0.0) {
                d4 += d10;
            }
            if (d11 > 0.0) {
                d5 += d11;
            }
            if (d12 > 0.0) {
                d6 += d12;
            }
            if (d13 > 0.0) {
                d7 += d13;
            }
            if (d9 >= 0.0 && d8 >= 0.0) {
                bl2 = true;
            }
            if (d8 > 0.0) {
                bl3 = true;
            }
            dArray2[n] = d8;
            stringArray[n] = string4 + ";" + string5 + ";" + this.round(d8, 4) + ";" + this.round(d9, 4) + ";" + this.round(d10, 4) + ";" + this.round(d11, 4) + ";" + this.round(d12, 2) + ";" + this.round(d13, 2) + ";" + this.round(d14, 4);
        }
        if (!bl3) {
            arrayList3 = new ArrayList();
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                arrayList3.add(stringArray[n]);
            }
            if (arrayList3.size() > 0) {
                Collections.sort(arrayList3);
            }
        } else {
            if (n6 > 0) {
                for (n = 0; n < dArray2.length; ++n) {
                    for (int i = 0; i < n; ++i) {
                        if (stringArray[n] == null || stringArray[i] == null || !(dArray2[n] > dArray2[i])) continue;
                        double d15 = dArray2[n];
                        dArray2[n] = dArray2[i];
                        dArray2[i] = d15;
                        String string6 = stringArray[n];
                        stringArray[n] = stringArray[i];
                        stringArray[i] = string6;
                    }
                }
            }
            arrayList3 = new ArrayList();
            for (n = 0; n < stringArray.length; ++n) {
                arrayList3.add(stringArray[n]);
            }
        }
        if (bl2) {
            this.userDD.put(string, arrayList3);
            dArray[0] = EgMainAgent.checkCpuCap(d2);
            dArray[1] = d;
            dArray[2] = d4;
            dArray[3] = d5;
            dArray[4] = d6;
            dArray[5] = d7;
            dArray[6] = d3;
        }
        return dArray;
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            int n2 = (int)d;
            string = string + n2;
            d -= (double)n2;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    public ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        try {
            int n2 = string.indexOf(string2);
            while (n2 >= 0) {
                string3 = string.substring(n, n2).trim();
                arrayList.add(string3);
                n = n2 + string2.length();
                n2 = string.indexOf(string2, n);
            }
            string3 = string.substring(n).trim();
            arrayList.add(string3);
        }
        catch (Exception exception) {
            String string4 = EgInstallInfo.getStackTraceAsString((Exception)exception);
        }
        return arrayList;
    }
}

