﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

clear
$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$repNameCompname=($TestInputs[4]).ToString().Split('#')
$reportingNam=$repNameCompname[0]
$CompType=$repNameCompname[1]

$rptPath='O365/'+$reportingNam
$LicensesCnt=0


$readmsolLUsr=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365PSmsolAccSku" -keyFileName "kO365PSmsolAccSku" -EgPath $egurkhaPath
$unProtctLUsr=$readmsolLUsr[1] -replace (".csv",".dat") 
$mlUsrPath=Unprotect-File $unProtctLUsr -Algorithm AES -KeyAsPlainText $readmsolLUsr[0]	
$Licenses= import-csv $mlUsrPath
Remove-Item $mlUsrPath

Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'O365PSmsolAccSku' -InputFile $readmsolLUsr[3]
Eg-DeleteFiles -FilePath $readmsolLUsr[2] -Pattern 'kO365PSmsolAccSku' -InputFile $readmsolLUsr[4]

if($Licenses.Count -ne $null){
    $LicensesCnt= $Licenses.Count
}else{
    $LicensesCnt=1
}

$readmsolLUsr1=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365PSmsolUsr" -keyFileName "kO365PSmsolUsr" -EgPath $egurkhaPath
$unProtctLUsr1=$readmsolLUsr1[1] -replace (".csv",".dat") 
$mlUsrPath1=Unprotect-File $unProtctLUsr1 -Algorithm AES -KeyAsPlainText $readmsolLUsr1[0]	
$users= import-csv $mlUsrPath1
Remove-Item $mlUsrPath1
Eg-DeleteFiles -FilePath $readmsolLUsr1[2] -Pattern 'O365PSmsolUsr' -InputFile $readmsolLUsr1[3]
Eg-DeleteFiles -FilePath $readmsolLUsr1[2] -Pattern 'kO365PSmsolUsr' -InputFile $readmsolLUsr1[4]

$DisabledHash = @{} 
$PendingActivationHash = @{} 
$PendingProvisionHash = @{} 
$PendingInputHash = @{} 
$OthersHash = @{} 
$SuccessHash= @{}
$measurehash=@{}
$tmpServiceName=$null

$SPOServiceName=@()
$SBOServiceName=@()
$EXOServiceName=@()
$MTMServiceName=@()
$tests=Get-content -Path $egurkhaPath'\agent\config\eg_tests.ini'
$firstEntry=$false
    foreach($testsini in $tests){
        if($testsini -eq '[AGENT_SETTINGS]'){
            $firstEntry=$true
        }
        elseif($testsini.StartsWith("[")){
            $firstEntry=$false
        }
        if($firstEntry){
            if($testsini.StartsWith("ExcludeO365Service")){
                $ExcludeService= $testsini.Split("=")[1].Split(",")
            }
        }
    }

    $firstEntry=$false
    foreach($testsini in $tests){
        if($testsini -eq '[O365_Subscriptions]'){
            $firstEntry=$true
        }
        elseif($testsini.StartsWith("[")){
            $firstEntry=$false
        }
        if($firstEntry){
            if($testsini -ne '[O365_Subscriptions]'){           
                $valAndOpt= $testsini.Split("=")
                $testsini=$testsini.ToUpper()
                $ExternalName=$valAndOpt[0]
                if($ExcludeService -contains ($ExternalName)){
                    continue
                }
                if($testsini.Contains("EXCHANGE")){
                    $EXOServiceName+="$ExternalName"
        	    }
			    elseif($testsini.Contains("LYNC") -or $testsini.Contains("SKYPE")){
                    $SBOServiceName+="$ExternalName"
			    }
			    elseif($testsini.Contains("SHAREPOINT")){
				    $SPOServiceName+="$ExternalName"
			    }
			    elseif($testsini.Contains("MICROSOFT TEAMS")){
				    $MTMServiceName+="$ExternalName"
			    }
            }
        }
    }

    if($CompType -eq 'SBO'){
        $tmpServiceName=$SBOServiceName
    }
    elseif($CompType -eq 'SPO'){
        $tmpServiceName=$SPOServiceName
    }
    elseif($CompType -eq 'EXO'){
        $tmpServiceName=$EXOServiceName
    }
    elseif($CompType -eq 'MTM'){
        $tmpServiceName=$MTMServiceName
    }
    for($k=0; $k -lt $LicensesCnt; $k++){ 
        $LicenseAccountSKUID = $Licenses[$k].AccountSKUID
        $SvcsCnt = $Licenses[$k].Status.split('~').count
        foreach($userstmp in $users){
            $UserAccountSKUID=$userstmp.AccId
                if($LicenseAccountSKUID -eq $UserAccountSKUID){      
                    for($j=0; $j -lt $SvcsCnt; $j++){
                        $ServiceName=$userstmp.ServiceName.Split(' ')
                        $ProvisioningStatus=$userstmp.ProvisioningStatus.Split(' ')
                        $SrvcName = $ServiceName[$j]
                        $SrvcStatus = $ProvisioningStatus[$j]
                        $UserName = $userstmp.UserName
                        $supportFlow=$false
                        if($SrvcName -ne $null -and $tmpServiceName -eq $null){ 
                            $supportFlow=$true
                        }
                        elseif($tmpServiceName -contains ($SrvcName)){
                            $supportFlow=$true
                        }
                        if($supportFlow){
                            $key = $UserName+'~'+$LicenseAccountSKUID+'~'+$SrvcName
                            $licSrvKey = $LicenseAccountSKUID +'~'+$SrvcName
                            $key1 = $LicenseAccountSKUID
                            if($measurehash.ContainsKey($key1)){
                                $tmparr=[int[]]$measurehash[$key1]
                                if($SrvcStatus -eq 'PendingActivation'){ 
                                    $tmparr[0]+=1
                                }
				                elseif ($SrvcStatus -eq 'PendingProvisioning'){ 
                                    $tmparr[1]+=1
                                }
                                elseif($SrvcStatus -eq 'PendingInput'){ 
                                    $tmparr[2]+=1
                                }
                                elseif($SrvcStatus -eq 'Success'){ 
                                    $tmparr[3]+=1
                                }
                                elseif($SrvcStatus -eq 'Disabled'){ 
                                    $tmparr[4]+=1
                                }
                            }
                            else{
                                $Disabledcnt=0
                                $PendingActivationcnt=0
                                $PendingProvisioncnt=0 
                                $PendingInputcnt=0
                                $Successcnt=0
                                if ($SrvcStatus -eq 'PendingProvisioning'){ 
                                    $PendingProvisioncnt=1
                                }
                                elseif($SrvcStatus -eq 'PendingActivation'){ 
                                    $PendingActivationcnt = 1
                                }
                                elseif($SrvcStatus -eq 'PendingInput'){ 
                                    $PendingInputcnt = 1
                                }
                                elseif($SrvcStatus -eq 'Success'){ 
                                    $Successcnt= 1
                                }
                                elseif($SrvcStatus -eq 'Disabled'){ 
                                    $Disabledcnt =1
                                }
                                [int[]]$measurearr =$PendingActivationcnt,$PendingProvisioncnt,$PendingInputcnt,$Successcnt,$Disabledcnt
                                $measurehash.add($key1,$measurearr)
                            }
                        if ($SrvcStatus -eq 'PendingProvisioning'){
                            if($PendingProvisionHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingProvisionHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingProvisionHash.add($licSrvKey, $ddarr)
                            }                              
                        }
                        elseif($SrvcStatus -eq 'PendingActivation'){
                            if($PendingActivationHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingActivationHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingActivationHash.add($licSrvKey, $ddarr)
                            }
                        }
                        elseif($SrvcStatus -eq 'PendingInput'){ 
                            if($PendingInputHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$PendingInputHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $PendingInputHash.add($licSrvKey, $ddarr)
                            }                                
                        }
                        elseif($SrvcStatus -eq 'Success'){
                            if($SuccessHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$SuccessHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $SuccessHash.add($licSrvKey, $ddarr)
                            }
                        }
                        elseif($SrvcStatus -eq 'Disabled'){ 
                            if($DisabledHash.ContainsKey($licSrvKey)){
                                $tmparr=[int[]]$DisabledHash[$licSrvKey]
                                $tmparr[0]+=1
                            }
                            else{
                                [int[]]$ddarr =1
                                $DisabledHash.add($licSrvKey, $ddarr)
                            }
                        }
                    }
                }
            }
        }
    }
    foreach($Hkey in $PendingActivationHash.keys){
        $HValue = $PendingActivationHash[$Hkey]
        Write-Host 'PendingActivationDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $PendingProvisionHash.keys){
        $HValue = $PendingProvisionHash[$Hkey]
        Write-Host 'PendingProvisionDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $PendingInputHash.keys){
        $HValue = $PendingInputHash[$Hkey]
        Write-Host 'PendingInputDD~'$Hkey'~'$HValue 
    }
    foreach($Hkey in $SuccessHash.keys){
        $HValue = $SuccessHash[$Hkey]
        Write-Host 'SuccessDD~'$Hkey'~'$HValue 
    }

    foreach($Hkey in $DisabledHash.keys){
        $HValue = $DisabledHash[$Hkey]
        Write-Host 'DisabledtDD~'$Hkey'~'$HValue 
    }
    foreach($Hkey in $measurehash.keys){
        $HValue = $measurehash[$Hkey]
        $HValue =$HValue -join '~'
        Write-Host 'MeasureCnt~'$Hkey '~' $HValue
    }

# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUclQt+zdxvJ4xm1Iom/Qg2tlH
# o+6ggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQUCSVrLGgwcqu4etJBFbgaouZF
# FeEwDQYJKoZIhvcNAQEBBQAEggEAR5l54t9/ZVs7IHGb74HJEMCkIwEbPJyQJQJU
# 5lh396vUB9MT+xwNW6F8K8ELuwTUzS72lx7/cL0Gp+2vFwuT/D5MZTB7NkHXuV2g
# hUrGSfBB3fyNbyDxv2E7tWMUxceMJgKjq6ff9xV5d58Uzz9Aub++ldlHJaEW6OTz
# /IZ/nPwIVVxdrWYkx1qScHS44O+GQdnN8+qzHAxte8TirMAeCMhiqgN06gRaULjL
# rhUAF5XodFEDGWWcHTlBZzEV/Rj790MPUDKVtvtPddXZ6GoRg0BmmOUz6LY5klea
# qL4abHCQJ98Jat8fWF6OADBwuv35zQpkMqZ1jJ8czrGA8aZlV6GCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwNzIzMDIwNDEwWjAjBgkqhkiG9w0BCQQxFgQUiTHFXCsAuTIgP9riDR7h
# 8U3cUGMwDQYJKoZIhvcNAQEBBQAEggEAcf1qDQvXCX7HWXnFVpuRkrV13e1ZE3kj
# xURn6Sc5lSeo5Z6R5g4675vfPBWF/SIdZqsayZDUBoYmL0Mau/0T8DqVohW4yG8F
# bN5D4dBH/MhHoXI82JHWtgPOdXr6hsbawLcwdQjVpUmqKHgowsLDLbfzW5SSWOzL
# R9XHIF7cogRz1bqI5cohkXrYsbEOdN+lR1nShfJTL3VCFqiz3ao0YaTU1Lnvixo5
# tsrGDGrDTLj32xf2T/pV7VGmTMZm+creoJCdiXd1W0CdARuCg9zQ6gf2bthTpcXD
# wUfwKpOq08OQKVh5pJCcGO3E4v/GHZa1p3DcI5pkMptEKxkwt1g4Zw==
# SIG # End signature block
