﻿##/*********************************************************************************
##Author                :   Vishnu S
##Purpose               :   Display the specific activities from audit log in O365
##Created               :   24/01/2018
##Modified By	        : 
##/*********************************************************************************
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$TestInputs=$args
$userName=$TestInputs[0]
$Password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$rpmea=$TestInputs[4]
$rpArr=$rpmea.Split('#')
$reportingNam=$rpArr[0]
$meaperiod=2*$rpArr[1]
#$proxyserverip=($rpArr[2]).ToString().trim()

$rptPath='O365/'+$reportingNam
try{
    $CultureDateTimeFormat = (Get-Culture).DateTimeFormat
    $DateFormat = $CultureDateTimeFormat.ShortDatePattern
    $TimeFormat = $CultureDateTimeFormat.LongTimePattern
    $DateTimeFormat = "$DateFormat $TimeFormat"

    $UserDisplayName=@{}
    $sysDateFmt=(Get-Date).ToUniversalTime().AddMinutes(-45)
    $sysDat=$sysDateFmt.AddMinutes(-$meaperiod)
    $SelectiveOprs=@("UserLoginFailed","UserLoggedIn")
    $uniqUserId=@{}

    $readUsrAct=Eg-ReadFile -ComntRptPath $rptPath -FileName "O365UsrAct" -keyFileName "kO365UsrAct" -EgPath $egurkhaPath
    $unProtctUsrAct=$readUsrAct[1] -replace (".csv",".dat") 
    $usrActPath=Unprotect-File $unProtctUsrAct -Algorithm AES -KeyAsPlainText $readUsrAct[0]	
    $a= import-csv $usrActPath
    Remove-Item $usrActPath
    foreach($b in $a){
        $dateCreated =[DateTime]::ParseExact(($b.CreationDate),$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        if($dateCreated -ge $sysDat){
            $activity = $b.AuditData | ConvertFrom-Json | select *          
            if($activity -ne "" -and $activity -ne $null){
                $key=$activity.Operation
                if($SelectiveOprs -Contains($key)){
                    if($uniqUserId.ContainsKey($key)){
                        $uniqUserId[$key]=[int]$uniqUserId[$key]+1
                    }else{
                        $uniqUserId.Add($key,1) 
                    }
                    if($key -eq "UserLoginFailed"){
                        Write-Host '#ddLoginFailed '$dateCreated '~!~'$activity.ClientIP'~!~'$activity.UserId'~!~'$activity.Workload
                    }
                }
            }
        }
    }
    if($uniqUserId -ne $null){
        foreach($key in $uniqUserId.keys){
            Write-Host $key '~'$uniqUserId[$key]
        }
    }
}
catch{    
    	$exceptionmsg=($_.Exception.Message)+($_.ScriptStackTrace) 
	    Write-error "Error Occured in User Logins Test --  $exceptionmsg "
}