/*
 * Decompiled with CFR 0.152.
 */
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.DimensionFilter;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsResult;
import com.amazonaws.services.cloudwatch.model.ListMetricsRequest;
import com.amazonaws.services.cloudwatch.model.Metric;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.Reservation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;

public class AWSCloudWatchMonitor {
    CloudInfo cInfo = null;
    private Hashtable metricType = null;
    private String serviceName = null;
    Hashtable ht_serviceWithDimValue = null;
    String regionName = "";
    String reportingName = "";
    String index = "";
    CloudConnection cloudConn = null;

    public AWSCloudWatchMonitor(CloudInfo cloudInfo, String string) {
        this.cInfo = cloudInfo;
        this.regionName = string;
    }

    public Hashtable fetchAndGetMetrics() {
        this.cloudConn = new CloudConnection(this.cInfo);
        String string = (String)CloudConstants.ht_CloudwatchEndPoint.get(this.regionName);
        String string2 = this.cInfo.getNameSpace();
        this.serviceName = this.cInfo.getServiceName();
        this.reportingName = this.cInfo.getReportingName();
        if (string == null) {
            return null;
        }
        AmazonCloudWatchClient amazonCloudWatchClient = this.cloudConn.getAWSCloudWatchConnection(string);
        if (amazonCloudWatchClient == null) {
            return null;
        }
        Hashtable hashtable = this.gatherMetrics(amazonCloudWatchClient, this.regionName, string2);
        this.cloudConn.disconnectWebClient((AmazonWebServiceClient)amazonCloudWatchClient);
        return hashtable;
    }

    public Hashtable gatherMetrics(AmazonCloudWatchClient amazonCloudWatchClient, String string, String string2) {
        Object var4_4 = null;
        Date date = null;
        Date date2 = null;
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        List list = this.getMetrics(amazonCloudWatchClient);
        this.metricType = this.cInfo.getMetricType();
        ArrayList arrayList = this.cInfo.getFilterNames();
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list != null && list.size() > 0) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            gregorianCalendar.add(13, -1 * gregorianCalendar.get(13));
            if (this.serviceName.equalsIgnoreCase("Billing")) {
                date = gregorianCalendar.getTime();
                gregorianCalendar.add(10, -6);
                date2 = gregorianCalendar.getTime();
            } else if (this.serviceName.equalsIgnoreCase("S3") || this.serviceName.equalsIgnoreCase("WorkSpaces")) {
                date = gregorianCalendar.getTime();
                gregorianCalendar.add(12, -5);
                date2 = gregorianCalendar.getTime();
            } else if (this.serviceName.equalsIgnoreCase("S3_24hrs")) {
                date = gregorianCalendar.getTime();
                gregorianCalendar.add(10, -24);
                date2 = gregorianCalendar.getTime();
            } else {
                date = gregorianCalendar.getTime();
                gregorianCalendar.add(12, -10);
                date2 = gregorianCalendar.getTime();
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                ArrayList arrayList2;
                Hashtable hashtable2;
                Metric metric = (Metric)list.get(i);
                List list2 = metric.getDimensions();
                int n = list2.size();
                String string3 = "";
                int n2 = -5;
                if (n == 1) {
                    if (this.serviceName.equalsIgnoreCase("elb_network") && ((Dimension)list2.get(0)).getName().equalsIgnoreCase("loadbalancer") && !metric.getMetricName().equalsIgnoreCase("consumedlcus")) continue;
                    string3 = ((Dimension)list2.get(0)).getValue();
                } else if (n == 2) {
                    if ((this.serviceName.equalsIgnoreCase("elb_network") || this.serviceName.equalsIgnoreCase("elb_application")) && ((Dimension)list2.get(0)).getName().equalsIgnoreCase("targetgroup") && ((Dimension)list2.get(1)).getName().equalsIgnoreCase("loadbalancer")) {
                        string3 = ((Dimension)list2.get(1)).getValue() + ":" + ((Dimension)list2.get(0)).getValue();
                    } else {
                        if (this.serviceName.equalsIgnoreCase("elb_application") && ((Dimension)list2.get(0)).getName().equalsIgnoreCase("loadbalancer") && ((Dimension)list2.get(1)).getName().equalsIgnoreCase("AvailabilityZone")) continue;
                        string3 = ((Dimension)list2.get(0)).getValue() + ":" + ((Dimension)list2.get(1)).getValue();
                    }
                } else if (n >= 3 && (this.serviceName.equalsIgnoreCase("elb_network") || this.serviceName.equalsIgnoreCase("elb_application"))) continue;
                if (string3 == null || string3.length() == 0) continue;
                if (!hashtable.containsKey(string3)) {
                    hashtable.put(string3, new Hashtable());
                }
                if ((hashtable2 = (Hashtable)hashtable.get(string3)).containsKey(metric.getMetricName())) continue;
                String string4 = metric.getMetricName();
                if (this.serviceName.equalsIgnoreCase("EC2") && ((String)arrayList.get(0)).equalsIgnoreCase("InstanceId") && this.cInfo != null && (arrayList2 = this.cInfo.getExcludedInstances()) != null && arrayList2.size() > 0) {
                    int n3 = arrayList2.size();
                    boolean bl = false;
                    for (int j = 0; j < n3; ++j) {
                        object = (String)arrayList2.get(j);
                        if (object == null || !this.isPaternMatch(string3, (String)object)) continue;
                        System.out.println(this.reportingName + " [AWSCloudWatchMonitor] " + string3 + " is in exclude list");
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                if (string4 == null || string4.length() <= 0) continue;
                try {
                    arrayList2 = new ArrayList();
                    String string5 = (String)this.metricType.get(string4);
                    if (string5 == null || string5.equalsIgnoreCase("") || string5.length() == 0) continue;
                    arrayList2.add(string5);
                    GetMetricStatisticsRequest getMetricStatisticsRequest = this.createGetMetricStatisticsRequest(string2, string4, arrayList2, list2, date, date2);
                    GetMetricStatisticsResult getMetricStatisticsResult = amazonCloudWatchClient.getMetricStatistics(getMetricStatisticsRequest);
                    if (getMetricStatisticsResult == null) {
                        System.out.println(string + " : " + list2 + "result is null for " + string4);
                    }
                    if ((object = getMetricStatisticsResult.getDatapoints()) != null && !object.isEmpty()) {
                        Object var24_28 = null;
                        double d = -5.0;
                        d = this.serviceName.equalsIgnoreCase("S3") && string4.endsWith("Requests") || this.serviceName.equalsIgnoreCase("WorkSpaces") && (string4.endsWith("Available") || string4.endsWith("Unhealthy") || string4.endsWith("Stopped") || string4.endsWith("Maintenance") || string4.endsWith("ConnectionAttempt") || string4.endsWith("ConnectionSuccess") || string4.endsWith("ConnectionFailure") || string4.endsWith("SessionLaunchTime") || string4.endsWith("InSessionLatency") || string4.endsWith("SessionDisconnect") || string4.endsWith("UserConnected")) ? this.getSumOfDatapoints(string4, (List)object) : this.getLatestDatapoint(string4, (List)object);
                        hashtable2.put(string4, new Double(d));
                    }
                    if (hashtable2 == null || hashtable2.size() <= 0) continue;
                    hashtable.put(string3, hashtable2);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("ERROR : while Collecting Datapoints..." + exception);
                    exception.printStackTrace();
                }
            }
        }
        return hashtable;
    }

    protected List getMetrics(AmazonCloudWatchClient amazonCloudWatchClient) {
        try {
            DimensionFilter dimensionFilter;
            Object object;
            if (this.cInfo == null || amazonCloudWatchClient == null) {
                return null;
            }
            ArrayList arrayList = this.cInfo.getFilterNames();
            String string = this.cInfo.getNameSpace();
            ListMetricsRequest listMetricsRequest = new ListMetricsRequest();
            ArrayList<DimensionFilter> arrayList2 = new ArrayList<DimensionFilter>();
            int n = arrayList.size();
            if (arrayList != null && n > 0) {
                for (int i = 0; i < n; ++i) {
                    object = (String)arrayList.get(i);
                    dimensionFilter = new DimensionFilter();
                    dimensionFilter.withName((String)object);
                    arrayList2.add(dimensionFilter);
                }
            }
            listMetricsRequest.withNamespace(string);
            listMetricsRequest.withDimensions(arrayList2);
            List list = listMetricsRequest.getDimensions();
            object = new ArrayList();
            dimensionFilter = amazonCloudWatchClient.listMetrics(listMetricsRequest);
            object = dimensionFilter.getMetrics();
            while (dimensionFilter.getNextToken() != null) {
                listMetricsRequest.setNextToken(dimensionFilter.getNextToken());
                dimensionFilter = amazonCloudWatchClient.listMetrics(listMetricsRequest);
                object.addAll(dimensionFilter.getMetrics());
            }
            return object;
        }
        catch (Exception exception) {
            System.out.println(" Execution Exception in getMetrics Method " + exception);
            return null;
        }
    }

    protected GetMetricStatisticsRequest createGetMetricStatisticsRequest(String string, String string2, ArrayList arrayList, List list, Date date, Date date2) {
        try {
            GetMetricStatisticsRequest getMetricStatisticsRequest = new GetMetricStatisticsRequest().withStartTime(date2).withNamespace(string).withDimensions((Collection)list).withPeriod(new Integer(60)).withMetricName(string2).withStatistics((Collection)arrayList).withEndTime(date);
            return getMetricStatisticsRequest;
        }
        catch (Exception exception) {
            System.out.println(" Exception while request to GetMetricStatisticsRequest Method " + exception);
            return null;
        }
    }

    public Integer getInstanceStatus(AmazonEC2 amazonEC2, String string) {
        try {
            Instance instance;
            InstanceState instanceState;
            Reservation reservation;
            List list;
            List list2;
            DescribeInstancesResult describeInstancesResult;
            if (amazonEC2 == null || string == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            String string2 = "";
            Integer n = null;
            DescribeInstancesRequest describeInstancesRequest = new DescribeInstancesRequest().withInstanceIds(arrayList);
            if (describeInstancesRequest != null && (describeInstancesResult = amazonEC2.describeInstances(describeInstancesRequest)) != null && (list2 = describeInstancesResult.getReservations()) != null && !list2.isEmpty() && (list = (reservation = (Reservation)list2.get(0)).getInstances()) != null && !list.isEmpty() && (instanceState = (instance = (Instance)list.get(0)).getState()) != null) {
                string2 = instanceState.getName();
                n = instanceState.getCode();
            }
            return n;
        }
        catch (Exception exception) {
            System.out.println(string + " Exception while getting instance state ...." + exception);
            return null;
        }
    }

    protected double getValue(String string, Datapoint datapoint) {
        String string2 = (String)this.metricType.get(string);
        Double d = null;
        double d2 = -5.0;
        if (string2.equalsIgnoreCase("average")) {
            d = datapoint.getAverage();
        } else if (string2.equalsIgnoreCase("sum")) {
            d = datapoint.getSum();
        } else if (string2.equalsIgnoreCase("maximum")) {
            d = datapoint.getMaximum();
        } else if (string2.equalsIgnoreCase("minimum")) {
            d = datapoint.getMinimum();
        } else if (string2.equalsIgnoreCase("SampleCount")) {
            d = datapoint.getSampleCount();
        }
        if (d != null) {
            d2 = d;
        }
        return d2;
    }

    protected double getLatestDatapoint(String string, List list) {
        Datapoint datapoint = null;
        if (list != null && list.size() > 0) {
            Date date = null;
            for (int i = 0; i < list.size(); ++i) {
                if (datapoint == null) {
                    datapoint = (Datapoint)list.get(i);
                    date = datapoint.getTimestamp();
                    continue;
                }
                Datapoint datapoint2 = (Datapoint)list.get(i);
                Date date2 = datapoint2.getTimestamp();
                if (date == null || date2 == null || date2.compareTo(date) != 1) continue;
                datapoint = datapoint2;
                date = date2;
            }
        }
        double d = this.getValue(string, datapoint);
        return d;
    }

    protected double getSumOfDatapoints(String string, List list) {
        double d = 0.0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Datapoint datapoint = (Datapoint)list.get(i);
                double d2 = this.getValue(string, datapoint);
                if (!(d2 >= 0.0)) continue;
                d += d2;
            }
        }
        return d;
    }

    private boolean isPaternMatch(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = "";
        string3 = string2.startsWith("*") ? string2.substring(string2.indexOf("*") + 1) : (string2.endsWith("*") ? string2.substring(0, string2.indexOf("*")) : string2);
        if (string.indexOf(string3) != -1) {
            System.out.println(" [AWSCLOUDWatchMonitor] paternMatch true : " + this.regionName + " : " + string3);
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
    }
}

