/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IISWebSiteReqTest
extends GenericTest {
    private double requestCutOff = 4.0;
    public Hashtable ddSlowRequestHash = new Hashtable();
    private IISHelper iisHelper = null;
    private String systemDir = "";
    private boolean useAppcmd = false;
    private boolean isWebsiteConfigured = false;
    private String website = "";
    private boolean isFirstTime = true;
    private ArrayList websiteList = new ArrayList();
    private String excludedWebsites = "";

    public IISWebSiteReqTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.isNewDynamicInfoTest = true;
        this.isFirstTime = true;
        this.iisHelper = new IISHelper(this.reportingName);
        String string = this.getValueForParam("website_name");
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            this.isWebsiteConfigured = false;
            this.website = "";
        } else {
            this.isWebsiteConfigured = true;
            this.website = string.toLowerCase();
        }
        String string2 = this.getValueForParam("exclude_websites");
        this.excludedWebsites = string2 == null || string2.length() == 0 || string2.equalsIgnoreCase("none") ? "none" : string2.trim();
        String string3 = this.getValueForParam("slow_request_cutoff");
        if (string3 != null && string3.length() > 0) {
            try {
                this.requestCutOff = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.requestCutOff = 4.0;
                numberFormatException.printStackTrace();
            }
        } else {
            this.requestCutOff = 4.0;
        }
        this.useAppcmd = true;
        this.systemDir = System.getenv("SystemRoot") + "\\System32";
    }

    public void freeTest() {
        this.ddSlowRequestHash = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Object object;
            Cloneable cloneable;
            if (!this.useAppcmd) {
                return;
            }
            if (this.iisHelper == null) {
                this.iisHelper = new IISHelper(this.reportingName);
            }
            if (this.isFirstTime && this.isWebsiteConfigured) {
                this.websiteList = this.iisHelper.getWebsiteList(this.website, this.excludedWebsites);
                cloneable = new ArrayList();
                if (this.websiteList != null && this.websiteList.size() > 0) {
                    for (int i = 0; i < this.websiteList.size(); ++i) {
                        String string = (String)this.websiteList.get(i);
                        if (string == null) continue;
                        string = string.toLowerCase();
                        ((ArrayList)cloneable).add(string);
                    }
                }
                this.websiteList = (ArrayList)((ArrayList)cloneable).clone();
                this.isFirstTime = false;
            }
            if ((cloneable = this.iisHelper.getSiteNameIdMap()) == null || ((Hashtable)cloneable).size() == 0) {
                return;
            }
            Hashtable hashtable2 = this.getRequestDetails();
            if (hashtable2 == null) {
                hashtable2 = new Hashtable();
            }
            double d = 0.0;
            double d2 = 0.0;
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration enumeration = ((Hashtable)cloneable).keys();
            Hashtable hashtable3 = new Hashtable();
            while (enumeration.hasMoreElements()) {
                ArrayList arrayList2;
                String string;
                object = (String)enumeration.nextElement();
                if (object == null || ((String)object).trim().length() == 0 || (string = (String)((Hashtable)cloneable).get(object)) == null || string.trim().length() == 0 || this.isWebsiteConfigured && !this.websiteList.contains(string.toLowerCase())) continue;
                ArrayList arrayList3 = (ArrayList)hashtable2.get(object);
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList();
                }
                if ((arrayList2 = (ArrayList)this.ddSlowRequestHash.get(object)) == null) {
                    arrayList2 = new ArrayList();
                }
                if (arrayList2.size() > 0) {
                    hashtable3.put(string, arrayList2);
                }
                int n = arrayList3.size();
                int n2 = arrayList2.size();
                String string2 = string + "~!~" + n + "~!~" + n2;
                arrayList.add(string2);
                d += (double)n;
                d2 += (double)n2;
                ArrayList<Double> arrayList4 = new ArrayList<Double>();
                arrayList4.add(new Double(n));
                arrayList4.add(new Double(n2));
                this.addNewMeasure(string, arrayList4);
            }
            this.ddSlowRequestHash = new Hashtable();
            this.ddSlowRequestHash = hashtable3;
            object = new ArrayList();
            ((ArrayList)object).add(new Double(d));
            ((ArrayList)object).add(new Double(d2));
            this.addNewMeasure("All Web Sites", (ArrayList)object);
            this.ddSlowRequestHash.put("All Web Sites", arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getRequestDetails() {
        Hashtable<String, ArrayList<String>> hashtable = new Hashtable<String, ArrayList<String>>();
        this.ddSlowRequestHash = new Hashtable();
        try {
            String string;
            Hashtable hashtable2;
            if (this.iisHelper == null) {
                this.iisHelper = new IISHelper(this.reportingName);
            }
            if ((hashtable2 = this.iisHelper.getSiteNameIdMap()) == null || hashtable2.size() == 0) {
                hashtable2 = new Hashtable();
            }
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.iisHelper.executeAppCmd("list requests /text:*");
            if (arrayList2 == null) {
                return hashtable;
            }
            if (arrayList2 != null && arrayList2.size() > 1) {
                arrayList = (ArrayList)arrayList2.get(0);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(1);
                if (arrayList3 != null && arrayList3.size() > 0) {
                    string = arrayList3.toString();
                }
            }
            if (arrayList == null || arrayList.size() == 0) {
                System.out.println("[IISWebSiteReqTest] outList is NULL !!");
                return hashtable;
            }
            int n = arrayList.size();
            string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            boolean bl = false;
            double d = this.requestCutOff * 1000.0;
            for (int i = 0; i < n; ++i) {
                int n2;
                String string10 = (String)arrayList.get(i);
                if (string10 == null || string10.trim().length() == 0) continue;
                if ((string10 = string10.trim()).equalsIgnoreCase("REQUEST")) {
                    string = "";
                    string2 = "";
                    string3 = "";
                    string4 = "";
                    string5 = "";
                    string6 = "";
                    string7 = "";
                    string8 = "";
                    string9 = "";
                    bl = false;
                }
                if ((n2 = string10.indexOf(":")) == -1) continue;
                if (string10.toLowerCase().startsWith("url:")) {
                    string2 = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (string10.toLowerCase().startsWith("verb:")) {
                    string = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (string10.toLowerCase().startsWith("time:")) {
                    string3 = this.getValidValue(string10.substring(n2 + 1));
                    if (string3 == null || string3.length() <= 0 || string3.equals("-")) continue;
                    double d2 = EgLangInfo.getDoubleValue((String)string3);
                    if (d2 < 0.0) {
                        d2 = 0.0;
                    }
                    if (!(d2 >= d)) continue;
                    bl = true;
                    continue;
                }
                if (string10.toLowerCase().startsWith("clientip:")) {
                    string4 = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (string10.toLowerCase().startsWith("stage:")) {
                    string5 = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (string10.toLowerCase().startsWith("module:")) {
                    string6 = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (string10.toLowerCase().startsWith("site.id:")) {
                    string7 = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (string10.toLowerCase().startsWith("wp.name:")) {
                    string9 = this.getValidValue(string10.substring(n2 + 1));
                    continue;
                }
                if (!string10.toLowerCase().startsWith("apppool.name:")) continue;
                string8 = this.getValidValue(string10.substring(n2 + 1));
                if (string7 == null || string7.length() == 0 || string7.equals("-")) continue;
                String string11 = string2 + "~!~" + string + "~!~" + string5 + "~!~" + string6 + "~!~" + string3 + "~!~" + string4 + "~!~" + string9 + "~!~" + string8;
                ArrayList<String> arrayList4 = (ArrayList<String>)hashtable.get(string7);
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<String>();
                }
                arrayList4.add(string11);
                hashtable.put(string7, arrayList4);
                if (!bl) continue;
                arrayList4 = (ArrayList<String>)this.ddSlowRequestHash.get(string7);
                if (arrayList4 == null) {
                    arrayList4 = new ArrayList<String>();
                }
                arrayList4.add(string11);
                this.ddSlowRequestHash.put(string7, arrayList4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getValidValue(String string) {
        String string2 = "-";
        try {
            if (string == null || string.trim().length() == 0) {
                return string2;
            }
            string2 = string.replace('\"', ' ');
            if ((string2 = string2.trim()).length() == 0) {
                string2 = "-";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2).trim();
            arrayList.add(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n).trim();
        arrayList.add(string3);
        return arrayList;
    }
}

