/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import com.eg.IniFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServerSocketCreator
extends Thread {
    private static ServerSocketCreator instance = null;
    private ServerSocket listener = null;
    private boolean restartServer = true;
    private Thread thread;
    private Vector clientSocketLister;
    private Vector clrSocketLister;
    private Vector azureBtmSocketLister = new Vector();
    private Vector azureClrSocketLister = new Vector();
    private Hashtable mapSettings;
    private Hashtable descriptorThresholds;
    private static String sync = new String("Debanka");
    private static String syncString = new String("DotNetBtm");
    private static boolean isServerSocketCreated = false;
    private Hashtable clrSocketChildThdHash = new Hashtable();
    private Hashtable threadMap = new Hashtable();
    private Vector processThreadList = new Vector();
    private int processThreadLimit = 50;
    private int processThreadCount = 1;
    private EgDateInfo dateInfo = new EgDateInfo();
    private PrintWriter logWriter;
    private static final int fileSizeLimit = 5000000;
    private String errorLogFilePath = EgInstallInfo.getInstallDir() + "/agent/logs/dotnetthread/error_log";
    public static final String BTM_TYPE = "BTM";
    public static final String CLR_TYPE = "CLR";
    public static final String AZURE_BTM_TYPE = "AZURE_BTM";
    public static final String AZURE_CLR_TYPE = "AZURE_CLR";
    private Vector clientStreamListener;

    private ServerSocketCreator() {
        this.mapSettings = new Hashtable();
        this.descriptorThresholds = new Hashtable();
        this.clientSocketLister = new Vector();
        this.clrSocketLister = new Vector();
        this.azureClrSocketLister = new Vector();
        this.azureBtmSocketLister = new Vector();
        this.clientStreamListener = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocketCreator getInstance() {
        if (instance == null) {
            String string = sync;
            synchronized (string) {
                if (instance == null) {
                    instance = new ServerSocketCreator();
                }
            }
        }
        return instance;
    }

    public static void removeInstance() {
        instance = null;
    }

    public void setThreadLimit(int n) {
        System.out.println("[ServerSocketCreator] setThreadLimit() =" + n);
        if (this.processThreadLimit != n) {
            this.processThreadLimit = n;
        }
    }

    public int getThreadLimit() {
        return this.processThreadLimit;
    }

    public boolean createServerSocket() {
        boolean bl = false;
        int n = 10;
        int n2 = 0;
        int n3 = 14001;
        try {
            if (isServerSocketCreated) {
                return true;
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_DotnetServer.ini", false);
            String string = iniFile.getValue("EG_DOTNET_SERVER_DATA", "PORT");
            String string2 = iniFile.getValue("SERVER_SOCKET_SETTINGS", "BACKLOG");
            String string3 = iniFile.getValue("SERVER_SOCKET_SETTINGS", "TIME_OUT");
            try {
                n3 = Integer.parseInt(string.trim());
            }
            catch (Exception exception) {
                n3 = 14001;
            }
            try {
                n = Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                n = 10;
            }
            try {
                n2 = Integer.parseInt(string3.trim());
            }
            catch (Exception exception) {
                n2 = 0;
            }
            if (DTMProfilerHelper.debugFlag >= 1) {
                System.out.println("[ServerSocketCreator] creating new instance of serversocket at port =" + n3);
            }
            this.listener = new ServerSocket(n3, n);
            this.listener.setSoTimeout(n2);
            bl = true;
            this.thread = new Thread(this);
            this.thread.start();
            System.out.println("[ServerSocketCreator] DTMProfilerHelper start()... ");
            DTMProfilerHelper.getInstance().startThread();
        }
        catch (SocketException socketException) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)socketException);
            this.logToErrorFile("Error", "[ServerSocketCreator]", string);
            bl = false;
        }
        catch (IOException iOException) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)iOException);
            this.logToErrorFile("Error", "[ServerSocketCreator]", string);
            bl = false;
        }
        catch (Exception exception) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", "[ServerSocketCreator]", string);
            bl = false;
        }
        return bl;
    }

    public ServerSocket getServerSocket() {
        return this.listener;
    }

    public void closeServerSocket(boolean bl) {
        isServerSocketCreated = false;
        try {
            System.out.println("[ServerSocketCreator] DTMProfilerHelper stopThread()... ");
            DTMProfilerHelper.getInstance().stopThread();
            this.closeAllSockets();
            this.restartServer = bl;
            if (this.listener != null) {
                this.listener.close();
            }
        }
        catch (IOException iOException) {
            String string = EgInstallInfo.getStackTraceAsString((Exception)iOException);
            this.logToErrorFile("Error", "ServerSocketCreator : CloseServerSocket() ", string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignToAvailableThread(String string, String string2) {
        try {
            String string3 = syncString;
            synchronized (string3) {
                int n;
                DTMProcessThread dTMProcessThread = null;
                if (this.processThreadList == null) {
                    this.processThreadList = new Vector();
                }
                if ((n = this.processThreadList.size()) < this.processThreadLimit) {
                    String string4 = "eG_ProcessThd_" + this.processThreadCount;
                    ++this.processThreadCount;
                    DTMProcessThread dTMProcessThread2 = new DTMProcessThread(string4);
                    this.processThreadList.add(dTMProcessThread2);
                    dTMProcessThread2.addChildThread(string, string2);
                    dTMProcessThread = dTMProcessThread2;
                } else {
                    int n2;
                    boolean bl = false;
                    for (n2 = 0; n2 < n; ++n2) {
                        DTMProcessThread dTMProcessThread3 = (DTMProcessThread)this.processThreadList.get(n2);
                        if (dTMProcessThread3 == null || !dTMProcessThread3.isAlive()) {
                            dTMProcessThread3 = new DTMProcessThread("eG_ProcessThd_" + this.processThreadCount);
                            ++this.processThreadCount;
                            this.processThreadList.set(n2, dTMProcessThread3);
                            dTMProcessThread3.addChildThread(string, string2);
                            dTMProcessThread = dTMProcessThread3;
                            bl = true;
                            break;
                        }
                        if (!dTMProcessThread3.done) continue;
                        dTMProcessThread3.addChildThread(string, string2);
                        dTMProcessThread = dTMProcessThread3;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        n2 = this.clientSocketLister.size();
                        int n3 = n2 % this.processThreadLimit;
                        if (n3 + 1 > this.processThreadList.size()) {
                            n3 = 0;
                        }
                        DTMProcessThread dTMProcessThread4 = (DTMProcessThread)this.processThreadList.get(n3);
                        dTMProcessThread4.addChildThread(string, string2);
                        dTMProcessThread = dTMProcessThread4;
                    }
                }
                this.threadMap.put(string, dTMProcessThread);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket = null;
        String string = "";
        isServerSocketCreated = true;
        try {
            try {
                int n = 1;
                while (true) {
                    if (DTMProfilerHelper.debugFlag >= 1) {
                        System.out.println("ServerSocketCreator: Listening..");
                    }
                    socket = ServerSocketCreator.getInstance().getServerSocket().accept();
                    ChildThread childThread = new ChildThread(socket);
                    string = "eGDrones_" + n;
                    this.setConnection(socket, childThread);
                    childThread.open(string);
                    ++n;
                }
            }
            catch (Exception exception) {
                try {
                    String string2 = EgInstallInfo.getStackTraceAsString((Exception)exception);
                    this.logToErrorFile("Error", "ServerSocketCreator", string2);
                    this.closeServerSocket(true);
                    this.removeConnection(socket, string, "ALL");
                    if (socket != null) {
                        socket.close();
                    }
                    if (this.restartServer) {
                        this.logToErrorFile("Error", "ServerSocketCreator", "Attempting to recreate the server socket..");
                        ServerSocketCreator.getInstance().createServerSocket();
                    }
                }
                catch (IOException iOException) {
                    String string3 = EgInstallInfo.getStackTraceAsString((Exception)iOException);
                    this.logToErrorFile("Error", "ServerSocketCreator : Exception is caught while closing the server socket ", string3);
                }
                isServerSocketCreated = false;
                if (DTMProfilerHelper.debugFlag >= 1) {
                    System.out.println("[ServerSocketCreator] Server Socket got closed gracefully");
                }
            }
        }
        catch (Throwable throwable) {
            isServerSocketCreated = false;
            if (DTMProfilerHelper.debugFlag >= 1) {
                System.out.println("[ServerSocketCreator] Server Socket got closed gracefully");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToLister(Socket socket, ChildThread childThread, String string) {
        try {
            String string2 = syncString;
            synchronized (string2) {
                this.clientSocketLister.remove(socket);
            }
            if (socket != null) {
                this.clrSocketChildThdHash.put(socket, childThread);
                if (string.equalsIgnoreCase(CLR_TYPE)) {
                    this.clrSocketLister.add(socket);
                } else if (string.equalsIgnoreCase(AZURE_BTM_TYPE)) {
                    this.azureBtmSocketLister.add(socket);
                } else if (string.equalsIgnoreCase(AZURE_CLR_TYPE)) {
                    this.azureClrSocketLister.add(socket);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setConnection(Socket socket, ChildThread childThread) {
        try {
            if (socket != null) {
                this.clientSocketLister.add(socket);
            }
            if (childThread != null) {
                this.clientStreamListener.add(childThread);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeConnection(Socket socket, String string, String string2) {
        try {
            if (string2.equalsIgnoreCase(BTM_TYPE)) {
                int n = this.clientSocketLister.indexOf(socket);
                if (n >= 0) {
                    this.clientStreamListener.remove(n);
                }
                if (socket != null) {
                    this.clientSocketLister.remove(socket);
                }
                if (this.threadMap != null) {
                    DTMProcessThread dTMProcessThread = (DTMProcessThread)this.threadMap.get(string);
                    if (dTMProcessThread != null && dTMProcessThread.isAlive()) {
                        dTMProcessThread.removeChildThread(string);
                    }
                    this.threadMap.remove(string);
                }
                this.updateProcessThdList();
            } else if (string2.equalsIgnoreCase(AZURE_BTM_TYPE)) {
                if (socket != null) {
                    this.azureBtmSocketLister.remove(socket);
                }
                if (this.threadMap != null) {
                    DTMProcessThread dTMProcessThread = (DTMProcessThread)this.threadMap.get(string);
                    if (dTMProcessThread != null && dTMProcessThread.isAlive()) {
                        dTMProcessThread.removeChildThread(string);
                    }
                    this.threadMap.remove(string);
                }
                this.updateProcessThdList();
            } else if (string2.equalsIgnoreCase(CLR_TYPE)) {
                if (socket != null) {
                    this.clrSocketLister.remove(socket);
                    this.clrSocketChildThdHash.remove(socket);
                }
                DTMProfilerHelper.getInstance().removeChildThread(string);
            } else if (string2.equalsIgnoreCase(AZURE_CLR_TYPE)) {
                if (socket != null) {
                    this.azureClrSocketLister.remove(socket);
                }
                DTMAzureHelper.getInstance().removeChildThread(string);
            } else if (string2.equalsIgnoreCase("ALL")) {
                if (socket != null) {
                    this.clientSocketLister.remove(socket);
                    this.clrSocketLister.remove(socket);
                    this.azureBtmSocketLister.remove(socket);
                    this.azureClrSocketLister.remove(socket);
                }
                if (this.threadMap != null) {
                    DTMProcessThread dTMProcessThread = (DTMProcessThread)this.threadMap.get(string);
                    if (dTMProcessThread != null && dTMProcessThread.isAlive()) {
                        dTMProcessThread.removeChildThread(string);
                    }
                    this.threadMap.remove(string);
                }
                this.updateProcessThdList();
                DTMProfilerHelper.getInstance().removeChildThread(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateProcessThdList() {
        try {
            Hashtable hashtable;
            Vector vector;
            if (this.processThreadList == null) {
                this.processThreadList = new Vector();
            }
            if ((vector = (Vector)this.processThreadList.clone()) == null || vector.size() == 0) {
                return;
            }
            if (this.threadMap == null) {
                this.threadMap = new Hashtable();
            }
            if ((hashtable = (Hashtable)this.threadMap.clone()) != null && hashtable.size() > 0) {
                for (DTMProcessThread dTMProcessThread : hashtable.values()) {
                    vector.remove(dTMProcessThread);
                }
            }
            if (vector.size() == 0) {
                return;
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                DTMProcessThread dTMProcessThread = (DTMProcessThread)vector.get(i);
                if (dTMProcessThread == null || !dTMProcessThread.isAlive()) continue;
                dTMProcessThread.setTerminateFlag(true);
            }
            this.processThreadList.removeAll(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Settings getSettings(String string, String string2) {
        Settings settings = null;
        if (string == null) {
            return settings;
        }
        try {
            Hashtable hashtable = (Hashtable)this.mapSettings.get(string2);
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            settings = (Settings)hashtable.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return settings;
    }

    public void setSettingsInformation(String string, Settings settings, String string2) {
        if (string == null) {
            return;
        }
        try {
            ArrayList arrayList;
            Hashtable<String, Settings> hashtable = (Hashtable<String, Settings>)this.mapSettings.get(string2);
            if (hashtable == null) {
                hashtable = new Hashtable<String, Settings>();
            }
            if ((arrayList = ServerSocketCreator.myTokenizer(string, ",")) == null || arrayList.size() == 0) {
                return;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)arrayList.get(i);
                if (string3 == null || string3.trim().length() == 0) continue;
                hashtable.put(string3.trim(), settings);
            }
            this.mapSettings.put(string2, hashtable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getAllSettings(String string) {
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = (Hashtable)this.mapSettings.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (Hashtable)hashtable.clone();
    }

    private void removeConfigSettings(String string, String string2) {
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = (Hashtable)this.mapSettings.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            hashtable.remove(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDescriptorThreshold(String string, Hashtable hashtable, String string2) {
        if (string == null) {
            return;
        }
        try {
            Hashtable<String, String> hashtable2;
            Hashtable hashtable3 = (Hashtable)this.descriptorThresholds.get(string2);
            if (hashtable3 == null) {
                hashtable3 = new Hashtable();
            }
            if ((hashtable2 = (Hashtable<String, String>)hashtable3.get(string)) == null) {
                hashtable2 = new Hashtable<String, String>();
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3;
                String string4 = (String)enumeration.nextElement();
                if (string4 == null || string4.trim().length() == 0 || (string3 = (String)hashtable.get(string4)) == null || string3.trim().length() == 0) continue;
                hashtable2.put(string4, string3.trim());
            }
            hashtable3.put(string, hashtable2);
            this.descriptorThresholds.put(string2, hashtable3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getAllDescriptorThreshold(String string) {
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = (Hashtable)this.descriptorThresholds.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return (Hashtable)hashtable.clone();
    }

    public void removeDescriptorThreshold(String string, String string2, String string3) {
        try {
            Hashtable hashtable = (Hashtable)this.descriptorThresholds.get(string3);
            if (hashtable == null || hashtable.size() == 0) {
                return;
            }
            Hashtable hashtable2 = (Hashtable)hashtable.get(string);
            System.out.println("[ServerSocketCreator] removeDesc descriptorHash --->" + hashtable2);
            if (hashtable2 == null || hashtable2.size() == 0) {
                return;
            }
            hashtable2.remove(string2);
            hashtable.put(string, hashtable2);
            this.descriptorThresholds.put(string3, hashtable);
            System.out.println("[ServerSocketCreator] removeDesc descriptorThresholds --->" + this.descriptorThresholds);
        }
        catch (Exception exception) {
            String string4 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("ERROR", "ServerSocketCreator", string4);
        }
    }

    private void removeThreshold(String string, String string2) {
        try {
            Hashtable hashtable = (Hashtable)this.descriptorThresholds.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
            }
            hashtable.remove(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeSettings(String string, String string2) {
        if (string == null) {
            return;
        }
        try {
            this.broadcast("-&eGRemove&-@" + string, string2);
            this.removeConfigSettings(string2, string);
            this.removeThreshold(string2, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void broadcast(String string, Vector vector) {
        try {
            if (vector == null || vector.size() == 0) {
                if (DTMProfilerHelper.debugFlag >= 1) {
                    System.out.println("ServerSocketCreator:No cilent socket recieved....");
                }
                return;
            }
            if (!string.endsWith("@END_BLOCK@")) {
                string = string + "@END_BLOCK@";
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Socket socket = (Socket)vector.get(i);
                ChildThread childThread = (ChildThread)this.clientStreamListener.get(i);
                BufferedWriter bufferedWriter = (BufferedWriter)childThread.getStreamWriter();
                bufferedWriter.write(string + "\n");
                bufferedWriter.flush();
                if (DTMProfilerHelper.debugFlag < 1) continue;
                System.out.println("[ServerSocketCreator] Broadcasting : " + string);
            }
        }
        catch (IOException iOException) {
            if (DTMProfilerHelper.debugFlag >= 1) {
                System.out.println("[ServerSocketCreator] Exception caught while Broadcasting data to profiler");
            }
            String string2 = EgInstallInfo.getStackTraceAsString((Exception)iOException);
            this.logToErrorFile("Error", "[ServerSocketCreator]", string2);
        }
    }

    public void broadcast(String string, String string2) {
        try {
            if (string2 == null) {
                return;
            }
            if (string2.equalsIgnoreCase(BTM_TYPE)) {
                this.broadcast(string, this.clientSocketLister);
            } else if (string2.equalsIgnoreCase(AZURE_BTM_TYPE)) {
                this.broadcast(string, this.azureBtmSocketLister);
            } else if (string2.equalsIgnoreCase(CLR_TYPE)) {
                this.broadcast(string, this.clrSocketLister);
            } else if (string2.equalsIgnoreCase(AZURE_CLR_TYPE)) {
                this.broadcast(string, this.azureClrSocketLister);
            }
        }
        catch (Exception exception) {
            if (DTMProfilerHelper.debugFlag >= 1) {
                System.out.println("ServerSocketCreator: Exception caught while Broadcasting data to profiler");
            }
            String string3 = EgInstallInfo.getStackTraceAsString((Exception)exception);
            this.logToErrorFile("Error", "ServerSocketCreator", string3);
        }
    }

    private void closeAllSockets() {
        try {
            Socket socket;
            int n;
            int n2;
            if (this.clientSocketLister != null) {
                n2 = this.clientSocketLister.size();
                for (n = 0; n < n2; ++n) {
                    socket = (Socket)this.clientSocketLister.get(n);
                    socket.close();
                    this.clientSocketLister.remove(n);
                    this.clientStreamListener.remove(n);
                }
            }
            if (this.clrSocketLister != null) {
                n2 = this.clrSocketLister.size();
                for (n = 0; n < n2; ++n) {
                    socket = (Socket)this.clrSocketLister.get(n);
                    socket.close();
                }
            }
            if (this.azureBtmSocketLister != null) {
                n2 = this.azureBtmSocketLister.size();
                for (n = 0; n < n2; ++n) {
                    socket = (Socket)this.azureBtmSocketLister.get(n);
                    socket.close();
                }
            }
            if (this.azureClrSocketLister != null) {
                n2 = this.azureClrSocketLister.size();
                for (n = 0; n < n2; ++n) {
                    socket = (Socket)this.azureClrSocketLister.get(n);
                    socket.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void logToErrorFile(String string, String string2, String string3) {
        String string4;
        if (string3 == null) {
            return;
        }
        String string5 = this.dateInfo.egetDate();
        try {
            File file;
            string4 = EgInstallInfo.getInstallDir() + "/agent/logs/dotnetthread/";
            File file2 = new File(string4);
            if (!file2.exists()) {
                file2.mkdir();
            }
            if (!(file = new File(this.errorLogFilePath)).exists()) {
                file.createNewFile();
            }
            if (file.length() > 5000000L) {
                String string6 = string4 + "error_log.1";
                File file3 = new File(string6);
                if (file3.exists()) {
                    file3.delete();
                }
                EgInstallInfo.fileRename((File)file, (File)file3);
            }
            this.logWriter = new PrintWriter(new FileWriter(this.errorLogFilePath, true));
        }
        catch (Exception exception) {
            System.err.println("[ServerSocketCreator] Cannot open log file " + this.errorLogFilePath);
            return;
        }
        try {
            string4 = new String(string5 + " " + string + " " + string2 + ": " + string3);
            this.logWriter.println(string4);
            this.logWriter.close();
        }
        catch (Exception exception) {
            System.err.println("[ServerSocketCreator] Error while writing into log file " + this.errorLogFilePath);
        }
        this.logWriter = null;
    }

    public static ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2).trim();
            arrayList.add(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n).trim();
        arrayList.add(string3);
        return arrayList;
    }
}

