/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class SystemGeneric
extends TestGeneric {
    private static long MBtob = 0x100000L;
    private int repeat = 2;
    private int period;
    double cpuUtil = 0.0;
    double run = 0.0;
    double block = 0.0;
    double swap = 0.0;
    double free = 0.0;
    double scan = 0.0;
    double sysCpu = 0.0;
    double idleCpu = 0.0;
    double stealTime = -5.0;
    double mpSteal = -5.0;
    String summaryInfo = null;
    double CPU = -5.0;
    double SYSCPU = -5.0;
    private boolean isCpuFromIdle = false;

    public SystemGeneric(String string, String string2, int n, String string3, String string4, boolean bl) {
        super(string, string2, n, string3, string4);
        this.isCpuFromIdle = bl;
    }

    public SystemGeneric(String string, String string2, int n, String string3, String string4, String string5, String string6, boolean bl) {
        super(string, string2, n, string3, string4, string5, string6);
        this.isCpuFromIdle = bl;
    }

    public SystemGeneric(String string, String string2, int n, String string3, String string4, boolean bl, boolean bl2) {
        super(string, string2, n, string3, string4, bl2);
        this.isCpuFromIdle = bl;
    }

    public boolean checkForMultiProcs() {
        this.cmdToExec = "mpstat";
        ArrayList arrayList = null;
        arrayList = this.execCommand(this.cmdToExec);
        boolean bl = false;
        if (arrayList == null) {
            return false;
        }
        int n = arrayList.size();
        Object var4_4 = null;
        return n > 2;
    }

    public String getActualResultsOnLinux(int n) {
        this.period = n;
        ArrayList arrayList = null;
        this.cmdToExec = "vmstat " + n + " " + this.repeat;
        arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultOnLinux(arrayList);
    }

    public String getActualResultsOnTru64(int n) {
        this.period = n;
        ArrayList arrayList = null;
        this.cmdToExec = "vmstat " + n + " " + this.repeat;
        arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultOnTru64(arrayList);
    }

    private ArrayList myTokenizer(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public String getActualResultOnTru64(ArrayList arrayList) {
        int n;
        String string = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        int n2 = 0;
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        String string2 = null;
        if (n2 <= 0) {
            return string2;
        }
        double d = 1.0;
        string = (String)arrayList.get(0);
        if (string.indexOf("pagesize =") >= 1 && string.endsWith(")") && (n = (string = string.substring(0, string.length() - 1)).lastIndexOf(" ")) >= 0) {
            string = string.substring(n + 1);
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        n = 3;
        string = (String)arrayList.get(1);
        if (string.indexOf("procs") >= 0) {
            string = (String)arrayList.get(2);
            n = 4;
        }
        string = string.trim();
        ArrayList arrayList2 = this.myTokenizer(string);
        int n3 = arrayList2.indexOf("r");
        int n4 = arrayList2.indexOf("b");
        int n5 = arrayList2.indexOf("w");
        int n6 = arrayList2.indexOf("free");
        if (n6 < 0) {
            n6 = arrayList2.indexOf("fre");
        }
        int n7 = arrayList2.lastIndexOf("us");
        int n8 = arrayList2.lastIndexOf("sy");
        int n9 = arrayList2.lastIndexOf("id");
        string = (String)arrayList.get(n);
        stringTokenizer = new StringTokenizer(string);
        stringArray = new String[stringTokenizer.countTokens()];
        int n10 = stringTokenizer.countTokens();
        this.swap = -5.0;
        this.scan = -5.0;
        this.run = -5.0;
        this.free = -5.0;
        this.block = -5.0;
        double d2 = 0.0;
        this.sysCpu = 0.0;
        this.idleCpu = 0.0;
        for (int i = 0; i < n10; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            if (i == n3) {
                this.run = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n4) {
                this.block = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n6) {
                if (stringArray[i].endsWith("K")) {
                    stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
                    this.free = Double.parseDouble(stringArray[i]);
                    this.free = this.free * d / 1024.0;
                    continue;
                }
                this.free = Double.parseDouble(stringArray[i]) / 1024.0;
                continue;
            }
            if (i == n8) {
                this.sysCpu = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n7) {
                d2 = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i != n9) continue;
            this.idleCpu = Double.parseDouble(stringArray[i]);
        }
        if (this.isCpuFromIdle) {
            if (this.idleCpu > 100.0) {
                this.idleCpu = 100.0;
            }
            this.cpuUtil = 100.0 - this.idleCpu;
        } else {
            this.cpuUtil = this.sysCpu + d2;
        }
        string2 = this.cpuUtil + "#" + this.sysCpu + "#" + this.run + "#" + this.block + "#" + this.swap + "#" + this.free + "#" + this.scan;
        return string2;
    }

    public Hashtable getActualResultOnLinuxMpStat(int n) {
        ArrayList arrayList;
        String string;
        int n2;
        Serializable serializable;
        Hashtable hashtable = new Hashtable();
        this.period = n;
        ArrayList arrayList2 = null;
        this.cmdToExec = "mpstat -P ALL " + n + " " + this.repeat;
        arrayList2 = this.execCommand(this.cmdToExec);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return null;
        }
        this.run = -5.0;
        this.block = -5.0;
        this.swap = -5.0;
        this.free = -5.0;
        this.scan = -5.0;
        this.stealTime = -5.0;
        this.swap = this.getSwapValue();
        try {
            String string2 = this.getActualResultsOnLinux(n);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "#");
            if (stringTokenizer.countTokens() >= 6) {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                serializable = new Double(stringTokenizer.nextToken());
                this.run = (Double)serializable;
                serializable = new Double(stringTokenizer.nextToken());
                this.block = (Double)serializable;
                stringTokenizer.nextToken();
                double d = this.getActualFreeMemValueLinux(stringTokenizer.nextToken());
                if (d > 0.0) {
                    this.free = d;
                }
                stringTokenizer.nextToken();
                serializable = new Double(stringTokenizer.nextToken());
                this.stealTime = (Double)serializable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        int n3 = arrayList2.size() - 1;
        serializable = new ArrayList();
        int n4 = 3;
        int n5 = 5;
        int n6 = 6;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl2 = false;
        Object var17_21 = null;
        for (n2 = 0; n2 < n3; ++n2) {
            string = (String)arrayList2.get(n2);
            if ((string = string.trim()).indexOf("intr/s") < 0 && string.indexOf("%usr") < 0 && string.indexOf("%user") < 0 && string.indexOf("%sys") < 0 || (arrayList = this.myMStatTokenizer(string, true)).size() < 7) continue;
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                if (string3.equalsIgnoreCase("%usr") || string3.equalsIgnoreCase("%user")) {
                    n4 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%sys") || string3.equalsIgnoreCase("%system")) {
                    n5 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%idl") || string3.equalsIgnoreCase("%idle")) {
                    n6 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%nice") || string3.equalsIgnoreCase("%nice")) {
                    n7 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%iowait") || string3.equalsIgnoreCase("%iowait")) {
                    n8 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%irq") || string3.equalsIgnoreCase("%irq")) {
                    n9 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%soft") || string3.equalsIgnoreCase("%soft")) {
                    n10 = i;
                    continue;
                }
                if (string3.equalsIgnoreCase("%steal") || string3.equalsIgnoreCase("%steal")) {
                    n11 = i;
                    continue;
                }
                if (!string3.equalsIgnoreCase("%guest") && !string3.equalsIgnoreCase("%guest")) continue;
                n12 = i;
            }
            break;
        }
        for (n2 = n3; n2 >= 0; --n2) {
            ArrayList<Double> arrayList3;
            String string4;
            String string5;
            string = (String)arrayList2.get(n2);
            if ((string = string.trim()).length() == 0 || string.startsWith("Average") || string.indexOf("intr/s") >= 0 || string.indexOf("%usr") >= 0 || string.indexOf("%user") >= 0 || string.indexOf("%sys") >= 0 || (arrayList = this.myMStatTokenizer(string, true)).size() < 7) continue;
            String string6 = (String)arrayList.get(2);
            boolean bl3 = false;
            if (string6.equalsIgnoreCase("all")) {
                string6 = "Summary";
                bl3 = true;
            } else {
                try {
                    Integer.parseInt(string6);
                }
                catch (Exception exception) {
                    continue;
                }
                string6 = "Processor_" + string6;
            }
            String string7 = (String)arrayList.get(n4);
            String string8 = (String)arrayList.get(n5);
            String string9 = (String)arrayList.get(n6);
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (n7 > 0 && (string5 = (String)arrayList.get(n7)) != null && string5.length() > 0) {
                string5 = string5.trim();
                d = EgLangInfo.getDoubleValue((String)string5);
            }
            if (n8 > 0 && (string5 = (String)arrayList.get(n8)) != null && string5.length() > 0) {
                string5 = string5.trim();
                d2 = EgLangInfo.getDoubleValue((String)string5);
            }
            if (n9 > 0 && (string5 = (String)arrayList.get(n9)) != null && string5.length() > 0) {
                string5 = string5.trim();
                d3 = EgLangInfo.getDoubleValue((String)string5);
            }
            if (n10 > 0 && (string5 = (String)arrayList.get(n10)) != null && string5.length() > 0) {
                string5 = string5.trim();
                d4 = EgLangInfo.getDoubleValue((String)string5);
            }
            if (n11 > 0 && (string5 = (String)arrayList.get(n11)) != null && string5.length() > 0) {
                string5 = string5.trim();
                this.mpSteal = d5 = EgLangInfo.getDoubleValue((String)string5);
            }
            if (n12 > 0 && (string5 = (String)arrayList.get(n12)) != null && string5.length() > 0) {
                string5 = string5.trim();
                d6 = EgLangInfo.getDoubleValue((String)string5);
            }
            this.sysCpu = -1.0;
            double d7 = -1.0;
            double d8 = 0.0;
            try {
                this.sysCpu = Double.parseDouble(string8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                d7 = Double.parseDouble(string7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                d8 = Double.parseDouble(string9);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.isCpuFromIdle) {
                if (d8 > 100.0) {
                    d8 = 100.0;
                }
                this.cpuUtil = 100.0 - d8;
            } else if (d7 >= 0.0) {
                this.cpuUtil = d7 + this.sysCpu + d + d2 + d3 + d4 + d5 + d6;
            }
            if (this.cpuUtil > 100.0) {
                this.cpuUtil = 100.0;
            }
            if (this.sysCpu > 100.0) {
                this.sysCpu = 100.0;
            }
            if (d7 > 100.0) {
                d7 = 100.0;
            }
            if (((ArrayList)serializable).contains(string4 = string6)) break;
            ((ArrayList)serializable).add(string4);
            if (!bl3) {
                arrayList3 = new ArrayList<Double>();
                arrayList3.add(new Double(this.cpuUtil));
                arrayList3.add(new Double(this.sysCpu));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                hashtable.put(string4, arrayList3);
                continue;
            }
            arrayList3 = new ArrayList();
            arrayList3.add(new Double(this.cpuUtil));
            arrayList3.add(new Double(this.sysCpu));
            arrayList3.add(new Double(this.run));
            arrayList3.add(new Double(this.block));
            arrayList3.add(new Double(this.swap));
            arrayList3.add(new Double(this.free));
            arrayList3.add(new Double(this.scan));
            arrayList3.add(new Double(this.stealTime));
            hashtable.put(string4, arrayList3);
        }
        return hashtable;
    }

    public ArrayList myMStatTokenizer(String string, boolean bl) {
        boolean bl2 = bl;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            if (n == 1 && bl2) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("am") || string2.equalsIgnoreCase("pm") || string2.equalsIgnoreCase("ist")) {
                    arrayList.add(string2);
                } else {
                    arrayList.add("AM");
                    arrayList.add(string2);
                }
            } else {
                arrayList.add(stringTokenizer.nextToken());
            }
            ++n;
        }
        return arrayList;
    }

    public String getActualResultOnLinux(ArrayList arrayList) {
        String string = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        String string2 = null;
        if (n <= 0) {
            return string2;
        }
        string = (String)arrayList.get(0);
        string = (String)arrayList.get(1);
        string = string.trim();
        ArrayList arrayList2 = this.myTokenizer(string);
        int n2 = arrayList2.indexOf("r");
        int n3 = arrayList2.indexOf("b");
        int n4 = arrayList2.indexOf("w");
        int n5 = arrayList2.indexOf("free");
        if (n5 < 0) {
            n5 = arrayList2.indexOf("fre");
        }
        int n6 = arrayList2.lastIndexOf("us");
        int n7 = arrayList2.lastIndexOf("sy");
        int n8 = arrayList2.lastIndexOf("id");
        int n9 = arrayList2.lastIndexOf("st");
        string = (String)arrayList.get(2);
        if (arrayList.size() >= 4) {
            string = (String)arrayList.get(3);
        }
        stringTokenizer = new StringTokenizer(string);
        stringArray = new String[stringTokenizer.countTokens()];
        int n10 = stringTokenizer.countTokens();
        this.swap = this.getSwapValue();
        this.scan = -5.0;
        this.run = -5.0;
        this.free = -5.0;
        this.block = -5.0;
        double d = 0.0;
        this.sysCpu = 0.0;
        this.idleCpu = 0.0;
        this.stealTime = -5.0;
        for (int i = 0; i < n10; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            if (i == n2) {
                this.run = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n3) {
                this.block = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n5) {
                this.free = this.getActualFreeMemValueLinux(stringArray[i]);
                continue;
            }
            if (i == n7) {
                this.sysCpu = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n6) {
                d = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i == n8) {
                this.idleCpu = Double.parseDouble(stringArray[i]);
                continue;
            }
            if (i != n9) continue;
            this.stealTime = Double.parseDouble(stringArray[i]);
        }
        if (this.isCpuFromIdle) {
            if (this.idleCpu > 100.0) {
                this.idleCpu = 100.0;
            }
            this.cpuUtil = 100.0 - this.idleCpu;
        } else {
            this.cpuUtil = this.sysCpu + d;
        }
        string2 = this.cpuUtil + "#" + this.sysCpu + "#" + this.run + "#" + this.block + "#" + this.swap + "#" + this.free + "#" + this.scan + "#" + this.stealTime;
        return string2;
    }

    private double getActualFreeMemValueLinux(String string) {
        double d = Double.parseDouble(string) / 1024.0;
        try {
            String string2 = "free -m";
            ArrayList arrayList = this.execCommand(string2);
            if (arrayList == null || arrayList.size() <= 0) {
                return d;
            }
            boolean bl = false;
            boolean bl2 = false;
            StringTokenizer stringTokenizer = null;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                String string3;
                String string4 = (String)arrayList.get(i);
                if (string4 == null || string4.trim().length() == 0) continue;
                if ((string4 = string4.trim()).indexOf("total") >= 0 && (string4.indexOf("buff/cache") > 0 || string4.indexOf("buffers/cache") > 0)) {
                    bl = true;
                    if (string4.indexOf("available") <= 0) continue;
                    bl2 = true;
                    continue;
                }
                if (string4.startsWith("Mem:") || string4.indexOf("Mem:") >= 0) {
                    stringTokenizer = new StringTokenizer(string4);
                    if (!bl) continue;
                    int n2 = stringTokenizer.countTokens();
                    if (n2 == 7) {
                        stringTokenizer.nextToken();
                        stringTokenizer.nextToken();
                        if (bl2) {
                            stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                            double d2 = EgLangInfo.getDoubleValue((String)string3.trim());
                            stringTokenizer.nextToken();
                            String string5 = stringTokenizer.nextToken();
                            double d3 = EgLangInfo.getDoubleValue((String)string5.trim());
                            if (d2 >= 0.0 && d3 >= 0.0) {
                                d = d2 + d3;
                            } else if (d2 >= 0.0 && d3 < 0.0) {
                                d = d2;
                            } else if (d2 < 0.0 && d3 >= 0.0) {
                                d = d3;
                            }
                        } else {
                            stringTokenizer.nextToken();
                            stringTokenizer.nextToken();
                            stringTokenizer.nextToken();
                            stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                            d = EgLangInfo.getDoubleValue((String)string3.trim());
                        }
                    }
                    if (n2 < 8) continue;
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    d = EgLangInfo.getDoubleValue((String)string3.trim());
                    continue;
                }
                if (string4.indexOf("-/+ buffers/cache:") < 0 && string4.indexOf("buffers/cache:") <= -1) continue;
                stringTokenizer = new StringTokenizer(string4);
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                d = Double.parseDouble(string3);
            }
        }
        catch (Exception exception) {
            return d;
        }
        return d;
    }

    public String getActualResultsOnSolaris(int n) {
        ArrayList arrayList = null;
        this.period = n;
        this.cmdToExec = "vmstat -S " + n + " " + this.repeat;
        String string = null;
        for (int i = 0; i < 3 && (string = this.getActualResultOnSolaris(arrayList = this.execCommand(this.cmdToExec))) == null; ++i) {
        }
        return string;
    }

    public String getActualResultOnSolaris(ArrayList arrayList) {
        int n;
        String string = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        int n2 = 0;
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        String string2 = null;
        if (n2 <= 0 || n2 < 3) {
            return string2;
        }
        for (n = 0; n < n2; ++n) {
            String string3 = (String)arrayList.get(n);
            if ((string3 = string3.toLowerCase()).indexOf("state change") <= 0) continue;
            return string2;
        }
        string = (String)arrayList.get(0);
        string = (String)arrayList.get(1);
        string = (String)arrayList.get(2);
        string = (String)arrayList.get(3);
        stringTokenizer = new StringTokenizer(string);
        stringArray = new String[stringTokenizer.countTokens()];
        n = stringTokenizer.countTokens();
        this.swap = 0.0;
        this.scan = 0.0;
        this.cpuUtil = 0.0;
        this.sysCpu = 0.0;
        this.idleCpu = 0.0;
        block11: for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            switch (i) {
                case 0: {
                    this.run = Double.parseDouble(stringArray[i]);
                    continue block11;
                }
                case 1: {
                    this.block = Double.parseDouble(stringArray[i]);
                    continue block11;
                }
                case 3: {
                    this.swap = Double.parseDouble(stringArray[i]) / 1024.0;
                    continue block11;
                }
                case 4: {
                    this.free = Double.parseDouble(stringArray[i]) / 1024.0;
                    continue block11;
                }
                case 11: {
                    this.scan = Double.parseDouble(stringArray[i]);
                    continue block11;
                }
                case 19: {
                    this.cpuUtil = Double.parseDouble(stringArray[i]);
                    continue block11;
                }
                case 20: {
                    this.sysCpu = Double.parseDouble(stringArray[i]);
                    continue block11;
                }
                case 21: {
                    this.idleCpu = Double.parseDouble(stringArray[i]);
                }
            }
        }
        if (this.isCpuFromIdle) {
            if (this.idleCpu > 100.0) {
                this.idleCpu = 100.0;
            }
            this.cpuUtil = 100.0 - this.idleCpu;
        } else {
            this.cpuUtil += this.sysCpu;
        }
        double d = this.findFreeMemory();
        if (d >= 0.0) {
            this.free = d;
        }
        string2 = this.cpuUtil + "#" + this.sysCpu + "#" + this.run + "#" + this.block + "#" + this.swap + "#" + this.free + "#" + this.scan;
        return string2;
    }

    private double getCacheMemory() {
        String string = "/usr/bin/kstat zfs:0:arcstats:size";
        double d = -5.0;
        ArrayList arrayList = null;
        arrayList = this.execCommand(string);
        if (arrayList == null || arrayList.size() == 0) {
            return d;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            if (!(string2 = string2.trim()).startsWith("size")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            try {
                d = Double.parseDouble(string3);
                if (d >= 0.0) {
                    d /= 1048576.0;
                    continue;
                }
                d = -5.0;
                continue;
            }
            catch (Exception exception) {
                d = -5.0;
            }
        }
        return d;
    }

    private double findFreeMemory() {
        double d;
        String string = "/usr/bin/kstat -c pages";
        double d2 = this.getPageSize();
        ArrayList arrayList = null;
        arrayList = this.execCommand(string);
        double d3 = -5.0;
        if (arrayList == null || arrayList.size() == 0) {
            return d3;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            if (!(string2 = string2.trim()).startsWith("freemem")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            try {
                d3 = Double.parseDouble(string3);
                if (d2 >= 0.0) {
                    d3 = d3 * d2 / 1048576.0;
                    break;
                }
                d3 = -5.0;
            }
            catch (Exception exception) {
                d3 = -5.0;
            }
            break;
        }
        if ((d = this.getCacheMemory()) > 0.0) {
            d3 += d;
        }
        return d3;
    }

    private double getPageSize() {
        String string = "pagesize";
        ArrayList arrayList = null;
        arrayList = this.execCommand(string);
        double d = -5.0;
        if (arrayList == null || arrayList.size() == 0) {
            return d;
        }
        int n = arrayList.size();
        String string2 = (String)arrayList.get(n - 1);
        string2 = string2.trim();
        try {
            d = Double.parseDouble(string2);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    public String getActualResultsOnAix(int n) {
        this.period = n;
        this.cmdToExec = "vmstat " + n + " " + this.repeat;
        ArrayList arrayList = this.execCommand(this.cmdToExec);
        return this.getActualResultsOnAix(arrayList);
    }

    public String getActualResultsOnAix(ArrayList arrayList) {
        String string = null;
        String[] stringArray = null;
        StringTokenizer stringTokenizer = null;
        int n = 0;
        String string2 = null;
        try {
            int n2;
            if (arrayList != null) {
                n = arrayList.size();
            }
            if (n <= 0 || n < 3) {
                return string2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                string = (String)arrayList.get(n2);
            }
            if (string == null || string.length() <= 0) {
                return string2;
            }
            stringTokenizer = new StringTokenizer(string);
            stringArray = new String[stringTokenizer.countTokens()];
            n2 = stringTokenizer.countTokens();
            double d = 0.0;
            this.sysCpu = 0.0;
            this.idleCpu = 0.0;
            double d2 = -5.0;
            block15: for (int i = 0; i < n2; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
                switch (i) {
                    case 0: {
                        this.run = Double.parseDouble(stringArray[i]);
                        continue block15;
                    }
                    case 1: {
                        this.block = Double.parseDouble(stringArray[i]);
                        continue block15;
                    }
                    case 2: {
                        this.swap = Double.parseDouble(stringArray[i]) / 256.0;
                        continue block15;
                    }
                    case 3: {
                        this.free = Double.parseDouble(stringArray[i]) / 256.0;
                        d2 = this.getActualFreeMemValueAix(stringArray[i]);
                        continue block15;
                    }
                    case 8: {
                        this.scan = Double.parseDouble(stringArray[i]);
                        if (!(this.scan > 999999.0)) continue block15;
                        this.scan = -5.0;
                        continue block15;
                    }
                    case 13: {
                        d = Double.parseDouble(stringArray[i]);
                        continue block15;
                    }
                    case 14: {
                        this.sysCpu = Double.parseDouble(stringArray[i]);
                        continue block15;
                    }
                    case 15: {
                        try {
                            this.idleCpu = Double.parseDouble(stringArray[i]);
                            continue block15;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            if (d2 >= 0.0) {
                this.free = d2;
            }
            if (this.isCpuFromIdle) {
                if (this.idleCpu > 100.0) {
                    this.idleCpu = 100.0;
                }
                this.cpuUtil = 100.0 - this.idleCpu;
            } else {
                this.cpuUtil = this.sysCpu + d;
            }
            this.swap = this.getActualSwapMemValueAix();
            string2 = this.cpuUtil + "#" + this.sysCpu + "#" + this.run + "#" + this.block + "#" + this.swap + "#" + this.free + "#" + this.scan;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string2;
    }

    private double getActualFreeMemValueAix(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string) / 256.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n;
            String string2 = "uname -v";
            ArrayList arrayList = this.execCommand(string2);
            if (arrayList == null) {
                return d;
            }
            String string3 = "";
            for (n = 0; n < arrayList.size(); ++n) {
                string3 = (String)arrayList.get(n);
            }
            int n2 = Integer.parseInt(string3 = string3.trim());
            if (n2 >= 5) {
                string2 = "/usr/bin/pagesize";
                arrayList = this.execCommand(string2);
                n = 0;
                if (arrayList == null) {
                    return d;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    string3 = (String)arrayList.get(i);
                }
                string3 = string3.trim();
                n = Integer.parseInt(string3);
                string2 = "vmstat -v";
                arrayList = this.execCommand(string2);
                if (arrayList == null) {
                    return d;
                }
                double d2 = 0.0;
                double d3 = 0.0;
                int n3 = arrayList.size();
                for (int i = 0; i < n3; ++i) {
                    int n4;
                    String string4;
                    string3 = (String)arrayList.get(i);
                    if (string3.indexOf("free pages") > -1) {
                        string4 = string3.substring(0, string3.indexOf("free pages"));
                        n4 = string4.indexOf("@");
                        if (n4 > -1) {
                            string4 = string4.substring(0, n4);
                        }
                        d2 = Double.parseDouble(string4.trim());
                        continue;
                    }
                    if (string3.indexOf("file pages") <= -1) continue;
                    string4 = string3.substring(0, string3.indexOf("file pages"));
                    n4 = string4.indexOf("@");
                    if (n4 > -1) {
                        string4 = string4.substring(0, n4);
                    }
                    d3 = Double.parseDouble(string4.trim());
                }
                d = (d2 + d3) * (double)n;
                d = d < 0.0 ? -5.0 : (d /= (double)MBtob);
            }
        }
        catch (Exception exception) {
            return d;
        }
        return d;
    }

    private double getActualSwapMemValueAix() {
        String string = "/usr/sbin/lsps -a";
        ArrayList arrayList = this.execCommand(string);
        if (arrayList == null || arrayList.size() == 0) {
            return -5.0;
        }
        int n = arrayList.size();
        double d = 0.0;
        for (int i = 1; i < n; ++i) {
            String string2 = (String)arrayList.get(i);
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() < 8) continue;
            String string3 = stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = stringTokenizer.nextToken();
            if (!string6.equalsIgnoreCase("yes") && !string6.equalsIgnoreCase("y")) continue;
            double d2 = -5.0;
            try {
                string4 = string4.substring(0, string4.length() - 2);
                d2 = Double.parseDouble(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d3 = -5.0;
            try {
                d3 = Double.parseDouble(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (d3 < 0.0 || d2 < 0.0) continue;
            d += (d3 /= 100.0) * d2;
        }
        return d;
    }

    public String getActualResultsOnHPUnix(int n) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        this.period = n;
        this.cmdToExec = "vmstat " + n + " " + this.repeat;
        arrayList = this.execCommand(this.cmdToExec);
        this.cmdToExec = "/usr/sbin/swapinfo -tm";
        arrayList2 = this.execCommand(this.cmdToExec);
        return this.getActualResultsOnHPUnix(arrayList, arrayList2);
    }

    private double findSwapUsed(ArrayList arrayList) {
        double d = -5.0;
        try {
            int n = arrayList.size();
            String string = (String)arrayList.get(n - 1);
            if (string == null || string.length() == 0) {
                return -5.0;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() < 3) {
                return -5.0;
            }
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            try {
                d = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                d = -5.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public String getActualResultsOnHPUnix(ArrayList arrayList, ArrayList arrayList2) {
        String string = new String();
        String string2 = "";
        if (arrayList == null) {
            return null;
        }
        int n = arrayList.size();
        double d = 0.0;
        try {
            int n2;
            this.swap = this.findSwapUsed(arrayList2);
            for (n2 = 0; n2 < n; ++n2) {
                string2 = (String)arrayList.get(n2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            n2 = stringTokenizer.countTokens();
            block13: for (int i = 0; i < n2; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
                switch (i) {
                    case 0: {
                        this.run = Double.parseDouble(stringArray[i]);
                        continue block13;
                    }
                    case 1: {
                        this.block = Double.parseDouble(stringArray[i]);
                        continue block13;
                    }
                    case 3: {
                        continue block13;
                    }
                    case 4: {
                        this.free = Double.parseDouble(stringArray[i]);
                        continue block13;
                    }
                    case 11: {
                        this.scan = Double.parseDouble(stringArray[i]);
                        continue block13;
                    }
                    case 15: {
                        d = Double.parseDouble(stringArray[i]);
                        continue block13;
                    }
                    case 16: {
                        this.sysCpu = Double.parseDouble(stringArray[i]);
                        continue block13;
                    }
                    case 17: {
                        this.idleCpu = Double.parseDouble(stringArray[i]);
                    }
                }
            }
            if (this.isCpuFromIdle) {
                if (this.idleCpu > 100.0) {
                    this.idleCpu = 100.0;
                }
                this.cpuUtil = 100.0 - this.idleCpu;
            } else {
                this.cpuUtil = d + this.sysCpu;
            }
            if (this.cpuUtil > 100.0) {
                this.cpuUtil = 100.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        String string3 = this.cpuUtil + "#" + this.sysCpu + "#" + this.run + "#" + this.block + "#" + this.swap + "#" + this.free + "#" + this.scan;
        return string3;
    }

    public ArrayList runMultiProcsTest(double d, double d2, double d3, double d4, double d5, boolean bl) {
        int n;
        int n2;
        this.cmdToExec = "mpstat " + this.period + "  " + this.repeat;
        String[] stringArray = null;
        ArrayList arrayList = this.execCommand(this.cmdToExec);
        int n3 = 0;
        String string = null;
        if (arrayList == null) {
            return null;
        }
        n3 = arrayList.size();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            string = (String)arrayList.get(n2);
            if ((string = string.trim()).startsWith("CPU")) {
                ++n4;
            }
            if (n4 == this.repeat) break;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = n2 + 1; n < n3; ++n) {
            string = (String)arrayList.get(n);
            arrayList2.add(string);
        }
        n = arrayList2.size();
        if (n > 0) {
            this.summaryInfo = new String();
        }
        double d6 = 0.0;
        double d7 = 0.0;
        String string2 = null;
        StringTokenizer stringTokenizer = null;
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string2 = (String)arrayList2.get(i);
            stringTokenizer = new StringTokenizer(string2);
            stringArray = new String[stringTokenizer.countTokens()];
            int n5 = stringTokenizer.countTokens();
            String string3 = "";
            double d8 = -5.0;
            double d9 = -5.0;
            double d10 = -5.0;
            double d11 = -5.0;
            block9: for (n2 = 0; n2 < n5; ++n2) {
                stringArray[n2] = stringTokenizer.nextToken();
                switch (n2) {
                    case 0: {
                        string3 = "cpu" + stringArray[n2];
                        continue block9;
                    }
                    case 12: {
                        d10 = Double.parseDouble(stringArray[n2]);
                        continue block9;
                    }
                    case 13: {
                        d8 = Double.parseDouble(stringArray[n2]);
                        d7 += d8;
                        continue block9;
                    }
                    case 15: {
                        d11 = Double.parseDouble(stringArray[n2]);
                    }
                }
            }
            if (this.isCpuFromIdle) {
                if (d11 > 100.0) {
                    d11 = 100.0;
                }
                d9 = 100.0 - d11;
                d6 += d9;
            } else if (d10 >= 0.0) {
                d9 = d10 + d8;
                d6 += d9;
            } else {
                d9 = -5.0;
            }
            String string4 = string3 + "#" + d9 + "#" + d8 + "#" + d + "#" + d2 + "#" + d3 + "#" + d4 + "#" + d5;
            arrayList3.add(string4);
        }
        if (this.summaryInfo != null && n > 0 && !bl) {
            Object var27_21 = null;
            this.summaryInfo = (d6 /= (double)n) + "#" + (d7 /= (double)n) + "#" + d + "#" + d2 + "#" + d3 + "#" + d4 + "#" + d5;
        } else if (bl) {
            this.executeiostat();
            this.summaryInfo = this.CPU + "#" + this.SYSCPU + "#" + d + "#" + d2 + "#" + d3 + "#" + d4 + "#" + d5;
        }
        return arrayList3;
    }

    public void executeiostat() {
        String string;
        String string2 = "iostat -c " + this.period + " " + this.repeat;
        ArrayList arrayList = this.execCommand(string2);
        if (arrayList == null || arrayList.size() < 4) {
            return;
        }
        String string3 = "";
        string3 = (String)arrayList.get(arrayList.size() - 1);
        if (string3 == null || string3.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3 = string3.trim());
        int n = stringTokenizer.countTokens();
        if (n < 4) {
            return;
        }
        String string4 = stringTokenizer.nextToken();
        double d = -1.0;
        double d2 = -1.0;
        double d3 = -1.0;
        if (string4 != null) {
            d = Double.parseDouble(string4);
        }
        if ((string = stringTokenizer.nextToken()) != null) {
            d2 = Double.parseDouble(string);
        }
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        if (string6 != null) {
            d3 = Double.parseDouble(string6);
        }
        if (d < 0.0 || d2 < 0.0) {
            this.CPU = -5.0;
            this.SYSCPU = -5.0;
        } else if (this.isCpuFromIdle) {
            if (d3 > 100.0) {
                d3 = 100.0;
            }
            this.CPU = 100.0 - d3;
        } else {
            this.SYSCPU = d2;
            this.CPU = d + d2;
        }
    }

    public double getIoStatCpu() {
        return this.CPU;
    }

    public double getIoStatSysCpu() {
        return this.SYSCPU;
    }

    public String getSummaryInfo() {
        return this.summaryInfo;
    }

    private double getSwapValue() {
        String string = "\"cat /proc/meminfo | grep Swap\"";
        ArrayList arrayList = this.execCommand(string);
        if (arrayList == null || arrayList.size() <= 0) {
            return 0.0;
        }
        String string2 = (String)arrayList.get(0);
        if (string2 == null || string2.length() <= 0) {
            return -5.0;
        }
        string2 = string2.trim();
        double d = -5.0;
        double d2 = 1048576.0;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.countTokens() >= 4) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            return d /= d2;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = arrayList.size();
        while (n < n2) {
            StringTokenizer stringTokenizer2;
            int n3;
            string2 = (String)arrayList.get(n);
            ++n;
            if (string2 == null) break;
            if (string2.startsWith("SwapTotal")) {
                n3 = string2.indexOf(58);
                if (n3 < 0) continue;
                if ((string2 = string2.substring(n3 + 1)).indexOf("kB") > 0 || string2.indexOf("KB") > 0) {
                    bl = true;
                }
                try {
                    string2 = string2.trim();
                    stringTokenizer2 = new StringTokenizer(string2);
                    if (stringTokenizer2.countTokens() > 1) {
                        string2 = stringTokenizer2.nextToken();
                    }
                    d3 = Double.parseDouble(string2.trim());
                    continue;
                }
                catch (Exception exception) {
                    return d;
                }
            }
            if (!string2.startsWith("SwapFree") || (n3 = string2.indexOf(58)) < 0) continue;
            string2 = string2.substring(n3 + 1);
            stringTokenizer2 = new StringTokenizer(string2 = string2.trim());
            if (stringTokenizer2.countTokens() > 1) {
                string2 = stringTokenizer2.nextToken();
            }
            try {
                d4 = Double.parseDouble(string2.trim());
            }
            catch (Exception exception) {
                return d;
            }
        }
        if (d3 > 0.0) {
            d = d3 - d4;
            if (d < 0.0) {
                d = -5.0;
            }
            if (bl) {
                d /= 1024.0;
            }
        }
        return d;
    }

    public static void main(String[] stringArray) {
    }
}

