/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgJNIUtil;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class W3WPPoolTest
extends GenericTest {
    private static String strObject = "Process";
    private static String[] counters = new String[]{"ID Process", "% Processor Time", "Working Set", "Thread Count", "Handle Count", "Page Faults/sec", "Private Bytes", "Pool Paged Bytes", "Pool Nonpaged Bytes", "IO Read Bytes/sec", "IO Read Operations/sec", "IO Write Bytes/sec", "IO Write Operations/sec"};
    private String strPoolParamValue;
    public Hashtable ddPoolTable;
    private ArrayList configuredList = new ArrayList();
    private static double MB = 1048576.0;
    String systemDir = "";
    String OSName = "";
    boolean useAppcmd = false;
    private double ramsize = 1.0;

    public W3WPPoolTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(13);
        this.isDynamicInfoTest = true;
        this.ddPoolTable = new Hashtable();
        this.strPoolParamValue = this.getValueForParam("Application_Pool_Name");
        if (this.strPoolParamValue.equalsIgnoreCase("all")) {
            this.configuredList.add("all");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.strPoolParamValue, ",");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                this.configuredList.add(stringTokenizer.nextToken());
            }
        }
    }

    private String checkOS() {
        String string = System.getProperties().getProperty("os.name");
        String string2 = "";
        WindowsOsHelper windowsOsHelper = new WindowsOsHelper(this.reportingName, this.meAgentless);
        windowsOsHelper.setOs();
        ArrayList arrayList = windowsOsHelper.getOsInfo();
        if (arrayList == null || arrayList.size() < 2) {
            string2 = "C:\\Windows\\System32";
            this.useAppcmd = true;
            this.systemDir = string2;
            return string;
        }
        arrayList = (ArrayList)arrayList.get(0);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            String string3 = (String)arrayList.get(i);
            if (string3.startsWith("Caption")) {
                n2 = string3.indexOf(":");
                if (n2 > 0) {
                    string = string3.substring(n2 + 1);
                }
                string = string.trim();
                continue;
            }
            if (!string3.startsWith("WindowsDirectory")) continue;
            n2 = string3.indexOf(":");
            if (n2 > 0) {
                string2 = string3.substring(n2 + 1);
            }
            string2 = string2.trim();
        }
        string2 = string2 + "\\System32";
        this.useAppcmd = true;
        this.systemDir = string2;
        return string;
    }

    private String[] getInstances() {
        Object object;
        int n;
        String[] stringArray = EgJNIUtil.discoverInstances((String)strObject);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < stringArray.length; ++n) {
            object = stringArray[n];
            if (!((String)(object = ((String)object).toLowerCase())).startsWith("w3wp")) continue;
            arrayList.add(object);
        }
        n = arrayList.size();
        object = new String[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (String)arrayList.get(i);
        }
        return object;
    }

    private ArrayList executeCommand(String string) {
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string);
        if (arrayList == null || arrayList.size() < 2) {
            System.out.println("Cannot run the executable : " + string);
            return null;
        }
        return (ArrayList)arrayList.get(0);
    }

    private Hashtable getAppPools() {
        String string = "cscript.exe //Nologo " + EgInstallInfo.getInstallDir() + "/bin/W3WPPoolTest.vbs ";
        ArrayList arrayList = this.executeCommand(string);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable<String, Cloneable> hashtable = new Hashtable<String, Cloneable>();
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String string2 = (String)arrayList.get(i);
            if ((string2 = string2.trim()).startsWith("Running pools list starts")) {
                int n2;
                int n3 = string2.indexOf("@");
                object2 = string2.substring(n3 + 1, n2 = string2.indexOf("*"));
                if (object2 == null) {
                    hashtable.put("poolslist", arrayList2);
                    continue;
                }
                if (((String)(object2 = ((String)object2).trim())).length() == 0) {
                    hashtable.put("poolslist", arrayList2);
                    continue;
                }
                object = new StringTokenizer((String)object2, ",");
                int n4 = ((StringTokenizer)object).countTokens();
                for (int j = 0; j < n4; ++j) {
                    arrayList2.add(((StringTokenizer)object).nextToken());
                }
                hashtable.put("poolslist", arrayList2);
                continue;
            }
            if (!string2.startsWith("W3WP.exe")) continue;
            String string3 = string2;
            StringTokenizer stringTokenizer = null;
            object2 = null;
            object = null;
            String string4 = null;
            String string5 = null;
            int n5 = string2.indexOf("-v");
            if (n5 > 0) {
                string3 = string2.substring(0, n5);
                stringTokenizer = new StringTokenizer(string3, ":");
                if (stringTokenizer.countTokens() < 3) continue;
                stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                object2 = new StringTokenizer(string4);
                object = ((StringTokenizer)object2).nextToken().trim();
                string5 = stringTokenizer.nextToken().trim();
            } else {
                stringTokenizer = new StringTokenizer(string2, ":");
                int n6 = stringTokenizer.countTokens();
                if (n6 < 3) continue;
                stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken().trim();
                object2 = new StringTokenizer(string4);
                object = ((StringTokenizer)object2).nextToken().trim();
                string5 = stringTokenizer.nextToken().trim();
            }
            if (string5 != null && string5.endsWith("\"")) {
                string5 = string5.substring(0, string5.length() - 1);
            }
            System.out.println("strPoolName = " + string5);
            String string6 = "";
            if (hashtable2.containsKey(string5)) {
                string6 = (String)hashtable2.get(string5);
                string6 = string6 + "," + (String)object;
                object = string6;
            }
            hashtable2.put(string5, object);
        }
        hashtable.put("w3wp", hashtable2);
        System.out.println(hashtable);
        return hashtable;
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            int n2 = (int)d;
            string = string + n2;
            d -= (double)n2;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private double stringToDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = -5.0;
        }
        return d;
    }

    private double measureConvert(int n, double d) {
        switch (n) {
            case 1: {
                if (d > 0.0) {
                    d = EgMainAgent.reportCpu(d, true);
                }
            }
            case 3: 
            case 4: {
                String string = this.round(d, 4);
                d = this.stringToDouble(string);
                break;
            }
            case 2: {
                d /= MB;
                d = d / this.ramsize * 100.0;
                String string = this.round(d, 4);
                d = this.stringToDouble(string);
                break;
            }
            case 5: {
                String string = this.round(d, 4);
                d = this.stringToDouble(string);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                String string = this.round(d /= MB, 4);
                d = this.stringToDouble(string);
                break;
            }
            case 9: 
            case 11: {
                String string = this.round(d /= 1024.0, 4);
                d = this.stringToDouble(string);
                break;
            }
            case 10: 
            case 12: {
                String string = this.round(d, 4);
                d = this.stringToDouble(string);
                break;
            }
        }
        return d;
    }

    private Hashtable getPoolList() {
        Hashtable hashtable = null;
        hashtable = this.useAppcmd ? this.getAppPools2008() : this.getAppPools();
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        return hashtable;
    }

    private Hashtable getAppPools2008() {
        int n;
        String string = this.systemDir + "\\inetsrv\\appcmd list apppools /state:Started";
        String string2 = this.systemDir + "\\inetsrv\\appcmd list wp";
        ArrayList arrayList = this.executeCommand(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Hashtable<String, Cloneable> hashtable = new Hashtable<String, Cloneable>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string3 = (String)arrayList.get(i);
            if (!string3.startsWith("APPPOOL")) continue;
            int n3 = string3.indexOf(" ");
            n = string3.lastIndexOf("\"");
            string3 = string3.substring(n3, n);
            string3 = string3.replace('\"', ' ');
            string3 = string3.trim();
            arrayList2.add(string3);
        }
        hashtable.put("poolslist", arrayList2);
        ArrayList arrayList3 = this.executeCommand(string2);
        if (arrayList3 == null || arrayList3.size() == 0) {
            hashtable.put("w3wp", hashtable2);
            return hashtable;
        }
        n2 = 0;
        n2 = arrayList3.size();
        for (int i = 0; i < n2; ++i) {
            String string4 = (String)arrayList3.get(i);
            if (!string4.startsWith("WP")) continue;
            n = string4.indexOf(" ");
            int n4 = string4.indexOf("(");
            int n5 = string4.lastIndexOf(")");
            String string5 = string4.substring(n, n4);
            String string6 = string4.substring(n4 + 1, n5);
            StringTokenizer stringTokenizer = new StringTokenizer(string6, ":");
            stringTokenizer.nextToken();
            String string7 = stringTokenizer.nextToken();
            string5 = string5.replace('\"', ' ');
            string5 = string5.trim();
            String string8 = "";
            if (hashtable2.containsKey(string7)) {
                string8 = (String)hashtable2.get(string7);
                string5 = string8 = string8 + "," + string5;
            }
            hashtable2.put(string7, string5);
        }
        hashtable.put("w3wp", hashtable2);
        System.out.println("appcmd result " + hashtable);
        return hashtable;
    }

    private boolean isPoolAvailableInList(String string, Hashtable hashtable) {
        boolean bl = false;
        if (hashtable.containsKey(string)) {
            bl = true;
        }
        return bl;
    }

    private String[] getW3WPInstances() {
        String[] stringArray = this.getInstances();
        return stringArray;
    }

    private double[][] getW3WPValues(String[] stringArray) {
        EgJNIUtil egJNIUtil = new EgJNIUtil();
        double[][] dArray = egJNIUtil.getCounterValue(strObject, stringArray, counters, true);
        egJNIUtil.stop();
        return dArray;
    }

    private void getValues(Hashtable hashtable, double[][] dArray) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            this.getValues(string, string2, dArray);
        }
    }

    private void getValues(String string, String string2, double[][] dArray) {
        int n;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string2, ",");
        int n2 = stringTokenizer.countTokens();
        double[] dArray2 = new double[this.measureCount];
        dArray2[0] = n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        this.ddPoolTable.clear();
        block0: for (n = 0; n < n2; ++n) {
            String string3 = stringTokenizer.nextToken();
            String string4 = new String();
            for (int i = 0; i < dArray.length; ++i) {
                int n3 = (int)dArray[i][0];
                String string5 = "" + n3;
                if (!string3.equalsIgnoreCase(string5)) continue;
                for (int j = 1; j < dArray[i].length; ++j) {
                    double d = dArray[i][j];
                    d = this.measureConvert(j, d);
                    dArray2[j] = dArray2[j] + d;
                    string4 = string4.length() == 0 ? string5 + ";" + d : string4 + ";" + d;
                }
                arrayList.add(string4);
                continue block0;
            }
        }
        for (n = 0; n < dArray2.length; ++n) {
            arrayList2.add(new Double(dArray2[n]));
        }
        this.ddPoolTable.put(string, arrayList);
        System.out.println("pool Name is = " + string + " value is = " + arrayList2);
        this.addNewMeasure(string, arrayList2);
    }

    public void stopTest() {
    }

    public void freeTest() {
        this.ddPoolTable = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        FindMemory findMemory = new FindMemory();
        this.ramsize = findMemory.execute(false, "localhost");
        if (this.OSName == null || this.OSName.trim().length() == 0) {
            this.OSName = this.checkOS();
        }
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = this.getPoolList();
        if (hashtable3.containsKey("poolslist")) {
            arrayList = (ArrayList)hashtable3.get("poolslist");
        }
        if (hashtable3.containsKey("w3wp")) {
            hashtable2 = (Hashtable)hashtable3.get("w3wp");
        }
        this.ddPoolTable = new Hashtable();
        String[] stringArray = this.getW3WPInstances();
        ArrayList<Double> arrayList2 = null;
        String string = "";
        double[][] dArray = null;
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        if (stringArray != null) {
            dArray = this.getW3WPValues(stringArray);
        }
        if (this.configuredList.contains("all")) {
            int n = arrayList.size();
            if (dArray == null) {
                for (int i = 0; i < n; ++i) {
                    string = (String)arrayList.get(i);
                    arrayList2 = new ArrayList<Double>();
                    for (int j = 0; j < this.measureCount; ++j) {
                        if (j == 0) {
                            arrayList2.add(new Double(0.0));
                            continue;
                        }
                        arrayList2.add(new Double(-5.0));
                    }
                    this.addNewMeasure(string, arrayList2);
                }
                return;
            }
            for (int i = 0; i < n; ++i) {
                string = (String)arrayList.get(i);
                if (!this.isPoolAvailableInList(string, hashtable2)) {
                    arrayList2 = new ArrayList();
                    for (int j = 0; j < this.measureCount; ++j) {
                        if (j == 0) {
                            arrayList2.add(new Double(0.0));
                            continue;
                        }
                        arrayList2.add(new Double(-5.0));
                    }
                    this.addNewMeasure(string, arrayList2);
                    continue;
                }
                String string2 = (String)hashtable2.get(string);
                this.getValues(string, string2, dArray);
            }
        } else {
            int n = this.configuredList.size();
            if (dArray == null) {
                for (int i = 0; i < n; ++i) {
                    string = (String)this.configuredList.get(i);
                    arrayList2 = new ArrayList();
                    for (int j = 0; j < this.measureCount; ++j) {
                        if (j == 0) {
                            arrayList2.add(new Double(0.0));
                            continue;
                        }
                        arrayList2.add(new Double(-5.0));
                    }
                    this.addNewMeasure(string, arrayList2);
                }
                return;
            }
            for (int i = 0; i < n; ++i) {
                string = (String)this.configuredList.get(i);
                if (!this.isPoolAvailableInList(string, hashtable2)) {
                    arrayList2 = new ArrayList();
                    for (int j = 0; j < this.measureCount; ++j) {
                        if (j == 0) {
                            arrayList2.add(new Double(0.0));
                            continue;
                        }
                        arrayList2.add(new Double(-5.0));
                    }
                    this.addNewMeasure(string, arrayList2);
                    continue;
                }
                String string3 = (String)hashtable2.get(string);
                this.getValues(string, string3, dArray);
            }
        }
    }

    public static void main(String[] stringArray) {
        W3WPPoolTest w3WPPoolTest = new W3WPPoolTest(stringArray);
        while (true) {
            try {
                while (true) {
                    w3WPPoolTest.computeMeasures(new Hashtable());
                    Thread.sleep(7000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

