/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SyslogOutputStream
extends OutputStream {
    private static final int MAX_LEN = 1024;
    private InetAddress address;
    private DatagramSocket ds;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private final int port;

    public SyslogOutputStream(String string, int n2) throws UnknownHostException, SocketException {
        this.address = InetAddress.getByName(string);
        this.port = n2;
        this.ds = new DatagramSocket();
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.baos.write(byArray, n2, n3);
    }

    public void flush() throws IOException {
        byte[] byArray = this.baos.toByteArray();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.address, this.port);
        if (this.baos.size() > 1024) {
            this.baos = new ByteArrayOutputStream();
        } else {
            this.baos.reset();
        }
        if (byArray.length == 0) {
            return;
        }
        if (this.ds != null) {
            this.ds.send(datagramPacket);
        }
    }

    public void close() {
        this.address = null;
        this.ds = null;
    }

    public int getPort() {
        return this.port;
    }

    public void write(int n2) throws IOException {
        this.baos.write(n2);
    }

    int getSendBufferSize() throws SocketException {
        return this.ds.getSendBufferSize();
    }
}

