/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.subst;

import com.eg.ch.qos.logback.core.spi.ScanException;
import com.eg.ch.qos.logback.core.subst.Token;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tokenizer {
    final String pattern;
    final int patternLength;
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    public Tokenizer(String string) {
        this.pattern = string;
        this.patternLength = string.length();
    }

    List<Token> tokenize() throws ScanException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.pointer < this.patternLength) {
            char c2 = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c2, arrayList, stringBuilder);
                    break;
                }
                case START_STATE: {
                    this.handleStartState(c2, arrayList, stringBuilder);
                    break;
                }
                case DEFAULT_VAL_STATE: {
                    this.handleDefaultValueState(c2, arrayList, stringBuilder);
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addLiteralToken(arrayList, stringBuilder);
                break;
            }
            case DEFAULT_VAL_STATE: {
                stringBuilder.append(':');
                this.addLiteralToken(arrayList, stringBuilder);
                break;
            }
            case START_STATE: {
                stringBuilder.append('$');
                this.addLiteralToken(arrayList, stringBuilder);
            }
        }
        return arrayList;
    }

    private void handleDefaultValueState(char c2, List<Token> list, StringBuilder stringBuilder) {
        switch (c2) {
            case '-': {
                list.add(Token.DEFAULT_SEP_TOKEN);
                this.state = TokenizerState.LITERAL_STATE;
                break;
            }
            case '$': {
                stringBuilder.append(':');
                this.addLiteralToken(list, stringBuilder);
                stringBuilder.setLength(0);
                this.state = TokenizerState.START_STATE;
                break;
            }
            default: {
                stringBuilder.append(':').append(c2);
                this.state = TokenizerState.LITERAL_STATE;
            }
        }
    }

    private void handleStartState(char c2, List<Token> list, StringBuilder stringBuilder) {
        if (c2 == '{') {
            list.add(Token.START_TOKEN);
        } else {
            stringBuilder.append('$').append(c2);
        }
        this.state = TokenizerState.LITERAL_STATE;
    }

    private void handleLiteralState(char c2, List<Token> list, StringBuilder stringBuilder) {
        if (c2 == '$') {
            this.addLiteralToken(list, stringBuilder);
            stringBuilder.setLength(0);
            this.state = TokenizerState.START_STATE;
        } else if (c2 == ':') {
            this.addLiteralToken(list, stringBuilder);
            stringBuilder.setLength(0);
            this.state = TokenizerState.DEFAULT_VAL_STATE;
        } else if (c2 == '{') {
            this.addLiteralToken(list, stringBuilder);
            list.add(Token.CURLY_LEFT_TOKEN);
            stringBuilder.setLength(0);
        } else if (c2 == '}') {
            this.addLiteralToken(list, stringBuilder);
            list.add(Token.CURLY_RIGHT_TOKEN);
            stringBuilder.setLength(0);
        } else {
            stringBuilder.append(c2);
        }
    }

    private void addLiteralToken(List<Token> list, StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        list.add(new Token(Token.Type.LITERAL, stringBuilder.toString()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TokenizerState {
        LITERAL_STATE,
        START_STATE,
        DEFAULT_VAL_STATE;

    }
}

