﻿<#
    /*****************************************************************************
    Author            :       Prabaharan.T
    Purpose           :       display the activity operations that done by user
    Created           :       31/01/2018
    Modified By       : 

#>
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue

clear

$TestInputs=$args

$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$testFreRpt=$TestInputs[2]
$inputUsrKey=$TestInputs[3]
$arrStrng=$TestInputs[4]
$proxyUsr=$TestInputs[5]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[6]


$spoOpertns=$arrStrng.ToString().Trim().Split('#')

$fileOpe=$spoOpertns[0].ToString().Trim().Split('~')
$folderOpe=$spoOpertns[1].ToString().Trim().Split('~')
$syncOpe=$spoOpertns[2].ToString().Trim().Split('~')
$sharngOpe=$spoOpertns[3].ToString().Trim().Split('~')
$siteAdminOpe=$spoOpertns[4].ToString().Trim().Split('~')

$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')

$tstArr=$testFreRpt.Split('#')
$testFrequency=[int]$tstArr[0]
$reportingNam=$tstArr[1]
$showUsrFileOpe=$tstArr[2]
$rptPath='SPO/'+$reportingNam
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }

Function Start-SleepWithProgress {
	Param([int]$sleeptime)

	For ($i=0;$i -le $sleeptime;$i++){
		$timeleft = ($sleeptime - $i);
		Write-Progress -Activity "Sleeping" -CurrentOperation "$Timeleft More Seconds" -PercentComplete (($i/$sleeptime)*100);
		start-sleep 1
	}
	
	Write-Progress -Completed -Activity "Sleeping"
}

Function New-CleanSPOSession {
    $Credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $i = 0
	while (($Credential -eq $Null) -and ($i -lt 5)){
		$script:Credential = Get-Credential -Message "Please provide your Exchange Online Credentials"
		$i++
	}

	if ($Credential -eq $null){
		Write-Error -Message "Failed to get credentials" -ErrorAction Stop
	}

	Get-PSSession | Remove-PSSession -Confirm:$false
	[System.GC]::Collect()
	Start-SleepWithProgress -SleepTime 15
	$Error.Clear()
	
    $sessionOption = New-PSSessionOption -SkipRevocationCheck
	if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
	    $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
	    $sessionOption = New-PSSessionOption -SkipRevocationCheck -ProxyAccessType WinHttpConfig -ProxyAuthentication Basic -ProxyCredential $proxyCred
	}
	$session = New-PSSession -ConfigurationName Microsoft.Exchange -ConnectionUri $azureEnvArr[1] -Credential $Credential -Authentication Basic -AllowRedirection -SessionOption $sessionOption -WarningAction SilentlyContinue
		
	if ($Error.Count -gt 0){
		$ErrorCount++
		if ($ErrorCount -gt 3){
			exit
		}
		Start-SleepWithProgress -sleeptime 60
		New-CleanSPOSession
	}
	else {
		$ErrorCount = 0
	}
	$null = Import-PSSession $session -AllowClobber -WarningAction SilentlyContinue -DisableNameChecking
	Set-Variable -Scope script -Name SessionStartTime -Value (Get-Date)
}

$fileAct=@{}
foreach($act in $fileOpe){  
    $fileAct.Add($act,0)
}

$folderAct=@{}
foreach($act in $folderOpe){ 
    $folderAct.Add($act,0)
}

$syncAct=@{}
foreach($act in $syncOpe){  
    $syncAct.Add($act,0)
}

$sharngAct=@{}
foreach($act in $sharngOpe){  
    $sharngAct.Add($act,0)
}

$siteAdminAct=@{}
foreach($act in $siteAdminOpe){  
    $siteAdminAct.Add($act,0)
}

# hash for summary counts
$uniqOpe=@{}
$uniqusers= @{}
$uniqClientIp=@{}
$uniqsites=@{}
$uniqItem=@{}
$uniqDestnatn=@{}
$uniqUsrAgent=@{}

$uniqFdrOpe=@{}
$uniqFdrusers= @{}
$uniqFdrClientIp=@{}
$uniqFdrsites=@{}
$uniqFdrItem=@{}
$uniqFdrDestnatn=@{}
$uniqFdUsrAgent=@{}

$uniqSyncOpe=@{}
$uniqSyncUsers= @{}
$uniqSyncClientIp=@{}
$uniqSyncSites=@{}
$uniqSyncItem=@{}
$uniqSyncDestnatn=@{}
$uniqSyncUsrAgent=@{}

$uniqShrOpe=@{}
$uniqShrUsers= @{}
$uniqShrClientIp=@{}
$uniqShrSites=@{}
$uniqShrItem=@{}
$uniqShrDestnatn=@{}
$uniqShrUsrAgent=@{}

$uniqAdmnOpe=@{}
$uniqAdmnUsers= @{}
$uniqAdmnClientIp=@{}
$uniqAdmnSites=@{}
$uniqAdmnItem=@{}
$uniqAdmnDestnatn=@{}
$uniqAdmnUsrAgent=@{}

$usrFileOpe=@("FileAccessed","FileCheckedIn","FileCheckedOut","FileDeleted","FileUploaded")

$usrKeyArr=$inputUsrKey.Split(',')
$filePath=''
$kfilePath=''

$sysDat=(Get-Date).ToUniversalTime()
$endDat=$sysDat.AddMinutes(-60)
$startDat=$endDat.AddMinutes(-($testFrequency))
Try{
    Import-Module MsOnline
    Set-StrictMode -Version 2
    $ErrorCount = 0

    New-CleanSPOSession
    
    Try{
        $actWritArr = Eg-WriteFile -ComntRptPath $rptPath -FileName "spoActOprBase" -keyFileName "kspoActOprBase" -EgPath $egurkhaPath
        Search-UnifiedAuditLog -StartDate $startDat -EndDate $endDat | select AuditData,Operations |Export-Csv $actWritArr[1]
        $null=Protect-File  $actWritArr[1] -Algorithm AES -KeyAsPlainText $actWritArr[0] -RemoveSource
    }Catch{}

    $actReadArr=Eg-ReadFile -ComntRptPath $rptPath -FileName "spoActOprBase" -keyFileName "kspoActOprBase" -EgPath $egurkhaPath
    $unProtctAct=$actReadArr[1] -replace (".csv",".dat") 
    $actPath=Unprotect-File $unProtctAct -Algorithm AES -KeyAsPlainText $actReadArr[0]	
    $serchAuditLog= import-csv $actPath
    Remove-Item $actPath
 
    $filePath=$actReadArr[2]+''+$actReadArr[3]
    $kfilePath=$actReadArr[2]+''+$actReadArr[4]
    
    Get-PSSession | Remove-PSSession
}
Catch{
    Write-Host 'Exception Occured in SPO Activity operation "Search-UnifiedAuditLog" - ' $_.Exception.Message !>
}

Try{

    foreach($log in $serchAuditLog){

         #'if' condition for if userkey is in {NT AUTHORITY\SYSTEM,SHAREPOINT\system} or not
        if($inputUsrKey -ne "" -and $inputUsrKey -ne $null -and $inputUsrKey -ne "No" -and $inputUsrKey -ne "false"){
            $res= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $fileOpe -and $_.UserKey -notin $usrKeyArr}
            $resFldr= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $folderOpe -and $_.UserKey -notin $usrKeyArr}
            $resSync= $log.AuditData | ConvertFrom-Json | Where-Object {($_.Workload -eq "SharePoint" -or $_.Workload -eq "OneDrive") -and $_.Operation -in $syncOpe -and $_.UserKey -notin $usrKeyArr}
            $resShrg= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $sharngOpe -and $_.UserKey -notin $usrKeyArr}
            $resSAdm= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $siteAdminOpe -and $_.UserKey -notin $usrKeyArr}
        }else{
            $res= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $fileOpe}
            $resFldr= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $folderOpe }
            $resSync= $log.AuditData | ConvertFrom-Json | Where-Object {($_.Workload -eq "SharePoint" -or $_.Workload -eq "OneDrive") -and $_.Operation -in $syncOpe }
            $resShrg= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $sharngOpe }
            $resSAdm= $log.AuditData | ConvertFrom-Json | Where-Object {$_.Workload -eq "SharePoint" -and $_.Operation -in $siteAdminOpe }
        }

        # ******* FILE OPERATIONS ********* 

        if($res -ne "" -and $res -ne $null){ 
	    if($showUsrFileOpe -eq 'no'){
                if(($res.UserId -eq $userName) -and ($res.Operation -in $usrFileOpe )){
                    continue;
                }
            }
        
            $isUserAgent=[bool]($res.PSobject.Properties.name -match "UserAgent")
            $isSiteUrl=[bool]($res.PSobject.Properties.name -match "SiteUrl")   

            if($uniqOpe.ContainsKey($res.Operation)){
                $uniqOpe[$res.Operation]=[int]$uniqOpe[$res.Operation]+1
            }else{
                $uniqOpe.Add($res.Operation,1) 
            }

            $uniqUsrLine=$res.UserId+'#'+$res.ClientIP
            if($uniqusers.ContainsKey($uniqUsrLine)){          
                $output=[String]$uniqusers[$uniqUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($res.Operation)){
                    $uniqusers[$uniqUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqusers[$uniqUsrLine]= $arr[0]+','+$res.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqusers.Add($uniqUsrLine,$res.Operation+'#'+1) 
            }

            if($uniqClientIp.ContainsKey($res.ClientIP)){
                $ipOutput=[String]$uniqClientIp[$res.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($res.Operation)){
                    $uniqClientIp[$res.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqClientIp[$res.ClientIP]= $ipArr[0]+','+$res.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqClientIp.Add($res.ClientIP,$res.Operation+'#'+1)
            }        

            if($isSiteUrl){
                $uniqsiteLine=$res.SiteUrl+'#'+$res.Site
            }else{
                $uniqsiteLine='-#'+$res.Site
            }
            if($uniqsites.ContainsKey($uniqsiteLine)){
                $siteOutput=[String]$uniqsites[$uniqsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($res.Operation)){
                    $uniqsites[$uniqsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqsites[$uniqsiteLine]= $siteArr[0]+','+$res.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqsites.Add($uniqsiteLine,$res.Operation+'#'+1)
            }

            if($uniqItem.ContainsKey($res.ItemType)){
                $itemOutput=[String]$uniqItem[$res.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($res.Operation)){
                    $uniqItem[$res.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqItem[$res.ItemType]= $itemArr[0]+','+$res.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqItem.Add($res.ItemType,$res.Operation+'#'+1)
            }

            if($isSiteUrl){
                if($uniqDestnatn.ContainsKey($res.SiteUrl)){
                    $destOutput=[String]$uniqDestnatn[$res.SiteUrl]
                    $destArr=$destOutput.Split('#')
                    if($destOutput.Contains($res.Operation)){
                        $uniqDestnatn[$res.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                    }else{
                        $uniqDestnatn[$res.SiteUrl]= $destArr[0]+','+$res.Operation+'#'+[String]([int]$destArr[1]+1)
                    }
                }else{
                    $uniqDestnatn.Add($res.SiteUrl,$res.Operation+'#'+1)
                }
            }

            if($isUserAgent){
                if($uniqUsrAgent.ContainsKey($res.UserAgent)){
                    $uniqUsrAgent[$res.UserAgent]=[int]$uniqUsrAgent[$res.UserAgent]+1
                }else{
                    $uniqUsrAgent.Add($res.UserAgent,1)
                }
            }

            if($fileAct.ContainsKey($res.Operation)){      
                $fileAct[$res.Operation]=[int]$fileAct[$res.Operation]+1
            }
        }

        #    ********** FOLDER OPERATIONS *******

        if($resFldr -ne "" -and $resFldr -ne $null){

            if($uniqFdrOpe.ContainsKey($resFldr.Operation)){
                $uniqFdrOpe[$resFldr.Operation]=[int]$uniqFdrOpe[$resFldr.Operation]+1
            }else{
                $uniqFdrOpe.Add($resFldr.Operation,1) 
            }

            $fldrUsrLine=$resFldr.UserId+'#'+$resFldr.ClientIP
            if($uniqFdrusers.ContainsKey($fldrUsrLine)){          
                $output=[String]$uniqFdrusers[$fldrUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resFldr.Operation)){
                    $uniqFdrusers[$fldrUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqFdrusers[$fldrUsrLine]= $arr[0]+','+$resFldr.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqFdrusers.Add($fldrUsrLine,$resFldr.Operation+'#'+1) 
            }

            if($uniqFdrClientIp.ContainsKey($resFldr.ClientIP)){
                $ipOutput=[String]$uniqFdrClientIp[$resFldr.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resFldr.Operation)){
                    $uniqFdrClientIp[$resFldr.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqFdrClientIp[$resFldr.ClientIP]= $ipArr[0]+','+$resFldr.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqFdrClientIp.Add($resFldr.ClientIP,$resFldr.Operation+'#'+1)
            }

            $fldrsiteLine=$resFldr.SiteUrl+'#'+$resFldr.Site
            if($uniqFdrsites.ContainsKey($fldrsiteLine)){
                $siteOutput=[String]$uniqFdrsites[$fldrsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resFldr.Operation)){
                    $uniqFdrsites[$fldrsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqFdrsites[$fldrsiteLine]= $siteArr[0]+','+$resFldr.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqFdrsites.Add($fldrsiteLine,$resFldr.Operation+'#'+1)
            }

            if($uniqFdrItem.ContainsKey($resFldr.ItemType)){
                $itemOutput=[String]$uniqFdrItem[$resFldr.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resFldr.Operation)){
                    $uniqFdrItem[$resFldr.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqFdrItem[$resFldr.ItemType]= $itemArr[0]+','+$resFldr.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqFdrItem.Add($resFldr.ItemType,$resFldr.Operation+'#'+1)
            }

            if($uniqFdrDestnatn.ContainsKey($resFldr.SiteUrl)){
                $destOutput=[String]$uniqFdrDestnatn[$resFldr.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resFldr.Operation)){
                    $uniqFdrDestnatn[$resFldr.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqFdrDestnatn[$resFldr.SiteUrl]= $destArr[0]+','+$resFldr.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqFdrDestnatn.Add($resFldr.SiteUrl,$resFldr.Operation+'#'+1)
            }

            if($uniqFdUsrAgent.ContainsKey($resFldr.UserAgent)){
                $uniqFdUsrAgent[$resFldr.UserAgent]=[int]$uniqFdUsrAgent[$resFldr.UserAgent]+1
            }else{
                $uniqFdUsrAgent.Add($resFldr.UserAgent,1)
            }
     
            if($folderAct.ContainsKey($resFldr.Operation)){      
                $folderAct[$resFldr.Operation]=[int]$folderAct[$resFldr.Operation]+1
            }       
        }

        #    ********** SYNC OPERATIONS ********

        if($resSync -ne "" -and $resSync -ne $null){  

            if($uniqSyncOpe.ContainsKey($resSync.Operation)){
                $uniqSyncOpe[$resSync.Operation]=[int]$uniqSyncOpe[$resSync.Operation]+1
            }else{
                $uniqSyncOpe.Add($resSync.Operation,1) 
            }

            $syncUsrLine=$resSync.UserId+'#'+$resSync.ClientIP
            if($uniqSyncUsers.ContainsKey($syncUsrLine)){          
                $output=[String]$uniqSyncUsers[$syncUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resSync.Operation)){
                    $uniqSyncUsers[$syncUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqSyncUsers[$syncUsrLine]= $arr[0]+','+$resSync.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqSyncUsers.Add($syncUsrLine,$resSync.Operation+'#'+1) 
            }

            if($uniqSyncClientIp.ContainsKey($resSync.ClientIP)){
                $ipOutput=[String]$uniqSyncClientIp[$resSync.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resSync.Operation)){
                    $uniqSyncClientIp[$resSync.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqSyncClientIp[$resSync.ClientIP]= $ipArr[0]+','+$resSync.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqSyncClientIp.Add($resSync.ClientIP,$resSync.Operation+'#'+1)
            }

            $syncsiteLine=$resSync.SiteUrl+'#'+$resSync.Site
            if($uniqSyncSites.ContainsKey($syncsiteLine)){
                $siteOutput=[String]$uniqSyncSites[$syncsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resSync.Operation)){
                    $uniqSyncSites[$syncsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqSyncSites[$syncsiteLine]= $siteArr[0]+','+$resSync.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqSyncSites.Add($syncsiteLine,$resSync.Operation+'#'+1)
            }

            if($uniqSyncItem.ContainsKey($resSync.ItemType)){
                $itemOutput=[String]$uniqSyncItem[$resSync.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resSync.Operation)){
                    $uniqSyncItem[$resSync.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqSyncItem[$resSync.ItemType]= $itemArr[0]+','+$resSync.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqSyncItem.Add($resSync.ItemType,$resSync.Operation+'#'+1)
            }

            if($uniqSyncDestnatn.ContainsKey($resSync.SiteUrl)){
                $destOutput=[String]$uniqSyncDestnatn[$resSync.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resSync.Operation)){
                    $uniqSyncDestnatn[$resSync.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqSyncDestnatn[$resSync.SiteUrl]= $destArr[0]+','+$resSync.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqSyncDestnatn.Add($resSync.SiteUrl,$resSync.Operation+'#'+1)
            }

            if($uniqSyncUsrAgent.ContainsKey($resSync.UserAgent)){
                $uniqSyncUsrAgent[$resSync.UserAgent]=[int]$uniqSyncUsrAgent[$resSync.UserAgent]+1
            }else{
                $uniqSyncUsrAgent.Add($resSync.UserAgent,1)
            }

            if($syncAct.ContainsKey($resSync.Operation)){          
                $syncAct[$resSync.Operation]=[int]$syncAct[$resSync.Operation]+1
            }  
        }

        #    ********** SHARING OPERATIONS ********

        if($resShrg -ne "" -and $resShrg -ne $null){

            if($uniqShrOpe.ContainsKey($resShrg.Operation)){
                $uniqShrOpe[$resShrg.Operation]=[int]$uniqShrOpe[$resShrg.Operation]+1
            }else{
                $uniqShrOpe.Add($resShrg.Operation,1) 
            }

            $shrgUsrLine=$resShrg.UserId+'#'+$resShrg.ClientIP
            if($uniqShrUsers.ContainsKey($shrgUsrLine)){          
                $output=[String]$uniqShrUsers[$shrgUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resShrg.Operation)){
                    $uniqShrUsers[$shrgUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqShrUsers[$shrgUsrLine]= $arr[0]+','+$resShrg.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqShrUsers.Add($shrgUsrLine,$resShrg.Operation+'#'+1) 
            }

            if($uniqShrClientIp.ContainsKey($resShrg.ClientIP)){
                $ipOutput=[String]$uniqShrClientIp[$resShrg.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resShrg.Operation)){
                    $uniqShrClientIp[$resShrg.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqShrClientIp[$resShrg.ClientIP]= $ipArr[0]+','+$resShrg.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqShrClientIp.Add($resShrg.ClientIP,$resShrg.Operation+'#'+1)
            }

            $shrgsiteLine=$resShrg.SiteUrl+'#'+$resShrg.Site
            if($uniqShrSites.ContainsKey($shrgsiteLine)){
                $siteOutput=[String]$uniqShrSites[$shrgsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resShrg.Operation)){
                    $uniqShrSites[$shrgsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqShrSites[$shrgsiteLine]= $siteArr[0]+','+$resShrg.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqShrSites.Add($shrgsiteLine,$resShrg.Operation+'#'+1)
            }

            if($uniqShrItem.ContainsKey($resShrg.ItemType)){
                $itemOutput=[String]$uniqShrItem[$resShrg.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resShrg.Operation)){
                    $uniqShrItem[$resShrg.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqShrItem[$resShrg.ItemType]= $itemArr[0]+','+$resShrg.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqShrItem.Add($resShrg.ItemType,$resShrg.Operation+'#'+1)
            }

            if($uniqShrDestnatn.ContainsKey($resShrg.SiteUrl)){
                $destOutput=[String]$uniqShrDestnatn[$resShrg.SiteUrl]
                $destArr=$destOutput.Split('#')
                if($destOutput.Contains($resShrg.Operation)){
                    $uniqShrDestnatn[$resShrg.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                }else{
                    $uniqShrDestnatn[$resShrg.SiteUrl]= $destArr[0]+','+$resShrg.Operation+'#'+[String]([int]$destArr[1]+1)
                }
            }else{
                $uniqShrDestnatn.Add($resShrg.SiteUrl,$resShrg.Operation+'#'+1)
            }   

            if($uniqShrUsrAgent.ContainsKey($resShrg.UserAgent)){
                $uniqShrUsrAgent[$resShrg.UserAgent]=[int]$uniqShrUsrAgent[$resShrg.UserAgent]+1
            }else{
                $uniqShrUsrAgent.Add($resShrg.UserAgent,1)
            }
     
            if($sharngAct.ContainsKey($resShrg.Operation)){               
                $sharngAct[$resShrg.Operation]=[int]$sharngAct[$resShrg.Operation]+1
            }
   
        }

        # ************** SITE ADMIN OPERATIONS ****************

        if($resSAdm -ne "" -and $resSAdm -ne $null){

            $isAdmUserAgent=[bool]($resSAdm.PSobject.Properties.name -match "UserAgent")
             $isAdmSiteUrl=[bool]($resSAdm.PSobject.Properties.name -match "SiteUrl")
        
            if($uniqAdmnOpe.ContainsKey($resSAdm.Operation)){
                $uniqAdmnOpe[$resSAdm.Operation]=[int]$uniqAdmnOpe[$resSAdm.Operation]+1
            }else{
                $uniqAdmnOpe.Add($resSAdm.Operation,1) 
            }

            $admnUsrLine=$resSAdm.UserId+'#'+$resSAdm.ClientIP
            if($uniqAdmnUsers.ContainsKey($admnUsrLine)){          
                $output=[String]$uniqAdmnUsers[$admnUsrLine]
                $arr=$output.Split('#')
                if($output.Contains($resSAdm.Operation)){
                    $uniqAdmnUsers[$admnUsrLine]=$arr[0]+'#'+[String]([int]$arr[1]+1)
                }else{
                    $uniqAdmnUsers[$admnUsrLine]= $arr[0]+','+$resSAdm.Operation+'#'+[String]([int]$arr[1]+1)
                }               
            }else{
                $uniqAdmnUsers.Add($admnUsrLine,$resSAdm.Operation+'#'+1) 
            }

            if($uniqAdmnClientIp.ContainsKey($resSAdm.ClientIP)){
                $ipOutput=[String]$uniqAdmnClientIp[$resSAdm.ClientIP]
                $ipArr=$ipOutput.Split('#')
                if($ipOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnClientIp[$resSAdm.ClientIP]=$ipArr[0]+'#'+[String]([int]$ipArr[1]+1)
                }else{
                    $uniqAdmnClientIp[$resSAdm.ClientIP]= $ipArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$ipArr[1]+1)
                }               
            }else{
                $uniqAdmnClientIp.Add($resSAdm.ClientIP,$resSAdm.Operation+'#'+1)
            }

            if($isAdmSiteUrl){
                $admnsiteLine=$resSAdm.SiteUrl+'#'+$resSAdm.Site
            }else{
                $admnsiteLine='-#'+$resSAdm.Site
            }
            if($uniqAdmnSites.ContainsKey($admnsiteLine)){
                $siteOutput=[String]$uniqAdmnSites[$admnsiteLine]
                $siteArr=$siteOutput.Split('#')
                if($siteOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnSites[$admnsiteLine]=$siteArr[0]+'#'+[String]([int]$siteArr[1]+1)
                }else{
                    $uniqAdmnSites[$admnsiteLine]= $siteArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$siteArr[1]+1)
                } 
            }else{
                $uniqAdmnSites.Add($admnsiteLine,$resSAdm.Operation+'#'+1)
            }

            if($uniqAdmnItem.ContainsKey($resSAdm.ItemType)){
                $itemOutput=[String]$uniqAdmnItem[$resSAdm.ItemType]
                $itemArr=$itemOutput.Split('#')
                if($itemOutput.Contains($resSAdm.Operation)){
                    $uniqAdmnItem[$resSAdm.ItemType]=$itemArr[0]+'#'+[String]([int]$itemArr[1]+1)
                }else{
                    $uniqAdmnItem[$resSAdm.ItemType]= $itemArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$itemArr[1]+1)
                } 
            }else{
                $uniqAdmnItem.Add($resSAdm.ItemType,$resSAdm.Operation+'#'+1)
            }

            if($isAdmSiteUrl){
                if($uniqAdmnDestnatn.ContainsKey($resSAdm.SiteUrl)){
                    $destOutput=[String]$uniqAdmnDestnatn[$resSAdm.SiteUrl]
                        $destArr=$destOutput.Split('#')
                    if($destOutput.Contains($resSAdm.Operation)){
                        $uniqAdmnDestnatn[$resSAdm.SiteUrl]=$destArr[0]+'#'+[String]([int]$destArr[1]+1)
                    }else{
                        $uniqAdmnDestnatn[$resSAdm.SiteUrl]= $destArr[0]+','+$resSAdm.Operation+'#'+[String]([int]$destArr[1]+1)
                    }
                }else{
                    $uniqAdmnDestnatn.Add($resSAdm.SiteUrl,$resSAdm.Operation+'#'+1)
                }
            }

            if($isAdmUserAgent){
                if($uniqAdmnUsrAgent.ContainsKey($resSAdm.UserAgent)){
                    $uniqAdmnUsrAgent[$resSAdm.UserAgent]=[int]$uniqAdmnUsrAgent[$resSAdm.UserAgent]+1
                }else{
                    $uniqAdmnUsrAgent.Add($resSAdm.UserAgent,1)
                }
            }
      
            if($siteAdminAct.ContainsKey($resSAdm.Operation)){    
                $siteAdminAct[$resSAdm.Operation]=[int]$siteAdminAct[$resSAdm.Operation]+1
            }
        }

    }



    # ******* FILE OPERATIONS *********

    $fileOperCnt=""
    for($i=0;$i -lt $fileOpe.Length;$i++ ){
        $fileOperCnt+="~!~"+$fileAct[$fileOpe[$i]]
    }
    Write-Host "FilePage Operations Count"$fileOperCnt !>

    #Summary measure count values
    foreach($key in $uniqOpe.keys){
        Write-Host "FilePageOpeartion"~!~ $key ~!~ $uniqOpe[$key] !>
    }

    foreach($key in $uniqusers.keys){
        Write-Host "FilePageUsers"~!~ $key '#' $uniqusers[$key] !>
    }

    foreach($key in $uniqClientIp.keys){
        Write-Host "FilePageClientIP #"$key '#' $uniqClientIp[$key] !>
    }

    foreach($key in $uniqsites.keys){
        Write-Host "FilePageSites #"$key '#' $uniqsites[$key] !>
    }

    foreach($key in $uniqItem.keys){
        Write-Host "FilePageitems #"$key '#' $uniqItem[$key] !>
    }
    
    foreach($key in $uniqDestnatn.keys){
        Write-Host "FilePageDestination #"$key '#' $uniqDestnatn[$key] !>
    }

    foreach($key in $uniqUsrAgent.keys){
        Write-Host "FilePageUserAgent"~!~ $key~!~ $uniqUsrAgent[$key] !>
    }

    #    ********** FOLDER OPERATIONS *******

    $fldrOperCnt=""
    for($i=0;$i -lt $folderOpe.Length;$i++ ){   
        $fldrOperCnt+="~!~"+$folderAct[$folderOpe[$i]]
    }
    Write-Host "Folder Operations Count"$fldrOperCnt !>

    foreach($key in $uniqFdrOpe.keys){
        Write-Host "FolderOpeartion"~!~ $key ~!~ $uniqFdrOpe[$key] !>
    }

    foreach($key in $uniqFdrusers.keys){
        Write-Host "FolderUsers"~!~ $key '#' $uniqFdrusers[$key] !>
    }

    foreach($key in $uniqFdrClientIp.keys){
        Write-Host "FolderClientIP #" $key '#' $uniqFdrClientIp[$key] !>
    }

    foreach($key in $uniqFdrsites.keys){
        Write-Host "FolderSites #" $key '#' $uniqFdrsites[$key] !>
    }

    foreach($key in $uniqFdrItem.keys){
        Write-Host "Folderitems #" $key '#' $uniqFdrItem[$key] !>
    }

    foreach($key in $uniqFdrDestnatn.keys){
        Write-Host "FolderDestination #" $key '#' $uniqFdrDestnatn[$key] !>
    }

    foreach($key in $uniqFdUsrAgent.keys){
        Write-Host "FolderUserAgent"~!~ $key~!~ $uniqFdUsrAgent[$key] !>
    }


    #    ********** SYNC OPERATIONS ********


    $syncOperCnt=""
    for($i=0;$i -lt $syncOpe.Length;$i++ ){
        $syncOperCnt+="~!~"+$syncAct[$syncOpe[$i]]
    }
    Write-Host "Synchronization Operations Count"$syncOperCnt !>

    foreach($key in $uniqSyncOpe.keys){
        Write-Host "SyncOpeartion"~!~ $key ~!~ $uniqSyncOpe[$key] !>
    }

    foreach($key in $uniqSyncUsers.keys){
        Write-Host "SyncUsers"~!~ $key '#' $uniqSyncUsers[$key] !>
    }

    foreach($key in $uniqSyncClientIp.keys){
        Write-Host "SyncClientIP #" $key '#' $uniqSyncClientIp[$key] !>
    }

    foreach($key in $uniqSyncSites.keys){
        Write-Host "SyncSites #"$key '#' $uniqSyncSites[$key] !>
    }

    foreach($key in $uniqSyncItem.keys){
        Write-Host "Syncitems #"$key '#' $uniqSyncItem[$key] !>
    }

    foreach($key in $uniqSyncDestnatn.keys){
        Write-Host "SyncDestination #"$key '#' $uniqSyncDestnatn[$key] !>
    }

    foreach($key in $uniqSyncUsrAgent.keys){
        Write-Host "SyncUserAgent"~!~ $key~!~ $uniqSyncUsrAgent[$key] !>
    }


    #    ********** SHARING OPERATIONS ******** 

    $shrOperCnt=""
     for($i=0;$i -lt $sharngOpe.Length;$i++ ){  
         $shrOperCnt+="~!~"+$sharngAct[$sharngOpe[$i]]
     }
     Write-Host "Sharng Operations Count"$shrOperCnt !>
 
    foreach($key in $uniqShrOpe.keys){
        Write-Host "SharngOpeartion"~!~ $key ~!~ $uniqShrOpe[$key] !>
    }

    foreach($key in $uniqShrUsers.keys){
        Write-Host "SharngUsers"~!~ $key '#' $uniqShrUsers[$key] !>
    }

    foreach($key in $uniqShrClientIp.keys){
        Write-Host "SharngClientIP #"$key '#' $uniqShrClientIp[$key] !>
    }

    foreach($key in $uniqShrSites.keys){
        Write-Host "SharngSites #"$key '#' $uniqShrSites[$key] !>
    }

    foreach($key in $uniqShrItem.keys){
        Write-Host "Sharngitems #"$key '#' $uniqShrItem[$key] !>
    }

    foreach($key in $uniqShrDestnatn.keys){
        Write-Host "SharngDestination #"$key '#' $uniqShrDestnatn[$key] !>
    }

    foreach($key in $uniqShrUsrAgent.keys){
        Write-Host "SharngUserAgent"~!~ $key~!~ $uniqShrUsrAgent[$key] !>
    }

    # ************** SITE ADMIN OPERATIONS ****************

    $siteAdminOperCnt=""
    for($i=0;$i -lt $siteAdminOpe.Length;$i++ ){  
        $siteAdminOperCnt+="~!~"+$siteAdminAct[$siteAdminOpe[$i]]
    }
    Write-Host "SAdmin Operations Count"$siteAdminOperCnt !>
 
    foreach($key in $uniqAdmnOpe.keys){
        Write-Host "SAdminOpeartion"~!~ $key ~!~ $uniqAdmnOpe[$key] !>
    }

    foreach($key in $uniqAdmnUsers.keys){
        Write-Host "SAdminUsers"~!~ $key '#' $uniqAdmnUsers[$key] !>
    }

    foreach($key in $uniqAdmnClientIp.keys){
        Write-Host "SAdminClientIP #"$key '#' $uniqAdmnClientIp[$key] !>
    }

    foreach($key in $uniqAdmnSites.keys){
        Write-Host "SAdminSites #"$key '#' $uniqAdmnSites[$key] !>
    }

    foreach($key in $uniqAdmnItem.keys){
        Write-Host "SAdminitems #"$key '#' $uniqAdmnItem[$key] !>
    }

    foreach($key in $uniqAdmnDestnatn.keys){
        Write-Host "SAdminDestination #"$key '#' $uniqAdmnDestnatn[$key] !>
    }

    foreach($key in $uniqAdmnUsrAgent.keys){
        Write-Host "SAdminUserAgent"~!~ $key~!~ $uniqAdmnUsrAgent[$key] !>
    }

}
Catch{
    Write-Host 'Exception Occured in SPO Activity operation - ' $_.Exception.Message !>
}
Remove-Item $filePath -Force
Remove-Item $kfilePath -Force
#         *************************** END *************************


# SIG # Begin signature block
# MIIcdAYJKoZIhvcNAQcCoIIcZTCCHGECAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUboSXLAdWp7dkryaJqa76Qc/a
# Y82ggherMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFNDCC
# BBygAwIBAgIQAuEYSxAWnqD3sU8D3BMzUjANBgkqhkiG9w0BAQsFADByMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29k
# ZSBTaWduaW5nIENBMB4XDTE4MDcxMDAwMDAwMFoXDTIxMDkxNTEyMDAwMFowcTEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxp
# bjEdMBsGA1UEChMUZUcgSW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElu
# bm92YXRpb25zLCBJbmMuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# oNt7XWB1y9xwtvCGO/XipXallOkZ3ScdXunWCONnBzryRdCj7C/WX9s1CU8KkjRP
# FjWW+BOXvvC4ZUqw0Ad2uJAXyBY2/lV9eaoTRFB6Kb2/tJzG3je7Vcu8MxGJlwzP
# QQrr6icEJeqAPFE7vmzThVbd9H1n5Zdmwx20WCFe2V9qyVYHt7/6GS7WB2CwwjT6
# iVmiKP8HZXgr3tHZeAEb7tdQqd5//9e+8Mp8anb8ZdNgC9PQjBmbrQ/wH3kV65gK
# L+5kbgRvIfsmYxXiU1IFkq4rSQ+tfsDtYqBhGfovef9Gt8ZTjx7S4fortxwR7tlz
# i+wLO5m8I9sm4I2ouyIOQQIDAQABo4IBxTCCAcEwHwYDVR0jBBgwFoAUWsS5eyoK
# o6XqcQPAYPkt9mV1DlgwHQYDVR0OBBYEFD3yRqdsw6UIddfMPwhUMv2AaGRAMA4G
# A1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWg
# M6Axhi9odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcx
# LmNybDA1oDOgMYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC1jcy1nMS5jcmwwTAYDVR0gBEUwQzA3BglghkgBhv1sAwEwKjAoBggrBgEFBQcC
# ARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAP1QnJ6TEczaeGxVokMinsKam1mJB+zDk4B9rfm31
# iaZe9OeNvR/UJAs+5b0gKBZF9NmTVdayAYV74vZU5IElRo59q6hbg/20Wu87UyoE
# Yjwrv2DxHgl3z80piuLllmoe79vEu/bYvreBamzZmHlyxRP0us2KRfEsLBH23y1o
# zBATLc3yBu+mCfDg9E1RfhpKyD1iMHkbC90To6bpOlP9Pd6R4WEAFROILgm2bofQ
# ZhN4UNKbJ1uLCvV2NiUbU7+YSC3NP9SdphaDBiOnUWiK8MjTIPZbhh3QjI5f342q
# cUiR4LGx/Z/6pq4w6YHWd8c1czexD7xVCom7ZafCOKFWyzCCBmowggVSoAMCAQIC
# EAMBmgI6/1ixa9bV6uYX8GYwDQYJKoZIhvcNAQEFBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgQXNzdXJlZCBJRCBDQS0xMB4XDTE0MTAyMjAw
# MDAwMFoXDTI0MTAyMjAwMDAwMFowRzELMAkGA1UEBhMCVVMxETAPBgNVBAoTCERp
# Z2lDZXJ0MSUwIwYDVQQDExxEaWdpQ2VydCBUaW1lc3RhbXAgUmVzcG9uZGVyMIIB
# IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAo2Rd/Hyz4II14OD2xirmSXU7
# zG7gU6mfH2RZ5nxrf2uMnVX4kuOe1VpjWwJJUNmDzm9m7t3LhelfpfnUh3SIRDsZ
# yeX1kZ/GFDmsJOqoSyyRicxeKPRktlC39RKzc5YKZ6O+YZ+u8/0SeHUOplsU/UUj
# joZEVX0YhgWMVYd5SEb3yg6Np95OX+Koti1ZAmGIYXIYaLm4fO7m5zQvMXeBMB+7
# NgGN7yfj95rwTDFkjePr+hmHqH7P7IwMNlt6wXq4eMfJBi5GEMiN6ARg27xzdPpO
# 2P6qQPGyznBGg+naQKFZOtkVCVeZVjCT88lhzNAIzGvsYkKRrALA76TwiRGPdwID
# AQABo4IDNTCCAzEwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYDVR0l
# AQH/BAwwCgYIKwYBBQUHAwgwggG/BgNVHSAEggG2MIIBsjCCAaEGCWCGSAGG/WwH
# ATCCAZIwKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMw
# ggFkBggrBgEFBQcCAjCCAVYeggFSAEEAbgB5ACAAdQBzAGUAIABvAGYAIAB0AGgA
# aQBzACAAQwBlAHIAdABpAGYAaQBjAGEAdABlACAAYwBvAG4AcwB0AGkAdAB1AHQA
# ZQBzACAAYQBjAGMAZQBwAHQAYQBuAGMAZQAgAG8AZgAgAHQAaABlACAARABpAGcA
# aQBDAGUAcgB0ACAAQwBQAC8AQwBQAFMAIABhAG4AZAAgAHQAaABlACAAUgBlAGwA
# eQBpAG4AZwAgAFAAYQByAHQAeQAgAEEAZwByAGUAZQBtAGUAbgB0ACAAdwBoAGkA
# YwBoACAAbABpAG0AaQB0ACAAbABpAGEAYgBpAGwAaQB0AHkAIABhAG4AZAAgAGEA
# cgBlACAAaQBuAGMAbwByAHAAbwByAGEAdABlAGQAIABoAGUAcgBlAGkAbgAgAGIA
# eQAgAHIAZQBmAGUAcgBlAG4AYwBlAC4wCwYJYIZIAYb9bAMVMB8GA1UdIwQYMBaA
# FBUAEisTmLKZB+0e36K+Vw0rZwLNMB0GA1UdDgQWBBRhWk0ktkkynUoqeRqDS/Qe
# icHKfTB9BgNVHR8EdjB0MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURDQS0xLmNybDA4oDagNIYyaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEQ0EtMS5jcmwwdwYIKwYBBQUHAQEE
# azBpMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYB
# BQUHMAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRENBLTEuY3J0MA0GCSqGSIb3DQEBBQUAA4IBAQCdJX4bM02yJoFcm4bOIyAP
# gIfliP//sdRqLDHtOhcZcRfNqRu8WhY5AJ3jbITkWkD73gYBjDf6m7GdJH7+IKRX
# rVu3mrBgJuppVyFdNC8fcbCDlBkFazWQEKB7l8f2P+fiEUGmvWLZ8Cc9OB0obzpS
# CfDscGLTYkuw4HOmksDTjjHYL+NtFxMG7uQDthSr849Dp3GdId0UyhVdkkHa+Q+B
# 0Zl0DSbEDn8btfWg8cZ3BigV6diT5VUW8LsKqxzbXEgnZsijiwoc5ZXarsQuWaBh
# 3drzbaJh6YoLbewSGL33VVRAA5Ira8JRwgpIr7DUbuD0FAo6G+OPPcqvao173NhE
# MIIGzTCCBbWgAwIBAgIQBv35A5YDreoACus/J7u6GzANBgkqhkiG9w0BAQUFADBl
# MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
# d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
# b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMjExMTEwMDAwMDAwWjBiMQswCQYDVQQG
# EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
# cnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBBc3N1cmVkIElEIENBLTEwggEiMA0G
# CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDogi2Z+crCQpWlgHNAcNKeVlRcqcTS
# QQaPyTP8TUWRXIGf7Syc+BZZ3561JBXCmLm0d0ncicQK2q/LXmvtrbBxMevPOkAM
# Rk2T7It6NggDqww0/hhJgv7HxzFIgHweog+SDlDJxofrNj/YMMP/pvf7os1vcyP+
# rFYFkPAyIRaJxnCI+QWXfaPHQ90C6Ds97bFBo+0/vtuVSMTuHrPyvAwrmdDGXRJC
# geGDboJzPyZLFJCuWWYKxI2+0s4Grq2Eb0iEm09AufFM8q+Y+/bOQF1c9qjxL6/s
# iSLyaxhlscFzrdfx2M8eCnRcQrhofrfVdwonVnwPYqQ/MhRglf0HBKIJAgMBAAGj
# ggN6MIIDdjAOBgNVHQ8BAf8EBAMCAYYwOwYDVR0lBDQwMgYIKwYBBQUHAwEGCCsG
# AQUFBwMCBggrBgEFBQcDAwYIKwYBBQUHAwQGCCsGAQUFBwMIMIIB0gYDVR0gBIIB
# yTCCAcUwggG0BgpghkgBhv1sAAEEMIIBpDA6BggrBgEFBQcCARYuaHR0cDovL3d3
# dy5kaWdpY2VydC5jb20vc3NsLWNwcy1yZXBvc2l0b3J5Lmh0bTCCAWQGCCsGAQUF
# BwICMIIBVh6CAVIAQQBuAHkAIAB1AHMAZQAgAG8AZgAgAHQAaABpAHMAIABDAGUA
# cgB0AGkAZgBpAGMAYQB0AGUAIABjAG8AbgBzAHQAaQB0AHUAdABlAHMAIABhAGMA
# YwBlAHAAdABhAG4AYwBlACAAbwBmACAAdABoAGUAIABEAGkAZwBpAEMAZQByAHQA
# IABDAFAALwBDAFAAUwAgAGEAbgBkACAAdABoAGUAIABSAGUAbAB5AGkAbgBnACAA
# UABhAHIAdAB5ACAAQQBnAHIAZQBlAG0AZQBuAHQAIAB3AGgAaQBjAGgAIABsAGkA
# bQBpAHQAIABsAGkAYQBiAGkAbABpAHQAeQAgAGEAbgBkACAAYQByAGUAIABpAG4A
# YwBvAHIAcABvAHIAYQB0AGUAZAAgAGgAZQByAGUAaQBuACAAYgB5ACAAcgBlAGYA
# ZQByAGUAbgBjAGUALjALBglghkgBhv1sAxUwEgYDVR0TAQH/BAgwBgEB/wIBADB5
# BggrBgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0
# LmNvbTBDBggrBgEFBQcwAoY3aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Rp
# Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0
# cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNy
# bDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJl
# ZElEUm9vdENBLmNybDAdBgNVHQ4EFgQUFQASKxOYspkH7R7for5XDStnAs0wHwYD
# VR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDQYJKoZIhvcNAQEFBQADggEB
# AEZQPsm3KCSnOB22WymvUs9S6TFHq1Zce9UNC0Gz7+x1H3Q48rJcYaKclcNQ5IK5
# I9G6OoZyrTh4rHVdFxc0ckeFlFbR67s2hHfMJKXzBBlVqefj56tizfuLLZDCwNK1
# lL1eT7EF0g49GqkUW6aGMWKoqDPkmzmnxPXOHXh2lCVz5Cqrz5x2S+1fwksW5Etw
# TACJHvzFebxMElf+X+EevAJdqP77BzhPDcZdkbkPZ0XN1oPt55INjbFpjE/7WeAj
# D9KqrgB87pxCDs+R1ye3Fu4Pw718CqDuLAhVhSK46xgaTfwqIa1JMYNHlXdx3LEb
# S0scEJx3FMGdTy9alQgpECYxggQzMIIELwIBATCBhjByMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5n
# IENBAhAC4RhLEBaeoPexTwPcEzNSMAkGBSsOAwIaBQCgcDAQBgorBgEEAYI3AgEM
# MQIwADAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgorBgEEAYI3AgELMQ4w
# DAYKKwYBBAGCNwIBFTAjBgkqhkiG9w0BCQQxFgQULPCsxNPZusAz+J0zklpVsx4e
# TOEwDQYJKoZIhvcNAQEBBQAEggEAdob1xIUsgfd6ThkYwMXS3B5WyYFIPWGsm9gU
# yR37rakrs8pVsHhgQDLXJ/asaRB/ca/9+6PYcVbVLf+uTlVItTFVvorwpv6fyVjS
# ecZqWiqgy6Hsqfx1bO/UpiwLrCkvzL4qVm4hbqb4ewpRuppwsCJOc7+eYJtd6iln
# PN2CmKWDjEzWqepNAV/LyLL7FCNxrdSA0pwcFSVI3K945d2aWMsyEJmc62dsHcFR
# euEhDn+CQl5ysDhQ6Hcp+GLDguVfX411EplZAy1TlGkxMWUKUNp/LTQJ40my6dDJ
# xhlLfQ5/Gg0tP+at0ZGARrukQ8wkzsRziqY4irQsnzk1ukcnIaGCAg8wggILBgkq
# hkiG9w0BCQYxggH8MIIB+AIBATB2MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxE
# aWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMT
# GERpZ2lDZXJ0IEFzc3VyZWQgSUQgQ0EtMQIQAwGaAjr/WLFr1tXq5hfwZjAJBgUr
# DgMCGgUAoF0wGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUx
# DxcNMjAwODEyMDYzNjM2WjAjBgkqhkiG9w0BCQQxFgQUR1RdPw5iSP19iXZMZZzn
# 3aj7mxMwDQYJKoZIhvcNAQEBBQAEggEAUxC6rsAGz3GSxvqvkdbQU0ktnEh2KMyE
# emetn8GFb+9c2qlYVWb/6oN/3N+0g3h+i1EsOSyKBLknmUXQIEHLd/LZ35r/K0CP
# /aW0ATUYW1/yMlF56JKleMYQyrl3CVWB4Duj1xfGUk9PZQd3gR4QNmRGU8Akbd8V
# YyWrE/ErZrqW2K9r8tw3ZZ7vML6vjmk3CjaIb9Dbwf8J6Tf4anL5xn21sBLUfmBa
# K4X09SVFAto5zTZ06z7Qdlq8nGb986LwlYxvV71DEOuf7uCkWyZIo2qKFTczyKbf
# 4eh5JEONxM+eTHtNoogD1vgS89s2o83X54TENAJbWTAQxACJh6Ft8g==
# SIG # End signature block
