﻿##/**************************************************************************************
##Author                :      Guravareddy.T
##Purpose               :      O365 Modules Connectivity Status and Time Taken To Connect
##Created               :      11/01/2018
##Modified By		    :             
##/**************************************************************************************
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egurkhaPath=(Get-Item Env:EGURKHA_INSTALL_DIR).value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserverip=($TestInputs[4]).ToString().trim()
$azureVal=Eg-GetAzureEnv -UserName $userName
$azureEnvArr=$azureVal.Split(',')
if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
 
$credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
if(!$proxyserverip.Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr -ne 'none' -and $proxyPass -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }


Write-Host "-------Office 365--------"
    $d1=Get-Date
    Import-Module MsOnline
    Connect-MsolService -Credential $credential -AzureEnvironment $azureEnvArr[0]
    $d2=Get-Date
    $diff=New-TimeSpan -Start $d1 -End $d2
    try{
    $mosldmin=Get-MsolDomain

     if($mosldmin.Name -ne $null){
        Write-Host 'Office 365#Success' ($diff.TotalSeconds).ToString().replace(',','.')
     }else{
        Write-Host 'Office 365#Failed' ($diff.TotalSeconds).ToString().replace(',','.')
     }
     }catch{
        Write-Host 'Exception Occured in O365ConnectivityChecks - ' $_.Exception.Message
    }
