/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

import com.eg.agent.EgClassFileTransformer;
import com.eg.jtm.BTMLog;
import com.eg.jtm.PropsManager;
import com.eg.jtm.StartServer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAgent {
    private Instrumentation instrumentation;
    private boolean isJRE5;
    private boolean isJRE6andAbove;
    private boolean appendSuccess;
    private boolean isVmAttach;

    public JavaAgent(Instrumentation instrumentation, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.instrumentation = instrumentation;
        this.isJRE5 = bl;
        this.isJRE6andAbove = bl2;
        this.appendSuccess = bl3;
        this.isVmAttach = bl5;
        this.initialize();
    }

    private void initialize() {
        block4: {
            block5: {
                block6: {
                    PropsManager.EG_BTM_HOME = System.getProperty("EG_BTM_HOME");
                    if (!this.isJRE5 && !this.appendSuccess) break block5;
                    boolean bl = StartServer.startThread();
                    if (!bl) break block6;
                    this.logSystemProperties();
                    EgClassFileTransformer egClassFileTransformer = null;
                    try {
                        egClassFileTransformer = new EgClassFileTransformer(this.instrumentation, this.isJRE6andAbove, true, this.isVmAttach);
                    }
                    catch (Throwable throwable) {
                        JavaAgent.printOutLog("ERROR", "Problem occured while creating instance of \"EgClassFileTransformer\" " + this.stackTraceString(throwable));
                        StartServer.stopBTMServer();
                        if (egClassFileTransformer == null) break block4;
                        try {
                            boolean bl2 = this.instrumentation.removeTransformer(egClassFileTransformer);
                            JavaAgent.printOutLog("INFO", "Is Transformer Removed Successfully? :" + bl2);
                            break block4;
                        }
                        catch (Exception exception) {}
                    }
                    break block4;
                }
                JavaAgent.printOutLog("INFO", "Problem occured StartServer.startThread() method.");
                StartServer.stopBTMServer();
                break block4;
            }
            JavaAgent.printOutLog("INFO", "eG Business Transaction Monitor not started either JRE is below 1.5 (or) BTM jar file is failed to add BootstrapClassLoader");
        }
    }

    private String stackTraceString(Throwable throwable) {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            JavaAgent.printOutLog("ERROR", "Exception occured while converting stacktrace " + exception.getMessage());
            return null;
        }
    }

    private void logSystemProperties() {
        if (BTMLog.debugLogger.isInfoEnabled()) {
            Object object;
            Object object2;
            Properties properties = System.getProperties();
            Set<Object> set = properties.keySet();
            Iterator<Object> iterator = set.iterator();
            BTMLog.debugLogger.info(" **************** System Properties Begin********************");
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = properties.getProperty((String)object2);
                BTMLog.debugLogger.info("{} == {}", object2, object);
            }
            BTMLog.debugLogger.info(" **************** System Properties End ********************");
            object2 = null;
            try {
                object = ManagementFactory.getRuntimeMXBean();
                object2 = object.getInputArguments();
            }
            catch (Exception exception) {
                BTMLog.debugLogger.error("Exception while getting VM Arguments from RuntimeMXBean", exception);
            }
            if (object2 != null) {
                int n = object2.size();
                BTMLog.debugLogger.info(" **************** VM Arguments Begin ********************");
                for (int i = 0; i < n; ++i) {
                    String string = (String)object2.get(i);
                    BTMLog.debugLogger.info("[ {} ] = {}", (Object)i, (Object)string);
                }
                BTMLog.debugLogger.info(" **************** VM Arguments End ********************");
            }
        }
    }

    private static void printOutLog(String string, String string2) {
        if (string == null || string.length() == 0) {
            string = "INFO";
        }
        if (string2 != null) {
            System.out.println(new Date() + " " + string + "  [eG BTM] - " + string2);
        }
    }

    private boolean isRetransformRequired(String string, ArrayList<String> arrayList) {
        boolean bl = false;
        String string2 = string.replace('.', '/');
        if (arrayList.contains(string2)) {
            bl = true;
        }
        return bl;
    }

    public void startRetransformProcess(ArrayList<Class<?>> arrayList) {
        BTMLog.debugLogger.info("[JavaAgent] - R  E  T  R  A  N  S  F  O  R  M  Starting now !!!");
        try {
            BTMLog.debugLogger.info("[JavaAgent] - Retransform the Following classes only : {}", (Object)arrayList);
            if (arrayList.size() > 0) {
                int n = 0;
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < arrayList.size(); ++i) {
                    Class[] classArray = new Class[]{arrayList.get(i)};
                    try {
                        Thread.sleep(20L);
                        BTMLog.debugLogger.info("[JavaAgent] - Retransforming the Class - {} ", (Object)classArray[0].getName());
                        this.instrumentation.retransformClasses(classArray);
                        ++n;
                        continue;
                    }
                    catch (Throwable throwable) {
                        BTMLog.debugLogger.error("[JavaAgent] - Error while performing retransform {} ", throwable);
                        arrayList2.add(classArray[0].getName());
                    }
                }
                if (n > 0) {
                    BTMLog.debugLogger.info("[JavaAgent] - Total no.of classes retransformed successfully : {}", (Object)n);
                }
                if (arrayList2.size() > 0) {
                    BTMLog.debugLogger.info("[JavaAgent] - Total no.of failed retransformed classes : {}", (Object)arrayList2.size());
                    BTMLog.debugLogger.info("[JavaAgent] - List of failed classes : {} ", (Object)arrayList2);
                }
            }
        }
        catch (Exception exception) {
            BTMLog.debugLogger.error("[JavaAgent] - Error in Retransforming {} ", exception);
        }
    }

    public boolean isRetransFormSupported() {
        return this.instrumentation.isRetransformClassesSupported();
    }

    public void doRetransformClasses(ArrayList<String> arrayList) {
        if (this.isRetransFormSupported()) {
            ArrayList arrayList2 = new ArrayList();
            try {
                Class[] classArray = this.instrumentation.getAllLoadedClasses();
                for (int i = 0; i < classArray.length; ++i) {
                    if (!this.instrumentation.isModifiableClass(classArray[i])) continue;
                    String string = classArray[i].getName();
                    boolean bl = false;
                    bl = this.isRetransformRequired(string, arrayList);
                    if (!bl) continue;
                    BTMLog.debugLogger.info("[JavaAgent] Retransform className  ==>" + string);
                    arrayList2.add(classArray[i]);
                }
            }
            catch (Exception exception) {
                BTMLog.debugLogger.error("[JavaAgent] Error in finding Retransform classes {} ", exception);
            }
            this.startRetransformProcess(arrayList2);
        }
    }
}

