/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.adapter;

import com.eg.jtm.BTMLog;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.commons.AdviceAdapter;

public class EgHTTPMethodAdviceAdapter
extends AdviceAdapter {
    private String methodName;
    private String className;
    private String description;
    private static final String HTTP_CONNECT_METHOD_DESC = "()V";
    private static final String HTTP_GETOUTPUTSTREAM_METHOD_DESC = "()Ljava/io/OutputStream;";
    private static final String HTTP_GETINPUTSTREAM_METHOD_DESC = "()Ljava/io/InputStream;";
    private static final String HTTP_GETERRORSTREAM_METHOD_DESC = "()Ljava/io/InputStream;";
    private static final String APACHE_4_HTTP_EXECUTE_METHOD_DESC1 = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/client/methods/CloseableHttpResponse;";
    private static final String APACHE_4_HTTP_EXECUTE_METHOD_DESC2 = "(Lorg/apache/http/client/methods/HttpUriRequest;Lorg/apache/http/protocol/HttpContext;)Lorg/apache/http/client/methods/CloseableHttpResponse;";
    private static final String APACHE_4_HTTP_EXECUTE_METHOD_DESC3 = "(Lorg/apache/http/HttpHost;Lorg/apache/http/HttpRequest;)Lorg/apache/http/client/methods/CloseableHttpResponse;";
    private static final String APACHE_3_HTTP_EXECUTE_METHOD_DESC = "(Lorg/apache/commons/httpclient/HttpMethod;)V";
    private boolean isHttpConnMethod = false;
    private boolean isInputOrOutputStream = false;
    private boolean isErrorStreamMethod = false;
    private boolean isApacheRequestMethod = false;
    private boolean isApacheHttpUriRequestMethod = false;
    private boolean isApacheHttp3Client = false;
    private int okFlag = this.newLocal(Type.BOOLEAN_TYPE);
    Label startFinally = new Label();

    public EgHTTPMethodAdviceAdapter(int n, MethodVisitor methodVisitor, String string, String string2, String string3, int n2) {
        super(458752, methodVisitor, n, string, string2);
        this.className = string3;
        this.methodName = string;
        this.description = string2;
        this.isHttpConnMethod = false;
        if (string.equals("connect") && string2.equals(HTTP_CONNECT_METHOD_DESC)) {
            this.isHttpConnMethod = true;
        } else if (string.equals("getOutputStream") && string2.equals(HTTP_GETOUTPUTSTREAM_METHOD_DESC)) {
            this.isInputOrOutputStream = true;
        } else if (string.equals("getInputStream") && string2.equals("()Ljava/io/InputStream;")) {
            this.isInputOrOutputStream = true;
        } else if (string.equals("getErrorStream") && string2.equals("()Ljava/io/InputStream;")) {
            this.isErrorStreamMethod = true;
        } else if (string.equals("execute")) {
            if (string2.equals(APACHE_4_HTTP_EXECUTE_METHOD_DESC1) || string2.equals(APACHE_4_HTTP_EXECUTE_METHOD_DESC3)) {
                this.isApacheRequestMethod = true;
            } else if (string2.equals(APACHE_4_HTTP_EXECUTE_METHOD_DESC2)) {
                this.isApacheHttpUriRequestMethod = true;
            }
        } else if (string.equals("executeMethod") && string2.equals(APACHE_3_HTTP_EXECUTE_METHOD_DESC)) {
            this.isApacheHttp3Client = true;
        }
        BTMLog.debugLogger.info(" [HTTP Connection MethodAdviceAdapter] : {} \t {} \t {}", string3, string, string2);
    }

    public void visitCode() {
        super.visitCode();
        this.mv.visitLabel(this.startFinally);
    }

    protected void onMethodEnter() {
        if (this.isHttpConnMethod) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "httpUrlConnMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isInputOrOutputStream) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "httpStreamMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isErrorStreamMethod) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "httpOtherMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isApacheRequestMethod) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(25, 2);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "apacheHttpRequestMethodBegin", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isApacheHttpUriRequestMethod) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "apacheHttpUriMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        } else if (this.isApacheHttp3Client) {
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.okFlag);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "apacheCommonHttpMethodBegin", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", false);
            this.mv.visitVarInsn(54, this.okFlag);
        }
    }

    protected void onMethodExit(int n) {
        if (n != 191) {
            this.onFinally(n);
        }
    }

    public void visitMaxs(int n, int n2) {
        Label label = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, label, label, null);
        this.mv.visitLabel(label);
        this.onFinally(191);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(n + 4, n2);
    }

    private void onFinally(int n) {
        if (this.isHttpConnMethod) {
            if (n == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitVarInsn(25, 0);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(n);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "httpUrlConnMethodEnd", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        } else if (this.isInputOrOutputStream) {
            if (n == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            String string = "methodEnd";
            String string2 = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V";
            if (this.methodName.equals("getInputStream")) {
                string = "inputStreamEnd";
                string2 = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V";
                this.mv.visitVarInsn(25, 0);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(n);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", string, string2, false);
        } else if (this.isErrorStreamMethod) {
            if (n == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(n);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "methodEnd", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        } else if (this.isApacheRequestMethod || this.isApacheHttpUriRequestMethod) {
            if (n == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitInsn(89);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(n);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "apacheHttpMethodEnd", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        } else if (this.isApacheHttp3Client) {
            if (n == 191) {
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(this.className);
                this.mv.visitLdcInsn(this.methodName);
                this.mv.visitLdcInsn(this.description);
                this.mv.visitVarInsn(21, this.okFlag);
                this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "recordSQLException", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", false);
            }
            this.mv.visitVarInsn(25, 1);
            this.mv.visitLdcInsn(this.className);
            this.mv.visitLdcInsn(this.methodName);
            this.mv.visitLdcInsn(this.description);
            this.mv.visitVarInsn(21, this.okFlag);
            this.mv.visitLdcInsn(n);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "apacheCommonHttpMethodEnd", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZI)V", false);
        }
    }
}

