/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.adapter;

import com.eg.agent.ux.MeasureUtil;
import com.eg.jtm.BTMLog;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Type;

public class EgMeasureMethodVisitor
extends MethodVisitor {
    private String methodName;
    private String className;
    private String description;
    private String measureId;
    private int methodParamIndex;
    private String classWithMethodKey;
    private boolean isStaticMethod = false;

    public EgMeasureMethodVisitor(int n, MethodVisitor methodVisitor, String string, String string2, String string3, String string4, int n2, String string5) {
        super(458752, methodVisitor);
        this.className = string3;
        this.methodName = string;
        this.description = string2;
        this.measureId = string4;
        this.methodParamIndex = n2;
        this.classWithMethodKey = string5;
        if ((n & 8) != 0) {
            this.isStaticMethod = true;
        }
        BTMLog.debugLogger.info(" [EgMeasure MethodAdviceAdapter] : {} \t : {} \t : {} \t : {} \t :{} \t : {}", string3, string, string2, string4, n2, string5);
    }

    public void visitCode() {
        super.visitCode();
        this.captureArgs();
    }

    private void captureArgs() {
        Type[] typeArray = Type.getArgumentTypes(this.description);
        int n = typeArray.length;
        int n2 = this.methodParamIndex;
        int n3 = 0;
        if (this.isStaticMethod) {
            n3 = 1;
            n2 = this.methodParamIndex - 1;
        }
        if (n2 >= 0 && n > 0 && n2 <= n - n3) {
            Type type = typeArray[this.methodParamIndex - 1];
            String string = null;
            if (type.equals(Type.BOOLEAN_TYPE)) {
                this.mv.visitVarInsn(21, n2);
                string = "(ZLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.BYTE_TYPE)) {
                this.mv.visitVarInsn(21, n2);
                string = "(BLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.CHAR_TYPE)) {
                this.mv.visitVarInsn(21, n2);
                string = "(CLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.SHORT_TYPE)) {
                this.mv.visitVarInsn(21, n2);
                string = "(SLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.INT_TYPE)) {
                this.mv.visitVarInsn(21, n2);
                string = "(ILjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.LONG_TYPE)) {
                this.mv.visitVarInsn(22, n2);
                string = "(JLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.FLOAT_TYPE)) {
                this.mv.visitVarInsn(23, n2);
                string = "(FLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals(Type.DOUBLE_TYPE)) {
                this.mv.visitVarInsn(24, n2);
                string = "(DLjava/lang/String;Ljava/lang/String;)V";
            } else if (type.equals("Ljava/lang/String;")) {
                this.mv.visitVarInsn(25, n2);
                string = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
            } else {
                this.mv.visitVarInsn(25, n2);
                string = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V";
            }
            this.visitLdcInsn(this.measureId);
            this.visitLdcInsn(this.classWithMethodKey);
            this.mv.visitMethodInsn(184, "com/eg/agent/trace/RootTracer", "measureMethodBegin", string, false);
        } else {
            BTMLog.logger.warn("[IC_For_APM] Invalid Measure; Param index doesn't match; Removing : {Measure id = " + this.measureId + "}");
            MeasureUtil.removeRuntimeInvalidMeasure(this.measureId, this.classWithMethodKey, 1);
        }
    }
}

