/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.attach;

import com.eg.agent.JavaVersion;
import com.eg.agent.attach.Attacher;
import com.eg.agent.attach.JavaAttachHelper;
import com.eg.agent.attach.ReflectionUtil8;
import com.eg.agent.attach.ReflectionUtil9;
import com.eg.jtm.BTMLog;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossOSGI
implements Attacher {
    private Class<?> clazz;

    @Override
    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public boolean execute() {
        int n;
        Object object;
        String string = System.getProperty("jboss.modules.system.pkgs");
        if (string != null && string.trim().length() > 0) {
            BTMLog.logger.info("Found JBoss (or) WildFly OSGI container !!!");
            if (string.indexOf(",") > 0) {
                object = new StringTokenizer(string, ",");
                n = ((StringTokenizer)object).countTokens();
                for (int i = 0; i < n; ++i) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    if (!string2.equals("com.eg") && !string2.equals("com.eg.")) continue;
                    return true;
                }
            }
        } else {
            BTMLog.logger.info("Found Non-OSGI JBoss server !!!");
            return true;
        }
        object = this.clazz.getClassLoader();
        n = JBossOSGI.patchOSGiJboss((ClassLoader)object);
        if (n != 0) {
            BTMLog.logger.info("JBoss/WildFly OSGI - Added \"com.eg.\" package as a system package !!!");
        } else {
            BTMLog.logger.warn("JBoss/WildFly OSGI - Unable to add \"com.eg.\" package as a system package !!!");
            BTMLog.logger.warn("eG BTM does not trace any transactions on this server. Exiting...");
        }
        return n != 0;
    }

    public static boolean patchOSGiJboss(ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass("org.jboss.modules.Module");
            Field field = clazz.getDeclaredField("systemPackages");
            field.setAccessible(true);
            String[] stringArray = (String[])field.get(clazz);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            String[] stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
                BTMLog.logger.debug("JBoss/WildFly OSGI - systemPackages {} - {}", (Object)i, (Object)stringArray[i]);
            }
            JBossOSGI.replaceBytemanWithEg(stringArray);
            stringArray2[stringArray.length] = "com.eg.";
            if (JavaVersion.getJavaVersion().isJava9Higher()) {
                ReflectionUtil9.setStaticFinalField(field, stringArray2);
            } else {
                ReflectionUtil8.setStaticFinalField(field, stringArray2);
            }
            try {
                Field field2 = clazz.getDeclaredField("systemPackages");
                field2.setAccessible(true);
                String[] stringArray3 = (String[])field.get(clazz);
                if (stringArray3 != null) {
                    BTMLog.logger.info("JBoss/WildFly OSGI, after patch {} :", (Object)Arrays.asList(stringArray3));
                } else {
                    BTMLog.logger.info("JBoss/WildFly OSGI after patch is null");
                }
            }
            catch (Exception exception) {
                BTMLog.logger.warn("Exception while listing systemPackages {} ", exception);
            }
            return JavaAttachHelper.checkAgentCanBeLoaded(classLoader);
        }
        catch (Throwable throwable) {
            BTMLog.logger.warn("Problem trying to patch OSGi System Packages {} ", throwable);
            return false;
        }
    }

    private static void replaceBytemanWithEg(String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].contains("org.jboss.byteman.")) continue;
            stringArray[i] = "com.eg.";
        }
    }
}

