/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace.utils;

import com.eg.jtm.BTMLog;
import com.eg.jtm.BTMUtils;
import com.eg.jtm.PropsManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomConfigurationManager {
    private static final String CPC_PREFIX = "CPC";
    private static final String fieldSeparator = "~|~";
    private static final String urlDescSeparator = "~#~";
    private static final String urlSeparator = "~!~";
    private static final int URL_SEP_LENGTH = "~!~".length();
    private static final String HP_STRING = "HP";
    private static final String HP_STRING_ = "HP_";
    private static final String HD_STRING = "HD";
    private static final String HD_STRING_ = "HD_";
    private static final String CK_STRING = "CK";
    private static final String CK_STRING_ = "CK_";
    private static final String US_STRING = "US";
    private static final String CUSTOM_SEGMENT_BUILDER = "/";
    private static final String KB = "KB";
    private static final String B = "B";
    public static final String CPC_PROPS_FILE_NAME = "custom.props";
    private static final HashMap<String, Object[][]> customURLpatternMap = new HashMap();
    private static final ArrayList<String> orderedCPCList = new ArrayList();
    private static final HashMap<String, Object[][]> KBcustomURLpatternMap = new HashMap();
    private static final ArrayList<String> KBorderedCPCList = new ArrayList();
    private static File cpcPropsFile = null;
    private static long lastModifiedTime = -1L;

    private static final void clearConfig() {
        customURLpatternMap.clear();
        orderedCPCList.clear();
        KBcustomURLpatternMap.clear();
        KBorderedCPCList.clear();
        BTMLog.logger.info("[CPC Manager] - Clearing all the CPC configuration ");
    }

    public static boolean isValid() {
        boolean bl = PropsManager.isPropsFileValid(cpcPropsFile);
        if (bl) {
            lastModifiedTime = cpcPropsFile.lastModified();
        }
        return bl;
    }

    public static final long getLastModifiedTime() {
        return lastModifiedTime;
    }

    public static Properties readCPCProps() {
        Properties properties = new Properties();
        String string = PropsManager.EG_BTM_HOME + CUSTOM_SEGMENT_BUILDER + CPC_PROPS_FILE_NAME;
        cpcPropsFile = new File(string);
        try {
            properties.load(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.logger.warn("[PROPERTIES] {}  is not available ", (Object)string);
        }
        catch (IOException iOException) {
            BTMLog.logger.warn("[PROPERTIES]  {}  is not available", (Object)string);
        }
        return properties;
    }

    public static Properties readCPCProps(String string) {
        Properties properties = new Properties();
        File file = new File(string);
        try {
            properties.load(new BufferedInputStream(new FileInputStream(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTMLog.logger.warn("[PROPERTIES] {}  is not available ", (Object)string);
        }
        catch (IOException iOException) {
            BTMLog.logger.warn("[PROPERTIES]  {}  is not available", (Object)string);
        }
        return properties;
    }

    public static final void getCustomConfiguredPatternMap(Properties properties) {
        CustomConfigurationManager.clearConfig();
        if (PropsManager.isCommonGuidPropsFileAvailable()) {
            PropsManager.processCpcConfigsFromGuidPropsFile();
        }
        if (properties != null && properties.size() > 0) {
            Set<Object> set = properties.keySet();
            for (String string : set) {
                Object[][] objectArray;
                String string2;
                String string3;
                int n;
                String string4;
                if (string == null || !string.startsWith(CPC_PREFIX)) continue;
                boolean bl = false;
                String string5 = properties.getProperty(string);
                BTMLog.logger.debug("[CPC Manager] - Property & Value {} : {} ", (Object)string, (Object)string5);
                int n2 = string.indexOf("#");
                if (n2 > 0 && (string4 = string.substring(n2 + 1)) != null) {
                    if (string4.equalsIgnoreCase(KB)) {
                        bl = true;
                    } else if (!string4.equalsIgnoreCase(B)) continue;
                }
                if ((n = string5.indexOf(urlSeparator)) <= 0) continue;
                String string6 = string3 = string5.substring(0, n);
                int n3 = string3.indexOf(urlDescSeparator);
                if (n3 > 0) {
                    string6 = string3.substring(0, n3);
                }
                if (bl) {
                    if (KBorderedCPCList.contains(string6)) {
                        BTMLog.logger.warn("[CPC Manager] - Already {} is exists in the Key Business CPC List {} ", (Object)string6, (Object)KBorderedCPCList);
                        continue;
                    }
                    string2 = string5.substring(n + URL_SEP_LENGTH);
                    if (string2 == null || string2.length() <= 0 || (objectArray = CustomConfigurationManager.getCustomConfiguredPatternArray(string2)) == null) continue;
                    KBcustomURLpatternMap.put(string6, objectArray);
                    KBorderedCPCList.add(string6);
                    continue;
                }
                if (orderedCPCList.contains(string6)) {
                    BTMLog.logger.warn("[CPC Manager] - Already {} is exists in the CPC List {} ", (Object)string6, (Object)orderedCPCList);
                    continue;
                }
                string2 = string5.substring(n + URL_SEP_LENGTH);
                if (string2 == null || string2.length() <= 0 || (objectArray = CustomConfigurationManager.getCustomConfiguredPatternArray(string2)) == null) continue;
                customURLpatternMap.put(string6, objectArray);
                orderedCPCList.add(string6);
            }
        }
        BTMLog.logger.info("[CPC Manager] - Configured URL List for Businees : {} ", (Object)orderedCPCList);
        BTMLog.logger.info("[CPC Manager] - Configured URL List for Businees  & its Values : {} ", (Object)customURLpatternMap);
        BTMLog.logger.info("[CPC Manager] - Configured URL List for KeyBusiness : {} ", (Object)KBorderedCPCList);
        BTMLog.logger.info("[CPC Manager] - Configured URL List for KeyBusiness & its Values : {} ", (Object)KBcustomURLpatternMap);
    }

    public static final void getCustomConfiguredPatternMap(Properties properties, String string, String string2, boolean bl) {
        if (properties != null && properties.size() > 0) {
            String string3 = properties.getProperty(string, null);
            Object[] objectArray = null;
            int n = 0;
            if (string3 != null) {
                objectArray = string3.split("\\~\\|\\~");
                if (objectArray == null) {
                    objectArray = new String[]{string3};
                }
            } else {
                return;
            }
            n = objectArray.length;
            if (BTMLog.logger.isDebugEnabled()) {
                BTMLog.logger.debug("[CPC Manager] Common Props - CPC Measure IDs: " + Arrays.toString(objectArray));
            }
            for (int i = 0; i < n; ++i) {
                Object[][] objectArray2;
                String string4;
                String string5;
                int n2;
                Object object = objectArray[i];
                String string6 = string2 + (String)object;
                String string7 = properties.getProperty(string6, null);
                BTMLog.logger.debug("[CPC Manager] - Property & Value {} : {} ", (Object)string6, (Object)string7);
                if (string7 == null || (n2 = string7.indexOf(urlSeparator)) <= 0) continue;
                String string8 = string5 = string7.substring(0, n2);
                int n3 = string5.indexOf(urlDescSeparator);
                if (n3 > 0) {
                    string8 = string5.substring(0, n3);
                }
                if (bl) {
                    if (KBorderedCPCList.contains(string8)) {
                        BTMLog.logger.warn("[CPC Manager] - Already {} is exists in the Key Business CPC List {} ", (Object)string8, (Object)KBorderedCPCList);
                        continue;
                    }
                    string4 = string7.substring(n2 + URL_SEP_LENGTH);
                    if (string4 == null || string4.length() <= 0 || (objectArray2 = CustomConfigurationManager.getCustomConfiguredPatternArray(string4)) == null) continue;
                    KBcustomURLpatternMap.put(string8, objectArray2);
                    KBorderedCPCList.add(string8);
                    continue;
                }
                if (orderedCPCList.contains(string8)) {
                    BTMLog.logger.warn("[CPC Manager] - Already {} is exists in the CPC List {} ", (Object)string8, (Object)orderedCPCList);
                    continue;
                }
                string4 = string7.substring(n2 + URL_SEP_LENGTH);
                if (string4 == null || string4.length() <= 0 || (objectArray2 = CustomConfigurationManager.getCustomConfiguredPatternArray(string4)) == null) continue;
                customURLpatternMap.put(string8, objectArray2);
                orderedCPCList.add(string8);
            }
        }
        if (!bl) {
            BTMLog.logger.info("[CPC Manager] - Common Props - Configured URL List for Businees : {} ", (Object)orderedCPCList);
            BTMLog.logger.info("[CPC Manager] - Common Props - Configured URL List for Businees  & its Values : {} ", (Object)customURLpatternMap);
        } else {
            BTMLog.logger.info("[CPC Manager] - Common Props - Configured URL List for KeyBusiness : {} ", (Object)KBorderedCPCList);
            BTMLog.logger.info("[CPC Manager] - Common Props - Configured URL List for KeyBusiness & its Values : {} ", (Object)KBcustomURLpatternMap);
        }
    }

    private static Object[][] getCustomConfiguredPatternArray(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, fieldSeparator);
            int n = stringTokenizer.countTokens();
            CPCType[] cPCTypeArray = new CPCType[n];
            String[] stringArray = new String[n];
            String[] stringArray2 = null;
            for (int i = 0; i < n; ++i) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                int n2 = string3.lastIndexOf("=");
                if (n2 <= 0) continue;
                String string4 = string3.substring(0, n2);
                String string5 = string3.substring(n2 + 1);
                if (string4.startsWith(HP_STRING)) {
                    if (string4.startsWith(HP_STRING_) && (string2 = string4.substring(3)) != null && string2.length() > 0) {
                        if (stringArray2 == null) {
                            stringArray2 = new String[n];
                        }
                        stringArray2[i] = string2;
                    }
                    stringArray[i] = string5;
                    cPCTypeArray[i] = CPCType.HP;
                    continue;
                }
                if (string4.equals(US_STRING)) {
                    stringArray[i] = string5;
                    cPCTypeArray[i] = CPCType.US;
                    continue;
                }
                if (string4.startsWith(HD_STRING)) {
                    if (string4.startsWith(HD_STRING_) && (string2 = string4.substring(3)) != null && string2.length() > 0) {
                        if (stringArray2 == null) {
                            stringArray2 = new String[n];
                        }
                        stringArray2[i] = string2;
                    }
                    stringArray[i] = string5;
                    cPCTypeArray[i] = CPCType.HD;
                    continue;
                }
                if (!string4.startsWith(CK_STRING)) continue;
                if (string4.startsWith(CK_STRING_) && (string2 = string4.substring(3)) != null && string2.length() > 0) {
                    if (stringArray2 == null) {
                        stringArray2 = new String[n];
                    }
                    stringArray2[i] = string2;
                }
                stringArray[i] = string5;
                cPCTypeArray[i] = CPCType.CK;
            }
            Object[][] objectArray = new Object[][]{cPCTypeArray, stringArray, stringArray2};
            BTMLog.logger.info("[CPC Manager] - Configured Datas : {} QueryParam Array : {} Matcher Array : {} Regex.Pattern Array : {} ", string, stringArray != null ? Arrays.asList(stringArray) : null, cPCTypeArray != null ? Arrays.asList(cPCTypeArray) : null, stringArray2 != null ? Arrays.asList(stringArray2) : null);
            return objectArray;
        }
        return null;
    }

    private static final String getCPCPattern(String string, ArrayList arrayList) {
        String string2 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            boolean bl = BTMUtils.patternMatch(string, string3);
            if (!bl) continue;
            BTMLog.logger.debug("[CPC Manager] CPC Pattern matches for the URL : {} & Pattern is : {} ", (Object)string, (Object)string3);
            string2 = string3;
            break;
        }
        return string2;
    }

    public static final String getGroupedURLPattern(String string, String string2, Map map, Hashtable hashtable, String string3) {
        String string4 = null;
        String string5 = CustomConfigurationManager.getCPCPattern(string, KBorderedCPCList);
        if (string5 == null) {
            return string4;
        }
        Object[][] objectArray = KBcustomURLpatternMap.get(string5);
        string4 = CustomConfigurationManager.getDynamicPattern(objectArray, string5, string, string2, map, hashtable);
        if (string4 == null || string4.length() == 0) {
            string4 = string3;
        }
        return string4;
    }

    public static final String getGroupedURLPattern(String string, String string2, Map map, Hashtable hashtable) {
        String string3 = null;
        String string4 = CustomConfigurationManager.getCPCPattern(string, orderedCPCList);
        if (string4 == null) {
            return string3;
        }
        Object[][] objectArray = customURLpatternMap.get(string4);
        string3 = CustomConfigurationManager.getDynamicPattern(objectArray, string4, string, string2, map, hashtable);
        return string3;
    }

    private static String getDynamicPattern(Object[][] objectArray, String string, String string2, String string3, Map map, Hashtable hashtable) {
        String string4 = null;
        CPCType[] cPCTypeArray = (CPCType[])objectArray[0];
        StringBuilder stringBuilder = new StringBuilder();
        if (cPCTypeArray != null && cPCTypeArray.length > 0) {
            String[] stringArray = (String[])objectArray[1];
            String[] stringArray2 = (String[])objectArray[2];
            HashMap hashMap = null;
            String[] stringArray3 = null;
            boolean bl = false;
            boolean bl2 = false;
            block10: for (int i = 0; i < cPCTypeArray.length; ++i) {
                String string5 = stringArray[i];
                String string6 = null;
                if (stringArray2 != null) {
                    string6 = stringArray2[i];
                }
                switch (cPCTypeArray[i]) {
                    case HP: {
                        String[] stringArray4;
                        if (map == null || (stringArray4 = (String[])map.get(string5)) == null || stringArray4.length <= 0) continue block10;
                        String string7 = stringArray4[0];
                        if (string6 != null) {
                            stringBuilder.append((CharSequence)CustomConfigurationManager.getRegexResult(string6, string7, cPCTypeArray[i]));
                            continue block10;
                        }
                        stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string7);
                        continue block10;
                    }
                    case US: {
                        String string7;
                        if (!bl) {
                            stringArray3 = CustomConfigurationManager.splitURL(string2);
                            bl = true;
                        }
                        int n = -1;
                        try {
                            n = Integer.parseInt(string5);
                            try {
                                string7 = stringArray3[n - 1];
                                stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string7);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            }
                        }
                        catch (Exception exception) {
                            BTMLog.logger.error("[CPC Manager] - Parsing Error", exception);
                        }
                        continue block10;
                    }
                    case HD: {
                        String string7;
                        if (hashtable == null || (string7 = (String)hashtable.get(string5)) == null) continue block10;
                        if (string6 != null) {
                            stringBuilder.append((CharSequence)CustomConfigurationManager.getRegexResult(string6, string7, cPCTypeArray[i]));
                            continue block10;
                        }
                        stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string7);
                        continue block10;
                    }
                    case CK: {
                        String string7;
                        if (!bl2) {
                            hashMap = CustomConfigurationManager.splitCookies(hashtable);
                            bl2 = true;
                        }
                        if (hashMap == null || (string7 = (String)hashMap.get(string5)) == null) continue block10;
                        if (string6 != null) {
                            stringBuilder.append((CharSequence)CustomConfigurationManager.getRegexResult(string6, string7, cPCTypeArray[i]));
                            continue block10;
                        }
                        stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string7);
                    }
                }
            }
        }
        if (stringBuilder.length() > 0) {
            string4 = stringBuilder.toString();
            BTMLog.logger.info("[CPC Manager] - Found CPC Pattern for the URL : {} & it's result : {} ", (Object)string2, (Object)string4);
        }
        return string4;
    }

    private static String[] splitURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, CUSTOM_SEGMENT_BUILDER);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2;
            stringArray[i] = string2 = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static HashMap splitCookies(Hashtable hashtable) {
        String string;
        HashMap<String, String> hashMap = null;
        if (hashtable != null && (string = (String)hashtable.get("cookie")) != null) {
            hashMap = new HashMap<String, String>();
            String[] stringArray = string.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2 == null || stringArray2.length < 2) continue;
                String string2 = stringArray2[0];
                String string3 = stringArray2[1];
                hashMap.put(string2, string3);
            }
        }
        return hashMap;
    }

    private static StringBuilder getRegexResult(String string, String string2, CPCType cPCType) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Pattern pattern = Pattern.compile(string);
            Matcher matcher = pattern.matcher(string2);
            if (matcher.find()) {
                String string3 = matcher.group(1);
                stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string3);
            } else {
                stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string2);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[CPC Manager] - Exception occured during RegEx.apply on {} of {} & Regex.Pattern {} ", new Object[]{string2, cPCType, string, exception});
            stringBuilder.append(CUSTOM_SEGMENT_BUILDER).append(string2);
        }
        return stringBuilder;
    }

    private static Map<String, String> splitQuery(String string, String string2) throws UnsupportedEncodingException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split("&");
        try {
            for (String string3 : stringArray) {
                int n = string3.indexOf("=");
                String string4 = URLDecoder.decode(string3.substring(0, n), "UTF-8");
                String string5 = URLDecoder.decode(string3.substring(n + 1), "UTF-8");
                hashMap.put(string4, string5);
            }
        }
        catch (Exception exception) {
            BTMLog.logger.warn("[CPC Manager] - Unable to parse the QueryString {} : for the URL {} ", (Object)string, (Object)string2);
        }
        return hashMap;
    }

    static final boolean isKeyConfigurationExists() {
        boolean bl = false;
        if (KBorderedCPCList.size() > 0) {
            bl = true;
        }
        return bl;
    }

    static final boolean isConfigurationExists() {
        boolean bl = false;
        if (orderedCPCList.size() > 0) {
            bl = true;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CPCType {
        HP,
        US,
        CK,
        HD;

    }
}

