/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.adapter.ConnectionPoolMethodAdviceAdapter;
import com.eg.agent.adapter.EgDriverMethodAdviceAdapter;
import com.eg.agent.adapter.EgMySQLConnectionMethodAdviceAdapter;
import com.eg.agent.adapter.EgMySQLStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLCallableStatmentMethodAdviceAdapter;
import com.eg.agent.adapter.EgSQLPreparedStatmentMethodAdviceAdapter;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;
import java.util.ArrayList;

public class EgMySQLClassVisitor
extends ClassVisitor {
    private String className;
    private boolean driverFlag = false;
    private boolean connectionFlag = false;
    private boolean connectionPoolFlag = false;
    private boolean isCallableStmt = false;
    private boolean isPreparedStmt = false;
    private boolean isStmt = false;
    private int classFileVersion;

    public EgMySQLClassVisitor(ClassVisitor classVisitor, String string, ArrayList arrayList, int n) {
        super(458752, classVisitor);
        this.className = string;
        this.classFileVersion = n;
        if (arrayList != null && arrayList.size() > 0) {
            if (arrayList.indexOf("java/sql/CallableStatement") >= 0) {
                this.isCallableStmt = true;
            } else if (arrayList.indexOf("java/sql/PreparedStatement") >= 0) {
                this.isPreparedStmt = true;
            } else if (arrayList.indexOf("java/sql/Statement") >= 0) {
                this.isStmt = true;
            } else if (arrayList.indexOf("java/sql/Driver") >= 0) {
                this.driverFlag = true;
            } else if (arrayList.indexOf("java/sql/Connection") >= 0) {
                this.connectionFlag = true;
            } else if (arrayList.indexOf("javax/sql/DataSource") >= 0 || arrayList.indexOf("javax/sql/ConnectionPoolDataSource") >= 0 || arrayList.indexOf("javax/sql/XADataSource") >= 0) {
                this.connectionPoolFlag = true;
            }
        }
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodVisitor methodVisitor = this.cv.visitMethod(n, string, string2, string3, stringArray);
        if ((n & 0x100) != 0 || (n & 0x400) != 0) {
            return methodVisitor;
        }
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return methodVisitor;
        }
        if (methodVisitor != null) {
            if (this.driverFlag) {
                methodVisitor = new EgDriverMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.connectionPoolFlag) {
                methodVisitor = new ConnectionPoolMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.connectionFlag) {
                methodVisitor = new EgMySQLConnectionMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.isCallableStmt) {
                methodVisitor = new EgSQLCallableStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.isPreparedStmt) {
                methodVisitor = new EgSQLPreparedStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            } else if (this.isStmt) {
                methodVisitor = new EgMySQLStatmentMethodAdviceAdapter(n, methodVisitor, string, string2, this.className, this.classFileVersion);
            }
        }
        return methodVisitor;
    }
}

