/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.classic.pattern;

import com.eg.ch.qos.logback.classic.pattern.Abbreviator;

public class TargetLengthBasedClassNameAbbreviator
implements Abbreviator {
    final int targetLength;

    public TargetLengthBasedClassNameAbbreviator(int n) {
        this.targetLength = n;
    }

    public String abbreviate(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.targetLength);
        if (string == null) {
            throw new IllegalArgumentException("Class name may not be null");
        }
        int n = string.length();
        if (n < this.targetLength) {
            return string;
        }
        int[] nArray = new int[16];
        int[] nArray2 = new int[17];
        int n2 = TargetLengthBasedClassNameAbbreviator.computeDotIndexes(string, nArray);
        if (n2 == 0) {
            return string;
        }
        this.computeLengthArray(string, nArray, nArray2, n2);
        for (int i = 0; i <= n2; ++i) {
            if (i == 0) {
                stringBuilder.append(string.substring(0, nArray2[i] - 1));
                continue;
            }
            stringBuilder.append(string.substring(nArray[i - 1], nArray[i - 1] + nArray2[i]));
        }
        return stringBuilder.toString();
    }

    static int computeDotIndexes(String string, int[] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; (n2 = string.indexOf(46, n2)) != -1 && n < 16; ++n) {
            nArray[n] = n2++;
        }
        return n;
    }

    void computeLengthArray(String string, int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = string.length() - this.targetLength;
        for (n2 = 0; n2 < n; ++n2) {
            int n4;
            int n5;
            int n6 = -1;
            if (n2 > 0) {
                n6 = nArray[n2 - 1];
            }
            int n7 = n5 = (n4 = nArray[n2] - n6 - 1) < 1 ? n4 : 1;
            n5 = n3 > 0 ? (n4 < 1 ? n4 : 1) : n4;
            n3 -= n4 - n5;
            nArray2[n2] = n5 + 1;
        }
        n2 = n - 1;
        nArray2[n] = string.length() - nArray[n2];
    }

    static void printArray(String string, int[] nArray) {
        System.out.print(string);
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                System.out.print(nArray[i]);
                continue;
            }
            System.out.print(", " + nArray[i]);
        }
        System.out.println();
    }
}

